/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.objectprotocol;

import com.documentum.fc.impl.util.UTF8Util;
import java.util.NoSuchElementException;

final class Tokenizer {
    private int m_cursor;
    private int m_mark;
    private int m_maximumCursor;
    private int m_offsetToLastToken;
    private String m_string;

    Tokenizer(String string) {
        this.m_string = string;
        this.m_mark = 0;
        this.m_cursor = 0;
        this.m_offsetToLastToken = 0;
        this.m_maximumCursor = this.m_string.length();
    }

    void reset() {
        this.m_cursor = this.m_mark;
    }

    void mark() {
        this.m_mark = this.m_cursor;
    }

    int getOffsetToLastToken() {
        return this.m_offsetToLastToken;
    }

    String nextToken() {
        char c;
        if (this.m_cursor == this.m_maximumCursor) {
            throw new NoSuchElementException();
        }
        this.skipDelimiters();
        this.m_offsetToLastToken = this.m_cursor;
        while (this.m_cursor < this.m_maximumCursor && (c = this.m_string.charAt(this.m_cursor)) != ' ' && c != '\n') {
            ++this.m_cursor;
        }
        return this.m_string.substring(this.m_offsetToLastToken, this.m_cursor);
    }

    String nextToken(char delimiter) {
        char c;
        if (this.m_cursor == this.m_maximumCursor) {
            throw new NoSuchElementException();
        }
        this.skipDelimiters();
        this.m_offsetToLastToken = this.m_cursor;
        while (this.m_cursor < this.m_maximumCursor && (c = this.m_string.charAt(this.m_cursor)) != delimiter) {
            ++this.m_cursor;
        }
        return this.m_string.substring(this.m_offsetToLastToken, this.m_cursor);
    }

    String nextToken(int lengthInBytes) {
        int remainingLength = lengthInBytes;
        this.m_offsetToLastToken = this.m_cursor;
        while (this.m_cursor < this.m_maximumCursor && remainingLength > 0) {
            char charNumber = this.m_string.charAt(this.m_cursor);
            remainingLength = charNumber <= '\u007f' ? --remainingLength : (charNumber <= '\u07ff' ? (remainingLength -= 2) : (UTF8Util.isSurrogate(charNumber) ? (remainingLength -= 2) : (remainingLength -= 3)));
            ++this.m_cursor;
        }
        return this.m_string.substring(this.m_offsetToLastToken, this.m_cursor);
    }

    public char peek() {
        if (this.m_cursor == this.m_maximumCursor) {
            throw new NoSuchElementException();
        }
        return this.m_string.charAt(this.m_cursor);
    }

    public void skipChar() {
        if (this.m_cursor == this.m_maximumCursor) {
            throw new NoSuchElementException();
        }
        ++this.m_cursor;
    }

    public String getString() {
        return this.m_string;
    }

    private void skipDelimiters() {
        while (this.m_cursor < this.m_maximumCursor) {
            char c = this.m_string.charAt(this.m_cursor);
            if (c != ' ' && c != '\n') {
                return;
            }
            ++this.m_cursor;
        }
    }
}

