/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.objectprotocol;

import com.documentum.fc.client.impl.connection.LiteTypeManager;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnection;
import com.documentum.fc.client.impl.objectmanager.PersistentDataManager;
import com.documentum.fc.client.impl.objectprotocol.AbstractObjectProtocol;
import com.documentum.fc.client.impl.objectprotocol.ObjectProtocolException;
import com.documentum.fc.client.impl.objectprotocol.Tokenizer;
import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.DataConverter;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.LiteType;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.impl.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;

public class ObjectProtocolV1
extends AbstractObjectProtocol {
    private int m_serializationVersion = 2;
    private boolean m_tzAware = false;
    protected static ThreadLocal<SimpleDateFormat> s_UTCDateFormat = new ThreadLocal();
    private static final String UTC_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final int OOB_MASK_TYPE_CHANGE = 64;

    public ObjectProtocolV1(IDocbaseConnection connection, LiteTypeManager typeManager) {
        this.m_connection = connection;
        this.m_typeManager = typeManager;
    }

    public ObjectProtocolV1(IDocbaseConnection connection, LiteTypeManager typeManager, int serializationVersion, boolean tzAware) {
        this(connection, typeManager);
        this.m_serializationVersion = serializationVersion;
        this.m_tzAware = tzAware;
    }

    public ITypedData[] deserializeObjects(String serializedObjects, ILiteType type, int count) throws DfException {
        ITypedData[] objects = new ITypedData[count];
        if (count == 0) {
            return objects;
        }
        Tokenizer tokenizer = new Tokenizer(serializedObjects);
        int algVersion = ObjectProtocolV1.deserializeInteger(tokenizer, "Serialization Algorithm");
        this.verifySerializationAlg(algVersion);
        for (int i = 0; i < count; ++i) {
            objects[i] = this.deserializeObject(tokenizer, type);
        }
        return objects;
    }

    public ITypedData deserializeObject(String serializedObject, ILiteType type) throws DfException {
        DfLogger.debug((Object)this, "deserializeObject: {0}", new Object[]{serializedObject}, null);
        Tokenizer tokenizer = new Tokenizer(serializedObject);
        int algVersion = ObjectProtocolV1.deserializeInteger(tokenizer, "Serialization Algorithm");
        this.verifySerializationAlg(algVersion);
        return this.deserializeObject(tokenizer, type);
    }

    private ITypedData deserializeObject(Tokenizer tokenizer, ILiteType type) throws DfException {
        if (!tokenizer.nextToken().equals("OBJ") && !tokenizer.nextToken().equals("OBJ")) {
            throw ObjectProtocolException.newMissingObjTokenException(tokenizer);
        }
        String typeName = tokenizer.nextToken();
        if (typeName.equals("NULL")) {
            type = new LiteType();
        } else {
            if (type == null) {
                throw ObjectProtocolException.newUnknownTypeException(tokenizer);
            }
            if (StringUtil.isEmptyOrNull(type.getAspectName()) && !typeName.equals(type.getUnextendedType().getName())) {
                throw ObjectProtocolException.newTypeMismatchException(typeName, type.getUnextendedType().getName());
            }
        }
        ObjectProtocolV1.deserializeInteger(tokenizer, "type vstamp");
        ObjectProtocolV1.deserializeInteger(tokenizer, "type version");
        int cacheVStamp = ObjectProtocolV1.deserializeInteger(tokenizer, "type cache vstamp");
        if (this.m_typeManager != null) {
            type = this.m_typeManager.refreshTypeIfNeeded(type, cacheVStamp, this.m_connection);
        }
        ITypedData data = PersistentDataManager.newData(type, DfId.DF_NULLID, null);
        this.deserializeStaticAttributes(tokenizer, data);
        this.deserializeExtendedAttributes(tokenizer, data);
        this.deserializeAspects(tokenizer, data);
        data.setModified(false);
        return data;
    }

    public void receiveOutOfBandData(int outOfBandData) {
        if ((outOfBandData & 0x40) != 0) {
            DfLogger.info((Object)this, "Received type change in out of band data", null, null);
            this.m_typeManager.requestConsistencyCheck();
        }
    }

    private void deserializeExtendedAttributes(Tokenizer tokenizer, ITypedData data) throws DfException {
        int extendedAttributeCount = ObjectProtocolV1.deserializeInteger(tokenizer, "extended attribute count");
        for (int i = 0; i < extendedAttributeCount; ++i) {
            this.deserializeValue(tokenizer, ObjectProtocolV1.resolveAttribute(data, this.deserializeAttribute(tokenizer, null, null)), data);
        }
    }

    private void deserializeStaticAttributes(Tokenizer tokenizer, ITypedData data) throws DfException {
        ILiteType type = data.getType();
        int staticAttributeCount = ObjectProtocolV1.deserializeInteger(tokenizer, "static attribute count");
        for (int i = 0; i < staticAttributeCount; ++i) {
            Attribute attr;
            String attrId = tokenizer.nextToken();
            Attribute attribute = attr = attrId.equals("?") ? type.getAttr(i) : type.getAttrById(attrId);
            if (this.m_serializationVersion == 2) {
                ObjectProtocolV1.deserializeRepeatingIndicator(tokenizer);
                ObjectProtocolV1.deserializeInteger(tokenizer, "attribute data type");
            }
            this.deserializeValue(tokenizer, attr, data);
        }
    }

    private ITypedData[] deserializeAspects(Tokenizer tokenizer, ITypedData data) throws DfException {
        String aspectCountStr = tokenizer.nextToken();
        if (StringUtil.isEmptyOrNull(aspectCountStr)) {
            return null;
        }
        int aspectAttrObjCount = Integer.parseInt(aspectCountStr);
        for (int i = 0; i < aspectAttrObjCount; ++i) {
            if (!tokenizer.nextToken().equals("OBJ")) {
                throw ObjectProtocolException.newMissingObjTokenException(tokenizer);
            }
            String aspectAttrDefTypeName = tokenizer.nextToken();
            ObjectProtocolV1.deserializeInteger(tokenizer, "type vstamp");
            ObjectProtocolV1.deserializeInteger(tokenizer, "type version");
            int cacheVStamp = ObjectProtocolV1.deserializeInteger(tokenizer, "type cache vstamp");
            ILiteType aspectType = this.getLastKnownExtendedType(aspectAttrDefTypeName, null);
            aspectType = this.m_typeManager.refreshTypeIfNeeded(aspectType, cacheVStamp, this.m_connection);
            String aspectName = aspectType.getAspectName();
            int staticAttributeCount = ObjectProtocolV1.deserializeInteger(tokenizer, "static attribute count");
            for (int j = 0; j < staticAttributeCount; ++j) {
                String attrId = new StringBuilder(50).append(aspectName).append('.').append(tokenizer.nextToken()).toString();
                if (this.m_serializationVersion == 2) {
                    ObjectProtocolV1.deserializeRepeatingIndicator(tokenizer);
                    ObjectProtocolV1.deserializeInteger(tokenizer, "attribute data type");
                }
                this.deserializeValue(tokenizer, data.getType().getAttrById(attrId), data);
            }
        }
        return null;
    }

    private ITypedData deserializeObjectWithPossiblyExtendedType(Tokenizer tokenizer, ILiteType type) throws DfException {
        tokenizer.mark();
        try {
            return this.deserializeObject(tokenizer, type);
        }
        catch (AbstractObjectProtocol.AttributeMismatchException e) {
            DfLogger.debug(ObjectProtocolV1.class, "Extended attributes changed for {0}", new String[]{type.getUnextendedType().getName()}, (Throwable)e);
            tokenizer.reset();
            return this.deserializeObject(tokenizer, type.getUnextendedType());
        }
    }

    public ILiteType[] deserializePersistentTypes(String serializedTypes, int count) throws DfException {
        Tokenizer tokenizer = new Tokenizer(serializedTypes);
        int algVersion = ObjectProtocolV1.deserializeInteger(tokenizer, "Serialization Algorithm");
        this.verifySerializationAlg(algVersion);
        return this.deserializePersistentTypes(tokenizer, count);
    }

    public void serializeObject(StringBuilder sb, ITypedData typedData) {
        ILiteType type = typedData.getType();
        ILiteType originalNamedType = null;
        if (type.getUnextendedType().getName().length() > 0) {
            originalNamedType = type.getUnextendedType();
        }
        sb.append(this.m_serializationVersion);
        sb.append('\n');
        sb.append("OBJ ");
        sb.append(originalNamedType != null ? originalNamedType.getName() : "NULL");
        sb.append(' ');
        sb.append(type.getVStamp());
        sb.append(' ');
        sb.append(type.getVersion());
        sb.append(' ');
        sb.append(type.getCacheVStamp());
        sb.append(' ');
        int staticAttributeCount = originalNamedType != null ? originalNamedType.getAttrCount() : 0;
        sb.append(Integer.toString(staticAttributeCount));
        sb.append('\n');
        for (int i = 0; i < staticAttributeCount; ++i) {
            this.serializeValue(sb, type.getAttr(i), typedData);
        }
        int totalAttributeCount = type.getAttrCount();
        sb.append(Integer.toString(totalAttributeCount - staticAttributeCount));
        sb.append('\n');
        for (int i = staticAttributeCount; i < totalAttributeCount; ++i) {
            Attribute attribute = type.getAttr(i);
            this.serializeAttribute(sb, attribute);
            this.serializeValue(sb, attribute, typedData);
        }
    }

    public ITypedData deserializeObjectWithPreamble(String serializedObject) throws DfException {
        DfLogger.debug((Object)this, "deserializeObjectWithPreamble: {0}", new Object[]{serializedObject}, null);
        Tokenizer tokenizer = new Tokenizer(serializedObject);
        int algVersion = ObjectProtocolV1.deserializeInteger(tokenizer, "Serialization Algorithm");
        this.verifySerializationAlg(algVersion);
        tokenizer.mark();
        String keyword = tokenizer.nextToken();
        tokenizer.reset();
        if (keyword.equals("TYPE")) {
            ILiteType type = this.deserializeType(tokenizer);
            return this.deserializeObject(tokenizer, type);
        }
        if (!keyword.equals("OBJ")) {
            String typeName = tokenizer.nextToken();
            DfId id = new DfId(tokenizer.nextToken());
            int aspectTypeCount = ObjectProtocolV1.deserializeInteger(tokenizer, "aspect type count");
            ArrayList<String> aspectTypeNames = new ArrayList<String>(aspectTypeCount);
            for (int i = 0; i < aspectTypeCount; ++i) {
                aspectTypeNames.add(tokenizer.nextToken());
            }
            ILiteType type = this.getLastKnownExtendedType(typeName, aspectTypeNames);
            ITypedData object = this.deserializeObjectWithPossiblyExtendedType(tokenizer, type);
            object.setObjectId(id);
            if (object.getType() != type) {
                this.m_typeManager.registerExtendedType(typeName, aspectTypeNames, object.getType());
            }
            return object;
        }
        throw new DfCriticalException("An object without preamble was not expected");
    }

    public ILiteType deserializeType(String serializedType) throws DfException {
        Tokenizer tokenizer = new Tokenizer(serializedType);
        int algVersion = ObjectProtocolV1.deserializeInteger(tokenizer, "Serialization Algorithm");
        this.verifySerializationAlg(algVersion);
        return this.deserializeType(tokenizer);
    }

    public ILiteType deserializeType(Tokenizer tokenizer, ILiteType superType) throws DfException {
        String aspectName;
        DfLogger.debug((Object)this, "deserializeType: {0}", new Object[]{tokenizer.getString()}, null);
        if (!tokenizer.nextToken().equals("TYPE")) {
            throw ObjectProtocolException.newMissingTypeTokenException(tokenizer);
        }
        String typeName = tokenizer.nextToken(' ');
        tokenizer.nextToken();
        int typeVStamp = ObjectProtocolV1.deserializeInteger(tokenizer, "type vstamp");
        int typeVersion = ObjectProtocolV1.deserializeInteger(tokenizer, "type version");
        int typeCacheVStamp = ObjectProtocolV1.deserializeInteger(tokenizer, "type cache vstamp");
        String superTypeName = tokenizer.nextToken();
        ObjectProtocolV1.verifySuperNameMatchesExpectations(superTypeName, superType);
        String parentTypeName = tokenizer.nextToken();
        if (parentTypeName.equals("NULL")) {
            parentTypeName = null;
        }
        if ((aspectName = tokenizer.nextToken()).equals("NULL")) {
            aspectName = null;
        }
        String attrNamePrefix = null;
        if (aspectName != null) {
            attrNamePrefix = aspectName + ".";
        }
        boolean aspectDataShareable = tokenizer.nextToken().equalsIgnoreCase("t");
        int attributeCount = ObjectProtocolV1.deserializeInteger(tokenizer, "attribute count");
        if (parentTypeName != null) {
            superType = superTypeName.equals("NULL") ? null : new LiteType(superTypeName);
        }
        LiteType type = new LiteType(typeName, superType);
        type.setDeclaredParentTypeName(parentTypeName);
        type.setAspectName(aspectName);
        type.setAspectDataShareable(aspectDataShareable);
        type.setVersionInfo(typeVStamp, typeVersion, typeCacheVStamp);
        for (int i = 0; i < attributeCount; ++i) {
            type.addAttr(this.deserializeStaticAttribute(tokenizer, attrNamePrefix));
        }
        return type;
    }

    protected SimpleDateFormat getDateFormat() {
        if (this.m_serializationVersion == 2 && this.m_tzAware) {
            SimpleDateFormat dateFormat = s_UTCDateFormat.get();
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(UTC_DATE_PATTERN, s_englishLocale);
                dateFormat.setTimeZone(TimeZone.getTimeZone("Z"));
                dateFormat.setLenient(false);
                s_UTCDateFormat.set(dateFormat);
            }
            return dateFormat;
        }
        return super.getDateFormat();
    }

    protected void serializeTimeValue(StringBuilder sb, String value) {
        if (this.m_serializationVersion == 2 && this.m_tzAware) {
            if (value.length() == 0) {
                sb.append("nulldate");
            } else if (value.equals("nulldate") || value.equals("invaliddate")) {
                sb.append(value);
            } else {
                String time = this.getDateFormat().format(DataConverter.convertToDate(value));
                sb.append(time);
            }
            sb.append('\n');
        } else {
            super.serializeTimeValue(sb, value);
        }
    }

    private Attribute deserializeStaticAttribute(Tokenizer tokenizer, String attrNamePrefix) throws DfException {
        String attrId = tokenizer.nextToken();
        Attribute attr = this.deserializeAttribute(tokenizer, attrNamePrefix, attrId);
        attr.setRestriction(ObjectProtocolV1.deserializeInteger(tokenizer, "attribute restriction"));
        return attr;
    }

    private Attribute deserializeAttribute(Tokenizer tokenizer, String attrNamePrefix, String attrId) throws DfException {
        String name;
        if (!StringUtil.isEmptyOrNull(attrNamePrefix)) {
            name = new StringBuilder(50).append(attrNamePrefix).append(tokenizer.nextToken()).toString();
            attrId = new StringBuilder(50).append(attrNamePrefix).append(attrId).toString();
        } else {
            name = tokenizer.nextToken();
        }
        int dataType = ObjectProtocolV1.deserializeDataType(tokenizer);
        boolean isRepeating = ObjectProtocolV1.deserializeRepeatingIndicator(tokenizer);
        int length = ObjectProtocolV1.deserializeInteger(tokenizer, "attribute length");
        String actualAttrId = attrId;
        if (attrId != null && attrId.equals("?")) {
            actualAttrId = null;
        }
        Attribute attr = new Attribute(-1, name, actualAttrId, isRepeating, dataType, length, -1);
        attr.setAspectAttr(!StringUtil.isEmptyOrNull(attrNamePrefix));
        return attr;
    }

    private void serializeAttribute(StringBuilder sb, IDfAttr attribute) {
        sb.append(attribute.getName());
        sb.append(' ');
        sb.append(s_dataTypeNames[attribute.getDataType()]);
        sb.append(' ');
        sb.append(attribute.isRepeating() ? (char)'R' : 'S');
        sb.append(' ');
        sb.append(Integer.toString(attribute.getLength()));
        sb.append('\n');
    }

    private void verifySerializationAlg(int alg) throws DfException {
        if (alg != this.m_serializationVersion) {
            throw ObjectProtocolException.newWrongSerialVersionException(alg, this.m_serializationVersion);
        }
    }
}

