/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.objectprotocol;

import com.documentum.fc.client.DfIOException;
import com.documentum.fc.client.impl.objectprotocol.Tokenizer;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;

public class ObjectProtocolException
extends DfIOException {
    private int m_offset;
    private String m_serializedObject;

    public static ObjectProtocolException newMissingObjTokenException(Tokenizer tokenizer) {
        return new ObjectProtocolException("DFC_OBJPROTO_MISSING_OBJ_TOKEN", tokenizer);
    }

    public static ObjectProtocolException newUnknownTypeException(Tokenizer tokenizer) {
        return new ObjectProtocolException("DFC_OBJPROTO_UNKNOWN_TYPE", tokenizer);
    }

    public static ObjectProtocolException newTypeMismatchException(String value, String expectedValue) {
        return new ObjectProtocolException("DFC_OBJPROTO_TYPE_MISMATCH", null, new Object[]{value, expectedValue});
    }

    public static ObjectProtocolException newBadNumberFormatException(Tokenizer tokenizer, String description) {
        return new ObjectProtocolException("DFC_OBJPROTO_BAD_NUMBER_FORMAT", tokenizer, new Object[]{description});
    }

    public static ObjectProtocolException newBadStringFormatException(Tokenizer tokenizer) {
        return new ObjectProtocolException("DFC_OBJPROTO_BAD_STRING_FORMAT", tokenizer);
    }

    public static ObjectProtocolException newBadStringLengthException(Tokenizer tokenizer) {
        return new ObjectProtocolException("DFC_OBJPROTO_BAD_STRING_LENGTH", tokenizer);
    }

    public static ObjectProtocolException newBadHexStringException(Tokenizer tokenizer, String value) {
        return new ObjectProtocolException("DFC_OBJPROTO_BAD_HEX_STRING", tokenizer, new Object[]{value});
    }

    public static ObjectProtocolException newBadTimeStringException(Tokenizer tokenizer, String value) {
        return new ObjectProtocolException("DFC_OBJPROTO_BAD_TIME_STRING", tokenizer, new Object[]{value});
    }

    public static ObjectProtocolException newBadDatatypeException(Tokenizer tokenizer) {
        return new ObjectProtocolException("DFC_OBJPROTO_BAD_DATATYPE", tokenizer);
    }

    public static ObjectProtocolException newBadSRIndicatorException(Tokenizer tokenizer) {
        return new ObjectProtocolException("DFC_OBJPROTO_BAD_SR_INDICATOR", tokenizer);
    }

    public static ObjectProtocolException newMissingTypeTokenException(Tokenizer tokenizer) {
        return new ObjectProtocolException("DFC_OBJPROTO_MISSING_TYPE_TOKEN", tokenizer);
    }

    public static ObjectProtocolException newSupertypeMismatchException(String value, String expectedValue) {
        return new ObjectProtocolException("DFC_OBJPROTO_SUPERTYPE_MISMATCH", null, new Object[]{value, expectedValue});
    }

    public static ObjectProtocolException newWrongSerialVersionException(int actualValue, int expectedValue) {
        return new ObjectProtocolException("DFC_OBJPROTO_WRONG_SERIAL_VERSION", null, new Object[]{actualValue, expectedValue});
    }

    public static ObjectProtocolException newTypeManagerFailedException(Throwable cause) {
        return new ObjectProtocolException("DFC_OBJPROTO_TYPE_MANAGER_FAILED", null, null, cause);
    }

    private ObjectProtocolException(String message, Tokenizer tokenizer) {
        this(message, tokenizer, null);
    }

    protected ObjectProtocolException(String message, Tokenizer tokenizer, Object[] arguments) {
        super(message, arguments);
        this.finishConstruction(tokenizer);
        this.optionallyLogException();
    }

    protected ObjectProtocolException(String message, Tokenizer tokenizer, Object[] arguments, Throwable cause) {
        super(message, arguments, cause);
        this.finishConstruction(tokenizer);
        this.optionallyLogException();
    }

    private void finishConstruction(Tokenizer tokenizer) {
        if (tokenizer != null) {
            this.m_serializedObject = tokenizer.getString();
            this.m_offset = tokenizer.getOffsetToLastToken();
        } else {
            this.m_serializedObject = null;
            this.m_offset = 0;
        }
    }

    protected void optionallyLogException() {
        DfLogger.warn((Object)this, "DFC_OBJPROTO_DESERIALIZATION_FAILURE", new Object[]{this.m_offset}, (Throwable)this);
        if (DfPreferences.getInstance().isLoggingVerbose() && this.m_serializedObject != null) {
            DfLogger.warn((Object)this, "DFC_OBJPROTO_SERIALIZED_OBJECT", new Object[]{this.m_serializedObject}, null);
        }
    }

    public int getOffset() {
        return this.m_offset;
    }

    public String getSerializedObject() {
        return this.m_serializedObject;
    }
}

