/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.objectprotocol;

import com.documentum.fc.client.DfFolder;
import com.documentum.fc.client.DfSysObject;
import com.documentum.fc.client.content.impl.Content;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalAttributeRegistry {
    private final Set<String> m_localAttributeNames;
    private static final Map<String, LocalAttributeRegistry> s_localAttributeRegistyMap;
    private static final LocalAttributeRegistry s_defaultLocalAttributeRegistry;
    private static final String DM_IMPLIED_ROOT = "dm_impliedRoot";
    private String m_superTypeName;

    static synchronized LocalAttributeRegistry getInstance(ILiteType type) {
        while (type != null) {
            LocalAttributeRegistry ilar = s_localAttributeRegistyMap.get(type.getName());
            if (ilar != null) {
                return ilar;
            }
            type = type.getSuperType();
        }
        return s_defaultLocalAttributeRegistry;
    }

    boolean isLocal(String attributeName) {
        if (!this.m_localAttributeNames.contains(attributeName)) {
            if (this.m_superTypeName == null) {
                return false;
            }
            LocalAttributeRegistry localAttrReg = s_localAttributeRegistyMap.get(this.m_superTypeName);
            return localAttrReg.isLocal(attributeName);
        }
        return true;
    }

    private LocalAttributeRegistry(Collection<String> localAttributeNames, String superTypeName) {
        this.m_localAttributeNames = new HashSet<String>(localAttributeNames);
        this.m_superTypeName = superTypeName;
    }

    static {
        HashSet<String> s_specialAttrLocalList = new HashSet<String>();
        s_specialAttrLocalList.add("i_is_replica");
        s_specialAttrLocalList.add("i_vstamp");
        s_defaultLocalAttributeRegistry = new LocalAttributeRegistry(s_specialAttrLocalList, null);
        s_localAttributeRegistyMap = new HashMap<String, LocalAttributeRegistry>();
        s_localAttributeRegistyMap.put(DM_IMPLIED_ROOT, s_defaultLocalAttributeRegistry);
        s_localAttributeRegistyMap.put("dm_folder", new LocalAttributeRegistry(DfFolder.getLocalAttributeNames(), "dm_sysobject"));
        s_localAttributeRegistyMap.put("dm_sysobject", new LocalAttributeRegistry(DfSysObject.getLocalAttributeNames(), DM_IMPLIED_ROOT));
        s_localAttributeRegistyMap.put("dmr_content", new LocalAttributeRegistry(Content.getLocalAttributeNames(), DM_IMPLIED_ROOT));
    }
}

