/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.docbase;

import com.documentum.fc.client.impl.docbase.IDocbaseSpec;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.ITraceString;

public final class DocbaseSpec
implements IDocbaseSpec,
ITraceString {
    private String m_docbase;
    private String m_server;
    private String m_host;
    private static final String SERVER_SEPARATOR = ".";
    private static final String HOST_SEPARATOR = "@";

    public DocbaseSpec(String docbaseSpecString) {
        if (docbaseSpecString == null) {
            throw new NullPointerException("docbaseSpecString");
        }
        this.parse(docbaseSpecString);
        if (this.m_docbase.length() == 0 && docbaseSpecString.length() > 0) {
            throw DocbaseSpec.newEmptyNameException(docbaseSpecString);
        }
    }

    public DocbaseSpec(String docbase, String server, String host) {
        this.m_docbase = StringUtil.nullToEmpty(docbase);
        this.m_server = StringUtil.nullToEmpty(server);
        this.m_host = StringUtil.nullToEmpty(host);
    }

    public String getDocbase() {
        return this.m_docbase;
    }

    public String getServer() {
        return this.m_server;
    }

    public String getHost() {
        return this.m_host;
    }

    public boolean matches(IDocbaseSpec selector) {
        String selectorDocbase = selector.getDocbase();
        if (!selectorDocbase.equals(this.m_docbase)) {
            return false;
        }
        String selectorServer = selector.getServer();
        if (selectorServer.length() != 0 && !selectorServer.equals(this.m_server)) {
            return false;
        }
        String selectorHost = selector.getHost();
        return selectorHost.length() == 0 || selectorHost.equalsIgnoreCase(this.m_host);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.m_docbase.length() + this.m_server.length() + this.m_host.length() + 2);
        buffer.append(this.m_docbase);
        if (this.m_server.length() != 0) {
            buffer.append(SERVER_SEPARATOR).append(this.m_server);
        }
        if (this.m_host.length() != 0) {
            buffer.append(HOST_SEPARATOR).append(this.m_host);
        }
        return buffer.toString();
    }

    public String toTraceString(boolean verbose) {
        return "DocbaseSpec{" + this.toString() + "}";
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof DocbaseSpec)) {
            return false;
        }
        DocbaseSpec docbaseSpecification = (DocbaseSpec)rhs;
        return this.m_docbase.equals(docbaseSpecification.m_docbase) && this.m_host.equals(docbaseSpecification.m_host) && this.m_server.equals(docbaseSpecification.m_server);
    }

    public int hashCode() {
        int result = 53;
        result = 37 * result + this.m_docbase.hashCode();
        result = 37 * result + this.m_host.hashCode();
        result = 37 * result + this.m_server.hashCode();
        return result;
    }

    private void parse(String docbaseSpecString) {
        docbaseSpecString = docbaseSpecString.trim();
        int serverIndex = docbaseSpecString.indexOf(SERVER_SEPARATOR);
        int hostIndex = docbaseSpecString.indexOf(HOST_SEPARATOR);
        if (hostIndex != -1 && serverIndex > hostIndex) {
            serverIndex = -1;
        }
        if (serverIndex == -1 && hostIndex == -1) {
            this.m_docbase = docbaseSpecString;
            this.m_host = StringUtil.EMPTY_STRING;
            this.m_server = StringUtil.EMPTY_STRING;
            return;
        }
        if (hostIndex == -1 && docbaseSpecString.indexOf(SERVER_SEPARATOR, serverIndex + 1) > -1) {
            throw DocbaseSpec.newSyntaxMultiException(docbaseSpecString);
        }
        if (docbaseSpecString.indexOf(HOST_SEPARATOR, hostIndex + 1) > -1) {
            throw DocbaseSpec.newSyntaxMultiException(docbaseSpecString);
        }
        if (serverIndex != -1) {
            this.m_docbase = docbaseSpecString.substring(0, serverIndex);
            if (hostIndex != -1) {
                this.m_server = docbaseSpecString.substring(serverIndex + SERVER_SEPARATOR.length(), hostIndex);
                this.m_host = docbaseSpecString.substring(hostIndex + HOST_SEPARATOR.length());
                if (this.m_server.length() == 0 || this.m_host.length() == 0) {
                    throw DocbaseSpec.newSyntaxOrderException(docbaseSpecString);
                }
            } else {
                this.m_server = docbaseSpecString.substring(serverIndex + SERVER_SEPARATOR.length());
                this.m_host = StringUtil.EMPTY_STRING;
                if (this.m_server.length() == 0) {
                    throw DocbaseSpec.newSyntaxOrderException(docbaseSpecString);
                }
            }
        } else {
            this.m_docbase = docbaseSpecString.substring(0, hostIndex);
            this.m_server = StringUtil.EMPTY_STRING;
            this.m_host = docbaseSpecString.substring(hostIndex + HOST_SEPARATOR.length());
            if (this.m_host.length() == 0) {
                throw DocbaseSpec.newSyntaxOrderException(docbaseSpecString);
            }
        }
    }

    private static IllegalArgumentException newEmptyNameException(String docbaseSpecString) {
        return new IllegalArgumentException("Invalid syntax for the docbase connect string '" + docbaseSpecString + "'. No docbase was specified.");
    }

    private static IllegalArgumentException newSyntaxOrderException(String docbaseSpecString) {
        return new IllegalArgumentException("Invalid syntax for the docbase connect string '" + docbaseSpecString + "'. The docbase/server separator, '.' must preceed the server/host separator '@'");
    }

    private static IllegalArgumentException newSyntaxMultiException(String docbaseSpecString) {
        return new IllegalArgumentException("Invalid syntax for the docbase connect string '" + docbaseSpecString + "'. The docbase/host separator, '@', and the docbase/server separator '.' can only appear once.");
    }
}

