/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.docbase;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocbaseMessageIds {
    private static ResourceBundle s_resourceBundle = null;
    private static Map<String, Integer> s_messageIdToCodeMap;

    public static String getString(int key) {
        StringBuffer sb = new StringBuffer(Integer.toHexString(key));
        while (sb.length() < 8) {
            sb.insert(0, "0");
        }
        return DocbaseMessageIds.getResourceBundle().getString(sb.toString());
    }

    public static int getCodeFromId(String id) {
        Integer r = DocbaseMessageIds.getCodeToIdMap().get(id);
        return r == null ? 0 : r;
    }

    private static synchronized Map<String, Integer> getCodeToIdMap() {
        if (s_messageIdToCodeMap == null) {
            ResourceBundle rb = DocbaseMessageIds.getResourceBundle();
            HashMap<String, Integer> m = new HashMap<String, Integer>(5000);
            Enumeration<String> e = rb.getKeys();
            while (e.hasMoreElements()) {
                String code = e.nextElement();
                String messageId = rb.getString(code);
                m.put(messageId, Integer.parseInt(code, 16));
            }
            s_messageIdToCodeMap = m;
        }
        return s_messageIdToCodeMap;
    }

    public static synchronized ResourceBundle getResourceBundle() {
        if (s_resourceBundle == null) {
            s_resourceBundle = ResourceBundle.getBundle(DocbaseMessageIds.class.getName());
        }
        return s_resourceBundle;
    }
}

