/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.docbase;

import com.documentum.fc.client.DfAuthenticationException;
import com.documentum.fc.client.DfIdNotFoundException;
import com.documentum.fc.client.DfOutOfServerSessionsException;
import com.documentum.fc.client.DfRestrictedAccessException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.impl.MessageHelper;
import java.util.HashMap;
import java.util.Map;

public final class DocbaseExceptionMapper {
    private static final Map<String, Boolean> s_exceptionWorthiness = new HashMap<String, Boolean>();

    public static DfException newException(String message, Object[] arguments) {
        return DocbaseExceptionMapper.newException(new MessageHelper(message, arguments));
    }

    public static DfException newException(MessageHelper messageHelper) {
        String messageId = messageHelper.getMessageId();
        if (messageId.equals("DM_SESSION_E_MAX_SESSIONS_EXCEEDED")) {
            return new DfOutOfServerSessionsException();
        }
        if (DocbaseExceptionMapper.isIdNotFoundException(messageId)) {
            DfId objectId = new DfId(messageHelper.getArguments()[0].toString());
            return new DfIdNotFoundException((IDfId)objectId, (Throwable)new DfException(messageHelper));
        }
        if (DocbaseExceptionMapper.isAuthenticationException(messageId)) {
            return new DfAuthenticationException(messageHelper);
        }
        if (DocbaseExceptionMapper.isRestrictedAccessException(messageId)) {
            return new DfRestrictedAccessException(messageHelper);
        }
        return new DfException(messageHelper);
    }

    private static boolean isIdNotFoundException(String messageId) {
        if (messageId.equals("DM_SESSION_W_FETCH_FAILED")) {
            return true;
        }
        return messageId.indexOf("CANT_FETCH_INVALID_ID") >= 0;
    }

    private static boolean isAuthenticationException(String messageId) {
        if (messageId.equals("DM_SESSION_E_NT_UNIFIED_LOGON_FAILED")) {
            return true;
        }
        if (messageId.equals("DM_SESSION_E_LDAP_AUTHENTICATION_FAILED")) {
            return true;
        }
        if (messageId.equals("DM_SESSION_E_AUTH_FAIL")) {
            return true;
        }
        if (messageId.equals("DM_SESSION_E_AUTH_PLUGIN_AUTH_FAIL")) {
            return true;
        }
        if (messageId.equals("DM_SESSION_E_INLINE_AUTHENTICATION_FAILED")) {
            return true;
        }
        if (messageId.equals("DM_SESSION_E_LDAP_AUTH_FAILED")) {
            return true;
        }
        return messageId.equals("DM_SESSION_E_PASSWORD_EXPIRED");
    }

    private static boolean isRestrictedAccessException(String messageId) {
        return messageId.equals("DM_SESSION_E_RESTRICTED_ACCESS");
    }

    public static boolean isWorthyOfException(String messageId, int severity) {
        Boolean exceptionWorthiness = s_exceptionWorthiness.get(messageId);
        if (exceptionWorthiness != null) {
            return exceptionWorthiness;
        }
        if (severity > 2) {
            return true;
        }
        if (severity < 2) {
            return false;
        }
        return DfPreferences.getInstance().shouldThrowWarnings();
    }

    static {
        s_exceptionWorthiness.put("DM_ACL_E_CANT_FETCH_ACL", false);
        s_exceptionWorthiness.put("DM_SESSION_E_PASSWORD_EXPIRED", false);
        s_exceptionWorthiness.put("DM_SYSOBJECT_W_NOT_PRUNED", false);
        s_exceptionWorthiness.put("DM_OBJECT_W_GET_ATTR_LENGTH_ERROR", false);
        s_exceptionWorthiness.put("DM_QUERY_W_NOT_A_FOLDER_PATH", false);
        s_exceptionWorthiness.put("DM_OBJECT_W_SET_ATTR_STRING_TOO_LONG", false);
        s_exceptionWorthiness.put("DM_XFRM_W_NO_CONVERT_LOC_DEFINED", false);
        s_exceptionWorthiness.put("DM_SESSION_W_TRANSACTION_FAILURE", true);
        s_exceptionWorthiness.put("DM_SESSION_W_ROLLBACK_FAILURE", true);
        s_exceptionWorthiness.put("DM_SESSION_W_CANT_BEGIN_TRANSACTION", true);
        s_exceptionWorthiness.put("DM_SESSION_W_FETCH_FAILED", true);
        s_exceptionWorthiness.put("DM_SYSOBJECT_W_FOLDER_DEFACL", true);
        s_exceptionWorthiness.put("DM_QUERY_I_MODIFY_ATTR_NO", true);
    }
}

