/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.docbase;

import com.documentum.fc.client.IDfGetObjectOptions;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnection;
import com.documentum.fc.client.impl.connection.docbase.UnknownServerResponseException;
import com.documentum.fc.client.impl.typeddata.DynamicallyTypedData;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.ITypedDataIterator;
import com.documentum.fc.common.DfDocbaseConstants;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfList;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.impl.annotation.Mask;
import com.documentum.xml.xquery.IDfXQueryTargets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocbaseApi {
    private final IDocbaseConnection m_connection;
    private static final int STANDARD_BATCH_HINT = 50;
    private static final int IMMEDIATE_SHUTDOWN = 2;
    private static final int GRACEFUL_SHUTDOWN = 1;

    public DocbaseApi(IDocbaseConnection connection) {
        this.m_connection = connection;
    }

    public ITypedDataIterator getEvents(String username, boolean inTransaction) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(username)) {
            arguments.setString("USER", username);
        }
        arguments.setBoolean("TRANSACTION", inTransaction);
        return this.m_connection.applyForCollection("GetEvents", null, arguments, 50, true, true, true, false);
    }

    public boolean anyEvents() throws DfException {
        return this.m_connection.applyForBool("AnyEvents", null, null, true, true, true);
    }

    public ITypedDataIterator exec(String query, boolean forUpdate, int batchHint, boolean acquireReadQueryLock) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("QUERY", query);
        arguments.setBoolean("FOR_UPDATE", forUpdate);
        arguments.setInt("BATCH_HINT", batchHint);
        arguments.setBoolean("BOF_DQL", true);
        return this.m_connection.applyForCollection("EXEC", null, arguments, batchHint, true, true, true, acquireReadQueryLock);
    }

    public ITypedDataIterator exec(String query, boolean forUpdate, int batchHint, boolean acquireReadQueryLock, int flushBatch) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("QUERY", query);
        arguments.setBoolean("FOR_UPDATE", forUpdate);
        arguments.setInt("BATCH_HINT", batchHint);
        arguments.setBoolean("BOF_DQL", true);
        arguments.setInt("FLUSH_BATCH", flushBatch);
        return this.m_connection.applyForCollection("EXEC", null, arguments, batchHint, true, true, true, acquireReadQueryLock);
    }

    public ITypedData parameterizedFetch(String methodName, IDfId objectId, String typeName, boolean forRevert, int cacheVStamp, IDfGetObjectOptions objectOptions) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(typeName)) {
            arguments.setString("OBJECT_TYPE", typeName);
        } else if (!StringUtil.isEmptyOrNull(objectOptions.getTypeName())) {
            arguments.setString("OBJECT_TYPE", objectOptions.getTypeName());
        }
        arguments.setBoolean("FOR_REVERT", forRevert);
        arguments.setInt("CACHE_VSTAMP", cacheVStamp);
        if (objectOptions.getPartitionId() != -1) {
            arguments.setInt("I_PARTITION", objectOptions.getPartitionId());
        }
        return this.m_connection.applyForObject(methodName, objectId, arguments, true, true, true);
    }

    public ITypedData sysObjRevert(IDfId objectId, String typeName, int cacheVStamp, IDfGetObjectOptions objectOptions) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(typeName)) {
            arguments.setString("OBJECT_TYPE", typeName);
        } else if (!StringUtil.isEmptyOrNull(objectOptions.getTypeName())) {
            arguments.setString("OBJECT_TYPE", objectOptions.getTypeName());
        }
        arguments.setBoolean("FOR_REVERT", true);
        arguments.setInt("CACHE_VSTAMP", cacheVStamp);
        if (objectOptions.getPartitionId() != -1) {
            arguments.setInt("I_PARTITION", objectOptions.getPartitionId());
        }
        return this.m_connection.applyForObject("SysObjRevert", objectId, arguments, true, true, true);
    }

    public ITypedData lightObjRevert(IDfId objectId, String typeName, int cacheVStamp, IDfGetObjectOptions objectOptions) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(typeName)) {
            arguments.setString("OBJECT_TYPE", typeName);
        } else if (!StringUtil.isEmptyOrNull(objectOptions.getTypeName())) {
            arguments.setString("OBJECT_TYPE", objectOptions.getTypeName());
        }
        arguments.setBoolean("FOR_REVERT", true);
        arguments.setInt("CACHE_VSTAMP", cacheVStamp);
        if (objectOptions.getPartitionId() != -1) {
            arguments.setInt("I_PARTITION", objectOptions.getPartitionId());
        }
        return this.m_connection.applyForObject("LiteObjRevert", objectId, arguments, true, true, true);
    }

    public ITypedData sysObjCheckout(IDfId objectId, String typeName, IDfId chronicleId, String versionLabel, String compoundArchValue, String specialAppValue, boolean disallowRelock, ITypedData lightObjectData, int cacheVStamp) throws DfException {
        ITypedData arguments;
        ITypedData iTypedData = arguments = lightObjectData != null ? lightObjectData : new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(typeName)) {
            arguments.setString("OBJECT_TYPE", typeName);
        }
        arguments.setId("_CHRONICLE_ID_", chronicleId);
        if (!StringUtil.isEmptyOrNull(versionLabel)) {
            arguments.setString("_VERSION_LABEL_", versionLabel);
        }
        if (!StringUtil.isEmptyOrNull(compoundArchValue)) {
            arguments.setString("_COMP_ARCH_", compoundArchValue);
        }
        if (!StringUtil.isEmptyOrNull(specialAppValue)) {
            arguments.setString("_SPEC_APP_", specialAppValue);
        }
        arguments.setBoolean("_DISALLOW_RELOCK_FLAG_", disallowRelock);
        arguments.setInt("CACHE_VSTAMP", cacheVStamp);
        return this.m_connection.applyForObject("SysObjCheckout", objectId, arguments, true, true, true);
    }

    public boolean sysObjUnlock(IDfId objectId, boolean sendMail, String compoundValue, String specialValue) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("_SEND_MAIL_", sendMail);
        if (!StringUtil.isEmptyOrNull(compoundValue)) {
            arguments.setString("_COMP_ARCH_", compoundValue);
        }
        if (!StringUtil.isEmptyOrNull(specialValue)) {
            arguments.setString("_SPEC_APP_", specialValue);
        }
        return this.m_connection.applyForBool("SysObjUnlock", objectId, arguments, true, true, true);
    }

    public boolean isCurrent(IDfId objectId, String typeName, int vstamp, int cacheVStamp, int typeCacheVStamp, List<String> aspectTypeNames, List<Integer> aspectTypeVStamp) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(typeName)) {
            arguments.setString("OBJECT_TYPE", typeName);
        }
        arguments.setInt("i_vstamp", vstamp);
        arguments.setInt("CACHE_VSTAMP", cacheVStamp);
        arguments.setInt("TYPE_CACHE_VSTAMP", typeCacheVStamp);
        if (aspectTypeNames != null) {
            int count = aspectTypeNames.size();
            for (int i = 0; i < count; ++i) {
                String aspectTypeName = aspectTypeNames.get(i);
                if (StringUtil.isEmptyOrNull(aspectTypeName)) continue;
                arguments.appendString("ASPECT_INT_TYPE_NAME", aspectTypeName);
                arguments.appendInt("ASPECT_INT_TYPE_VSTAMP", aspectTypeVStamp.get(i));
            }
        }
        return this.m_connection.applyForBool("IsCurrent", objectId, arguments, true, true, true);
    }

    public void policyInstall(IDfId objectId, boolean notifyFlag) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("NOTIFY_FLAG", notifyFlag);
        this.m_connection.apply("PolicyInstall", objectId, arguments, true, true, true);
    }

    public void policyUninstall(IDfId objectId, boolean notifyFlag) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("NOTIFY_FLAG", notifyFlag);
        this.m_connection.apply("PolicyUninstall", objectId, arguments, true, true, true);
    }

    public String policySubtypes(IDfId policyId) throws DfException {
        return this.m_connection.applyForString("PolicySubtypes", policyId, null, true, true, true);
    }

    public void policyValidate(IDfId objectId) throws DfException {
        this.m_connection.apply("PolicyValidate", objectId, null, true, true, true);
    }

    public IDfId getExtTypeObjId(IDfId policyId, int stateNo) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("_STATE_NO_", stateNo);
        return new DfId(this.m_connection.applyForString("GetExtTypeObjID", policyId, arguments, true, true, true));
    }

    public String outputDoc(IDfId objectId, String outputDeviceName, long start, long end, boolean cover, boolean save, long copies) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_DEVICE_NAME_", outputDeviceName);
        arguments.setLong("startpage", start);
        arguments.setLong("endpage", end);
        arguments.setBoolean("cover", cover);
        arguments.setBoolean("saverend", save);
        arguments.setLong("copies", copies);
        return this.m_connection.applyForString("OutputDoc", objectId, arguments, true, true, true);
    }

    public IDfId createAuditForEvent(IDfId objectId, IDfId chronicleId, String eventName, String userName, String reason) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("CHRON_ID", chronicleId.getId());
        arguments.setString("EVENT", eventName);
        arguments.setString("USER_NAME", userName == null ? "" : userName);
        arguments.setString("REASON", reason == null ? "" : reason);
        return this.m_connection.applyForId("CreateAuditForEvent", objectId, arguments, true, true, true);
    }

    public void createExtTypeObj(IDfId newPolicyId, IDfId oldPolicyId, String oldExtensionType) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("_NEW_POLICY_ID_", newPolicyId);
        arguments.setId("_OLD_POLICY_ID_", oldPolicyId);
        arguments.setString("_OLD_EXTENSION_TYPE_", oldExtensionType);
        this.m_connection.apply("CreateExtTypeObj", newPolicyId, arguments, true, true, true);
    }

    public void sysObjectAttach(IDfId sysObjectId, String policyId, String state, String aliasSet, String sessionAliasSet) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_POLICY_ID_", policyId);
        arguments.setString("_ATTACH_STATE_", state == null ? "" : state);
        arguments.setString("_ALIAS_SET_", aliasSet == null ? "" : aliasSet);
        arguments.setString("_SESSION_ALIAS_SET_", sessionAliasSet);
        this.m_connection.apply("SysObjAttach", sysObjectId, arguments, true, true, true);
    }

    public void sysObjectDetachPolicy(IDfId sysObjectId) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_POLICY_ID_", "");
        arguments.setString("_ATTACH_STATE", "");
        arguments.setString("_ALIAS_SET_", "");
        this.m_connection.apply("SysObjAttach", sysObjectId, arguments, true, true, true);
    }

    public void sysObjectPromote(IDfId sysObjectId, String state, boolean override, boolean testOnly, boolean cancel, IDfTime scheduledDate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_TO_STATE_", state == null ? "" : state);
        arguments.setBoolean("_OVERRIDE_FLAG_", override);
        arguments.setBoolean("_TEST_ONLY_FLAG_", testOnly);
        arguments.setBoolean("_CANCEL_FLAG_", cancel);
        arguments.setTime("_SCHEDULED_DATE_", scheduledDate);
        this.m_connection.apply("SysObjPromote", sysObjectId, arguments, true, true, true);
    }

    public void sysObjectDemote(IDfId sysObjectId, String toState, boolean toBase, boolean cancel, IDfTime scheduledDate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_TO_STATE_", toState == null ? "" : toState);
        arguments.setBoolean("_BASE_FLAG_", toBase);
        arguments.setBoolean("_CANCEL_FLAG_", cancel);
        arguments.setTime("_SCHEDULED_DATE_", scheduledDate);
        this.m_connection.apply("SysObjDemote", sysObjectId, arguments, true, true, true);
    }

    public void sysObjectResume(IDfId sysObjectId, String fromState, boolean toBase, boolean override, boolean testOnly, boolean cancel, IDfTime scheduledDate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_FROM_STATE_", fromState == null ? "" : fromState);
        arguments.setBoolean("_BASE_FLAG_", toBase);
        arguments.setBoolean("_OVERRIDE_FLAG_", override);
        arguments.setBoolean("_TEST_ONLY_FLAG_", testOnly);
        arguments.setBoolean("_CANCEL_FLAG_", cancel);
        arguments.setTime("_SCHEDULED_DATE_", scheduledDate);
        this.m_connection.apply("SysObjResume", sysObjectId, arguments, true, true, true);
    }

    public void sysObjectSuspend(IDfId sysObjectId, String fromState, boolean override, boolean fTestOnly, boolean cancel, IDfTime scheduledDate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_FROM_STATE_", fromState == null ? "" : fromState);
        arguments.setBoolean("_OVERRIDE_FLAG_", override);
        arguments.setBoolean("_TEST_ONLY_FLAG_", fTestOnly);
        arguments.setBoolean("_CANCEL_FLAG_", cancel);
        arguments.setTime("_SCHEDULED_DATE_", scheduledDate);
        this.m_connection.apply("SysObjSuspend", sysObjectId, arguments, true, true, true);
    }

    public ITypedData referenceFetchInfo(IDfId sourceObjectId, String bindingLabel, String bindingCondition, boolean returnACLInfo) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("BINDING_TYPE", bindingCondition);
        arguments.setString("BINDING_LABEL", bindingLabel);
        arguments.setBoolean("RETURN_ACL_INFO", returnACLInfo);
        return this.m_connection.applyForObject("ReferenceFetchInfo", sourceObjectId, arguments, true, true, true);
    }

    public void referenceRefresh(IDfId mirrorId, ITypedData refreshData) throws DfException {
        this.m_connection.apply("ReferenceRefresh", mirrorId, refreshData, true, true, true);
    }

    public void referenceRefreshAcl(IDfId mirrorId, ITypedData refreshData) throws DfException {
        this.m_connection.apply("ReferenceRefreshAcl", mirrorId, refreshData, true, true, true);
    }

    public IDfId convertId(IDfId objectId, String format, int page, String pageModifier, boolean convert, boolean useConvert) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("page", page);
        arguments.setString("format", format);
        if (!StringUtil.isEmptyOrNull(pageModifier)) {
            arguments.setString("page_modifier", pageModifier);
        }
        arguments.setBoolean("convert", convert);
        arguments.setBoolean("useconvert", useConvert);
        return this.m_connection.applyForId("CONVERT_ID", objectId, arguments, true, true, true);
    }

    public boolean replicaRefresh(IDfId id, ITypedData args) throws DfException {
        return this.m_connection.applyForBool("ReplicaRefresh", id, args, true, true, true);
    }

    public boolean replicaRefreshPostD6(IDfId id, ITypedData args) throws DfException {
        return this.m_connection.applyForBool("ReplicaRefreshPostD6", id, args, true, true, true);
    }

    public void audit(IDfId objectId, String eventName, boolean auditSubtypes, String controllingApp, String policyId, String stateName, int authentication, String eventDescription, IDfList attributeList, boolean signAudit, boolean esignatureRequired) throws DfException {
        int count;
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("_AUDITEDOBJECTID_", objectId);
        arguments.setString("_EVENTNAME_", eventName);
        arguments.setBoolean("_AUDIT_SUBTYPES_FLAG_", auditSubtypes);
        arguments.setString("_CONTROLLING_APP_", controllingApp == null ? "" : controllingApp);
        arguments.setString("_POLICY_ID_STR_", policyId == null ? "" : policyId);
        arguments.setString("_STATE_NAME_", stateName == null ? "" : stateName);
        arguments.setInt("_AUTHENTICATION_", authentication);
        arguments.setString("_EVENT_DESCRIPTION_", eventDescription == null ? "" : eventDescription);
        StringBuffer sb = new StringBuffer();
        if (attributeList != null && (count = attributeList.getCount()) > 0) {
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(attributeList.getString(i));
            }
        }
        arguments.setString("_ATTRIBUTE_LIST_", sb.toString());
        arguments.setBoolean("_SIGN_AUDIT_", signAudit);
        if (esignatureRequired) {
            arguments.setInt("_ESIGNATURE_REQUIRED_", 1);
        } else {
            arguments.setInt("_ESIGNATURE_REQUIRED_", 0);
        }
        this.m_connection.apply("dmAudit", objectId, arguments, true, true, true);
    }

    public void unaudit(IDfId objectId, String eventName, String controllingApp, String policyId, String stateName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("_AUDITEDOBJECTID_", objectId);
        arguments.setString("_EVENTNAME_", eventName);
        arguments.setString("_CONTROLLING_APP_", controllingApp == null ? "" : controllingApp);
        arguments.setString("_POLICY_ID_STR_", policyId == null ? "" : policyId);
        arguments.setString("_STATE_NAME_", stateName == null ? "" : stateName);
        this.m_connection.apply("dmUnAdudit", objectId, arguments, true, true, true);
    }

    public void retainerObjSetStatus(IDfId retainerId, String retainerTypeName, int status) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OBJECT_TYPE", retainerTypeName);
        arguments.setInt("STATUS_VALUE", status);
        this.m_connection.apply("RetainerObjSetStatus", retainerId, arguments, true, true, true);
    }

    public ITypedData checkCacheConfig(String name, boolean forceCheck) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("CONFIG_NAME", name);
        arguments.setBoolean("FORCE_CHECK", forceCheck);
        return this.m_connection.applyForObject("CHECK_CACHE_CONFIG", null, arguments, true, true, true);
    }

    public IDfTime getServerTime() throws DfException {
        return this.m_connection.applyForTime("TIME", null, null, true, true, true);
    }

    public ITypedDataIterator setContentAttrs(IDfId parentId, String format, int page, String pageModifier, String parameters) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("FORMAT", format);
        arguments.setInt("PAGE", page);
        arguments.setString("PAGE_MODIFIER", pageModifier);
        arguments.setString("PARAMETERS", parameters);
        return this.m_connection.applyForCollection("SET_CONTENT_ATTRS", parentId, arguments, 50, true, true, false, false);
    }

    public ITypedDataIterator migrateContent(IDfId parentId, String targetStore, String renditions, boolean removeOriginal) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("TARGET_STORE", targetStore);
        arguments.setString("RENDITIONS", renditions);
        arguments.setBoolean("REMOVE_ORIGINAL", removeOriginal);
        return this.m_connection.applyForCollection("MIGRATE_CONTENT", parentId, arguments, 50, true, true, false, false);
    }

    public IDfId folderIdFindByPath(String folderPath) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_FOLDER_PATH_", folderPath);
        return this.m_connection.applyForId("FolderIdFindByPath", null, arguments, true, true, true);
    }

    public void pushContentAttrsInternal(IDfId id, ITypedData storeExtraData) throws DfException {
        this.m_connection.apply("PUSH_CONTENT_ATTRS_INTERNAL", id, storeExtraData, true, true, true);
    }

    public IDfId originalContent(IDfId parentId, int page) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("PAGE", page);
        return this.m_connection.applyForId("ORIGINAL_CONTENT", parentId, arguments, true, true, true);
    }

    public byte[] getTurboContent(IDfId contentId, IDfId sysObjectId) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("SYSOBJ_ID", sysObjectId);
        return this.m_connection.applyForByteArray("GET_TURBO_CONTENT", contentId, arguments, true, true, true);
    }

    public boolean isSeekable(int pullerHandle) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", pullerHandle);
        return this.m_connection.applyForBool("IS_SEEKABLE", null, arguments, true, true, false);
    }

    public long seek64(int pullerHandle, long position, int direction) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", pullerHandle);
        int upper = (int)(position >> 32);
        arguments.setInt("POSITION_HIGH", upper);
        int lower = (int)(position & 0xFFFFFFFFFFFFFFFFL);
        arguments.setInt("POSITION_LOW", lower);
        arguments.setInt("DIRECTION", direction);
        ITypedData resultObj = this.m_connection.applyForObject("SEEK_64", null, arguments, true, true, false);
        long position_low = resultObj.getInt("position_low");
        long position_high = resultObj.getInt("position_high");
        position_low <<= 32;
        return position_high << 32 | (position_low >>>= 32);
    }

    public long seek(int pullerHandle, long position, int direction) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", pullerHandle);
        int upper = (int)(position >> 32);
        arguments.setInt("POSITION_HIGH", upper);
        int lower = (int)(position & 0xFFFFFFFFFFFFFFFFL);
        arguments.setInt("POSITION_LOW", lower);
        arguments.setInt("DIRECTION", direction);
        return this.m_connection.applyForLong("SEEK", null, arguments, true, true, false);
    }

    public int makePuller(IDfId storeId, IDfId contentId, IDfId sysobjId, IDfId formatId, int storeTicket, boolean isOffline, boolean isOther, boolean compression, boolean noAccessUpdate) throws DfException {
        int pullerHandle;
        boolean implicitlyStartPull;
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("STORE", storeId);
        boolean bl = implicitlyStartPull = contentId != null && !contentId.isNull();
        if (implicitlyStartPull) {
            arguments.setId("CONTENT", contentId);
            arguments.setInt("TICKET", storeTicket);
            arguments.setId("FORMAT", formatId);
            arguments.setBoolean("IS_OTHER", isOther);
            arguments.setBoolean("IS_OFFLINE", isOffline);
            arguments.setBoolean("COMPRESSION", compression);
            if (noAccessUpdate) {
                arguments.setBoolean("NO_ACCESS_UPDATE", noAccessUpdate);
            }
            if (!sysobjId.isNull()) {
                arguments.setId("SYSOBJ_ID", sysobjId);
            }
        }
        if ((pullerHandle = this.m_connection.applyForInt("MAKE_PULLER", null, arguments, true, true, true)) == 0) {
            throw new UnknownServerResponseException("MAKE_PULLER", null, arguments);
        }
        return pullerHandle;
    }

    public boolean startPull(int handle, IDfId contentId, IDfId sysobjId, IDfId formatId, int storeTicket, boolean isOffline, boolean isOther, boolean compression, boolean noAccessUpdate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", handle);
        arguments.setId("CONTENT", contentId);
        arguments.setInt("TICKET", storeTicket);
        arguments.setId("FORMAT", formatId);
        arguments.setBoolean("IS_OTHER", isOther);
        arguments.setBoolean("IS_OFFLINE", isOffline);
        arguments.setBoolean("COMPRESSION", compression);
        if (noAccessUpdate) {
            arguments.setBoolean("NO_ACCESS_UPDATE", noAccessUpdate);
        }
        if (!sysobjId.isNull()) {
            arguments.setId("SYSOBJ_ID", sysobjId);
        }
        return this.m_connection.applyForBool("START_PULL", null, arguments, true, true, false);
    }

    public boolean endPull(int handle) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", handle);
        return this.m_connection.applyForBool("END_PULL", null, arguments, true, true, false);
    }

    public boolean killPuller(int handle) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", handle);
        return this.m_connection.applyForBool("KILL_PULLER", null, arguments, true, true, false);
    }

    public int makePusher(IDfId storeId, boolean compression) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("STORE", storeId);
        arguments.setBoolean("COMPRESSION", compression);
        return this.m_connection.applyForInt("MAKE_PUSHER", null, arguments, true, true, true);
    }

    public boolean startPush(int handle, IDfId contentId, IDfId formatId, int storeTicket, int sizeLow, int sizeHigh, boolean isOther, boolean compression, String encodedContentAttrs, ITypedData extraData, int partition_id) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.addValuesFrom(extraData);
        arguments.setInt("HANDLE", handle);
        arguments.setId("CONTENT_ID", contentId);
        arguments.setId("FORMAT", formatId);
        arguments.setInt("D_TICKET", storeTicket);
        arguments.setInt("SIZE", sizeLow);
        arguments.setInt("SIZE_LOW", sizeLow);
        arguments.setInt("SIZE_HIGH", sizeHigh);
        arguments.setBoolean("IS_OTHER", isOther);
        arguments.setBoolean("COMPRESSION", compression);
        arguments.setBoolean("CAN_USE_NEW_CALLBACKS", true);
        arguments.setString("ENCODED_CONTENT_ATTRS", encodedContentAttrs);
        arguments.setInt("I_PARTITION", partition_id);
        return this.m_connection.applyForBool("START_PUSH", null, arguments, true, true, false);
    }

    public int endPush(int handle) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", handle);
        int dataTicket = this.m_connection.applyForInt("END_PUSH", null, arguments, false, true, false);
        return dataTicket;
    }

    public ITypedData endPushV2(int handle) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", handle);
        ITypedData result = this.m_connection.applyForObject("END_PUSH_V2", null, arguments, false, true, false);
        return result;
    }

    public boolean killPusher(int handle) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("HANDLE", handle);
        return this.m_connection.applyForBool("KILL_PUSHER", null, arguments, true, true, false);
    }

    public ITypedDataIterator getPath(IDfId contentId, IDfId sysObjectId, IDfId sysObjectChronId, boolean other) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("SYSOBJ_ID", sysObjectId);
        arguments.setId("SYSOBJ_CHRON_ID", sysObjectChronId);
        arguments.setBoolean("IS_OTHER", other);
        return this.m_connection.applyForCollection("GET_PATH", contentId, arguments, 50, true, true, false, false);
    }

    public void parameterizedSave(String methodName, IDfId objectId, ITypedData saveData, int cacheVStamp) throws DfException {
        saveData.setInt("CACHE_VSTAMP", cacheVStamp);
        if (this.m_connection.applyForInt(methodName, objectId, saveData, true, true, true) == 0) {
            throw new UnknownServerResponseException(methodName, objectId, saveData);
        }
    }

    public ITypedData saveContAttrsV6(IDfId objectId, ITypedData saveData) throws DfException {
        ITypedData result = this.m_connection.applyForObject("SAVE_CONT_ATTRS_V6", objectId, saveData, true, true, true);
        return result;
    }

    public IDfId makeDump(IDfId objectId, ITypedData argData) throws DfException {
        return this.m_connection.applyForId("MAKE_DUMP", objectId, argData, true, true, true);
    }

    public boolean continueDump(IDfId objectId) throws DfException {
        return this.m_connection.applyForBool("CONTINUE_DUMP", objectId, null, true, true, true);
    }

    public IDfId makeLoad(IDfId objectId, ITypedData argData) throws DfException {
        return this.m_connection.applyForId("MAKE_LOAD", objectId, argData, true, true, true);
    }

    public boolean continueLoad(IDfId objectId) throws DfException {
        return this.m_connection.applyForBool("CONTINUE_LOAD", objectId, null, true, true, true);
    }

    public ITypedData getType(IDfId objectId) throws DfException {
        return this.m_connection.applyForObject("GETTYPE", objectId, null, true, true, true);
    }

    public IDfId nextId(int tag, int count) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("TAG", tag);
        arguments.setInt("HOW_MANY", count);
        return this.m_connection.applyForId("NEXT_ID", null, arguments, true, true, true);
    }

    public ITypedData nextIdList(int tag, int count) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("TAG", tag);
        arguments.setInt("HOW_MANY", count);
        return this.m_connection.applyForObject("NEXT_ID_LIST", null, arguments, true, true, true);
    }

    public ITypedData getDDObject(String handle) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("DD_HANDLE", handle);
        return this.m_connection.applyForObject("GET_DD_OBJECT", null, arguments, true, true, true);
    }

    public void parameterizedExpunge(String methodName, IDfId objectId, int vstamp, String typeName, boolean force, String reason, boolean forceDeleteChildren) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("i_vstamp", vstamp);
        if (!StringUtil.isEmptyOrNull(typeName)) {
            arguments.setString("OBJECT_TYPE", typeName);
        }
        if (force) {
            if (methodName.equals("ACLExpunge")) {
                arguments.setBoolean("_ACL_FORCE_", force);
            } else if (methodName.equals("PolicyExpunge")) {
                arguments.setBoolean("EXPUNGE_OPTION", force);
            } else if (methodName.equals("LocationExpunge") || methodName.equals("MountPointExpunge")) {
                arguments.setBoolean("_EXPUNGE_OPTION_", force);
            } else if (methodName.equals("SysObjExpunge")) {
                arguments.setBoolean("FORCE_DELETE", true);
            }
            if (reason != null) {
                arguments.setString("FORCE_DELETE_REASON", reason);
            }
        }
        if (forceDeleteChildren) {
            arguments.setBoolean("DELETE_ALL_CHILDREN", forceDeleteChildren);
        }
        this.m_connection.apply(methodName, objectId, arguments, true, true, true);
    }

    public String getLogin(String userName, String scope, int timeout, boolean singleUse, String serverName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(userName)) {
            arguments.setString("OPTIONAL_USER_NAME", userName);
        }
        if (!StringUtil.isEmptyOrNull(scope)) {
            arguments.setString("LOGIN_TICKET_SCOPE", scope);
        }
        if (!StringUtil.isEmptyOrNull(serverName)) {
            arguments.setString("SERVER_NAME", serverName);
        }
        if (timeout > 0) {
            arguments.setInt("LOGIN_TICKET_TIMEOUT", timeout);
        }
        if (singleUse) {
            arguments.setString("SINGLE_USE", "T");
        } else {
            arguments.setString("SINGLE_USE", "F");
        }
        return this.m_connection.applyForString("GET_LOGIN", null, arguments, true, true, true);
    }

    public ITypedDataIterator doMethod(IDfId objectId, String method, String methodArguments, Integer timeOutSeconds, Boolean launchDirect, Boolean launchAsync, Boolean runAsServer, Boolean traceLaunch) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("METHOD", method);
        if (methodArguments != null) {
            arguments.setString("ARGUMENTS", methodArguments);
        }
        if (timeOutSeconds != null) {
            arguments.setInt("TIME_OUT", timeOutSeconds);
        }
        if (launchDirect != null) {
            arguments.setBoolean("LAUNCH_DIRECT", launchDirect);
        }
        if (launchAsync != null) {
            arguments.setBoolean("LAUNCH_ASYNC", launchAsync);
        }
        if (runAsServer != null) {
            arguments.setBoolean("RUN_AS_SERVER", runAsServer);
        }
        if (traceLaunch != null) {
            arguments.setBoolean("TRACE_LAUNCH", traceLaunch);
        }
        return this.m_connection.applyForCollection("DO_METHOD", objectId, arguments, 50, true, true, true, false);
    }

    public boolean flushSessionCache(String flushType) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_TYPES_", flushType);
        return this.m_connection.applyForBool("FlushSessionCache", null, arguments, true, true, true);
    }

    public boolean sysObjFlushCache(boolean discardDirty, IDfId objectIdToFlush) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("_DISCARD_DIRTY_", discardDirty);
        return this.m_connection.applyForBool("SysObjFlushCache", objectIdToFlush, arguments, true, true, true);
    }

    public int sysObjGetPermit(IDfId objectId, String accessorName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_ACC_NAME_", accessorName);
        return this.m_connection.applyForInt("SysObjGetPermit", objectId, arguments, true, true, true);
    }

    public int sysObjGetXPermit(IDfId objectId, String accessorName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_ACC_NAME_", accessorName);
        return this.m_connection.applyForInt("SysObjGetXPermit", objectId, arguments, true, true, true);
    }

    public int aclObjGetPermit(IDfId objectId, String accessorName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_ACC_NAME_", accessorName);
        return this.m_connection.applyForInt("AclObjGetPermit", objectId, arguments, true, true, true);
    }

    public int aclObjGetXPermit(IDfId objectId, String accessorName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_ACC_NAME_", accessorName);
        return this.m_connection.applyForInt("AclObjGetXPermit", objectId, arguments, true, true, true);
    }

    public ITypedData sysObjProcACL(IDfId objectId, ITypedData saveData) throws DfException {
        return this.m_connection.applyForObject("SysObjProcACL", objectId, saveData, true, true, true);
    }

    public boolean paramatarizedPrune(String methodName, IDfId objectId, boolean keepLabels) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("_KEEP_LABELS_", keepLabels);
        return this.m_connection.applyForBool(methodName, objectId, arguments, true, true, true);
    }

    public boolean checkRetentionExpiredForContent(IDfId contentId) throws DfException {
        return this.m_connection.applyForBool("CHECK_RETENTION_EXPIRED_FOR_CONTENT", contentId, null, true, true, true);
    }

    public void publishDataDictionary(String locale, String typeName, String attributeName, boolean forceRepublish) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(locale)) {
            arguments.setString("NLS_KEY", locale);
        }
        if (!StringUtil.isEmptyOrNull(typeName)) {
            arguments.setString("TYPE_NAME", typeName);
        }
        if (!StringUtil.isEmptyOrNull(attributeName)) {
            arguments.setString("ATTRIBUTE_NAME", attributeName);
        }
        arguments.setBoolean("FORCE_REPUBLISH", forceRepublish);
        this.m_connection.apply("PUBLISH_DATA_DICTIONARY", null, arguments, true, true, true);
    }

    public boolean enableTimeout() throws DfException {
        return this.m_connection.applyForBool("ENABLE_TIMEOUT", null, null, true, true, true);
    }

    public boolean disableTimeout() throws DfException {
        return this.m_connection.applyForBool("DISABLE_TIMEOUT", null, null, true, true, true);
    }

    public ITypedDataIterator parameterizedApply(String methodName, IDfId objectId, ITypedData arguments, boolean throwErrors) throws DfException {
        return this.m_connection.applyForCollection(methodName, objectId, arguments, 50, throwErrors, true, true, false);
    }

    public String groupAllUsers(IDfId objectId) throws DfException {
        return this.m_connection.applyForString("GroupAllUsers", objectId, null, true, true, true);
    }

    public ITypedData parameterizedCheckin(String methodName, IDfId objectId, ITypedData saveData) throws DfException {
        return this.m_connection.applyForObject(methodName, objectId, saveData, true, true, true);
    }

    public ITypedData parameterizedBranch(String methodName, IDfId objectId, IDfId chronicleId, String typeName, String versionLabel) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OBJECT_TYPE", typeName);
        arguments.setId("_CHRONICLE_ID_", chronicleId);
        arguments.setString("_VERSION_LABEL_", versionLabel == null ? "" : versionLabel);
        return this.m_connection.applyForObject(methodName, objectId, arguments, true, true, true);
    }

    public void procStateOp(IDfId objectId, int action, boolean recur, boolean restart) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("ArgAction", action);
        arguments.setBoolean("ArgRecur", recur);
        arguments.setBoolean("ArgRestart", restart);
        this.m_connection.apply("ProcStateOp", objectId, arguments, true, true, true);
    }

    public void procDestroy(IDfId objectId) throws DfException {
        this.m_connection.apply("ProcDestroy", objectId, null, true, true, true);
    }

    public void wflowStateOp(IDfId objectId, int action, String sessionAliasSet) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("ArgAction", action);
        arguments.setString("sessionaliasset", sessionAliasSet);
        this.m_connection.apply("WflowStateOp", objectId, arguments, true, true, true);
    }

    public void wflowActStateOp(IDfId objectId, int action, int actSeqNo, int suspendInterval, boolean manualComplete, String sessionAliasSet) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("ArgAction", action);
        arguments.setInt("ArgActSeqno", actSeqNo);
        arguments.setInt("ArgSuspendInterval", suspendInterval);
        arguments.setBoolean("ArgManualCompleteFlag", manualComplete);
        arguments.setString("sessionaliasset", sessionAliasSet);
        this.m_connection.apply("WflowActStateOp", objectId, arguments, true, true, true);
    }

    public void wflowSetSkillLevel(IDfId objectId, String packageName, int skillLevel) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("ArgPackageName", packageName);
        arguments.setInt("ArgSkillLevel", skillLevel);
        this.m_connection.apply("WflowSetSkillLevel", objectId, arguments, true, true, true);
    }

    public void wflowRemoveAttachment(IDfId objectId, IDfId attachmentId) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("ArgAttachmentId", attachmentId);
        this.m_connection.apply("WflowRemoveAttachment", objectId, arguments, true, true, true);
    }

    public IDfId wflowAddAttachment(IDfId objectId, String compType, IDfId compId, String compName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("ArgPackageType", compType);
        arguments.setId("ArgComponentId", compId);
        arguments.setString("ArgComponentName", compName);
        return this.m_connection.applyForId("WflowAddAttachment", objectId, arguments, true, true, true);
    }

    public void wflowSetSupervisor(IDfId objectId, String newSupervisor) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("ArgPackageType", newSupervisor);
        this.m_connection.apply("WflowSetSupervisor", objectId, arguments, true, true, true);
    }

    public void wflowSetPerformers(IDfId objectId, String actName, IDfList performerName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("ArgPackageName", actName);
        if (performerName != null) {
            int limit = performerName.getCount();
            for (int i = 0; i < limit; ++i) {
                String name = performerName.getString(i);
                if (StringUtil.isEmptyOrNull(name = DfUtil.fromQuotedString(name))) continue;
                arguments.appendString("ArgPackageType", name);
            }
        }
        this.m_connection.apply("WflowSetPerformers", objectId, arguments, true, true, true);
    }

    public void wflowRemovePackage(IDfId objectId, String actName, String portName, String packageName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("ArgStartActName", actName);
        arguments.setString("ArgInputPortName", portName);
        arguments.setString("ArgPackageName", packageName);
        this.m_connection.apply("WflowRemovePackage", objectId, arguments, true, true, true);
    }

    public IDfId wflowAddPackage(IDfId objectId, String startActName, String inputPortName, String packageName, String packageType, IDfId noteId, boolean keepPermanent, IDfList componentIds, IDfList componentNames, int skillLevel, String sessionAliasSet) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("ArgStartActName", startActName);
        arguments.setString("ArgInputPortName", inputPortName);
        arguments.setString("ArgPackageName", packageName);
        arguments.setString("ArgPackageType", packageType);
        arguments.setId("ArgNoteId", noteId);
        arguments.setBoolean("ArgKeepPermanent", keepPermanent);
        arguments.setInt("ArgSkillLevel", skillLevel);
        arguments.setString("sessionaliasset", sessionAliasSet);
        int comp_cnt = componentIds.getCount();
        int comp_name_cnt = componentNames.getCount();
        for (int i = 0; i < comp_cnt; ++i) {
            arguments.appendString("ArgComponentId", componentIds.getId(i).getId());
            if (i < comp_name_cnt && componentNames.get(i) != null) {
                arguments.appendString("ArgComponentName", componentNames.getString(i));
                continue;
            }
            arguments.appendString("ArgComponentName", "");
        }
        IDfId result = this.m_connection.applyForId("WflowAddPackage", objectId, arguments, false, true, true);
        if (result == null || result.isNull()) {
            DfException exception = this.m_connection.getException();
            if (exception != null) {
                throw exception;
            }
            throw new UnknownServerResponseException("WflowAddPackage", objectId, arguments);
        }
        return result;
    }

    public IDfId inboxItemAppend(IDfId objectId, String queueName, int priority, String event, boolean sendMail, String message, IDfTime dueDate, String sessionAliasSet) throws DfException {
        queueName = DfUtil.fromQuotedString(queueName);
        message = DfUtil.fromQuotedString(message);
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("list_id", queueName);
        arguments.setInt("priority", priority);
        arguments.setString("event", event);
        arguments.setBoolean("sendmail", sendMail);
        arguments.setString("message", message);
        arguments.setTime("due_date", dueDate);
        arguments.setString("sessionaliasset", sessionAliasSet);
        return this.m_connection.applyForId("InboxItemAppend", objectId, arguments, true, true, true);
    }

    public void witemComplete(IDfId objectId, int returnValue, String osError, IDfId resultId, int userTime, double userCost, String sessionAliasSet) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("return_value", returnValue);
        arguments.setString("os_error", osError);
        arguments.setId("result_id", resultId);
        arguments.setInt("user_time", userTime);
        arguments.setDouble("user_cost", userCost);
        arguments.setString("sessionaliasset", sessionAliasSet);
        this.m_connection.apply("WITEMComplete", objectId, arguments, true, true, true);
    }

    public void witemResume(IDfId objectId) throws DfException {
        this.m_connection.apply("WITEMResume", objectId, null, true, true, true);
    }

    public void witemPause(IDfId objectId) throws DfException {
        this.m_connection.apply("WITEMPause", objectId, null, true, true, true);
    }

    public void witemReassign(IDfId objectId, String newPerformer, String sessionAliasSet) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("newperformer", newPerformer);
        arguments.setString("sessionaliasset", sessionAliasSet);
        this.m_connection.apply("WITEMReassign", objectId, arguments, true, true, true);
    }

    public void witemSetPriority(IDfId objectId, int newPriority) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("return_value", newPriority);
        this.m_connection.apply("WITEMSetPriority", objectId, arguments, true, true, true);
    }

    public void witemSetOutput(IDfId objectId, IDfList outputPorts) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        int performer_cnt = 0;
        if (outputPorts != null) {
            int limit = outputPorts.getCount();
            for (int i = 0; i < limit; ++i) {
                String name = outputPorts.getString(i);
                if (name == null || name.length() <= 0) continue;
                ++performer_cnt;
                arguments.appendString("output_ports", name);
            }
        }
        arguments.setInt("ext_performer_count", performer_cnt);
        this.m_connection.apply("WITEMSetOutput", objectId, arguments, true, true, true);
    }

    public void witemRepeat(IDfId objectId, IDfList users) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        int performer_cnt = 0;
        if (users != null) {
            int limit = users.getCount();
            for (int i = 0; i < limit; ++i) {
                String name = users.getString(i);
                if (StringUtil.isEmptyOrNull(name = DfUtil.fromQuotedString(name))) continue;
                ++performer_cnt;
                arguments.appendString("ext_performers", name);
            }
        }
        arguments.setInt("ext_performer_count", performer_cnt);
        this.m_connection.apply("WITEMRepeat", objectId, arguments, true, true, true);
    }

    public void witemAcquire(IDfId objectId) throws DfException {
        this.m_connection.apply("WITEMAcquire", objectId, null, true, true, true);
    }

    public void witemRemovePackage(IDfId objectId, String packageName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("pkgname", packageName);
        this.m_connection.apply("WITEMRemovePackage", objectId, arguments, true, true, true);
    }

    public IDfId witemAddPackage(IDfId objectId, String packageName, String packageType, IDfList componentIds, IDfList componentNames, int skillLevel) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("pkgname", packageName);
        arguments.setString("pkgtype", packageType);
        arguments.setInt("skill_level", skillLevel);
        int comp_cnt = componentIds.getCount();
        int comp_name_cnt = componentNames.getCount();
        for (int i = 0; i < comp_cnt; ++i) {
            arguments.appendString("components", componentIds.getId(i).getId());
            if (i < comp_name_cnt && componentNames.get(i) != null) {
                arguments.appendString("ArgComponentName", componentNames.getString(i));
                continue;
            }
            arguments.appendString("ArgComponentName", "");
        }
        arguments.setInt("component_count", comp_cnt);
        return this.m_connection.applyForId("WITEMAddPackage", objectId, arguments, true, true, true);
    }

    public void iPkgAddNote(IDfId objectId, IDfId noteId, boolean keepPermernent) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("IPKGIdString", noteId.getId());
        arguments.setBoolean("IPKGFlag", keepPermernent);
        this.m_connection.apply("IPKGAddNote", objectId, arguments, true, true, true);
    }

    public void iPkgRemoveNote(IDfId objectId, IDfId noteId) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("IPKGIdString", noteId.getId());
        this.m_connection.apply("IPKGRemoveNote", objectId, arguments, true, true, true);
    }

    public IDfId iPkgBind(IDfId objectId, IDfId compId, String compLabel, IDfId compChronId, String packageType) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("IPKGPackageId", compId);
        arguments.setString("IPKGPackageLabel", compLabel);
        arguments.setString("ArgPackageType", packageType);
        arguments.setId("IPKGComponentChronId", compChronId);
        return this.m_connection.applyForId("IPKGBind", objectId, arguments, true, true, true);
    }

    public void actStateOp(IDfId objectId, int action) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("ArgAction", action);
        this.m_connection.apply("ActStateOp", objectId, arguments, true, true, true);
    }

    public ITypedData actGetRouteTable(IDfId objectId, int stamp) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("ExtVstamp", stamp);
        return this.m_connection.applyForObject("ActGetRouteTable", objectId, arguments, true, true, true);
    }

    public ITypedData actGetPerformerConditionTable(IDfId objectId, int stamp) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("ExtVstamp", stamp);
        return this.m_connection.applyForObject("ActGetPerformerConditionTable", objectId, arguments, true, true, true);
    }

    public void wflowUpdateTimer(IDfId objectId, IDfId timerObjId, IDfTime newDueDate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("_TIMER_OBJ_ID_", timerObjId);
        arguments.setTime("_NEW_DUE_DATE_", newDueDate);
        this.m_connection.apply("WflowUpdateTimer", objectId, arguments, true, true, true);
    }

    public void containmentCopy(IDfId objectId, IDfId newParentId, List excludedContainmentIds) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("_NEW_PARENT_", newParentId);
        for (Object excludedContainmentId : excludedContainmentIds) {
            arguments.appendId("_REMOVE_PART_", (IDfId)excludedContainmentId);
        }
        this.m_connection.apply("ContainmentCopy", objectId, arguments, true, true, true);
    }

    public void relationCopy(IDfId objectId, IDfId newParentId) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("_NEW_PARENT_", newParentId);
        this.m_connection.applyForBool("RelationCopy", objectId, arguments, true, true, true);
    }

    public ITypedDataIterator sysObjBuildAssembly(IDfId objectId, IDfId bookId, int frequency, String qualification, String nodesortList) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("_BOOK_ID_", bookId);
        arguments.appendInt("_FREQUENCY_", frequency > 0 ? frequency : -1);
        arguments.appendString("_PREDICATE_", qualification != null ? qualification : "");
        arguments.appendString("_NODESORT_LIST_", nodesortList);
        return this.m_connection.applyForCollection("SysObjBuildAssembly", objectId, arguments, 1, true, true, true, false);
    }

    public void sysObjExpungeAssembly(IDfId objectId) throws DfException {
        this.m_connection.apply("SysObjExpungeAssembly", objectId, null, true, true, true);
    }

    public ITypedDataIterator getVDMPathQuery(IDfId objectId, IDfId rootId, boolean shortestPath, String versionList) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("ROOT_ID", rootId);
        arguments.appendBoolean("SHORTEST_PATH", shortestPath);
        arguments.appendString("BIND_CONDITION", versionList);
        return this.m_connection.applyForCollection("GetVDMPathQuery", objectId, arguments, 50, true, true, true, false);
    }

    public ITypedDataIterator getVDMPathDQLQuery(IDfId objectId, IDfId rootId, boolean shortestPath, String parentType, String bindingLabel, String nodeSortBy) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("ROOT_ID", rootId);
        arguments.appendString("OBJECT_TYPE", parentType);
        arguments.appendBoolean("SHORTEST_PATH", shortestPath);
        arguments.appendString("BIND_CONDITION", bindingLabel);
        arguments.appendString("SORT_BY", nodeSortBy);
        return this.m_connection.applyForCollection("GetVDMPathDQLQuery", objectId, arguments, 50, true, true, true, false);
    }

    public boolean lockObject(IDfId objectId, String typeName, int vstamp, boolean validateStamp) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        if (!StringUtil.isEmptyOrNull(typeName)) {
            arguments.setString("OBJECT_TYPE", typeName);
        }
        arguments.setBoolean("VALIDATE_STAMP", validateStamp);
        arguments.setInt("i_vstamp", validateStamp ? vstamp : -1);
        return this.m_connection.applyForBool("LOCK_OBJECT", objectId, arguments, true, true, true);
    }

    public void containmentReorder(IDfId objectId, int linkCnt) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("MAX_CNT", linkCnt);
        this.m_connection.apply("ContainmentReorder", objectId, arguments, true, true, true);
    }

    public boolean inboxItemDeleteAll() throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        return this.m_connection.applyForBool("InboxItemDeleteAll", null, arguments, true, true, true);
    }

    public boolean inboxItemDelete(IDfId objectId) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        return this.m_connection.applyForBool("InboxItemDelete", objectId, arguments, true, true, true);
    }

    public String aliasSetResolveAlias(IDfId objectId, String aliasValue, String sessionAliasSet) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OBJECT_TYPE", DfDocbaseConstants.DM_SYSOBJECT);
        arguments.setString("_ALIAS_VALUE_", aliasValue);
        arguments.setString("_SESSION_ALIAS_SET_", sessionAliasSet);
        return this.m_connection.applyForString("AliasSetResolveAlias", objectId, arguments, true, true, true);
    }

    public ITypedData doReinit(String configName, boolean projectFlag) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_CONFIG_NAME_", configName);
        arguments.setBoolean("_PROJECT_FLAG_", projectFlag);
        return this.m_connection.applyForObject("DO_REINIT", null, arguments, true, true, true);
    }

    public boolean doShutdown(boolean immediate, boolean deleteEntry) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        int request = immediate ? 2 : 1;
        arguments.setInt("REQUEST", request);
        arguments.setBoolean("DOCBROKER_REQUEST", deleteEntry);
        return this.m_connection.applyForBool("STOP_SERVER", null, arguments, true, true, true);
    }

    public ITypedData doRestart(String configName, boolean projectFlag) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_CONFIG_NAME_", configName);
        arguments.setBoolean("_PROJECT_FLAG_", projectFlag);
        return this.m_connection.applyForObject("DO_RESTART", null, arguments, true, true, true);
    }

    public boolean eventRegister(IDfId objectId, String message, String event, int priority, boolean sendMail, boolean oneShot) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_EVENT_", event.toLowerCase());
        arguments.setString("_MSG_", message);
        arguments.setInt("_PRIORITY_", priority);
        arguments.setBoolean("_SENDMAIL_", sendMail);
        arguments.setBoolean("_ONESHOT_", oneShot);
        return this.m_connection.applyForBool("EventRegister", objectId, arguments, true, true, true);
    }

    public boolean eventUnRegister(IDfId objectId, String event, String userName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_EVENT_", event.toLowerCase());
        arguments.setString("_USER_", userName);
        return this.m_connection.applyForBool("EventUnRegister", objectId, arguments, true, true, true);
    }

    public void reparentLiteObjBatch(IDfId newParentId, IDfList childIds) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("NEW_PARENT_ID", newParentId.getId());
        int count = childIds.getCount();
        for (int i = 0; i < count; ++i) {
            IDfId childId = childIds.getId(i);
            arguments.appendString("LITE_OBJ_LIST", childId.getId());
        }
        this.m_connection.apply("REPARENT_LITE_OBJ_BATCH", null, arguments, true, true, true);
    }

    public void setStorageState(IDfId objectId, String storeName, boolean readOnly, boolean offline) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("STORE", storeName);
        arguments.setBoolean("READONLY", readOnly);
        arguments.setBoolean("OFFLINE", offline);
        this.m_connection.apply("SET_STORAGE_STATE", objectId, arguments, true, true, true);
    }

    public void electronicSignOff(IDfId objectId, String user, @Mask String password, String reason, int objVStamp) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_SINGER_NAME_", user);
        arguments.setString("_SIGNER_PASSWD_", password);
        arguments.setString("_REASON_STRING_", reason);
        arguments.setInt("_OBJECT_VSTAMP_", objVStamp);
        this.m_connection.apply("ElectronicSignOff", objectId, arguments, true, true, true);
    }

    public void beginTrans(boolean insertOnly, boolean startScope) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("INSERT_ONLY", insertOnly);
        arguments.setBoolean("START_SCOPE", startScope);
        this.m_connection.apply("BEGIN_TRANS", null, arguments, true, true, true);
    }

    public void endTrans(boolean commit) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("COMMIT", commit);
        this.m_connection.apply("END_TRANS", null, arguments, false, false, false);
        DfException exception = this.m_connection.getException();
        if (exception != null) {
            DfLogger.debug((Object)this, "DFC_SESSION_IGNORED_ERRORS", new Object[]{"END_TRANS"}, (Throwable)exception);
        }
    }

    public int beginTrans(boolean insertOnly, int xid, boolean startScope) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("INSERT_ONLY", insertOnly);
        arguments.setInt("XID", xid);
        arguments.setBoolean("START_SCOPE", startScope);
        return this.m_connection.applyForInt("BEGIN_TRANS_EX", null, arguments, true, true, true);
    }

    public void endTrans(boolean commit, int xid) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setBoolean("COMMIT", commit);
        arguments.setInt("XID", xid);
        this.m_connection.apply("END_TRANS_EX", null, arguments, false, false, false);
        DfException exception = this.m_connection.getException();
        if (exception != null) {
            DfLogger.debug((Object)this, "DFC_SESSION_IGNORED_ERRORS", new Object[]{"END_TRANS"}, (Throwable)exception);
        }
    }

    public ITypedDataIterator getErrors(String objectType) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OBJECT_TYPE", objectType);
        return this.m_connection.applyForCollection("GET_ERRORS", null, arguments, 50, true, true, false, false);
    }

    public void setLocale(ITypedData arguments) throws DfException {
        this.m_connection.apply("SET_LOCALE", null, arguments, true, true, false);
    }

    public void setSessionParameters(ITypedData arguments) throws DfException {
        this.m_connection.apply("SET_SESSION_PARAMETERS", null, arguments, true, true, false);
    }

    public void setDynamicGroups(List<String> addGroups, List<String> removeGroups, boolean reset, boolean validate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        for (String entry : addGroups) {
            arguments.appendString("DYNAMIC_GROUP_ADD", entry);
        }
        for (String entry : removeGroups) {
            arguments.appendString("DYNAMIC_GROUP_REMOVE", entry);
        }
        arguments.setBoolean("DYNAMIC_GROUP_RESET", reset);
        arguments.setBoolean("DYNAMIC_GROUP_VALIDATE", validate);
        this.m_connection.apply("SET_DYNAMIC_GROUPS", null, arguments, true, true, false);
    }

    public ITypedDataIterator getDynamicGroups() throws DfException {
        return this.m_connection.applyForCollection("GET_DYNAMIC_GROUPS", null, null, 50, true, true, true, false);
    }

    public ITypedData authenticateUser(boolean assumeUser, boolean checkOnly, boolean authenticateOnly, boolean connectPooling, boolean isTrustedLoginDisabled, ITypedData localeArguments, String osLogonName, String osLogonDomain, String logonName, String password, String ulLogonType, String ulSecurityInfo, String[] extraCredentials, String clientAuthData) throws DfException {
        ITypedData arguments = localeArguments != null ? localeArguments : new DynamicallyTypedData();
        arguments.setBoolean("DO_SET_LOCALE", localeArguments != null);
        arguments.setBoolean("CONNECT_POOLING", connectPooling);
        arguments.setBoolean("ASSUME_USER", assumeUser);
        arguments.setBoolean("CHECK_ONLY", checkOnly);
        arguments.setBoolean("AUTHENTICATE_ONLY", authenticateOnly);
        arguments.setString("OS_LOGON_NAME", osLogonName);
        arguments.setString("OS_LOGON_DOMAIN", osLogonDomain);
        arguments.setString("LOGON_NAME", logonName);
        arguments.setString("USER_PASSWORD", DfUtil.obfuscate(password));
        for (String extraCredential : extraCredentials) {
            arguments.appendString("USER_EXTRA_CREDENTIAL", DfUtil.obfuscate(extraCredential));
        }
        arguments.setString("CLIENT_AUTH_DATA", clientAuthData);
        if (isTrustedLoginDisabled) {
            arguments.setBoolean("TRUSTED_LOGIN_ALLOWED", false);
        }
        if (ulLogonType != null && ulSecurityInfo != null) {
            arguments.setString("UL_LOGON_TYPE", ulLogonType);
            arguments.setString("UL_SECURITY_INFO", ulSecurityInfo);
        }
        return this.m_connection.applyForObject("AUTHENTICATE_USER", null, arguments, true, true, false);
    }

    public String encryptText(String textToEncrypt) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("TEXT_TO_ENCRYPT", DfUtil.obfuscate(textToEncrypt));
        return this.m_connection.applyForString("ENCRYPT_TEXT", null, arguments, true, true, true);
    }

    public String decryptText(String textToDecrypt) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("TEXT_TO_DECRYPT", textToDecrypt);
        return this.m_connection.applyForString("DECRYPT_TEXT", null, arguments, true, true, true);
    }

    public String encryptPassword(String passwordToEncrypt) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("PASSWORD_TO_ENCRYPT", DfUtil.obfuscate(passwordToEncrypt));
        return this.m_connection.applyForString("ENCRYPT_PASSWORD", null, arguments, true, true, true);
    }

    public boolean resetSession() throws DfException {
        return this.m_connection.applyForBool("RESET_SESSION", null, null, true, true, false);
    }

    public void verifyESignature(IDfId objectId) throws DfException {
        this.m_connection.apply("VERIFY_E_SIGNATURE", objectId, null, true, true, true);
    }

    public IDfId archive(String predicate, String operatorName, int priority, boolean sendMail, String dueDate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("predicate", predicate);
        arguments.setString("operator", operatorName);
        arguments.setBoolean("send_mail", sendMail);
        arguments.setInt("priority", priority);
        arguments.setString("due_date", dueDate);
        return this.m_connection.applyForId("ArchiveRequest", null, arguments, true, true, true);
    }

    public IDfId restore(String predicate, String operatorName, int priority, boolean sendMail, String dueDate) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("predicate", predicate);
        arguments.setString("operator", operatorName);
        arguments.setBoolean("send_mail", sendMail);
        arguments.setInt("priority", priority);
        arguments.setString("due_date", dueDate);
        return this.m_connection.applyForId("RestoreRequest", null, arguments, true, true, true);
    }

    public IDfId addESignature(IDfId objectId, int vStamp, String userName, String password, String signatureJustification, String formatToSign, String hashAlgorithm, String preSignatureHash, String signatureMethodName, String applicationProperties, String passThroughArgument1, String passThroughArgument2) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("V_STAMP", vStamp);
        arguments.setString("USER_NAME", userName);
        arguments.setString("USER_PASSWORD", password);
        arguments.setString("SIGNATURE_JUSTIFICATION", signatureJustification);
        arguments.setString("FORMAT_TO_SIGN", formatToSign);
        arguments.setString("HASH_ALGORITHM", hashAlgorithm);
        arguments.setString("PRE_SIGNATURE_HASH", preSignatureHash);
        arguments.setString("SIGNATURE_METHOD_NAME", signatureMethodName);
        arguments.setString("APPLICATION_PROPERTIES", applicationProperties);
        arguments.setString("PASS_THROUGH_ARGUMENT_1", passThroughArgument1);
        arguments.setString("PASS_THROUGH_ARGUMENT_2", passThroughArgument2);
        return this.m_connection.applyForId("ADD_E_SIGNATURE", objectId, arguments, true, true, true);
    }

    public ITypedData changePassword(String osLogonName, String osLogonDomain, String logonName, @Mask String oldPassword, @Mask String newPassword, String extraCredential1, int logonType, String securityInfo) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OS_LOGON_NAME", osLogonName);
        arguments.setString("OS_LOGON_DOMAIN", osLogonDomain);
        arguments.setString("LOGON_NAME", logonName);
        arguments.setString("OLD_USER_PASSWORD", DfUtil.obfuscate(oldPassword));
        arguments.setString("NEW_USER_PASSWORD", DfUtil.obfuscate(newPassword));
        arguments.appendString("USER_EXTRA_CREDENTIAL", extraCredential1);
        arguments.setInt("UL_LOGON_TYPE", logonType);
        if (securityInfo != null) {
            arguments.setString("UL_SECURITY_INFO", securityInfo);
        }
        return this.m_connection.applyForObject("CHANGE_USER_PASSWORD", null, arguments, true, true, true);
    }

    public void resetTicketKey() throws DfException {
        this.m_connection.apply("RESET_TICKET_KEY", null, null, true, true, true);
    }

    public String exportTicketKey(@Mask String password) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("PASSWORD", password);
        return this.m_connection.applyForString("EXPORT_TICKET_KEY", null, arguments, true, true, true);
    }

    public void importTicketKey(String key, @Mask String password) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("KEY_STRING", key);
        arguments.setString("PASSWORD", password);
        this.m_connection.apply("IMPORT_TICKET_KEY", null, arguments, true, true, true);
    }

    public String getToken(String userName, String scope, int timeout, String appId, boolean machineOnly, String machineId) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OPTIONAL_USER_NAME", userName);
        arguments.setString("APP_TOKEN_SCOPE", scope);
        if (timeout > 0) {
            arguments.setInt("APP_TOKEN_TIMEOUT", timeout);
        }
        if (appId != null && appId.length() > 0) {
            arguments.setString("APPLICATION_DATA", appId);
        }
        arguments.setBoolean("THIS_MACHINE_ONLY", machineOnly);
        arguments.setString("MACHINE_ID", machineId);
        return this.m_connection.applyForString("GET_TOKEN", null, arguments, true, true, true);
    }

    public String processNewServerMessage(ITypedData errorData) throws DfException {
        return this.m_connection.applyForString("PROCESS_NEW_SERVER_MESSAGE", null, errorData, true, true, false);
    }

    public String getDbTableOwner() throws DfException {
        return this.m_connection.applyForString("GET_DBTABLEOWNER", null, null, true, true, true);
    }

    public boolean setOptions(String option, boolean value) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OPTION", option);
        arguments.setBoolean("VALUE", value);
        return this.m_connection.applyForBool("SET_OPTIONS", null, arguments, true, true, true);
    }

    public void flushRegistryCache(String objectType, boolean resetChangeBit, boolean includeSubtypes) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OBJECT_TYPE", objectType);
        arguments.setBoolean("RESET_CHANGE_BIT", resetChangeBit);
        arguments.setBoolean("INCLUDE_SUBTYPES", includeSubtypes);
        this.m_connection.apply("FlushRegistryCache", null, arguments, true, true, true);
    }

    public int getAspectUseInfo(String aspectName) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("ASPECT_NAME", aspectName);
        return this.m_connection.applyForInt("GET_ASPECT_USE_INFO", null, arguments, true, true, true);
    }

    public ITypedData getTypesChanged(int cacheVStamp) throws DfException {
        DynamicallyTypedData args = new DynamicallyTypedData();
        args.setInt("CACHE_VSTAMP", cacheVStamp);
        return this.m_connection.applyForObject("GET_TYPES_CHANGED", null, args, true, true, true);
    }

    public void killSession(IDfId id, String vengenceLevel, String message) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_VENGEANCE_LEVEL_", vengenceLevel);
        arguments.setString("_MESSAGE_", message);
        this.m_connection.apply("KILL_SESSION", id, arguments, true, true, false);
    }

    public boolean verifyAuditRecord(IDfId id) throws DfException {
        return this.m_connection.applyForBool("VerifyAuditRecord", id, null, true, true, false);
    }

    public String getSignData(IDfId id) throws DfException {
        return this.m_connection.applyForString("GetSignData", id, null, true, true, true);
    }

    public ITypedData triggerConditionalRetention(IDfId objectId) throws DfException {
        return this.m_connection.applyForObject("TRIGGER_CONDITIONAL_RETENTION", objectId, null, true, true, false);
    }

    public boolean trace(int level, String facility, String argument, String clientMachine, int clientProcess, int clientThread) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("_TRACE_LEVEL_", level);
        arguments.setString("_TRACE_FACILITY_", facility);
        arguments.setString("_TRACE_ARGUMENT_", argument);
        arguments.setString("_TRACE_CLIENT_MACHINE_", clientMachine);
        arguments.setInt("_TRACE_CLIENT_PROCESS_", clientProcess);
        arguments.setInt("_TRACE_CLIENT_THREAD_", clientThread);
        if (facility != null && facility.equals("DIST_CONTENT_TRACE")) {
            return this.m_connection.applyForBool("TRACE", DfId.DF_NULLID, arguments, true, true, true);
        }
        if (level == 11) {
            return this.m_connection.applyForInt("TRACE", DfId.DF_NULLID, arguments, true, true, true) != 0;
        }
        if (facility != null && facility.equals("SQL_TRACE")) {
            return this.m_connection.applyForBool("TRACE", DfId.DF_NULLID, arguments, true, true, true);
        }
        return this.m_connection.applyForInt("TRACE", DfId.DF_NULLID, arguments, true, true, true) != 0;
    }

    public String getTypeName(IDfId objectId) throws DfException {
        return this.m_connection.applyForString("GETTYPENAME", objectId, null, true, true, true);
    }

    public void sysObjFlushGlobalCache(String whichCache) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("_WHICH_CACHE_", whichCache);
        this.m_connection.apply("SysObjFlushGlobalCache", null, arguments, true, true, true);
    }

    public int serverScopeOperation(int scopeOp, int scopeId, boolean bNested) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("OP_CODE", scopeOp);
        arguments.setBoolean("OVERRIDE", bNested);
        arguments.setInt("SCOPE_ID", scopeId);
        arguments.setInt("POLICY", 0);
        return this.m_connection.applyForInt("SERVER_SCOPE_OPERATION", DfId.DF_NULLID, arguments, true, true, true);
    }

    public int execXQuery(String xquery, IDfXQueryTargets target, HashMap<String, String> properties) throws DfException {
        int targetType = target.getTargetType();
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("QUERY", xquery);
        arguments.setString("TARGET", targetType == 0 ? "xmlstore" : "fulltext");
        if (properties != null) {
            Set<Map.Entry<String, String>> set = properties.entrySet();
            for (Map.Entry<String, String> entry : set) {
                arguments.setString(entry.getKey(), entry.getValue());
            }
        }
        if (targetType == 0) {
            for (int k = 0; k < target.getNames().size(); ++k) {
                arguments.appendString("STORE_NAME", target.getNames().get(k));
            }
        }
        return this.m_connection.applyForInt("EXEC_XQUERY", null, arguments, true, true, true);
    }

    public ITypedData getFulltextCapability() throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        return this.m_connection.applyForObject("GET_FULLTEXT_CAPABILITY", null, arguments, true, true, true);
    }

    public ITypedData getFilestoreMetadataAndPath(IDfId storeId, String format, boolean includeResourceFork) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("format", format);
        arguments.setBoolean("includeResourceFork", includeResourceFork);
        return this.m_connection.applyForObject("GET_FILESTORE_METADATA_AND_PATH", storeId, arguments, true, true, true);
    }

    public void auditSecurityFailure(IDfId objectId, String operationName, String errorMsg) throws DfException {
        if (!this.m_connection.getServerInfo().getMethodMap().containsKey("AUDIT_SECURITY_FAILURE")) {
            return;
        }
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("OPERATION_NAME", operationName);
        if (errorMsg != null && errorMsg.length() > 0) {
            arguments.setString("ERROR_MESSAGE", errorMsg);
        }
        this.m_connection.apply("AUDIT_SECURITY_FAILURE", objectId, arguments, true, true, true);
    }

    public ITypedData getObjectInfo(IDfId objectId, boolean fetchImmutabilityStatus) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setRepeatingId("OBJECT_ID", 0, objectId);
        arguments.setRepeatingBoolean("FETCH_IMMUTABILITY_STATUS", 0, fetchImmutabilityStatus);
        return this.m_connection.applyForObject("GET_OBJECT_INFO", null, arguments, true, true, true);
    }
}

