/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.crypto;

import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class AEKFile {
    private static final int INT_FIELD_SIZE = 4;
    private boolean m_bytesSwapped = false;
    private CipherInfo m_cipherInfo;
    private byte[] m_encryptedAEK;
    private File m_aekFile;

    AEKFile(String location) throws DfException {
        if (!(location != null && location.length() != 0 || (location = this.getDefaultLocation()) != null && location.length() != 0)) {
            throw new DfException("DM_CRYPTO_F_KEYSTORE_INIT", new Object[]{"UNKNOWN"});
        }
        this.m_aekFile = new File(location);
        byte[] buf = this.readFile();
        AEKInfo m_aekInfo = this.getAEKInfo(buf, 0);
        this.m_cipherInfo = this.getCipherInfo(buf, m_aekInfo.getSize());
        this.m_encryptedAEK = new byte[this.m_cipherInfo.getEncryptedDataLength()];
        System.arraycopy(buf, m_aekInfo.getSize() + this.m_cipherInfo.getSize(), this.m_encryptedAEK, 0, this.m_cipherInfo.getEncryptedDataLength());
    }

    String getAEKLocation() {
        return this.m_aekFile.getPath();
    }

    byte[] getSalt() {
        return this.m_cipherInfo.getSalt();
    }

    int getIterationCount() {
        return this.m_cipherInfo.getIterationCount();
    }

    byte[] getEncryptedAEK() {
        return this.m_encryptedAEK;
    }

    private byte[] readFile() throws DfException {
        if (!this.m_aekFile.exists()) {
            throw new DfException("DM_CRYPTO_F_KEYSTORE_INIT", new Object[]{this.getAEKLocation()});
        }
        byte[] buf = new byte[(int)this.m_aekFile.length()];
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(this.m_aekFile);
            fileIn.read(buf);
        }
        catch (IOException e) {
            throw new DfException("DM_CRYPTO_F_KEYSTORE_INIT", new Object[]{this.getAEKLocation()}, e);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {}
            }
        }
        return buf;
    }

    private String getDefaultLocation() {
        String location = null;
        String dmCryptoFile = System.getenv("DM_CRYPTO_FILE");
        if (dmCryptoFile != null && dmCryptoFile.length() > 0) {
            location = dmCryptoFile;
        } else {
            String documentum = System.getenv("DOCUMENTUM");
            String sep = System.getProperty("file.separator", "/");
            if (documentum != null && documentum.length() > 0) {
                location = documentum + sep + "dba" + sep + "secure" + sep + "aek.key";
            }
        }
        return location;
    }

    private int getInt(byte[] buf, int start) {
        if (buf.length < start + 4 - 1) {
            throw new DfCriticalException("Unexpected end of buffer reached.");
        }
        int retValue = this.m_bytesSwapped ? (buf[start + 3] << 24) + ((buf[start + 2] & 0xFF) << 16) + ((buf[start + 1] & 0xFF) << 8) + (buf[start] & 0xFF) : (buf[start] << 24) + ((buf[start + 1] & 0xFF) << 16) + ((buf[start + 2] & 0xFF) << 8) + (buf[start + 3] & 0xFF);
        return retValue;
    }

    private AEKInfo getAEKInfo(byte[] buf, int startIndex) throws DfException {
        int index = startIndex;
        AEKInfo aekInfo = new AEKInfo();
        aekInfo.setVersion(this.getInt(buf, index));
        if (aekInfo.getVersion() < 0 || aekInfo.getVersion() > 1) {
            this.m_bytesSwapped = true;
            aekInfo.setVersion(this.getInt(buf, index));
            if (aekInfo.getVersion() < 0 && aekInfo.getVersion() > 1) {
                throw new DfException("DM_CRYPTO_F_KEYSTORE_INIT", new Object[]{this.getAEKLocation()});
            }
        }
        aekInfo.setSize(this.getInt(buf, index += 4));
        if (aekInfo.getSize() == 0 || aekInfo.getSize() > 1024) {
            throw new DfException("DM_CRYPTO_F_KEYSTORE_INIT", new Object[]{this.getAEKLocation()});
        }
        aekInfo.setStorageType(this.getInt(buf, index += 4));
        if (aekInfo.getStorageType() != 3) {
            throw new DfException("DM_CRYPTO_F_KEYSTORE_INIT", new Object[]{this.getAEKLocation()});
        }
        aekInfo.setEncryptedDataLength(this.getInt(buf, index += 4));
        aekInfo.setAlgorithm(this.getInt(buf, index += 4));
        aekInfo.setKeyLength(this.getInt(buf, index += 4));
        aekInfo.setBlockSize(this.getInt(buf, index += 4));
        return aekInfo;
    }

    private CipherInfo getCipherInfo(byte[] buf, int startIndex) {
        int index = startIndex;
        CipherInfo cipherInfo = new CipherInfo();
        cipherInfo.setVersion(this.getInt(buf, index));
        cipherInfo.setSize(this.getInt(buf, index += 4));
        cipherInfo.setEncryptedDataLength(this.getInt(buf, index += 4));
        cipherInfo.setAlgorithm(this.getInt(buf, index += 4));
        cipherInfo.setKeyLength(this.getInt(buf, index += 4));
        cipherInfo.setBlockSize(this.getInt(buf, index += 4));
        cipherInfo.setIterationCount(this.getInt(buf, index += 4));
        cipherInfo.setSaltLength(this.getInt(buf, index += 4));
        if (buf.length < (index += 4) + cipherInfo.getSaltLength() - 1) {
            throw new DfCriticalException("Unexpected end of buffer reached.");
        }
        byte[] salt = new byte[cipherInfo.getSaltLength()];
        System.arraycopy(buf, index, salt, 0, cipherInfo.getSaltLength());
        cipherInfo.setSalt(salt);
        return cipherInfo;
    }

    class CipherInfo {
        private int version;
        private int size;
        private int encryptedDataLength;
        private int algorithm;
        private int keyLength;
        private int blockSize;
        private int iterationCount;
        private int saltLength;
        private byte[] salt;

        CipherInfo() {
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getEncryptedDataLength() {
            return this.encryptedDataLength;
        }

        public void setEncryptedDataLength(int encryptedDataLength) {
            this.encryptedDataLength = encryptedDataLength;
        }

        public int getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(int algorithm) {
            this.algorithm = algorithm;
        }

        public int getKeyLength() {
            return this.keyLength;
        }

        public void setKeyLength(int keyLength) {
            this.keyLength = keyLength;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public void setBlockSize(int blockSize) {
            this.blockSize = blockSize;
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public void setIterationCount(int iterationCount) {
            this.iterationCount = iterationCount;
        }

        public int getSaltLength() {
            return this.saltLength;
        }

        public void setSaltLength(int saltLength) {
            this.saltLength = saltLength;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public void setSalt(byte[] salt) {
            this.salt = salt;
        }

        public String toString() {
            String lineSep = System.getProperty("line.separator");
            StringBuffer b = new StringBuffer();
            b.append("Cipher Info: ");
            b.append(lineSep);
            b.append("Version: ");
            b.append(this.version);
            b.append(lineSep);
            b.append("Size: ");
            b.append(this.size);
            b.append(lineSep);
            b.append("Encrypted Data Length: ");
            b.append(this.encryptedDataLength);
            b.append(lineSep);
            b.append("Algorithm: ");
            b.append(this.algorithm);
            b.append(lineSep);
            b.append("Key Length: ");
            b.append(this.keyLength);
            b.append(lineSep);
            b.append("Block Size: ");
            b.append(this.blockSize);
            b.append(lineSep);
            b.append("Iteration Count: ");
            b.append(this.iterationCount);
            b.append(lineSep);
            b.append("Salt Length: ");
            b.append(this.saltLength);
            b.append(lineSep);
            b.append("Salt: ");
            b.append(new String(this.salt));
            b.append(lineSep);
            return b.toString();
        }
    }

    class AEKInfo {
        private static final int MIN_VERSION = 0;
        private static final int MAX_VERSION = 1;
        private static final int MAX_SIZE = 1024;
        private static final int EXPECTED_STORAGE_TYPE = 3;
        private int version;
        private int size;
        private int storageType;
        private int encryptedDataLength;
        private int algorithm;
        private int keyLength;
        private int blockSize;

        AEKInfo() {
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getStorageType() {
            return this.storageType;
        }

        public void setStorageType(int storageType) {
            this.storageType = storageType;
        }

        public int getEncryptedDataLength() {
            return this.encryptedDataLength;
        }

        public void setEncryptedDataLength(int encryptedDataLength) {
            this.encryptedDataLength = encryptedDataLength;
        }

        public int getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(int algorithm) {
            this.algorithm = algorithm;
        }

        public int getKeyLength() {
            return this.keyLength;
        }

        public void setKeyLength(int keyLength) {
            this.keyLength = keyLength;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public void setBlockSize(int blockSize) {
            this.blockSize = blockSize;
        }

        public String toString() {
            String lineSep = System.getProperty("line.separator");
            StringBuffer b = new StringBuffer();
            b.append("AEK Info: ");
            b.append(lineSep);
            b.append("Version: ");
            b.append(this.version);
            b.append(lineSep);
            b.append("Size: ");
            b.append(this.size);
            b.append(lineSep);
            b.append("Storage Type: ");
            b.append(this.storageType);
            b.append(lineSep);
            b.append("Encrypted Data Length: ");
            b.append(this.encryptedDataLength);
            b.append(lineSep);
            b.append("Algorithm: ");
            b.append(this.algorithm);
            b.append(lineSep);
            b.append("Key Length: ");
            b.append(this.keyLength);
            b.append(lineSep);
            b.append("Block Size: ");
            b.append(this.blockSize);
            b.append(lineSep);
            return b.toString();
        }
    }
}

