/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.netwise;

import com.documentum.fc.client.impl.connection.netwise.ByteArrayBuilder;
import com.documentum.fc.client.impl.connection.netwise.ProtocolException;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.impl.util.holders.IntHolder;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class NetwiseProtocol {
    public static void serializeByteArray(ByteBuffer buffer, byte[] value, int length) {
        if (value == null || length == 0) {
            buffer.put((byte)5);
            buffer.put((byte)0);
        } else {
            buffer.put((byte)22);
            NetwiseProtocol.serializeLength(buffer, length);
            buffer.put(value, 0, length);
        }
    }

    public static byte[] deserializeByteArray(ByteBuffer buffer, boolean forString) throws ProtocolException {
        byte type = buffer.get();
        if (type == 5 && buffer.get() == 0) {
            return new byte[0];
        }
        if (type == 22) {
            int length = NetwiseProtocol.deserializeLength(buffer);
            if (length >= 0) {
                byte[] bytes = new byte[length];
                buffer.get(bytes);
                return bytes;
            }
            throw new ProtocolException("Bad length for NetwiseProtocol byte array");
        }
        if (type == 54 && buffer.get() == -128) {
            ByteArrayBuilder builder = new ByteArrayBuilder();
            int position = buffer.position();
            while (buffer.get() != 0 || buffer.get() != 0) {
                buffer.position(position);
                byte[] segment = NetwiseProtocol.deserializeByteArray(buffer, forString);
                if (forString && segment[segment.length - 1] == 0) {
                    builder.append(segment, 0, segment.length - 1);
                } else {
                    builder.append(segment);
                }
                position = buffer.position();
            }
            return builder.toByteArray();
        }
        throw new ProtocolException("Wrong type for NetwiseProtocol byte array");
    }

    private static int deserializeLength(ByteBuffer buffer) {
        int value = buffer.get() & 0xFF;
        if (value <= 127) {
            return value;
        }
        int length = value & 0x7F;
        value = buffer.get() & 0xFF;
        while (--length > 0) {
            value = value << 8 | buffer.get() & 0xFF;
        }
        return value;
    }

    public static double deserializeDouble(ByteBuffer buffer) throws ProtocolException {
        throw new DfCriticalException("Deserialization of NetwiseProtocol double is not supported yet");
    }

    public static DfId deserializeId(ByteBuffer buffer) throws ProtocolException {
        return new DfId(NetwiseProtocol.deserializeString(buffer));
    }

    public static int deserializeInteger(ByteBuffer buffer) throws ProtocolException {
        if (buffer.get() == 2) {
            int length = buffer.get();
            int value = buffer.get();
            while (--length > 0) {
                value = value << 8 | buffer.get() & 0xFF;
            }
            return value;
        }
        throw new ProtocolException("Wrong type for NetwiseProtocol integer");
    }

    public static int[] deserializeIntegerArray(ByteBuffer buffer) throws ProtocolException {
        int[] newValues;
        if (buffer.get() != 48) {
            throw new ProtocolException("Wrong type for NetwiseProtocol integer array");
        }
        int length = NetwiseProtocol.deserializeLength(buffer);
        int endPosition = buffer.position() + length;
        int numberOfElements = 0;
        int[] values = new int[10];
        while (buffer.position() < endPosition) {
            if (numberOfElements >= values.length) {
                newValues = new int[values.length * 2];
                System.arraycopy(values, 0, newValues, 0, numberOfElements);
                values = newValues;
            }
            values[numberOfElements++] = NetwiseProtocol.deserializeInteger(buffer);
        }
        if (numberOfElements < values.length) {
            newValues = new int[numberOfElements];
            System.arraycopy(values, 0, newValues, 0, numberOfElements);
            values = newValues;
        }
        return values;
    }

    public static long deserializeLong(ByteBuffer buffer) throws ProtocolException {
        if (buffer.get() == 2) {
            int length = buffer.get();
            long value = buffer.get();
            while (--length > 0) {
                value = value << 8 | (long)(buffer.get() & 0xFF);
            }
            return value;
        }
        throw new ProtocolException("Wrong type for NetwiseProtocol integer");
    }

    public static boolean deserializeBoolean(ByteBuffer buffer) throws ProtocolException {
        return NetwiseProtocol.deserializeInteger(buffer) != 0;
    }

    public static void serializeResponseHeader(ByteBuffer buffer, int sequenceNumber, int status) {
        buffer.put((byte)48);
        buffer.put((byte)0);
        int beginPosition = buffer.position();
        NetwiseProtocol.serializeInteger(buffer, sequenceNumber);
        NetwiseProtocol.serializeInteger(buffer, status);
        int endPosition = buffer.position();
        int length = endPosition - beginPosition;
        buffer.put(beginPosition - 1, (byte)length);
    }

    public static void deserializeResponseHeader(ByteBuffer buffer, IntHolder sequenceNumberHolder) throws ProtocolException {
        int status;
        if (buffer.get() != 48) {
            throw new ProtocolException("Wrong type for NetwiseProtocol response header");
        }
        buffer.get();
        int sequenceNumber = NetwiseProtocol.deserializeInteger(buffer);
        if (sequenceNumberHolder != null) {
            sequenceNumberHolder.value = sequenceNumber;
        }
        if ((status = NetwiseProtocol.deserializeInteger(buffer)) != 0) {
            throw new ProtocolException("Error status in NetwiseProtocol header: " + status);
        }
    }

    public static String deserializeString(ByteBuffer buffer) throws ProtocolException {
        return NetwiseProtocol.toString(NetwiseProtocol.deserializeByteArray(buffer, true));
    }

    public static String toString(byte[] bytes) {
        try {
            int length = bytes.length;
            if (bytes[length - 1] == 0) {
                --length;
            }
            return new String(bytes, 0, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException("UTF-8 should always be supported", e);
        }
    }

    public static void serializeId(ByteBuffer buffer, IDfId value) {
        if (value == null) {
            value = DfId.DF_NULLID;
        }
        NetwiseProtocol.serializeString(buffer, ((Object)value).toString());
    }

    public static void serializeInteger(ByteBuffer buffer, int value) {
        buffer.put((byte)2);
        if (value >= 0) {
            if (value <= 127) {
                buffer.put((byte)1);
                buffer.put((byte)value);
            } else if (value <= Short.MAX_VALUE) {
                buffer.put((byte)2);
                byte lsb = (byte)value;
                buffer.put((byte)(value >> 8));
                buffer.put(lsb);
            } else {
                int temp = 0;
                int length = 1;
                while (value > 127) {
                    temp = temp << 8 | value & 0xFF;
                    value >>= 8;
                    ++length;
                }
                buffer.put((byte)length);
                buffer.put((byte)value);
                for (int i = 1; i < length; ++i) {
                    buffer.put((byte)temp);
                    temp >>= 8;
                }
            }
        } else {
            int temp = 0;
            int length = 1;
            while (value < -128) {
                temp = temp << 8 | value & 0xFF;
                value >>= 8;
                ++length;
            }
            buffer.put((byte)length);
            buffer.put((byte)value);
            for (int i = 1; i < length; ++i) {
                buffer.put((byte)temp);
                temp >>= 8;
            }
        }
    }

    public static void serializeIntegerArray(ByteBuffer buffer, int[] values) {
        buffer.put((byte)48);
        buffer.put((byte)-126);
        buffer.put((byte)0);
        buffer.put((byte)0);
        int beginPosition = buffer.position();
        int limit = values.length;
        for (int i = 0; i < limit; ++i) {
            NetwiseProtocol.serializeInteger(buffer, values[i]);
        }
        int endPosition = buffer.position();
        int length = endPosition - beginPosition;
        buffer.put(beginPosition - 2, (byte)(length >> 8));
        buffer.put(beginPosition - 1, (byte)length);
    }

    public static void serializeString(ByteBuffer buffer, String value) {
        try {
            if (value == null || value.length() == 0) {
                buffer.put((byte)5);
                buffer.put((byte)0);
            } else {
                byte[] bytes = value.getBytes("UTF-8");
                buffer.put((byte)22);
                int length = bytes.length + 1;
                NetwiseProtocol.serializeLength(buffer, length);
                buffer.put(bytes);
                buffer.put((byte)0);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException("UTF-8 should always be supported", e);
        }
    }

    private static void serializeLength(ByteBuffer buffer, int value) {
        if (value <= 127) {
            buffer.put((byte)value);
        } else if (value <= 255) {
            buffer.put((byte)-127);
            buffer.put((byte)value);
        } else if (value <= 65535) {
            buffer.put((byte)-126);
            buffer.put((byte)(value >> 8));
            buffer.put((byte)value);
        } else {
            long temp = 0L;
            int length = 1;
            while (value > 127) {
                temp = temp << 8 | (long)(value & 0xFF);
                value >>= 8;
                ++length;
            }
            buffer.put((byte)(0x80 | length));
            buffer.put((byte)value);
            for (int i = 1; i < length; ++i) {
                buffer.put((byte)temp);
                temp >>= 8;
            }
        }
    }

    public static void serializeRequestHeader(ByteBuffer buffer, int sequenceNumber, int rpcId, int version, int release, int iNumber) {
        buffer.put((byte)48);
        buffer.put((byte)0);
        int beginPosition = buffer.position();
        NetwiseProtocol.serializeInteger(buffer, sequenceNumber);
        NetwiseProtocol.serializeInteger(buffer, rpcId);
        NetwiseProtocol.serializeInteger(buffer, version);
        NetwiseProtocol.serializeInteger(buffer, release);
        NetwiseProtocol.serializeInteger(buffer, iNumber);
        int endPosition = buffer.position();
        int length = endPosition - beginPosition;
        buffer.put(beginPosition - 1, (byte)length);
    }

    public static void deserializeRequestHeader(ByteBuffer buffer, IntHolder sequenceNumberHolder, IntHolder rpcIdHolder, IntHolder versionHolder, IntHolder releaseHolder, IntHolder iNumberHolder) throws ProtocolException {
        if (buffer.get() != 48) {
            throw new ProtocolException("Wrong type for NetwiseProtocol request header");
        }
        buffer.get();
        int value = NetwiseProtocol.deserializeInteger(buffer);
        if (sequenceNumberHolder != null) {
            sequenceNumberHolder.value = value;
        }
        value = NetwiseProtocol.deserializeInteger(buffer);
        if (rpcIdHolder != null) {
            rpcIdHolder.value = value;
        }
        value = buffer.remaining() > 0 ? NetwiseProtocol.deserializeInteger(buffer) : 0;
        if (versionHolder != null) {
            versionHolder.value = value;
        }
        value = buffer.remaining() > 0 ? NetwiseProtocol.deserializeInteger(buffer) : 0;
        if (releaseHolder != null) {
            releaseHolder.value = value;
        }
        value = buffer.remaining() > 0 ? NetwiseProtocol.deserializeInteger(buffer) : 0;
        if (iNumberHolder != null) {
            iNumberHolder.value = value;
        }
    }
}

