/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.netwise;

import java.util.ArrayList;
import java.util.List;

public class ByteArrayBuilder {
    private final List<Segment> segments = new ArrayList<Segment>();

    public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    public void append(byte[] bytes, int offset, int length) {
        this.segments.add(new Segment(bytes, offset, length));
    }

    public byte[] toByteArray() {
        int length = 0;
        for (Segment segment : this.segments) {
            length += segment.length;
        }
        byte[] result = new byte[length];
        int cursor = 0;
        for (Segment segment : this.segments) {
            System.arraycopy(segment.bytes, segment.offset, result, cursor, segment.length);
            cursor += segment.length;
        }
        return result;
    }

    private static class Segment {
        private final byte[] bytes;
        private final int offset;
        private final int length;

        Segment(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

