/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.netwise;

import com.documentum.fc.client.DfIOException;
import com.documentum.fc.client.impl.connection.IAbstractRpcClient;
import com.documentum.fc.client.impl.connection.netwise.NetwiseProtocol;
import com.documentum.fc.client.impl.connection.netwise.ProtocolException;
import com.documentum.fc.client.impl.connection.netwise.StringBuilderSerializer;
import com.documentum.fc.client.impl.objectprotocol.IObjectProtocol;
import com.documentum.fc.client.impl.typeddata.DynamicallyTypedData;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.impl.util.holders.IntHolder;
import com.documentum.fc.impl.util.io.MessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;

public abstract class AbstractNetwiseRpcClient
implements IAbstractRpcClient {
    protected static final int BUFFER_SIZE = 64000;
    private boolean m_isLocalAddress;
    private boolean m_secure;
    private int m_numberOfSends;
    private int m_numberOfReceives;
    private int m_numberOfBytesSent;
    private int m_numberOfBytesReceived;
    private int m_nextSequenceNumber;
    private ByteBuffer m_byteBuffer;
    private IObjectProtocol m_objectProtocol;
    private IObjectProtocol m_entryPointObjectProtocol;
    private MessageChannel m_messageChannel;
    private final StringBuilderSerializer m_stringBuilderSerializer;

    protected AbstractNetwiseRpcClient(Socket socket) {
        this.m_messageChannel = new MessageChannel(socket);
        this.m_stringBuilderSerializer = new StringBuilderSerializer();
        this.m_nextSequenceNumber = 1;
        this.m_byteBuffer = null;
        this.m_objectProtocol = null;
        this.m_secure = socket instanceof SSLSocket;
        this.m_isLocalAddress = this.isLocalAndRemoteAddressSame(socket);
        this.m_numberOfSends = 0;
        this.m_numberOfBytesSent = 0;
        this.m_numberOfReceives = 0;
        this.m_numberOfBytesReceived = 0;
    }

    private boolean isLocalAndRemoteAddressSame(Socket socket) {
        InetAddress remoteAddress = socket.getInetAddress();
        InetAddress localAddress = socket.getLocalAddress();
        return Arrays.equals(localAddress.getAddress(), remoteAddress.getAddress());
    }

    public void setObjectProtocol(IObjectProtocol objectProtocol) {
        this.m_objectProtocol = objectProtocol;
    }

    public void setEntryPointObjectProtocol(IObjectProtocol objectProtocol) {
        this.m_entryPointObjectProtocol = objectProtocol;
    }

    protected IObjectProtocol getObjectProtocol() {
        if (this.m_objectProtocol == null) {
            throw new IllegalStateException("Object protocol is not initialized");
        }
        return this.m_objectProtocol;
    }

    protected IObjectProtocol getEntryPointObjectProtocol() {
        if (this.m_entryPointObjectProtocol == null) {
            throw new IllegalStateException("Entry Point Object protocol is not initialized");
        }
        return this.m_entryPointObjectProtocol;
    }

    public boolean isOpen() {
        return this.m_messageChannel.isOpen();
    }

    public synchronized void close() {
        this.quiesce();
        try {
            this.m_messageChannel.close();
        }
        catch (IOException e) {
            DfLogger.warn((Object)this, "DFC_SESSION_CLOSE_EXCEPTION", null, (Throwable)e);
        }
    }

    public synchronized void quiesce() {
        this.m_byteBuffer = null;
    }

    public final int getNumberOfSends() {
        return this.m_numberOfSends;
    }

    public final int getNumberOfBytesSent() {
        return this.m_numberOfBytesSent;
    }

    public final int getNumberOfReceives() {
        return this.m_numberOfReceives;
    }

    public final int getNumberOfBytesReceived() {
        return this.m_numberOfBytesReceived;
    }

    public boolean isSecure() {
        return this.m_secure;
    }

    public boolean isLocalAddress() {
        return this.m_isLocalAddress;
    }

    protected final synchronized ByteBuffer getByteBuffer() {
        ByteBuffer buffer = this.m_byteBuffer;
        if (buffer != null) {
            this.m_byteBuffer = null;
        } else {
            buffer = ByteBuffer.allocate(64000);
        }
        this.initializeByteBuffer(buffer);
        return buffer;
    }

    protected final synchronized void initializeByteBuffer(ByteBuffer buffer) {
        buffer.clear();
        buffer.position(4);
    }

    protected final synchronized void releaseByteBuffer(ByteBuffer buffer) {
        this.m_byteBuffer = buffer;
    }

    protected final synchronized int getNextSequenceNumber() {
        return this.m_nextSequenceNumber++;
    }

    protected final void receiveMessage(ByteBuffer buffer) throws DfIOException {
        if (this.m_messageChannel == null) {
            throw new IllegalStateException("socket not initialized");
        }
        try {
            buffer.clear();
            int bytesReceived = this.m_messageChannel.read(buffer);
            if (bytesReceived >= 0) {
                this.m_numberOfBytesReceived += bytesReceived;
                ++this.m_numberOfReceives;
                buffer.position(0);
            }
        }
        catch (IOException e) {
            throw DfIOException.newCommunicationFailureException(e);
        }
    }

    protected final void sendMessage(ByteBuffer buffer) throws DfIOException {
        if (this.m_messageChannel == null) {
            throw new IllegalStateException("socket not initialized");
        }
        try {
            buffer.limit(buffer.position());
            buffer.position(4);
            this.m_numberOfBytesSent += this.m_messageChannel.write(buffer);
            ++this.m_numberOfSends;
        }
        catch (IOException e) {
            throw DfIOException.newCommunicationFailureException(e);
        }
    }

    protected static void validateResponseHeader(ByteBuffer buffer, int requestSequenceNumber) throws ProtocolException {
        IntHolder sequenceNumberHolder = new IntHolder();
        NetwiseProtocol.deserializeResponseHeader(buffer, sequenceNumberHolder);
        if (sequenceNumberHolder.value != requestSequenceNumber) {
            throw new ProtocolException("Wrong sequence number in NetwiseProtocol header, expected {0}, received {1}", new Object[]{requestSequenceNumber, sequenceNumberHolder.value});
        }
    }

    protected void serializeObjectToStringBuilder(StringBuilder stringBuilder, ITypedData value) throws DfException {
        if (value == null) {
            value = new DynamicallyTypedData();
        }
        stringBuilder.setLength(0);
        this.getObjectProtocol().serializeObject(stringBuilder, value);
    }

    protected StringBuilderSerializer getStringBuilderSerializer() {
        return new StringBuilderSerializer();
    }
}

