/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase.netwise;

import com.documentum.fc.client.DfIOException;
import com.documentum.fc.client.impl.connection.docbase.DocbaseConnectionProtocol;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseRpcClient;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseRpcClientFactory;
import com.documentum.fc.client.impl.connection.docbase.ServerEntry;
import com.documentum.fc.client.impl.connection.docbase.netwise.IBMX509TrustManager;
import com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.IDfLoginInfo;
import com.documentum.fc.impl.util.StringUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class NetwiseDocbaseRpcClientFactory
implements IDocbaseRpcClientFactory {
    private static String[] s_cipherSuitesToEnable = null;
    private static TrustManager[] s_trustManager = null;
    private static final String DFC_IPV6_WINDOWS_ERROR_MESSAGE = "Address family not supported by protocol".intern();

    public IDocbaseRpcClient newDocbaseRpcClient(ServerEntry serverChoice, IDfLoginInfo loginInfo) throws DfException {
        if (!(serverChoice.getAddress() instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("address");
        }
        try {
            return new NetwiseDocbaseRpcClient(this.openSocket(serverChoice, loginInfo.getSecurityMode()));
        }
        catch (Exception e) {
            throw DfIOException.newCommunicationFailureException(e);
        }
    }

    private Socket openSocket(ServerEntry serverChoice, String securityMode) throws Exception {
        Socket socket = null;
        DocbaseConnectionProtocol protocol = null;
        protocol = serverChoice.getProtocol();
        if (protocol != null) {
            switch (protocol) {
                case IPV4_NATIVE: {
                    socket = this.openNormalSocket((InetSocketAddress)serverChoice.getAddress());
                    break;
                }
                case IPV4_SSL: {
                    socket = this.openSslSocket((InetSocketAddress)serverChoice.getAddress());
                    break;
                }
                case IPV6_NATIVE: {
                    socket = this.openNormalSocket((InetSocketAddress)serverChoice.getAddressIPV6());
                    break;
                }
                case IPV6_SSL: {
                    socket = this.openSslSocket((InetSocketAddress)serverChoice.getAddressIPV6());
                }
            }
        } else {
            if (StringUtil.isEmptyOrNull(securityMode)) {
                securityMode = DfPreferences.getInstance().getSessionSecureConnectDefault();
            }
            boolean canuseIPV6 = DfUtil.canUseIPV6();
            if (IDfLoginInfo.SECURITY_MODE_NATIVE.equals(securityMode)) {
                socket = this.makeNativeConnection(serverChoice, canuseIPV6);
            } else if (IDfLoginInfo.SECURITY_MODE_SECURE.equals(securityMode)) {
                socket = this.makeSecureConnection(serverChoice, canuseIPV6);
            } else if (IDfLoginInfo.SECURITY_MODE_TRY_SECURE_FIRST.equals(securityMode)) {
                socket = this.trySecureFirst(serverChoice, canuseIPV6);
            } else if (IDfLoginInfo.SECURITY_MODE_TRY_NATIVE_FIRST.equals(securityMode)) {
                socket = this.tryNativeFirst(serverChoice, canuseIPV6);
            } else {
                throw new IllegalArgumentException("Invalid security mode");
            }
        }
        return socket;
    }

    private Socket openNormalSocket(final InetSocketAddress address) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws IOException {
                    SocketChannel socketChannel = SocketChannel.open();
                    socketChannel.configureBlocking(true);
                    socketChannel.connect(address);
                    return socketChannel.socket();
                }
            });
        }
        catch (PrivilegedActionException e) {
            IOException ioEx = (IOException)e.getCause();
            if (System.getProperty("os.name").contains("Windows") && ioEx.getMessage().contains(DFC_IPV6_WINDOWS_ERROR_MESSAGE)) {
                return this.createNormalSocketOnWindowsIPV6Error(address);
            }
            throw ioEx;
        }
    }

    private Socket createNormalSocketOnWindowsIPV6Error(final InetSocketAddress address) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws IOException {
                    Socket socket = SocketFactory.getDefault().createSocket();
                    socket.connect(address);
                    return socket;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private Socket openSslSocket(final InetSocketAddress baseAddress) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws Exception {
                    InetSocketAddress sslAddress = new InetSocketAddress(baseAddress.getAddress(), baseAddress.getPort() + 1);
                    SSLSocket socket = NetwiseDocbaseRpcClientFactory.this.getSSLSocket();
                    socket.setEnabledCipherSuites(NetwiseDocbaseRpcClientFactory.this.getCipherSuitesToEnable());
                    socket.connect(sslAddress);
                    return socket;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private SSLSocket getSSLSocket() throws Exception {
        SSLSocket socket = null;
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.contains("IBM")) {
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, this.getTrustManager(), null);
            socket = (SSLSocket)ctx.getSocketFactory().createSocket();
        } else {
            socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
        }
        return socket;
    }

    private synchronized TrustManager[] getTrustManager() throws Exception {
        if (s_trustManager == null) {
            s_trustManager = new TrustManager[]{new IBMX509TrustManager()};
        }
        return s_trustManager;
    }

    private synchronized String[] getCipherSuitesToEnable() {
        if (s_cipherSuitesToEnable == null) {
            SSLSocketFactory socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            ArrayList<String> cipherSuites = new ArrayList<String>(Arrays.asList(socketFactory.getDefaultCipherSuites()));
            cipherSuites.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
            s_cipherSuitesToEnable = cipherSuites.toArray(new String[0]);
        }
        return s_cipherSuitesToEnable;
    }

    private Socket trySecureFirst(ServerEntry serverChoice, boolean canuseIPV6) throws Exception {
        Socket socket = this.trySecureFirstInternal(serverChoice, canuseIPV6);
        return socket;
    }

    private Socket trySecureFirstInternal(ServerEntry serverChoice, boolean canuseIPV6) throws Exception {
        Socket socket;
        try {
            socket = this.makeSecureConnection(serverChoice, canuseIPV6);
        }
        catch (ConnectException e) {
            socket = this.makeNativeConnection(serverChoice, canuseIPV6);
        }
        return socket;
    }

    private Socket tryNativeFirst(ServerEntry serverChoice, boolean canuseIPV6) throws Exception {
        Socket socket = this.tryNativeFirstInternal(serverChoice, canuseIPV6);
        return socket;
    }

    private Socket tryNativeFirstInternal(ServerEntry serverChoice, boolean canuseIPV6) throws Exception {
        Socket socket;
        try {
            socket = this.makeNativeConnection(serverChoice, canuseIPV6);
        }
        catch (ConnectException ex) {
            socket = this.makeSecureConnection(serverChoice, canuseIPV6);
        }
        return socket;
    }

    private Socket makeNativeConnection(ServerEntry serverChoice, boolean canuseIPV6) throws Exception {
        Socket socket;
        if (canuseIPV6 && !(serverChoice.getAddressIPV6() instanceof String)) {
            try {
                socket = this.openNormalSocket((InetSocketAddress)serverChoice.getAddressIPV6());
                DfLogger.debug((Object)this, "1:IPV6: " + canuseIPV6 + " address: " + serverChoice.getAddressIPV6(), null, null);
                serverChoice.setconnectionProtocol(DocbaseConnectionProtocol.IPV6_NATIVE);
            }
            catch (ConnectException e) {
                socket = this.openNormalSocket((InetSocketAddress)serverChoice.getAddress());
                DfLogger.debug((Object)this, "2:IPV6: " + canuseIPV6 + " address: " + serverChoice.getAddress(), null, null);
                serverChoice.setconnectionProtocol(DocbaseConnectionProtocol.IPV4_NATIVE);
            }
        } else {
            socket = this.openNormalSocket((InetSocketAddress)serverChoice.getAddress());
            DfLogger.debug((Object)this, "3:IPV6: " + canuseIPV6 + " address: " + serverChoice.getAddress(), null, null);
            serverChoice.setconnectionProtocol(DocbaseConnectionProtocol.IPV4_NATIVE);
        }
        return socket;
    }

    private Socket makeSecureConnection(ServerEntry serverChoice, boolean canuseIPV6) throws Exception {
        Socket socket;
        if (canuseIPV6 && !(serverChoice.getAddressIPV6() instanceof String)) {
            try {
                socket = this.openSslSocket((InetSocketAddress)serverChoice.getAddressIPV6());
                DfLogger.debug((Object)this, "4:IPV6: " + canuseIPV6 + " address: " + serverChoice.getAddressIPV6(), null, null);
                serverChoice.setconnectionProtocol(DocbaseConnectionProtocol.IPV6_SSL);
            }
            catch (ConnectException e) {
                socket = this.openSslSocket((InetSocketAddress)serverChoice.getAddress());
                DfLogger.debug((Object)this, "5:IPV6: " + canuseIPV6 + " address: " + serverChoice.getAddress(), null, null);
                serverChoice.setconnectionProtocol(DocbaseConnectionProtocol.IPV4_SSL);
            }
        } else {
            socket = this.openSslSocket((InetSocketAddress)serverChoice.getAddress());
            DfLogger.debug((Object)this, "6:IPV6: " + canuseIPV6 + " address: " + serverChoice.getAddress(), null, null);
            serverChoice.setconnectionProtocol(DocbaseConnectionProtocol.IPV4_SSL);
        }
        return socket;
    }
}

