/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase;

import com.documentum.fc.client.IDfServerMap;
import com.documentum.fc.client.impl.connection.docbase.ServerEntry;
import com.documentum.fc.client.impl.docbase.DocbaseSpec;
import com.documentum.fc.client.impl.docbroker.DocbrokerClient;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.internal.util.SoftwareVersion;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class ServerChoiceManager {
    private final String m_docbaseName;
    private ServerEntry[] m_serverChoices;
    private ServerEntry[] m_contentServerChoices;
    private long m_lastServerChoiceUpdate;
    private static Map<String, ServerChoiceManager> s_instances = new HashMap<String, ServerChoiceManager>();
    private static final int s_maximumAgeForServerChoices = 300000;

    static synchronized ServerChoiceManager getInstance(String docbaseName) {
        assert (docbaseName != null);
        ServerChoiceManager instance = s_instances.get(docbaseName);
        if (instance == null) {
            instance = new ServerChoiceManager(docbaseName);
            s_instances.put(docbaseName, instance);
        }
        return instance;
    }

    private ServerChoiceManager(String docbaseName) {
        this.m_docbaseName = docbaseName;
        this.m_serverChoices = new ServerEntry[0];
        this.m_contentServerChoices = new ServerEntry[0];
        this.m_lastServerChoiceUpdate = 0L;
    }

    synchronized ServerEntry[] getServerChoices() throws DfException {
        this.updateServerChoicesIfNecessary();
        ServerEntry[] result = this.m_serverChoices;
        this.m_serverChoices = this.rotateChoices(this.m_serverChoices);
        return result;
    }

    synchronized ServerEntry[] getContentServerChoices() throws DfException {
        this.updateServerChoicesIfNecessary();
        ServerEntry[] result = this.m_contentServerChoices;
        this.m_contentServerChoices = this.rotateChoices(this.m_contentServerChoices);
        return result;
    }

    private ServerEntry[] rotateChoices(ServerEntry[] choices) {
        if (choices.length <= 1) {
            return choices;
        }
        ServerEntry[] rotatedChoices = new ServerEntry[choices.length];
        int i = 1;
        int j = 0;
        while (i < choices.length && choices[i].getProximity() <= choices[0].getProximity()) {
            rotatedChoices[j++] = choices[i++];
        }
        rotatedChoices[j++] = choices[0];
        while (i < choices.length) {
            rotatedChoices[j++] = choices[i++];
        }
        return rotatedChoices;
    }

    private synchronized void updateServerChoicesIfNecessary() throws DfException {
        if (this.m_serverChoices.length == 0) {
            this.updateServerChoices();
        } else if (System.currentTimeMillis() - this.m_lastServerChoiceUpdate > 300000L) {
            this.updateServerChoices();
        }
    }

    synchronized void updateServerChoices() throws DfException {
        ArrayList<ServerEntry> serverChoices = new ArrayList<ServerEntry>();
        ArrayList<ServerEntry> contentServerChoices = new ArrayList<ServerEntry>();
        ArrayList<ServerEntry> badServerChoices = new ArrayList<ServerEntry>();
        IDfServerMap serverMap = (IDfServerMap)DocbrokerClient.getGlobalInstance().getServerMap(this.m_docbaseName);
        int limit = serverMap.getServerCount();
        for (int i = 0; i < limit; ++i) {
            DocbaseSpec docbaseSpec = new DocbaseSpec(this.m_docbaseName, serverMap.getServerName(i), serverMap.getHostName(i));
            int proximity = serverMap.getClientProximity(i);
            Object[] addresses = ServerChoiceManager.parseAddressFromDocbroker(serverMap.getConnectionAddress(i), serverMap.getConnectionAddress6(i));
            SoftwareVersion serverVersion = new SoftwareVersion(serverMap.getServerVersion(i));
            ServerEntry entry = new ServerEntry(docbaseSpec, serverMap.getDocbaseId(), proximity, addresses, serverVersion);
            if (serverMap.getLastStatus(i).equals("Open")) {
                serverChoices.add(entry);
                if (proximity < 9000) continue;
                contentServerChoices.add(entry);
                continue;
            }
            badServerChoices.add(entry);
        }
        if (serverChoices.size() == 0) {
            serverChoices = badServerChoices;
        }
        Collections.sort(serverChoices, new ServerProximityComparator());
        Collections.sort(contentServerChoices, new ServerProximityComparator());
        this.m_serverChoices = serverChoices.toArray(new ServerEntry[serverChoices.size()]);
        this.m_contentServerChoices = contentServerChoices.toArray(new ServerEntry[contentServerChoices.size()]);
        this.m_lastServerChoiceUpdate = System.currentTimeMillis();
        if (DfLogger.isDebugEnabled(this)) {
            DfLogger.debug((Object)this, "Updated Server Choices for ''{0}''. {1} servers found. {2} content servers found", new Object[]{this.m_docbaseName, this.m_serverChoices.length, this.m_contentServerChoices.length}, null);
        }
    }

    private static Object[] parseAddressFromDocbroker(String address, String address6) {
        Object[] addresses = new Object[2];
        addresses[1] = address6 != null ? ServerChoiceManager.parseAddressFromDocbrokerInternal(address6) : ServerChoiceManager.parseAddressFromDocbrokerInternal("".intern());
        addresses[0] = ServerChoiceManager.parseAddressFromDocbrokerInternal(address);
        return addresses;
    }

    private static Object parseAddressFromDocbrokerInternal(String address) {
        if (!address.startsWith("INET_ADDR:")) {
            return address;
        }
        try {
            int b = address.indexOf(32, address.indexOf(32) + 1) + 1;
            int e = address.indexOf(32, b);
            int port = Integer.parseInt(address.substring(b, e), 16);
            String host = address.substring(address.lastIndexOf(32) + 1);
            return new InetSocketAddress(host, port);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("address");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("address");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServerProximityComparator
    implements Comparator<ServerEntry>,
    Serializable {
        static final long serialVersionUID = 7397435743535991482L;

        private ServerProximityComparator() {
        }

        @Override
        public int compare(ServerEntry o1, ServerEntry o2) {
            return o1.getProximity() - o2.getProximity();
        }
    }
}

