/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase;

import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnection;
import com.documentum.fc.client.impl.connection.docbase.SeekFailedException;
import com.documentum.fc.client.impl.connection.docbase.StaleServerHandleException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.impl.util.holders.BooleanHolder;

public final class RawPuller {
    private final int m_handle;
    private final IDocbaseConnection m_connection;
    private final int m_originalReconnectCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawPuller(IDocbaseConnection connection, IDfId storeId, IDfId contentId, IDfId sysobjId, IDfId formatId, int storeTicket, boolean isOffline, boolean isOther, boolean compression, boolean noAccessUpdate) throws DfException {
        IDocbaseConnection iDocbaseConnection = this.m_connection = connection;
        synchronized (iDocbaseConnection) {
            this.m_handle = this.m_connection.getDocbaseApi().makePuller(storeId, contentId, sysobjId, formatId, storeTicket, isOffline, isOther, compression, noAccessUpdate);
            this.m_originalReconnectCount = connection.getReconnectCount();
        }
    }

    public int getHandle() throws DfException {
        if (this.m_connection.getReconnectCount() != this.m_originalReconnectCount) {
            throw new StaleServerHandleException();
        }
        return this.m_handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startPull(IDfId contentId, IDfId sysobjId, IDfId formatId, int storeTicket, boolean isOffline, boolean isOther, boolean compression, boolean noAccessUpdate) throws DfException {
        IDocbaseConnection iDocbaseConnection = this.m_connection;
        synchronized (iDocbaseConnection) {
            return this.m_connection.getDocbaseApi().startPull(this.getHandle(), contentId, sysobjId, formatId, storeTicket, isOffline, isOther, compression, noAccessUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlock(int blockNumber, BooleanHolder isLastBlockHolder) throws DfException {
        IDocbaseConnection iDocbaseConnection = this.m_connection;
        synchronized (iDocbaseConnection) {
            return this.m_connection.getBlock(this.getHandle(), blockNumber, isLastBlockHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSeekable() throws DfException {
        IDocbaseConnection iDocbaseConnection = this.m_connection;
        synchronized (iDocbaseConnection) {
            return this.m_connection.getDocbaseApi().isSeekable(this.getHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long seek(long position, int direction) throws DfException {
        long result;
        IDocbaseConnection iDocbaseConnection = this.m_connection;
        synchronized (iDocbaseConnection) {
            result = this.m_connection.getDocbaseApi().seek(this.getHandle(), position, direction);
        }
        if (result < 0L) {
            throw SeekFailedException.newSeekFailedException();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long seek64(long position, int direction) throws DfException {
        long result;
        IDocbaseConnection iDocbaseConnection = this.m_connection;
        synchronized (iDocbaseConnection) {
            result = this.m_connection.getDocbaseApi().seek64(this.getHandle(), position, direction);
        }
        if (result < 0L) {
            throw SeekFailedException.newSeekFailedException();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endPull() throws DfException {
        IDocbaseConnection iDocbaseConnection = this.m_connection;
        synchronized (iDocbaseConnection) {
            return this.m_connection.getDocbaseApi().endPull(this.getHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killPuller() throws DfException {
        IDocbaseConnection iDocbaseConnection = this.m_connection;
        synchronized (iDocbaseConnection) {
            return this.m_connection.getDocbaseApi().killPuller(this.getHandle());
        }
    }
}

