/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase;

import com.documentum.fc.client.impl.connection.docbase.IDocbaseMessageManager;
import com.documentum.fc.client.impl.connection.docbase.MessageEntry;
import com.documentum.fc.client.impl.docbase.DocbaseApi;
import com.documentum.fc.client.impl.docbase.DocbaseExceptionMapper;
import com.documentum.fc.client.impl.docbase.DocbaseMessageIds;
import com.documentum.fc.client.impl.typeddata.DynamicallyTypedData;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.ITypedDataIterator;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.impl.MessageHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocbaseMessageManager
implements IDocbaseMessageManager {
    private final DocbaseApi m_docbaseApi;
    private List<MessageEntry> m_messageEntries;

    DocbaseMessageManager(DocbaseApi docbaseApi) {
        assert (docbaseApi != null);
        this.m_docbaseApi = docbaseApi;
        this.m_messageEntries = new LinkedList<MessageEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importMessagesFromServer() throws DfException {
        boolean exceptionsWereImported = false;
        ITypedDataIterator it = this.m_docbaseApi.getErrors("dmError");
        try {
            DocbaseMessageManager docbaseMessageManager = this;
            synchronized (docbaseMessageManager) {
                while (it.hasNext()) {
                    Object[] arguments;
                    ITypedData errorData = it.next();
                    int severity = errorData.getInt("SEVERITY");
                    String message = this.extractMessage(errorData);
                    MessageHelper messageHelper = new MessageHelper(message, arguments = DocbaseMessageManager.extractErrorArguments(errorData));
                    boolean worthyOfException = DocbaseExceptionMapper.isWorthyOfException(messageHelper.getMessageId(), severity);
                    if (worthyOfException) {
                        exceptionsWereImported = true;
                    }
                    this.m_messageEntries.add(new MessageEntry(messageHelper, severity, worthyOfException));
                }
            }
        }
        finally {
            it.close();
        }
        return exceptionsWereImported;
    }

    private String extractMessage(ITypedData errorData) {
        int code = errorData.getInt("CODE");
        try {
            return DocbaseMessageIds.getString(code);
        }
        catch (MissingResourceException e) {
            return this.getMessageFromServer(errorData);
        }
    }

    private String getMessageFromServer(ITypedData errorData) {
        try {
            return this.m_docbaseApi.processNewServerMessage(this.createDynamicallyTypedErrorData(errorData));
        }
        catch (Exception e) {
            int code = errorData.getInt("CODE");
            DfLogger.warn((Object)this, "Failed to get message for error 0x{0}", new String[]{Integer.toHexString(code)}, (Throwable)e);
            return "Unknown server error 0x" + Integer.toHexString(code);
        }
    }

    private ITypedData createDynamicallyTypedErrorData(ITypedData errorData) {
        DynamicallyTypedData newErrorData = new DynamicallyTypedData();
        int limit = errorData.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            String attributeName = errorData.getType().getAttr(i).getName();
            newErrorData.setObject(attributeName, errorData.getObject(attributeName));
        }
        return newErrorData;
    }

    private static Object[] extractErrorArguments(ITypedData errorData) {
        ArrayList<Object> list = new ArrayList<Object>();
        int argumentCount = errorData.getInt("COUNT");
        for (int j = 1; j <= argumentCount; ++j) {
            list.add(errorData.getObject(Integer.toString(j)));
        }
        return list.toArray();
    }

    @Override
    public synchronized DfException getException() {
        DfException firstException = null;
        DfException lastException = null;
        Iterator<MessageEntry> it = this.m_messageEntries.iterator();
        while (it.hasNext()) {
            MessageEntry entry = it.next();
            if (!entry.isWorthyOfException()) continue;
            DfException thisException = entry.getException();
            if (firstException == null) {
                firstException = thisException;
            } else {
                lastException.setNextException(thisException);
            }
            lastException = thisException;
            it.remove();
        }
        return firstException;
    }

    @Override
    public synchronized String getMessage(int severity) {
        StringBuilder sb = new StringBuilder();
        for (MessageEntry entry : this.m_messageEntries) {
            if (entry.getSeverity() < severity) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(entry.getMessage()).append('\n');
        }
        this.m_messageEntries.clear();
        return sb.toString();
    }

    @Override
    public synchronized DfException getExceptionForAllMessages(int severity) {
        DfException firstException = null;
        DfException lastException = null;
        for (MessageEntry entry : this.m_messageEntries) {
            if (entry.getSeverity() < severity) continue;
            if (firstException == null) {
                lastException = firstException = entry.getException();
                continue;
            }
            DfException newException = entry.getException();
            lastException.setNextException(newException);
            lastException = newException;
        }
        this.m_messageEntries.clear();
        return firstException;
    }

    @Override
    public synchronized void flushMessages() {
        this.m_messageEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(int severity, String message, Object[] arguments) {
        MessageHelper messageHelper = new MessageHelper(message, arguments);
        DocbaseMessageManager docbaseMessageManager = this;
        synchronized (docbaseMessageManager) {
            this.m_messageEntries.add(0, new MessageEntry(messageHelper, severity, false));
        }
    }

    @Override
    public synchronized List<MessageEntry> saveMessageEntries() {
        List<MessageEntry> result = this.m_messageEntries;
        this.m_messageEntries = new LinkedList<MessageEntry>();
        return result;
    }

    @Override
    public synchronized void restoreMessageEntries(List<MessageEntry> entries) {
        assert (entries != null);
        entries.addAll(this.m_messageEntries);
        this.m_messageEntries = entries;
    }
}

