/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase;

import com.documentum.fc.client.DfAuthenticationException;
import com.documentum.fc.client.DfDeadlockException;
import com.documentum.fc.client.DfDocbaseUnreachableException;
import com.documentum.fc.client.DfIOException;
import com.documentum.fc.client.DfNoServersException;
import com.documentum.fc.client.impl.AuthenticationLevel;
import com.documentum.fc.client.impl.Docbase;
import com.documentum.fc.client.impl.Server;
import com.documentum.fc.client.impl.bof.security.RoleRequest;
import com.documentum.fc.client.impl.bof.security.RoleRequestManager;
import com.documentum.fc.client.impl.connection.LiteTypeManager;
import com.documentum.fc.client.impl.connection.docbase.ClientInfo;
import com.documentum.fc.client.impl.connection.docbase.DocbaseMessageManager;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnection;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnectionManager;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseMessageManager;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseRpcClient;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseRpcClientFactory;
import com.documentum.fc.client.impl.connection.docbase.MessageEntry;
import com.documentum.fc.client.impl.connection.docbase.RawPuller;
import com.documentum.fc.client.impl.connection.docbase.ServerChoiceManager;
import com.documentum.fc.client.impl.connection.docbase.ServerEntry;
import com.documentum.fc.client.impl.connection.docbase.ServerInfo;
import com.documentum.fc.client.impl.connection.docbase.UnknownServerResponseException;
import com.documentum.fc.client.impl.connection.docbase.UnknownSessionStartException;
import com.documentum.fc.client.impl.connection.docbase.UnsupportedRepositoryServerVersionException;
import com.documentum.fc.client.impl.crypto.CryptoUtils;
import com.documentum.fc.client.impl.docbase.DocbaseApi;
import com.documentum.fc.client.impl.docbase.DocbaseCharSetUtility;
import com.documentum.fc.client.impl.docbase.DocbaseDateFormat;
import com.documentum.fc.client.impl.docbase.DocbaseLocaleUtility;
import com.documentum.fc.client.impl.docbase.DocbaseMessages;
import com.documentum.fc.client.impl.docbase.DocbasePlatformUtility;
import com.documentum.fc.client.impl.docbase.DocbaseSpec;
import com.documentum.fc.client.impl.docbase.IDocbaseSpec;
import com.documentum.fc.client.impl.objectprotocol.IObjectProtocol;
import com.documentum.fc.client.impl.objectprotocol.ObjectProtocolV0;
import com.documentum.fc.client.impl.objectprotocol.ObjectProtocolV1;
import com.documentum.fc.client.impl.tokenstorage.TokenStorageManager;
import com.documentum.fc.client.impl.typeddata.DataConverter;
import com.documentum.fc.client.impl.typeddata.DynamicallyTypedData;
import com.documentum.fc.client.impl.typeddata.IBatchedTypedDataIterator;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.ITypedDataIterator;
import com.documentum.fc.client.impl.typeddata.TypedData;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfLoginInfo;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfRuntimeException;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfLoginInfo;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.common.UnifiedLoginHelper;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.RuntimeContext;
import com.documentum.fc.impl.security.action.GetPropertyAction;
import com.documentum.fc.impl.security.action.GetenvAction;
import com.documentum.fc.impl.util.Functor;
import com.documentum.fc.impl.util.holders.BooleanHolder;
import com.documentum.fc.impl.util.holders.ObjectHolder;
import com.documentum.fc.internal.util.SoftwareVersion;
import com.documentum.fc.tracing.IUserIdentifyingObject;
import com.documentum.fc.tracing.IUserTracingInfo;
import com.documentum.fc.tracing.impl.annotation.Mask;
import com.emc.documentum.kerberos.utility.KerberosUtility;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocbaseConnection
implements IDocbaseConnection,
IUserIdentifyingObject {
    private static SoftwareVersion MINIMUM_SERVER_VERSION = new SoftwareVersion("5.3.0.0");
    private int m_sessionRecordHint;
    private String m_externalId;
    private final IDocbaseSpec m_requestedDocbaseSpec;
    private IDfLoginInfo m_loginInfo;
    private ClientInfo m_clientInfo;
    private ServerInfo m_serverInfo;
    private ITypedData m_connectionInfo;
    private Thread m_transactionThread;
    private Thread m_readQueryThread;
    private int m_readQueryAcquireCount;
    private LiteTypeManager m_typeManager;
    private IDocbaseRpcClient m_rpcClient;
    private final IDocbaseRpcClientFactory m_rpcClientFactory;
    private final DocbaseApi m_docbaseApi;
    private final boolean m_forContent;
    private boolean m_deadlockVictim;
    private ServerEntry m_currentServerChoice;
    private IDocbaseMessageManager m_messageManager;
    private int m_reconnectCount;
    private int m_reuseCount;
    private IDocbaseConnection m_contentConnection;
    private IDocbaseConnectionManager m_connectionManager;
    private boolean m_reconnectNeeded;
    private int m_numberOfErrorsToGenerate;
    private IUserIdentifyingObject m_userIdentifyingObject;
    private final long m_internalId;
    private Docbase m_docbase;
    private Server m_server;
    private long m_timeOfLastAuthenticate;
    private static int s_maximumErrorRetries;
    private static int s_maximumOpenRetries;
    private static boolean s_tokenStorageEnabled;
    private static boolean s_neverUseContentServer;
    private static boolean s_alwaysUseContentServer;
    private static String s_logonName;
    private static String s_logonDomain;
    private static long s_nextInternalId;
    private static String s_ulLogonType;
    private static String s_ulSecurityInfo;
    private static final int MAXIMUM_PROXIMITY = 1000;
    private static final int SERIALIZATION_VERSION_CLIENT_SUPPORT = 2;
    private Stack<Integer> txStack = new Stack();
    private static final String AUTH_LEVEL = "AUTHENTICATION_LEVEL";
    private static final String CONTENT_SERVER_PROTOCOL = "CS";
    private static final String PROTOCOL_SEPARATOR = "/";
    private static final String DOMAIN_SEPARATOR = "@";

    DocbaseConnection(IDocbaseRpcClientFactory rpcClientFactory, IDocbaseSpec docbaseSpec, IDfLoginInfo loginInfo, ClientInfo clientInfo) throws DfException {
        this(rpcClientFactory, docbaseSpec, loginInfo, clientInfo, false, 1000);
    }

    private DocbaseConnection(IDocbaseRpcClientFactory rpcClientFactory, IDocbaseSpec docbaseSpec, IDfLoginInfo loginInfo, ClientInfo clientInfo, boolean forContent, int maximumProximity) throws DfException {
        assert (docbaseSpec != null);
        assert (loginInfo != null);
        this.m_externalId = "0000000000000000";
        this.m_sessionRecordHint = -1;
        this.m_rpcClientFactory = rpcClientFactory;
        this.m_requestedDocbaseSpec = docbaseSpec;
        this.m_forContent = forContent;
        this.m_deadlockVictim = false;
        this.m_transactionThread = null;
        this.m_readQueryThread = null;
        this.m_reconnectCount = 0;
        this.m_docbaseApi = new DocbaseApi(this);
        this.m_currentServerChoice = null;
        this.m_contentConnection = null;
        this.m_reconnectNeeded = false;
        this.m_numberOfErrorsToGenerate = 0;
        this.m_internalId = DocbaseConnection.getNextInternalId();
        this.m_reuseCount = 0;
        this.m_server = null;
        this.m_docbase = null;
        this.m_timeOfLastAuthenticate = 0L;
        this.m_messageManager = null;
        this.m_typeManager = null;
        this.open(loginInfo, clientInfo, maximumProximity, true);
    }

    private static synchronized long getNextInternalId() {
        return s_nextInternalId++;
    }

    private synchronized void open(IDfLoginInfo loginInfo, ClientInfo clientInfo, int maximumProximity, boolean retry) throws DfException {
        int numberOfIOErrors = 0;
        while (true) {
            try {
                this.establishNewRpcClient(loginInfo, maximumProximity);
                this.m_rpcClient.setUserIdentifyingObject(this);
                try {
                    this.beginSession(clientInfo);
                    this.authenticate(loginInfo, clientInfo, false, false, retry);
                    return;
                }
                catch (DfException e) {
                    this.close(false);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.close(false);
                    throw e;
                }
            }
            catch (DfException e) {
                if (this.shouldRetryOpenException(e) && numberOfIOErrors++ < DocbaseConnection.getMaximumOpenRetries()) {
                    String message = e instanceof DfIOException && e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                    DfLogger.warn((Object)this, "DFC_SESSION_RETRYING_OPEN", new Object[]{this.m_requestedDocbaseSpec, message}, null);
                    this.m_currentServerChoice = null;
                    if (numberOfIOErrors == 1) {
                        this.updateServerChoices();
                        continue;
                    }
                    this.delayBeforeOpenRetry(numberOfIOErrors);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private boolean shouldRetryOpenException(DfException e) {
        if (e instanceof DfIOException || e instanceof DfDocbaseUnreachableException) {
            Throwable cause = e.getCause();
            if (cause instanceof ConnectException) {
                String message = cause.getMessage();
                return !message.contains("timed out");
            }
            return !(cause instanceof DfNoServersException);
        }
        return e instanceof UnknownSessionStartException;
    }

    private void delayBeforeOpenRetry(int numberOfRetry) {
        try {
            Thread.sleep((long)((double)(numberOfRetry * 100) + 50.0 * Math.random()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void establishNewRpcClient(IDfLoginInfo loginInfo, int maximumProximity) throws DfException {
        DfException lastException = null;
        try {
            if (this.m_currentServerChoice != null) {
                this.m_rpcClient = this.m_rpcClientFactory.newDocbaseRpcClient(this.m_currentServerChoice, loginInfo);
                return;
            }
        }
        catch (DfIOException e) {
            lastException = e;
        }
        int i = 0;
        while (i++ < 2) {
            for (ServerEntry choice : this.getServerChoices()) {
                try {
                    if (!choice.getDocbaseSpec().matches(this.m_requestedDocbaseSpec) || choice.getServerProximity() >= maximumProximity) continue;
                    if (MINIMUM_SERVER_VERSION.compareTo(choice.getServerVersion()) > 0) {
                        throw UnsupportedRepositoryServerVersionException.newUnsupportedRepositoryServerVersionException(choice.getDocbaseSpec().toString(), choice.getServerVersion().getFormatted());
                    }
                    this.m_rpcClient = this.m_rpcClientFactory.newDocbaseRpcClient(choice, loginInfo);
                    this.m_currentServerChoice = choice;
                    return;
                }
                catch (DfIOException e) {
                    lastException = e;
                }
                catch (UnsupportedRepositoryServerVersionException e) {
                    lastException = e;
                }
            }
            if (this.m_forContent) continue;
            this.updateServerChoices();
        }
        if (lastException == null) {
            lastException = new DfNoServersException(this.m_requestedDocbaseSpec);
        }
        if (lastException instanceof DfIOException) {
            throw new DfDocbaseUnreachableException(this.m_requestedDocbaseSpec, lastException.getCause());
        }
        throw new DfDocbaseUnreachableException(this.m_requestedDocbaseSpec, (Throwable)lastException);
    }

    private ServerEntry[] getServerChoices() throws DfException {
        ServerChoiceManager choiceManager = ServerChoiceManager.getInstance(this.m_requestedDocbaseSpec.getDocbase());
        if (this.m_forContent) {
            return choiceManager.getContentServerChoices();
        }
        return choiceManager.getServerChoices();
    }

    private void updateServerChoices() throws DfException {
        ServerChoiceManager choiceManager = ServerChoiceManager.getInstance(this.m_requestedDocbaseSpec.getDocbase());
        choiceManager.updateServerChoices();
    }

    private void beginSession(ClientInfo clientInfo) throws DfException {
        if (this.m_typeManager == null) {
            this.m_typeManager = LiteTypeManager.getInstance(this.m_requestedDocbaseSpec.getDocbase());
        }
        if (this.m_messageManager == null) {
            this.m_messageManager = new DocbaseMessageManager(this.m_docbaseApi);
        }
        this.m_rpcClient.setMessageManager(this.m_messageManager);
        ObjectProtocolV0 entryPointObjectProtocol = new ObjectProtocolV0(this, this.m_typeManager);
        this.m_rpcClient.setEntryPointObjectProtocol(entryPointObjectProtocol);
        this.m_rpcClient.setObjectProtocol(entryPointObjectProtocol);
        ObjectHolder serverOptions = new ObjectHolder();
        this.m_externalId = this.m_rpcClient.newSessionByAddr(this.m_currentServerChoice.getDocbaseId(), null, DocbaseConnection.buildClientOptions(this.m_sessionRecordHint), serverOptions, this.m_externalId);
        this.m_rpcClient.setObjectProtocol(this.chooseObjectProtocol((int[])serverOptions.value));
        this.m_sessionRecordHint = ((int[])serverOptions.value)[6];
        ITypedData serverInfoData = this.applyForObject(null, DfId.DF_NULLID, DocbaseConnection.buildArgumentsFromClientInfo(clientInfo), true, true, false);
        this.m_serverInfo = new ServerInfo(serverInfoData, (int[])serverOptions.value);
        this.m_typeManager.updateFromServerInfo(this.m_serverInfo);
        this.m_rpcClient.setMethodMap(this.m_serverInfo.getMethodMap());
    }

    private static int[] buildClientOptions(int sessionHint) {
        int[] clientOptions = new int[10];
        clientOptions[1] = 2;
        clientOptions[2] = sessionHint;
        clientOptions[3] = 2;
        clientOptions[9] = 11;
        return clientOptions;
    }

    private static ITypedData buildArgumentsFromClientInfo(ClientInfo clientInfo) {
        DynamicallyTypedData data = new DynamicallyTypedData();
        DocbaseDateFormat df = new DocbaseDateFormat(clientInfo.getDatePattern(), clientInfo.getLocale());
        data.setInt("SDF_AN_custom_date_order", df.getCustomDateOrder());
        data.setInt("SDF_AN_custom_scan_fields", df.getCustomScanFields());
        data.setString("SDF_AN_date_separator", df.getDateSeparator());
        data.setInt("SDF_AN_date_order", df.getDateOrder());
        data.setBoolean("SDF_AN_day_leading_zero", df.getDayLeadingZero());
        data.setBoolean("SDF_AN_month_leading_zero", df.getMonthLeadingZero());
        data.setBoolean("SDF_AN_century", df.getFourDigitYear());
        data.setString("SDF_AN_time_separator", df.getTimeSeparator());
        data.setBoolean("SDF_AN_hours_24", df.getHours24());
        data.setBoolean("SDF_AN_hour_leading_zero", df.getHourLeadingZero());
        data.setBoolean("SDF_AN_noon_is_zero", df.getNoonIsZero());
        data.setString("SDF_AN_am", df.getAm());
        data.setString("SDF_AN_pm", df.getPm());
        data.setInt("UTC_OFFSET", clientInfo.getTimeZone().getOffset(System.currentTimeMillis()) / 1000);
        data.setInt("LANGUAGE", DocbaseLocaleUtility.getLocaleId(clientInfo.getLocale()));
        data.setInt("CHARACTER_SET", DocbaseCharSetUtility.getCharSetId("UTF-8"));
        data.setInt("PLATFORM_ENUM", DocbasePlatformUtility.getPlatformId());
        data.setString("PLATFORM_VERSION_IMAGE", System.getProperty("os.name"));
        if (clientInfo.getApplicationCodes().size() == 0) {
            data.appendString("APPLICATION_CODE", "");
        }
        for (String applicationCode : clientInfo.getApplicationCodes()) {
            data.appendString("APPLICATION_CODE", applicationCode);
        }
        return data;
    }

    private IObjectProtocol chooseObjectProtocol(int[] serverOptions) {
        int serializationVersion = serverOptions[7];
        boolean tzAware = true;
        if ((serverOptions[9] & 1) != 0) {
            tzAware = false;
        }
        DfLogger.info((Object)this, "Object protocol version {0}", new Object[]{serializationVersion}, null);
        if (serializationVersion == 2) {
            return new ObjectProtocolV1(this, this.m_typeManager, serializationVersion, tzAware);
        }
        return new ObjectProtocolV0(this, this.m_typeManager);
    }

    @Override
    public void authenticate(IDfLoginInfo loginInfo, ClientInfo clientInfo, boolean assumeUser, boolean checkOnly, boolean retry) throws DfException {
        block12: {
            IDfLoginInfo originalLoginInfo = this.m_loginInfo;
            ClientInfo originalClientInfo = this.m_clientInfo;
            if (!checkOnly) {
                this.setLoginInfo(loginInfo);
                this.m_clientInfo = clientInfo;
            }
            try {
                String password = this.getDocbasePassword(loginInfo);
                ITypedData localeArguments = assumeUser ? DocbaseConnection.buildArgumentsFromClientInfo(clientInfo) : null;
                String clientAuthData = RuntimeContext.getInstance().getIdentityManager().getIdentityBundle();
                Boolean trustedLoginDisabled = !DfPreferences.access().isTrustedLoginAllowed();
                String logonName = loginInfo.getUser();
                String ulLogonType = "";
                String ulSecurityInfo = "";
                if (DocbaseConnection.checkForUnifiedLogin(loginInfo)) {
                    this.initializeUnifiedLogin();
                    logonName = s_logonName;
                    ulLogonType = s_ulLogonType;
                    ulSecurityInfo = s_ulSecurityInfo;
                }
                try {
                    ITypedData connectionInfo = this.m_docbaseApi.authenticateUser(assumeUser, checkOnly, false, true, trustedLoginDisabled, localeArguments, s_logonName, s_logonDomain, logonName, password, ulLogonType, ulSecurityInfo, this.getExtraCredentials(loginInfo), clientAuthData);
                    this.m_timeOfLastAuthenticate = System.currentTimeMillis();
                    if (!checkOnly) {
                        this.m_connectionInfo = connectionInfo;
                        this.initializeDynamicGroups();
                        if (originalClientInfo != null && !((Object)originalClientInfo.getApplicationCodes()).equals(clientInfo.getApplicationCodes())) {
                            this.m_docbaseApi.setSessionParameters(DocbaseConnection.buildArgumentsFromClientInfo(clientInfo));
                        }
                    }
                }
                catch (DfIOException e) {
                    if (retry) {
                        if (checkOnly) {
                            this.m_docbaseApi.authenticateUser(assumeUser, checkOnly, false, true, trustedLoginDisabled, localeArguments, s_logonName, s_logonDomain, logonName, password, ulLogonType, ulSecurityInfo, this.getExtraCredentials(loginInfo), clientAuthData);
                            this.m_timeOfLastAuthenticate = System.currentTimeMillis();
                        } else {
                            this.reopen();
                        }
                        break block12;
                    }
                    throw e;
                }
            }
            catch (DfException e) {
                this.m_loginInfo = originalLoginInfo;
                this.m_clientInfo = originalClientInfo;
                throw e;
            }
            catch (RuntimeException e) {
                this.m_loginInfo = originalLoginInfo;
                this.m_clientInfo = originalClientInfo;
                throw e;
            }
        }
    }

    @Mask
    private String getDocbasePassword(IDfLoginInfo loginInfo) throws DfException {
        if (this.isKerberosAuthentication(loginInfo)) {
            return this.getKerberosPassword(loginInfo);
        }
        return this.getDecryptedPassword(loginInfo);
    }

    @Mask
    private String getDecryptedPassword(IDfLoginInfo loginInfo) throws DfException {
        try {
            return CryptoUtils.getInstance().decryptPassword(loginInfo.getPassword());
        }
        catch (SecurityException e) {
            throw new DfCriticalException("Unexpected internal security error");
        }
        catch (Throwable t) {
            throw DfAuthenticationException.newAuthFailException(this.getDocbaseSpec(), loginInfo.getUser());
        }
    }

    private String[] getExtraCredentials(IDfLoginInfo loginInfo) throws DfException {
        String applicationToken = loginInfo.getApplicationToken();
        if (applicationToken.length() == 0 && DocbaseConnection.isTokenStorageEnabled()) {
            applicationToken = TokenStorageManager.getApplicationToken(this.getDocbaseSpec().getDocbase());
        }
        String[] result = new String[]{loginInfo.getDomain(), loginInfo.getUserArg1(), DataConverter.convertToString(this.isSecure()), DfPreferences.getInstance().getMachineId(), applicationToken, loginInfo.getApplicationId()};
        return result;
    }

    private void initializeDynamicGroups() throws DfException {
        if (this.m_clientInfo.getAddedDynamicGroups().size() > 0 || this.m_clientInfo.getRemovedDynamicGroups().size() > 0) {
            this.m_docbaseApi.setDynamicGroups(this.m_clientInfo.getAddedDynamicGroups(), this.m_clientInfo.getRemovedDynamicGroups(), true, false);
        }
    }

    private synchronized void reopen() throws DfException {
        this.m_reconnectNeeded = false;
        this.close(false);
        this.open(this.m_loginInfo, this.m_clientInfo, 1000, false);
        ++this.m_reconnectCount;
    }

    @Override
    public synchronized ClientInfo getClientInfo() {
        return this.m_clientInfo;
    }

    @Override
    public synchronized void setClientInfo(ClientInfo newClientInfo, boolean validateDynamicGroups) throws DfException {
        ClientInfo oldClientInfo = this.m_clientInfo;
        this.m_clientInfo = newClientInfo;
        try {
            if (!oldClientInfo.getLocale().equals(newClientInfo.getLocale()) || !oldClientInfo.getDatePattern().equals(newClientInfo.getDatePattern())) {
                this.m_docbaseApi.setLocale(DocbaseConnection.buildArgumentsFromClientInfo(newClientInfo));
            }
            if (!((Object)oldClientInfo.getApplicationCodes()).equals(newClientInfo.getApplicationCodes())) {
                this.m_docbaseApi.setSessionParameters(DocbaseConnection.buildArgumentsFromClientInfo(newClientInfo));
            }
            if (!((Object)oldClientInfo.getAddedDynamicGroups()).equals(newClientInfo.getAddedDynamicGroups()) || !((Object)oldClientInfo.getRemovedDynamicGroups()).equals(newClientInfo.getRemovedDynamicGroups())) {
                this.m_docbaseApi.setDynamicGroups(newClientInfo.getAddedDynamicGroups(), newClientInfo.getRemovedDynamicGroups(), true, validateDynamicGroups);
            }
        }
        catch (DfIOException e) {
            this.reopen();
        }
    }

    @Override
    public void resendLocale() throws DfException {
        this.m_docbaseApi.setLocale(DocbaseConnection.buildArgumentsFromClientInfo(this.m_clientInfo));
    }

    @Override
    public void close() {
        this.close(true);
    }

    private synchronized void close(boolean sendCloseSessionRpc) {
        if (this.m_rpcClient.isOpen() && sendCloseSessionRpc) {
            try {
                this.m_rpcClient.closeSession(new DfId(this.getId()));
            }
            catch (DfIOException e) {
            }
            catch (DfException e) {
                DfLogger.warn((Object)this, "Failed to send closeSession RPC for session={0}", new Object[]{this.getId()}, (Throwable)e);
            }
        }
        this.m_rpcClient.close();
        if (this.m_contentConnection != null && this.m_contentConnection != this) {
            this.m_contentConnection.close();
        }
        this.m_contentConnection = null;
    }

    @Override
    public synchronized void quiesce() {
        if (this.m_readQueryThread != null) {
            this.cleanupFromUnexpectedReadQueryState();
        }
        if (this.m_transactionThread != null) {
            this.cleanupFromUnexpectedTransactionState();
        }
        this.m_rpcClient.quiesce();
        this.m_readQueryAcquireCount = 0;
    }

    @Override
    public synchronized int getNumberOfSends() {
        return this.m_rpcClient.getNumberOfSends();
    }

    @Override
    public synchronized int getNumberOfBytesSent() {
        return this.m_rpcClient.getNumberOfBytesSent();
    }

    @Override
    public synchronized int getNumberOfReceives() {
        return this.m_rpcClient.getNumberOfReceives();
    }

    @Override
    public synchronized int getNumberOfBytesReceived() {
        return this.m_rpcClient.getNumberOfBytesReceived();
    }

    @Override
    public synchronized boolean isSecure() {
        return this.m_rpcClient.isSecure();
    }

    @Override
    public synchronized boolean isLocalAddress() {
        return this.m_rpcClient.isLocalAddress();
    }

    @Override
    public synchronized boolean isDeadlockVictim() {
        return this.m_deadlockVictim;
    }

    @Override
    public synchronized IDocbaseConnection getContentConnection() throws DfException {
        if (this.m_contentConnection == null) {
            this.m_contentConnection = this.newContentConnectionOrThis();
        }
        return this.m_contentConnection;
    }

    private void cleanupFromUnexpectedReadQueryState() {
        DfLogger.error((Object)this, "Connection put back in pool with read query active, {0}", new Object[]{this.toString()}, null);
        this.m_readQueryThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFromUnexpectedTransactionState() {
        DfLogger.error((Object)this, "Connection put back in pool with transaction active, {0}", new Object[]{this.toString()}, null);
        try {
            this.m_docbaseApi.endTrans(false);
        }
        catch (DfException dfException) {
        }
        finally {
            this.m_transactionThread = null;
        }
    }

    private IDocbaseConnection newContentConnectionOrThis() throws DfException {
        if (this.m_forContent) {
            return this;
        }
        if (DocbaseConnection.shouldNeverUseContentServer()) {
            return this;
        }
        if (DocbaseConnection.isExplicitDocbaseSpec(this.m_requestedDocbaseSpec) && !DocbaseConnection.shouldAlwaysUseContentServer()) {
            return this;
        }
        try {
            DocbaseSpec simpleDocbaseSpec = new DocbaseSpec(this.m_requestedDocbaseSpec.getDocbase());
            return new DocbaseConnection(this.m_rpcClientFactory, simpleDocbaseSpec, this.m_loginInfo, this.m_clientInfo, true, this.m_currentServerChoice.getServerProximity());
        }
        catch (DfDocbaseUnreachableException e) {
            return this;
        }
    }

    private static boolean isExplicitDocbaseSpec(IDocbaseSpec docbaseSpec) {
        return docbaseSpec.getHost().length() > 0 || docbaseSpec.getServer().length() > 0;
    }

    @Override
    public synchronized int begin(int xid, boolean startScope) throws DfException {
        this.waitForCorrectSharingContext();
        assert (this.m_transactionThread == null || this.m_transactionThread == Thread.currentThread());
        if ((xid == -1 || xid == -3) && (this.txStack.contains(-1) || this.txStack.contains(-3))) {
            throw DfException.newTransactionActiveException();
        }
        if (xid == -1 || xid == -3) {
            this.m_docbaseApi.beginTrans(false, startScope);
        } else {
            xid = this.m_docbaseApi.beginTrans(false, xid, startScope);
        }
        assert (xid != 0);
        if (this.txStack.empty()) {
            this.m_transactionThread = Thread.currentThread();
            this.addUncaughtExceptionHandler(this.m_transactionThread);
        }
        this.txStack.push(xid);
        return xid;
    }

    private synchronized void waitForCorrectSharingContext() {
        long WAIT_INTERVAL = 10000L;
        while (this.m_transactionThread != null && this.m_transactionThread != Thread.currentThread() || this.m_readQueryThread != null && this.m_readQueryThread != Thread.currentThread()) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void addUncaughtExceptionHandler(Thread thread) {
        try {
            thread.setUncaughtExceptionHandler(new UncaughtExceptionHandler(thread.getUncaughtExceptionHandler()));
        }
        catch (AccessControlException e) {
            DfLogger.warn((Object)this, "DFC_SESSION_EXSETUP_FAILED", null, (Throwable)e);
        }
    }

    @Override
    public synchronized void commit(int xid) throws DfException {
        assert (this.m_transactionThread == Thread.currentThread());
        assert (this.txStack.peek() == xid);
        try {
            if (xid == -1 || xid == -3) {
                this.m_docbaseApi.endTrans(true);
            } else {
                this.m_docbaseApi.endTrans(true, xid);
            }
            this.txStack.pop();
        }
        catch (DfException e) {
            this.txStack.pop();
            DfLogger.info((Object)this, "DFC_SESSION_COMMIT_FAILED", new Object[]{this.m_transactionThread}, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            DfLogger.info((Object)this, "DFC_SESSION_COMMIT_FAILED", new Object[]{this.m_transactionThread}, (Throwable)e);
            throw e;
        }
        finally {
            if (this.txStack.empty()) {
                this.removeUncaughtExceptionHandler(Thread.currentThread());
                this.m_transactionThread = null;
                this.notifyAll();
            }
        }
    }

    private void removeUncaughtExceptionHandler(Thread thread) {
        try {
            Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
            if (handler instanceof UncaughtExceptionHandler) {
                thread.setUncaughtExceptionHandler(((UncaughtExceptionHandler)handler).getOldUncaughtExceptionHandler());
            }
        }
        catch (AccessControlException e) {
            DfLogger.warn((Object)this, "Failed to establish uncaught exception handler", null, (Throwable)e);
        }
    }

    @Override
    public synchronized void rollback(int xid) throws DfException {
        Throwable throwable;
        block11: {
            assert (this.m_transactionThread == Thread.currentThread());
            assert (this.txStack.contains(xid));
            boolean clear = true;
            try {
                if (!this.m_reconnectNeeded) {
                    if (xid == -1 || xid == -3) {
                        this.m_docbaseApi.endTrans(false);
                    }
                    this.m_docbaseApi.endTrans(false, xid);
                }
            }
            catch (RuntimeException e) {
                clear = false;
                throw e;
            }
            finally {
                if (!clear) break block11;
            }
            while (this.txStack.pop() != xid) {
            }
            if (this.txStack.empty()) {
                this.removeUncaughtExceptionHandler(Thread.currentThread());
                this.m_transactionThread = null;
                this.notifyAll();
            }
        }
        throw throwable;
    }

    @Override
    public synchronized void openBatch(ITypedData arguments, boolean startScope) throws DfException {
        this.waitForCorrectSharingContext();
        assert (this.m_transactionThread == null || this.m_transactionThread == Thread.currentThread());
        if (this.txStack.contains(-2)) {
            throw new DfException("DFC_BATCHMANAGER_BATCH_IN_PROGRESS");
        }
        arguments.setInt("OP_CODE", 0);
        arguments.setBoolean("START_SCOPE", startScope);
        this.apply("BATCH_OPERATION", null, arguments, true, true, true);
        if (this.txStack.empty()) {
            this.m_transactionThread = Thread.currentThread();
            this.addUncaughtExceptionHandler(this.m_transactionThread);
        }
        this.txStack.push(-2);
    }

    @Override
    public synchronized void flushBatch() throws DfException {
        assert (this.m_transactionThread == Thread.currentThread());
        assert (this.txStack.peek() == -2);
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("OP_CODE", 1);
        this.apply("BATCH_OPERATION", null, arguments, true, true, true);
    }

    @Override
    public synchronized void commitBatch() throws DfException {
        assert (this.m_transactionThread == Thread.currentThread());
        assert (this.txStack.peek() == -2);
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("OP_CODE", 2);
        try {
            this.apply("BATCH_OPERATION", null, arguments, true, true, true);
        }
        catch (DfException e) {
            DfLogger.info((Object)this, "DFC_SESSION_COMMIT_FAILED", new Object[]{this.m_transactionThread}, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            DfLogger.info((Object)this, "DFC_SESSION_COMMIT_FAILED", new Object[]{this.m_transactionThread}, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void abortBatch() throws DfException {
        Throwable throwable;
        block9: {
            assert (this.m_transactionThread == Thread.currentThread());
            assert (this.txStack.contains(-2));
            boolean clear = true;
            try {
                DynamicallyTypedData arguments = new DynamicallyTypedData();
                arguments.setInt("OP_CODE", 3);
                this.apply("BATCH_OPERATION", null, arguments, true, true, true);
            }
            catch (RuntimeException e) {
                clear = false;
                throw e;
            }
            finally {
                if (!clear) break block9;
            }
            while (this.txStack.pop() != -2) {
            }
            if (this.txStack.empty()) {
                this.removeUncaughtExceptionHandler(Thread.currentThread());
                this.m_transactionThread = null;
                this.notifyAll();
            }
        }
        throw throwable;
    }

    @Override
    public synchronized void closeBatch() throws DfException {
        assert (this.m_transactionThread == Thread.currentThread());
        assert (this.txStack.peek() == -2);
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setInt("OP_CODE", 4);
        try {
            this.apply("BATCH_OPERATION", null, arguments, true, true, true);
            this.txStack.pop();
            if (this.txStack.empty()) {
                this.removeUncaughtExceptionHandler(Thread.currentThread());
                this.m_transactionThread = null;
                this.notifyAll();
            }
        }
        catch (DfException e) {
            DfLogger.info((Object)this, "DFC_SESSION_COMMIT_FAILED", new Object[]{this.m_transactionThread}, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized boolean isTransactionActive() {
        return this.m_transactionThread == Thread.currentThread();
    }

    @Override
    public synchronized boolean isTransactionActiveForAnyThread() {
        return this.m_transactionThread != null;
    }

    private synchronized void acquireReadQueryLock() {
        this.waitForCorrectSharingContext();
        ++this.m_readQueryAcquireCount;
        this.m_readQueryThread = Thread.currentThread();
    }

    private synchronized void releaseReadQueryLock() {
        this.waitForCorrectSharingContext();
        assert (this.m_readQueryThread == Thread.currentThread());
        assert (this.m_readQueryAcquireCount >= 1);
        if (--this.m_readQueryAcquireCount == 0) {
            this.m_readQueryThread = null;
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized Object evaluateRpc(Functor rpcFunctor, boolean retry) throws DfException {
        this.waitForCorrectSharingContext();
        numberOfIOErrors = 0;
        block9: while (true) lbl-1000:
        // 3 sources

        {
            if (this.m_reconnectNeeded) {
                if (this.isTransactionActive()) {
                    throw DfException.newTransactionLostException();
                }
                this.reopen();
            }
            numberOfDeadlockRetries = 0;
            while (true) {
                this.m_deadlockVictim = false;
                if (this.m_numberOfErrorsToGenerate > 0) {
                    --this.m_numberOfErrorsToGenerate;
                    throw DfIOException.newCommunicationFailureException(new IOException("Phoney I/O error generated for testing purposes"));
                }
                try {
                    var5_9 = rpcFunctor.evaluate();
                    if (numberOfDeadlockRetries > 0) {
                        this.addMessage(0, "DM_SESSION_I_DEADLOCK_RETRY", null);
                    }
                    return var5_9;
                }
                catch (Throwable var6_10) {
                    try {
                        try {
                            if (numberOfDeadlockRetries > 0) {
                                this.addMessage(0, "DM_SESSION_I_DEADLOCK_RETRY", null);
                            }
                            throw var6_10;
                        }
                        catch (DfDeadlockException e) {
                            this.m_deadlockVictim = true;
                            if (!this.isTransactionActive() && retry && numberOfDeadlockRetries < DfPreferences.getInstance().getSessionMaxDeadlockRetries()) {
                                ++numberOfDeadlockRetries;
                                continue;
                            }
                            throw e;
                        }
                    }
                    catch (DfIOException e) {
                        this.m_reconnectNeeded = true;
                        if (!this.isTransactionActive() && retry && ++numberOfIOErrors <= DocbaseConnection.getMaximumErrorRetries()) ** GOTO lbl-1000
                        throw e;
                    }
                    catch (UnsupportedOperationException e) {
                        this.m_reconnectNeeded = true;
                        if (!this.isTransactionActive() && retry && ++numberOfIOErrors <= DocbaseConnection.getMaximumErrorRetries()) continue block9;
                        throw e;
                    }
                }
                break;
            }
            break;
        }
    }

    @Override
    public void apply(String methodName, IDfId id, ITypedData arguments, boolean throwErrors, boolean flushOldMessages, boolean retry) throws DfException {
        if (!this.applyForBool(methodName, id, arguments, throwErrors, flushOldMessages, retry)) {
            DfException exception = this.getException();
            if (exception != null) {
                throw exception;
            }
            throw new UnknownServerResponseException(methodName, id, arguments);
        }
    }

    @Override
    public synchronized boolean applyForBool(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (Boolean)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.applyForBool(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
            }
        }, retry);
    }

    private ITypedData addProtectedRolesIfNecessary(ITypedData arguments) {
        if (arguments == null) {
            arguments = new DynamicallyTypedData();
        }
        assert (arguments instanceof DynamicallyTypedData);
        Collection<RoleRequest> requests = RoleRequestManager.getInstance().getRoleRequests();
        if (requests.size() > 0) {
            String thisDocbaseName = this.getDocbaseSpec().getDocbase();
            for (RoleRequest request : requests) {
                String requestDocbaseName = request.getRoleSpec().getDocbaseName();
                if (requestDocbaseName != null && !requestDocbaseName.equals(thisDocbaseName)) continue;
                request.check(thisDocbaseName);
                arguments.appendString("__REQUESTED_PROTECTED_ROLES", request.getRoleSpec().getRoleName());
            }
        }
        return arguments;
    }

    @Override
    public byte[] applyForByteArray(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (byte[])this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.applyForByteArray(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
            }
        }, retry);
    }

    @Override
    public ITypedDataIterator applyForCollection(final String methodName, final IDfId objectId, ITypedData arguments, final int batchHint, final boolean throwErrors, boolean flushOldMessages, boolean retry, final boolean acquireReadQueryLock) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (ITypedDataIterator)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                IteratorSynchronizer result = null;
                if (acquireReadQueryLock) {
                    DocbaseConnection.this.acquireReadQueryLock();
                }
                try {
                    DocbaseConnection docbaseConnection = DocbaseConnection.this;
                    synchronized (docbaseConnection) {
                        ITypedDataIterator rawIterator = DocbaseConnection.this.m_rpcClient.applyForCollection(methodName, objectId, augmentedArguments, batchHint, throwErrors, true);
                        IteratorSynchronizer iteratorSynchronizer = result = new IteratorSynchronizer(rawIterator, acquireReadQueryLock);
                        return iteratorSynchronizer;
                    }
                }
                finally {
                    if (acquireReadQueryLock && result == null) {
                        DocbaseConnection.this.releaseReadQueryLock();
                    }
                }
            }
        }, retry);
    }

    @Override
    public double applyForDouble(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (Double)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.applyForDouble(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
            }
        }, retry);
    }

    @Override
    public IDfId applyForId(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (IDfId)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.applyForId(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
            }
        }, retry);
    }

    @Override
    public int applyForInt(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (Integer)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.applyForInt(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
            }
        }, retry);
    }

    @Override
    public long applyForLong(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (Long)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.applyForLong(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
            }
        }, retry);
    }

    @Override
    public ITypedData applyForObject(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (ITypedData)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                ITypedData data;
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    data = DocbaseConnection.this.m_rpcClient.applyForObject(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
                data.setFetchTimestamp(System.currentTimeMillis());
                return data;
            }
        }, retry);
    }

    @Override
    public String applyForString(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (String)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.applyForString(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
            }
        }, retry);
    }

    @Override
    public IDfTime applyForTime(final String methodName, final IDfId objectId, ITypedData arguments, final boolean throwErrors, final boolean flushOldMessages, boolean retry) throws DfException {
        final ITypedData augmentedArguments = this.addProtectedRolesIfNecessary(arguments);
        return (IDfTime)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.applyForTime(methodName, objectId, augmentedArguments, throwErrors, flushOldMessages);
                }
            }
        }, retry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILiteType fetchType(final String typeName, boolean retry) throws DfException {
        int vStamp;
        DocbaseConnection docbaseConnection = this;
        synchronized (docbaseConnection) {
            vStamp = this.m_typeManager.getCacheVStamp();
        }
        return (ILiteType)this.evaluateRpc(new Functor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object evaluate() throws DfException {
                DocbaseConnection docbaseConnection = DocbaseConnection.this;
                synchronized (docbaseConnection) {
                    return DocbaseConnection.this.m_rpcClient.fetchType(typeName, vStamp);
                }
            }
        }, retry);
    }

    public RawPuller makePuller(IDfId storeId, IDfId contentId, IDfId sysobjId, IDfId formatId, int storeTicket, boolean isOffline, boolean isOther, boolean compression, boolean noAccessUpdate) throws DfException {
        return new RawPuller(this, storeId, contentId, sysobjId, formatId, storeTicket, isOffline, isOther, compression, noAccessUpdate);
    }

    @Override
    public synchronized byte[] getBlock(int pullerHandle, int blockNumber, BooleanHolder isLastBlockHolder) throws DfException {
        this.waitForCorrectSharingContext();
        return this.m_rpcClient.getBlock(pullerHandle, blockNumber, isLastBlockHolder);
    }

    @Override
    public synchronized long doPush(int pusherHandle, InputStream inputStream) throws DfException {
        this.waitForCorrectSharingContext();
        return this.m_rpcClient.doPush(pusherHandle, inputStream);
    }

    @Override
    public synchronized String getMessage(int severity) {
        return this.m_messageManager.getMessage(severity);
    }

    @Override
    public synchronized DfException getExceptionForAllMessages(int severity) {
        return this.m_messageManager.getExceptionForAllMessages(severity);
    }

    @Override
    public synchronized DfException getException() {
        return this.m_messageManager.getException();
    }

    @Override
    public synchronized void flushMessages() {
        this.m_messageManager.flushMessages();
    }

    @Override
    public synchronized void addMessage(int severity, String message, Object[] arguments) {
        this.m_messageManager.addMessage(severity, message, arguments);
    }

    @Override
    public synchronized List<MessageEntry> saveMessageEntries() {
        return this.m_messageManager.saveMessageEntries();
    }

    @Override
    public synchronized void restoreMessageEntries(List<MessageEntry> entries) {
        this.m_messageManager.restoreMessageEntries(entries);
    }

    @Override
    public synchronized String getId() {
        return this.m_externalId;
    }

    @Override
    public IDocbaseConnectionManager getConnectionManager() {
        return this.m_connectionManager;
    }

    @Override
    public void setConnectionManager(IDocbaseConnectionManager connectionManager) {
        this.m_connectionManager = connectionManager;
    }

    @Override
    public synchronized int getReconnectCount() {
        return this.m_reconnectCount;
    }

    @Override
    public synchronized IDocbaseSpec getDocbaseSpec() {
        if (this.m_currentServerChoice != null) {
            return this.m_currentServerChoice.getDocbaseSpec();
        }
        return this.m_requestedDocbaseSpec;
    }

    @Override
    public synchronized IDfLoginInfo getLoginInfo() {
        return this.m_loginInfo;
    }

    @Override
    public synchronized void setLoginInfo(IDfLoginInfo loginInfo) {
        if (this.isKerberosAuthentication(loginInfo = new DfLoginInfo(loginInfo))) {
            loginInfo.setUser(DocbaseConnection.getKerberosUsername(loginInfo));
        }
        this.m_loginInfo = loginInfo;
    }

    @Override
    public synchronized ITypedData getConnectionInfo() {
        return this.m_connectionInfo;
    }

    @Override
    public synchronized ServerInfo getServerInfo() {
        return this.m_serverInfo;
    }

    @Override
    public DocbaseApi getDocbaseApi() {
        return this.m_docbaseApi;
    }

    @Override
    public synchronized ILiteType getLiteType(String typeName) throws DfException {
        return this.m_typeManager.getType(typeName, this);
    }

    @Override
    public synchronized ILiteType getLiteType(String typeName, List<String> aspectlist) throws DfException {
        return this.m_typeManager.getType(typeName, aspectlist, this);
    }

    @Override
    public synchronized void setNumberOfErrorsToGenerate(int numberOfErrors) {
        this.m_numberOfErrorsToGenerate = numberOfErrors;
    }

    @Override
    public void setUserIdentifyingObject(IUserIdentifyingObject userIdentifyingObject) {
        this.m_userIdentifyingObject = userIdentifyingObject;
    }

    @Override
    public String[] getUsersForTracing() {
        return this.m_userIdentifyingObject != null ? this.m_userIdentifyingObject.getUsersForTracing() : null;
    }

    @Override
    public IUserTracingInfo getUserTracingInfo(String userArgIgnored) {
        return this.m_userIdentifyingObject != null ? this.m_userIdentifyingObject.getUserTracingInfo(userArgIgnored) : null;
    }

    @Override
    public boolean isRestricted() {
        return this.m_connectionInfo.getInt(AUTH_LEVEL) == AuthenticationLevel.ALChangePassword.getAuthLevel();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Connection{");
        b.append("id=").append(this.m_internalId);
        b.append(", docbase=").append(this.m_requestedDocbaseSpec.getDocbase());
        b.append(", user=").append(this.m_loginInfo.getUser());
        b.append("}");
        return b.toString();
    }

    private static synchronized int getMaximumErrorRetries() {
        return s_maximumErrorRetries;
    }

    private static synchronized void setMaximumErrorRetries(int maximumErrorRetries) {
        s_maximumErrorRetries = maximumErrorRetries;
    }

    private static synchronized int getMaximumOpenRetries() {
        return s_maximumOpenRetries;
    }

    private static synchronized void setMaximumOpenRetries(int maximumOpenRetries) {
        s_maximumOpenRetries = maximumOpenRetries;
    }

    private static synchronized boolean isTokenStorageEnabled() {
        return s_tokenStorageEnabled;
    }

    private static synchronized void setTokenStorageEnabled(boolean tokenStorageEnabled) {
        s_tokenStorageEnabled = tokenStorageEnabled;
    }

    private static synchronized boolean shouldNeverUseContentServer() {
        return s_neverUseContentServer;
    }

    private static synchronized void setNeverUseContentServer(boolean neverUseContentServer) {
        s_neverUseContentServer = neverUseContentServer;
    }

    private static synchronized boolean shouldAlwaysUseContentServer() {
        return s_alwaysUseContentServer;
    }

    private static synchronized void setAlwaysUseContentServer(boolean alwaysUseContentServer) {
        s_alwaysUseContentServer = alwaysUseContentServer;
    }

    private static boolean checkForUnifiedLogin(IDfLoginInfo loginInfo) throws DfException {
        boolean isUnifiedLogin = false;
        String logonName = loginInfo.getUser();
        if (logonName == null || logonName.equals("")) {
            if (UnifiedLoginHelper.isULSupportedByClient()) {
                isUnifiedLogin = true;
            } else {
                throw new DfException("DFC_UNIFIED_LOGON_NO_CLIENT_SUPPORT");
            }
        }
        return isUnifiedLogin;
    }

    private void initializeUnifiedLogin() throws DfException {
        s_ulLogonType = "dm_Unified_Logon";
        s_ulSecurityInfo = UnifiedLoginHelper.getULUserSid();
        if (s_ulSecurityInfo == null) {
            throw new DfException("DFC_UNIFIED_LOGON_SETUP_FAIL");
        }
    }

    private boolean isKerberosAuthentication(IDfLoginInfo loginInfo) {
        return loginInfo.getBinaryCredential() instanceof GSSCredential;
    }

    private static String getKerberosUsername(IDfLoginInfo loginInfo) {
        try {
            GSSCredential credential = (GSSCredential)loginInfo.getBinaryCredential();
            String name = ((Object)credential.getName()).toString();
            int separatorIndex = name.indexOf(DOMAIN_SEPARATOR);
            return separatorIndex != -1 ? name.substring(0, separatorIndex) : name;
        }
        catch (GSSException e) {
            throw new DfRuntimeException("DFC_UNEXPECTED_GSS_EXCEPTION", e);
        }
    }

    private String getKerberosPassword(IDfLoginInfo loginInfo) throws DfException {
        try {
            GSSCredential credential = (GSSCredential)loginInfo.getBinaryCredential();
            String name = ((Object)credential.getName()).toString();
            int separatorIndex = name.indexOf(DOMAIN_SEPARATOR);
            String domain = separatorIndex != -1 ? name.substring(separatorIndex + 1) : "";
            String docbaseSPN = DocbaseConnection.buildKerberosSPN(this.getDocbaseSpec(), domain);
            return this.buildKerberosPassword(credential, docbaseSPN);
        }
        catch (GSSException e) {
            throw new DfRuntimeException("DFC_UNEXPECTED_GSS_EXCEPTION", e);
        }
    }

    private static String buildKerberosSPN(IDocbaseSpec docbaseSpec, String domainName) throws DfException {
        StringBuffer csSPN = new StringBuffer();
        csSPN.append(CONTENT_SERVER_PROTOCOL);
        csSPN.append(PROTOCOL_SEPARATOR);
        csSPN.append(docbaseSpec.getDocbase());
        if (!domainName.equals("")) {
            csSPN.append(DOMAIN_SEPARATOR);
            csSPN.append(domainName);
        }
        return csSPN.toString();
    }

    @Mask
    private String buildKerberosPassword(GSSCredential credential, String spnName) throws DfException {
        try {
            String targetST = KerberosUtility.delegate((String)spnName, (GSSCredential)credential);
            return DocbaseConnection.buildPluginPassword("dm_krb", targetST);
        }
        catch (GSSException e) {
            throw new DfException("DFC_UNEXPECTED_KRB_UTIL_EXCEPTION", (Throwable)e);
        }
    }

    @Mask
    private static String buildPluginPassword(String pluginName, @Mask String password) {
        StringBuilder pluginPassword = new StringBuilder();
        pluginPassword.append("DM_PLUGIN=");
        pluginPassword.append(pluginName);
        pluginPassword.append(PROTOCOL_SEPARATOR);
        pluginPassword.append(password);
        return pluginPassword.toString();
    }

    @Override
    public int getReuseCount() {
        return this.m_reuseCount;
    }

    @Override
    public void incrementReuseCount() {
        ++this.m_reuseCount;
    }

    @Override
    public synchronized Docbase getDocbase() throws DfException {
        if (this.m_docbase == null) {
            this.m_docbase = Docbase.getInstance(this, this.getServer());
        }
        return this.m_docbase;
    }

    @Override
    public synchronized Server getServer() throws DfException {
        if (this.m_server == null) {
            this.m_server = Server.getInstance(this);
        }
        return this.m_server;
    }

    @Override
    public synchronized void flushServer() throws DfException {
        if (this.m_server != null) {
            Server.flush(this.m_server.getConfigId());
            this.m_server = null;
        }
    }

    @Override
    public long getTimeOfLastAuthenticate() {
        return this.m_timeOfLastAuthenticate;
    }

    @Override
    public int getServerProximity() {
        return this.m_currentServerChoice != null ? this.m_currentServerChoice.getProximity() : -1;
    }

    static {
        s_nextInternalId = 0L;
        s_ulLogonType = "";
        s_ulSecurityInfo = "";
        new PreferencesObserver();
        DfException.registerResourceBundle(DocbaseMessages.getResourceBundle());
        try {
            s_logonName = AccessController.doPrivileged(new GetPropertyAction("user.name"));
            s_logonDomain = AccessController.doPrivileged(new GetenvAction("USERDOMAIN"));
        }
        catch (AccessControlException e) {
            DfLogger.error(DocbaseConnection.class, "Failed to learn user name and domain", null, (Throwable)e);
        }
    }

    private class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler m_oldHandler;

        UncaughtExceptionHandler(Thread.UncaughtExceptionHandler oldHandler) {
            this.m_oldHandler = oldHandler;
        }

        public void uncaughtException(Thread t, Throwable e) {
            if (DocbaseConnection.this.isTransactionActive()) {
                try {
                    DfLogger.error((Object)this, "Thread died with transaction active", null, e);
                    DocbaseConnection.this.rollback(this.getActiveXid());
                }
                catch (DfException e1) {
                    DfLogger.warn((Object)this, "Failed to rollback transaction for dead thread", null, (Throwable)e1);
                }
            }
            if (this.m_oldHandler != null) {
                this.m_oldHandler.uncaughtException(t, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer getActiveXid() {
            DocbaseConnection docbaseConnection = DocbaseConnection.this;
            synchronized (docbaseConnection) {
                return (Integer)DocbaseConnection.this.txStack.get(0);
            }
        }

        public Thread.UncaughtExceptionHandler getOldUncaughtExceptionHandler() {
            return this.m_oldHandler;
        }
    }

    private class IteratorSynchronizer
    implements IBatchedTypedDataIterator {
        private final ITypedDataIterator m_delegate;
        private boolean m_releaseReadQueryLock;

        IteratorSynchronizer(ITypedDataIterator delegate, boolean releaseReadQueryLock) {
            this.m_delegate = delegate;
            this.m_releaseReadQueryLock = releaseReadQueryLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() throws DfException {
            DocbaseConnection docbaseConnection = DocbaseConnection.this;
            synchronized (docbaseConnection) {
                return this.m_delegate.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ITypedData next() throws DfException, NoSuchElementException {
            DocbaseConnection docbaseConnection = DocbaseConnection.this;
            synchronized (docbaseConnection) {
                return this.m_delegate.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws DfException {
            DocbaseConnection docbaseConnection = DocbaseConnection.this;
            synchronized (docbaseConnection) {
                if (this.m_releaseReadQueryLock) {
                    DocbaseConnection.this.releaseReadQueryLock();
                }
                this.m_releaseReadQueryLock = false;
                this.m_delegate.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ILiteType getType() {
            DocbaseConnection docbaseConnection = DocbaseConnection.this;
            synchronized (docbaseConnection) {
                return this.m_delegate.getType();
            }
        }

        public boolean isValid() {
            return this.m_delegate.isValid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ITypedData[] getBatch() throws DfException {
            DocbaseConnection docbaseConnection = DocbaseConnection.this;
            synchronized (docbaseConnection) {
                if (this.m_delegate instanceof IBatchedTypedDataIterator) {
                    return ((IBatchedTypedDataIterator)this.m_delegate).getBatch();
                }
                return new TypedData[0];
            }
        }
    }

    private static class PreferencesObserver
    implements IPreferencesObserver {
        public PreferencesObserver() {
            DfPreferences.getInstance().addObserver(this);
            this.update(DfPreferences.getInstance(), null);
        }

        public void update(TypedPreferences typedPreferences, String preferenceName) {
            DfPreferences preferences = (DfPreferences)typedPreferences;
            DocbaseConnection.setMaximumErrorRetries(preferences.getSessionMaxErrorRetries());
            DocbaseConnection.setMaximumOpenRetries(preferences.getSessionMaxOpenRetries());
            DocbaseConnection.setTokenStorageEnabled(preferences.isTokenStorageEnabled());
            DocbaseConnection.setNeverUseContentServer(!preferences.getUseContentServer());
            DocbaseConnection.setAlwaysUseContentServer(!preferences.isUseContentServerDefaulted() && preferences.getUseContentServer());
        }
    }
}

