/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.content.impl;

import com.documentum.fc.client.content.impl.IPuller;
import com.documentum.fc.client.content.impl.ISeekable;
import com.documentum.fc.common.DfException;
import java.io.IOException;
import java.io.InputStream;

final class PullerInputStream
extends InputStream
implements ISeekable {
    private IPuller m_puller;
    private byte[] m_buffer;
    private int m_bufferLength;
    private int m_bufferCursor;

    PullerInputStream(IPuller puller) {
        this.m_puller = puller;
        this.m_buffer = null;
        this.m_bufferLength = 0;
        this.m_bufferCursor = 0;
    }

    public int available() throws IOException {
        this.verifyOpen();
        this.ensureBufferHasData();
        return this.bytesRemainingInBuffer();
    }

    private void verifyOpen() {
        if (this.m_puller == null) {
            throw new IllegalStateException("closed");
        }
    }

    private int bytesRemainingInBuffer() {
        return this.m_bufferLength - this.m_bufferCursor;
    }

    private void tossBufferedBytes() {
        this.m_bufferCursor = this.m_bufferLength;
    }

    public int read() throws IOException {
        this.verifyOpen();
        if (!this.ensureBufferHasData()) {
            return -1;
        }
        return this.m_buffer[this.m_bufferCursor++] & 0xFF;
    }

    private boolean ensureBufferHasData() throws IOException {
        if (this.bytesRemainingInBuffer() > 0) {
            return true;
        }
        this.getNextBuffer();
        return this.bytesRemainingInBuffer() > 0;
    }

    private void getNextBuffer() throws IOException {
        if (this.m_puller.hasNext()) {
            try {
                this.m_buffer = this.m_puller.nextBlock();
                this.m_bufferLength = this.m_buffer.length;
                this.m_bufferCursor = 0;
            }
            catch (DfException e) {
                throw PullerInputStream.convertToIOException(e);
            }
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        this.verifyOpen();
        int bytesNeeded = length;
        while (bytesNeeded > 0 && this.ensureBufferHasData()) {
            int segmentLength = Math.min(this.bytesRemainingInBuffer(), bytesNeeded);
            System.arraycopy(this.m_buffer, this.m_bufferCursor, buffer, offset, segmentLength);
            bytesNeeded -= segmentLength;
            offset += segmentLength;
            this.m_bufferCursor += segmentLength;
        }
        int byteRead = length - bytesNeeded;
        if (byteRead == 0 && length != 0) {
            byteRead = -1;
        }
        return byteRead;
    }

    public void close() throws IOException {
        this.verifyOpen();
        try {
            this.m_puller.close();
        }
        catch (DfException e) {
            throw PullerInputStream.convertToIOException(e);
        }
    }

    public boolean isSeekable() throws DfException {
        return this.m_puller.isSeekable();
    }

    public long seek(long offset, int root) throws DfException {
        long result = this.m_puller.seek(offset, root);
        this.tossBufferedBytes();
        return result;
    }

    private static IOException convertToIOException(DfException e) {
        IOException ioe = new IOException(e.getMessage());
        ioe.initCause(e);
        return ioe;
    }
}

