/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.content.impl;

import com.documentum.fc.client.content.impl.ContentInputStream;
import com.documentum.fc.client.content.impl.DfContentException;
import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.ITypedDataIterator;
import com.documentum.fc.client.impl.typeddata.LiteType;
import com.documentum.fc.client.impl.typeddata.TypedData;
import com.documentum.fc.common.DfException;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ContentIterator
implements ITypedDataIterator {
    static final int EOF = -1;
    static final int INIT = -2;
    private boolean m_isClosed;
    private final ContentInputStream m_stream;
    private byte[] m_currentBuffer;
    private byte[] m_readahead;
    private int m_readaheadBytes;
    private int m_currentLength;
    private long m_fullContentSize;
    private long m_bytePosition;
    private long m_nextBytePosition;
    private static int MAXIMUM_BUFFER_SIZE;
    private static final ILiteType s_type;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;

    ContentIterator(ContentInputStream stream, long fullContentSize) throws DfException {
        ContentInputStream contentInputStream = stream;
        long l = fullContentSize;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)contentInputStream, (Object)Conversions.longObject((long)l));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_readaheadBytes = -2;
            this.m_stream = stream;
            this.setIsClosed(false);
            this.setCurrentLength(0);
            this.setBytePosition(0L);
            this.setNextBytePosition(0L);
            this.setFullContentSize(fullContentSize);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)contentInputStream, (Object)Conversions.longObject((long)l));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)contentInputStream, (Object)Conversions.longObject((long)l));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean hasNext() throws DfException {
        if (this.isClosed()) {
            throw new IllegalStateException("call to next on closed collection not supported.");
        }
        if (this.m_readaheadBytes > 0) {
            return true;
        }
        if (this.m_readaheadBytes == -1) {
            return false;
        }
        try {
            this.m_readaheadBytes = -1;
            this.m_readahead = new byte[this.determineNextBufferSize()];
            this.m_readaheadBytes = this.m_stream.read(this.m_readahead);
        }
        catch (IOException e) {
            throw DfException.convert(e);
        }
        return this.m_readaheadBytes > 0;
    }

    public ITypedData next() throws DfException, NoSuchElementException {
        if (this.hasNext()) {
            this.fillNextBuffer();
            return this.getResultRow();
        }
        throw new NoSuchElementException();
    }

    public void close() throws DfException {
        try {
            this.m_stream.close();
            this.setIsClosed(true);
        }
        catch (IOException e) {
            throw DfException.convert(e);
        }
    }

    public ILiteType getType() {
        return s_type;
    }

    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    void seekEx(long l, int n) throws DfException {
        long l2 = l;
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            void root;
            void offset;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.setNextBytePosition(this.m_stream.seek((long)offset, (int)root));
            Object var8_6 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var8_6, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    String getContentBufferString() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.getCurrentBuffer() == null || this.isClosed()) {
                throw new IllegalStateException("_content_buffer is unavailable.");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.getCurrentBuffer());
            InputStreamReader r = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            try {
                int bytesThisTime;
                char[] buf = new char[this.getCurrentLength() + 100];
                while ((bytesThisTime = r.read(buf)) >= 0) {
                    sb.append(buf, 0, bytesThisTime);
                }
            }
            catch (IOException ioe) {
                throw DfContentException.newCantConvertContentToAStringException();
            }
            String string3 = string2 = (string = sb.toString());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    ByteArrayInputStream getBytesBuffer() {
        JoinPoint joinPoint = null;
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.getCurrentBuffer() == null || this.isClosed()) {
                throw new IllegalStateException("_content_buffer is unavailable.");
            }
            ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream2 = (byteArrayInputStream = new ByteArrayInputStream(this.m_currentBuffer, 0, this.m_currentLength));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(byteArrayInputStream2, joinPoint);
            }
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    boolean isSeekable() throws DfException {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.isClosed()) {
                throw new IllegalStateException("_content_buffer is unavailable.");
            }
            boolean bl3 = bl2 = (bl = this.m_stream.isSeekable());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private boolean fillNextBuffer() throws DfException {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (this.m_readaheadBytes > 0);
            this.m_currentBuffer = this.m_readahead;
            this.updateRowData(this.m_readaheadBytes);
            this.m_readahead = null;
            this.m_readaheadBytes = -2;
            boolean bl2 = this.m_currentLength > 0;
            boolean bl3 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateRowData(int n) throws DfException {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            void bytesReadThisTime;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.setCurrentLength((int)bytesReadThisTime);
            this.setBytePosition(this.getNextBytePosition());
            this.setNextBytePosition(this.getBytePosition() + (long)bytesReadThisTime);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private int determineNextBufferSize() throws IOException {
        JoinPoint joinPoint = null;
        try {
            int n;
            int available;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n3 = n2 = (available = this.m_stream.available()) == 0 ? (n = MAXIMUM_BUFFER_SIZE) : (n = Math.min(available, MAXIMUM_BUFFER_SIZE));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setIsClosed(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            void v;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_isClosed = v;
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setBytePosition(long l) {
        long l2 = l;
        JoinPoint joinPoint = null;
        try {
            void position;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_bytePosition = position;
            Object var6_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var6_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setFullContentSize(long l) {
        long l2 = l;
        JoinPoint joinPoint = null;
        try {
            void v;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_fullContentSize = v;
            Object var6_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var6_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setNextBytePosition(long l) {
        long l2 = l;
        JoinPoint joinPoint = null;
        try {
            void v;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_nextBytePosition = v;
            if (v > this.m_fullContentSize) {
                this.m_fullContentSize = v;
            }
            Object var6_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var6_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setCurrentLength(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            void v;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_currentLength = v;
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private boolean isClosed() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_isClosed);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private int getCurrentLength() {
        JoinPoint joinPoint = null;
        try {
            int n;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n3 = n2 = (n = this.m_currentLength);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private long getContentSize() {
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long l3 = l2 = (l = this.m_fullContentSize);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private long getBytePosition() {
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long l3 = l2 = (l = this.m_bytePosition);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private long getNextBytePosition() {
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long l3 = l2 = (l = this.m_nextBytePosition);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private byte[] getCurrentBuffer() {
        JoinPoint joinPoint = null;
        try {
            byte[] byArray;
            byte[] byArray2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            byte[] byArray3 = byArray2 = (byArray = this.m_currentBuffer);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(byArray2, joinPoint);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private int getCurrentBufferLength() {
        JoinPoint joinPoint = null;
        try {
            int n;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n2 = this.m_currentBuffer == null ? 0 : this.m_currentBuffer.length;
            int n3 = n = n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private ITypedData getResultRow() throws DfException {
        JoinPoint joinPoint = null;
        try {
            TypedData typedData;
            TypedData typedData2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            TypedData r = new TypedData(s_type);
            r.setInt("buffer", 0);
            r.setInt("buffer_size", this.getCurrentBufferLength());
            r.setInt("current_length", this.getCurrentLength());
            r.setInt("content_size", (int)this.getContentSize());
            r.setLong("full_content_size", this.getContentSize());
            r.setBoolean("_seekable", this.isSeekable());
            r.setInt("_byte_position", (int)this.getBytePosition());
            r.setLong("_full_byte_position", this.getBytePosition());
            TypedData typedData3 = typedData2 = (typedData = r);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(typedData2, joinPoint);
            }
            return typedData;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ContentIterator.java", Class.forName("com.documentum.fc.client.content.impl.ContentIterator"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "seekEx", "com.documentum.fc.client.content.impl.ContentIterator", "long:int:", "offset:root:", "com.documentum.fc.common.DfException:", "void"), 90);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getContentBufferString", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 98);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setNextBytePosition", "com.documentum.fc.client.content.impl.ContentIterator", "long:", "v:", "", "void"), 170);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setCurrentLength", "com.documentum.fc.client.content.impl.ContentIterator", "int:", "v:", "", "void"), 178);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isClosed", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "", "boolean"), 182);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCurrentLength", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "", "int"), 186);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getContentSize", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "", "long"), 190);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getBytePosition", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "", "long"), 194);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getNextBytePosition", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "", "long"), 198);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCurrentBuffer", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "", "[B"), 202);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCurrentBufferLength", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "", "int"), 206);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getResultRow", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.impl.typeddata.ITypedData"), 210);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getBytesBuffer", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "", "java.io.ByteArrayInputStream"), 119);
        ajc$tjp_20 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.content.impl.ContentIterator", "com.documentum.fc.client.content.impl.ContentInputStream:long:", "stream:fullContentSize:", "com.documentum.fc.common.DfException:"), 226);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isSeekable", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "com.documentum.fc.common.DfException:", "boolean"), 126);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "fillNextBuffer", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "com.documentum.fc.common.DfException:", "boolean"), 133);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateRowData", "com.documentum.fc.client.content.impl.ContentIterator", "int:", "bytesReadThisTime:", "com.documentum.fc.common.DfException:", "void"), 143);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineNextBufferSize", "com.documentum.fc.client.content.impl.ContentIterator", "", "", "java.io.IOException:", "int"), 150);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setIsClosed", "com.documentum.fc.client.content.impl.ContentIterator", "boolean:", "v:", "", "void"), 158);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setBytePosition", "com.documentum.fc.client.content.impl.ContentIterator", "long:", "position:", "", "void"), 162);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setFullContentSize", "com.documentum.fc.client.content.impl.ContentIterator", "long:", "v:", "", "void"), 166);
        MAXIMUM_BUFFER_SIZE = 65536;
        s_type = new LiteType("CONTENT_COLLECTION");
        s_type.addAttr(new Attribute("buffer", false, 1, 0));
        s_type.addAttr(new Attribute("current_length", false, 1, 0));
        s_type.addAttr(new Attribute("content_size", false, 1, 0));
        s_type.addAttr(new Attribute("buffer_size", false, 1, 0));
        s_type.addAttr(new Attribute("_seekable", false, 0, 0));
        s_type.addAttr(new Attribute("_byte_position", false, 1, 0));
        s_type.addAttr(new Attribute("full_content_size", false, 5, 0));
        s_type.addAttr(new Attribute("_full_byte_position", false, 5, 0));
    }
}

