/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.dmcl.impl;

import com.documentum.fc.common.DfException;

public class DmclApiException
extends DfException {
    protected DmclApiException(String message) {
        super(message);
    }

    protected DmclApiException(String message, String[] parameters, Throwable cause) {
        super(message, parameters, cause);
    }

    static DmclApiException newNoQueryException() {
        return new DmclApiException("DM_API_E_NOQUERY");
    }

    static DmclApiException newCurrentSessionNotDefinedException() {
        return new DmclApiException("DFC_DMCL_CURRENT_SESSION_NOT_DEFINED");
    }

    static DmclApiException newDisconnectAdoptedSessionException(String sessionId) {
        return new DmclApiException("DFC_DMCL_DISCONNECT_ADOPTED_SESSION", new String[]{sessionId}, null);
    }

    static DmclApiException newCantSeekException() {
        return new DmclApiException("DM_API_E_CANT_SEEK");
    }

    static DmclApiException newBadDirectionException(String direction) {
        return new DmclApiException("DM_API_E_BAD_DIRECTION", new String[]{direction}, null);
    }

    static DmclApiException newBadPositionException(String position, NumberFormatException nfe) {
        return new DmclApiException("DM_API_E_BAD_POSITION", new String[]{position}, (Throwable)nfe);
    }

    static DmclApiException newInvalidInput(String encodedForm) {
        return new DmclApiException("DM_API_E_INVALID_INPUT", new String[]{encodedForm}, null);
    }

    static DmclApiException newNoLastObjectId() {
        return new DmclApiException("DM_API_E_NOLAST");
    }

    static DmclApiException newCantUUpdateException() {
        return new DmclApiException("DM_API_E_CANT_UPDATE");
    }

    static DmclApiException newInvlaidPermitTypeException(String permitType) {
        return new DmclApiException("DM_API_E_INVALID_PERMIT_TYPE", new String[]{permitType}, null);
    }
}

