/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.extensions.remote.deploy.command;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Domain;
import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.LiferayBundleDeployer;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.GradleTooling;
import com.liferay.blade.cli.gradle.ProcessResult;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.FileWatcher;
import com.liferay.blade.extensions.remote.deploy.command.RemoteDeployArgs;
import com.liferay.blade.gradle.tooling.ProjectInfo;
import java.io.File;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.dto.BundleDTO;

public class RemoteDeployCommand
extends BaseCommand<RemoteDeployArgs> {
    public void execute() throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        GradleExec gradleExec = new GradleExec(bladeCLI);
        RemoteDeployArgs deployArgs = (RemoteDeployArgs)this.getArgs();
        File baseDir = new File(deployArgs.getBase());
        String host = "localhost";
        int port = 11311;
        if (!BladeUtil.canConnect((String)host, (int)port)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to connect to gogo shell on " + host + ":" + port);
            sb.append(System.lineSeparator());
            sb.append("Liferay may not be running, or the gogo shell may need to be enabled. ");
            sb.append("Please see this link for more details: ");
            sb.append("https://dev.liferay.com/en/develop/reference/");
            sb.append("-/knowledge_base/7-1/using-the-felix-gogo-shell");
            sb.append(System.lineSeparator());
            this._addError(sb.toString());
            PrintStream error = bladeCLI.error();
            new ConnectException(sb.toString()).printStackTrace(error);
            return;
        }
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)baseDir.toPath());
        Map projectOutputFiles = projectInfo.getProjectOutputFiles();
        if (deployArgs.isWatch()) {
            this._deployWatch(gradleExec, projectOutputFiles, host, port);
        } else {
            this._deploy(gradleExec, projectOutputFiles, host, port);
        }
    }

    public Class<RemoteDeployArgs> getArgsClass() {
        return RemoteDeployArgs.class;
    }

    private void _addError(String msg) {
        this.getBladeCLI().addErrors("deploy", Collections.singleton(msg));
    }

    private void _addError(String prefix, String msg) {
        this.getBladeCLI().addErrors(prefix, Collections.singleton(msg));
    }

    private void _deploy(GradleExec gradle, Map<String, Set<File>> projectOutputFiles, String host, int port) throws Exception {
        ProcessResult processResult = gradle.executeTask("assemble -x check");
        int resultCode = processResult.getResultCode();
        BladeCLI bladeCLI = this.getBladeCLI();
        if (resultCode > 0) {
            String errorMessage = "Gradle assemble task failed.";
            this._addError(errorMessage);
            PrintStream err = bladeCLI.error();
            this._addError(processResult.getError());
            new ConnectException(errorMessage).printStackTrace(err);
            return;
        }
        Collection<Set<File>> values = projectOutputFiles.values();
        Stream<Set<File>> stream = values.stream();
        stream.flatMap(files -> files.stream()).filter(File::exists).forEach(outputFile -> {
            try {
                this._installOrUpdate((File)outputFile, host, port);
            }
            catch (Exception e) {
                String message = e.getMessage();
                Class<?> exceptionClass = e.getClass();
                if (message == null) {
                    message = "DeployCommand._deploy threw " + exceptionClass.getSimpleName();
                }
                this._addError(message);
                PrintStream error = bladeCLI.error();
                e.printStackTrace(error);
            }
        });
    }

    private void _deployBundle(File file, LiferayBundleDeployer client, Domain bundle, Map.Entry<String, Attrs> bsn) throws Exception {
        Map.Entry fragmentHost = bundle.getFragmentHost();
        String hostBsn = null;
        if (fragmentHost != null) {
            hostBsn = (String)fragmentHost.getKey();
        }
        Collection bundles = client.getBundles();
        long existingId = client.getBundleId(bundles, bsn.getKey());
        long hostId = client.getBundleId(bundles, hostBsn);
        URI uri = file.toURI();
        if (existingId > 0L) {
            this._reloadExistingBundle(client, fragmentHost, existingId, hostId, uri);
        } else {
            this._installNewBundle(client, bsn, fragmentHost, hostId, uri);
        }
    }

    private void _deployWar(File file, LiferayBundleDeployer liferayBundleDeployer) throws Exception {
        URI uri = file.toURI();
        long bundleId = liferayBundleDeployer.install(uri);
        if (bundleId > 0L) {
            BladeCLI bladeCLI = this.getBladeCLI();
            PrintStream out = bladeCLI.out();
            out.println("Installed bundle " + bundleId);
            BundleDTO bundle = liferayBundleDeployer.getBundle(bundleId);
            if (bundle.state == 2) {
                liferayBundleDeployer.start(bundleId);
                out.println("Started bundle " + bundleId);
            } else if (bundle.state == 32) {
                liferayBundleDeployer.update(bundleId, uri);
                out.println("Updated bundle " + bundleId);
            }
        } else {
            throw new Exception("Failed to deploy war: " + file.getAbsolutePath());
        }
    }

    private void _deployWatch(final GradleExec gradleExec, Map<String, Set<File>> projectOutputFiles, final String host, final int port) throws Exception {
        this._deploy(gradleExec, projectOutputFiles, host, port);
        Collection<Set<File>> values = projectOutputFiles.values();
        Stream<Set<File>> stream = values.stream();
        final Collection outputPaths = stream.flatMap(files -> files.stream()).map(File::toPath).collect(Collectors.toSet());
        final BladeCLI bladeCLI = this.getBladeCLI();
        new Thread(){

            @Override
            public void run() {
                try {
                    gradleExec.executeTask("assemble -x check -t");
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message == null) {
                        message = "Gradle build task failed.";
                    }
                    RemoteDeployCommand.this._addError("deploy watch", message);
                    PrintStream error = bladeCLI.error();
                    e.printStackTrace(error);
                }
            }
        }.start();
        FileWatcher.Consumer<Path> consumer = new FileWatcher.Consumer<Path>(){

            public void consume(Path modified) {
                try {
                    File file = modified.toFile();
                    File modifiedFile = file.getAbsoluteFile();
                    if (outputPaths.contains(modifiedFile.toPath())) {
                        bladeCLI.out("installOrUpdate " + modifiedFile);
                        RemoteDeployCommand.this._installOrUpdate(modifiedFile, host, port);
                    }
                }
                catch (Exception e) {
                    String exceptionMessage = e.getMessage() == null ? "" : System.lineSeparator() + e.getMessage();
                    String message = "Error: Bundle Insatllation failed: " + modified + exceptionMessage;
                    RemoteDeployCommand.this._addError(message);
                    PrintStream error = bladeCLI.error();
                    e.printStackTrace(error);
                }
            }
        };
        BaseArgs args = bladeCLI.getArgs();
        File baseDir = new File(args.getBase());
        new FileWatcher(baseDir.toPath(), true, (FileWatcher.Consumer)consumer);
    }

    private void _installNewBundle(LiferayBundleDeployer client, Map.Entry<String, Attrs> bsn, Map.Entry<String, Attrs> fragmentHost, long hostId, URI uri) throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        PrintStream out = bladeCLI.out();
        long installedId = client.install(uri);
        out.println("Installed bundle " + installedId);
        if (fragmentHost != null && hostId > 0L) {
            client.refresh(hostId);
            out.println("Deployed fragment bundle " + installedId);
        } else {
            long existingId = client.getBundleId(bsn.getKey());
            try {
                if (!Objects.equals(installedId, existingId)) {
                    out.println("Error: Bundle IDs do not match.");
                } else if (existingId > 1L) {
                    client.start(existingId);
                    out.println("Started bundle " + installedId);
                } else {
                    out.println("Error: bundle failed to start: " + bsn);
                }
            }
            catch (Exception e) {
                String exceptionMessage = e.getMessage() == null ? "" : System.lineSeparator() + e.getMessage();
                String message = "Error: Bundle Deployment failed: " + bsn + exceptionMessage;
                this._addError("deploy watch", message);
                PrintStream error = bladeCLI.error();
                e.printStackTrace(error);
            }
        }
    }

    private void _installOrUpdate(File file, String host, int port) throws Exception {
        file = file.getAbsoluteFile();
        try (LiferayBundleDeployer client = LiferayBundleDeployer.newInstance((String)host, (int)port);){
            String name = file.getName();
            name = name.toLowerCase();
            if (name.endsWith(".war")) {
                this._deployWar(file, client);
            } else {
                Domain bundle = Domain.domain((File)file);
                Map.Entry bsn = bundle.getBundleSymbolicName();
                if (bsn != null) {
                    this._deployBundle(file, client, bundle, bsn);
                } else {
                    this.getBladeCLI().error("Unable to install or update " + file.getName() + "as it is not a bundle.");
                }
            }
        }
    }

    private final void _reloadExistingBundle(LiferayBundleDeployer client, Map.Entry<String, Attrs> fragmentHost, long existingId, long hostId, URI uri) throws Exception {
        if (fragmentHost != null && hostId > 0L) {
            client.reloadFragment(existingId, hostId, uri);
        } else {
            client.reloadBundle(existingId, uri);
        }
        PrintStream out = this.getBladeCLI().out();
        out.println("Updated bundle " + existingId);
    }
}

