/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeSettings;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.SamplesArgs;
import com.liferay.blade.cli.command.SamplesVisitor;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Stream;

public class SamplesCommand
extends BaseCommand<SamplesArgs> {
    private static final long _FILE_EXPIRATION_TIME = 604800000L;
    private static final File _USER_HOME_DIR = new File(System.getProperty("user.home"));
    private static final Collection<String> _topLevelFolders = Arrays.asList("apps", "extensions", "overrides", "themes");

    @Override
    public void execute() throws Exception {
        Path bladeRepoArchivePath;
        BladeCLI bladeCLI = this.getBladeCLI();
        SamplesArgs samplesArgs = (SamplesArgs)this.getArgs();
        String liferayVersion = this._getLiferayVersion(bladeCLI, samplesArgs);
        String bladeRepoName = "liferay-blade-samples-" + liferayVersion;
        String bladeRepoArchiveName = bladeRepoName + ".zip";
        String sampleName = samplesArgs.getSampleName();
        Path cachePath = this._getSamplesCachePath();
        if (this._needDownloadBladeSamplesRepo(bladeRepoArchiveName)) {
            String bladeRepoUrl = "https://github.com/liferay/liferay-blade-samples/archive/" + liferayVersion + ".zip";
            bladeRepoArchivePath = BladeUtil.downloadFile(bladeRepoUrl, cachePath, bladeRepoArchiveName);
        } else {
            bladeRepoArchivePath = cachePath.resolve(bladeRepoArchiveName);
        }
        this._extractBladeRepo(bladeRepoArchivePath);
        if (sampleName == null) {
            this._listSamples(bladeRepoName);
        } else {
            this._copySample(sampleName, bladeRepoName);
        }
    }

    @Override
    public Class<SamplesArgs> getArgsClass() {
        return SamplesArgs.class;
    }

    private void _copySample(String sampleName, String bladeRepoName) throws Exception {
        SamplesArgs samplesArgs = (SamplesArgs)this.getArgs();
        File workDir = samplesArgs.getDir();
        if (workDir == null) {
            workDir = samplesArgs.getBase();
        }
        Path cachePath = this._getSamplesCachePath();
        File bladeRepo = new File(cachePath.toFile(), bladeRepoName);
        String buildType = samplesArgs.getProfileName();
        File samples = new File(bladeRepo, buildType);
        SamplesVisitor visitor = new SamplesVisitor();
        for (File file : samples.listFiles()) {
            String fileName = file.getName();
            if (!file.isDirectory() || !_topLevelFolders.contains(fileName)) continue;
            Files.walkFileTree(file.toPath(), visitor);
        }
        for (Path path : visitor.getPaths()) {
            File file = path.toFile();
            String fileName = file.getName();
            if (!Files.isDirectory(path, new LinkOption[0]) || !fileName.equals(sampleName)) continue;
            File dest = new File(workDir, fileName);
            FileUtil.copyDir(path, dest.toPath());
            if (buildType.equals("gradle")) {
                this._updateBuildGradle(dest, bladeRepoName);
            }
            if (BladeUtil.hasGradleWrapper(dest)) continue;
            BladeUtil.addGradleWrapper(dest);
        }
    }

    private String _deindent(String s) {
        return s.replaceAll("(?m)^\t", "");
    }

    private void _extractBladeRepo(Path bladeRepoArchivePath) throws Exception {
        Path samplesCachePath = this._getSamplesCachePath();
        FileUtil.unzip(bladeRepoArchivePath.toFile(), samplesCachePath.toFile(), null);
    }

    private String _getLiferayVersion(BladeCLI bladeCLI, SamplesArgs samplesArgs) throws Exception {
        String liferayVersion = samplesArgs.getLiferayVersion();
        if (liferayVersion == null) {
            BladeSettings bladeSettings = bladeCLI.getBladeSettings();
            liferayVersion = bladeSettings.getLiferayVersionDefault();
        }
        return liferayVersion;
    }

    private Path _getSamplesCachePath() throws Exception {
        Path userHomePath = _USER_HOME_DIR.toPath();
        Path samplesCachePath = userHomePath.resolve(".blade/cache/samples");
        if (!Files.exists(samplesCachePath, new LinkOption[0])) {
            Files.createDirectories(samplesCachePath, new FileAttribute[0]);
        }
        return samplesCachePath;
    }

    private void _listSamples(String bladeRepoName) throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        SamplesArgs samplesArgs = (SamplesArgs)this.getArgs();
        Path cachePath = this._getSamplesCachePath();
        File bladeRepo = new File(cachePath.toFile(), bladeRepoName);
        String buildType = samplesArgs.getProfileName();
        File samples = new File(bladeRepo, buildType);
        HashMap samplesMap = new HashMap();
        for (File file : samples.listFiles()) {
            String fileName = file.getName();
            if (!file.isDirectory() || !_topLevelFolders.contains(fileName)) continue;
            SamplesVisitor visitor = new SamplesVisitor();
            Files.walkFileTree(file.toPath(), visitor);
            ArrayList<Path> samplesList = (ArrayList<Path>)samplesMap.get(fileName);
            if (samplesList == null) {
                samplesList = new ArrayList<Path>();
                samplesMap.put(fileName, samplesList);
            }
            for (Path path : visitor.getPaths()) {
                samplesList.add(path.getFileName());
            }
            if (!samplesMap.containsKey(fileName)) continue;
            Collections.sort(samplesList);
        }
        bladeCLI.out("Please provide the sample project name to create, e.g. \"blade samples jsp-portlet\"\n");
        bladeCLI.out("Currently available categories and samples:");
        Set keySet = samplesMap.keySet();
        Stream stream = keySet.stream();
        stream.sorted().peek(category -> bladeCLI.out("\t " + category + ":")).map(samplesMap::get).flatMap(category -> category.stream()).forEach(sample -> bladeCLI.out("\t\t " + sample));
    }

    private boolean _needDownloadBladeSamplesRepo(String bladeRepoArchiveName) throws Exception {
        Path cachePath = this._getSamplesCachePath();
        File bladeRepoArchive = new File(cachePath.toFile(), bladeRepoArchiveName);
        if (bladeRepoArchive.exists()) {
            Date now = new Date();
            long diff = now.getTime() - bladeRepoArchive.lastModified();
            boolean old = false;
            if (diff > 604800000L) {
                old = true;
            }
            if (old || !BladeUtil.isZipValid(bladeRepoArchive)) {
                bladeRepoArchive.delete();
                return true;
            }
            return false;
        }
        return true;
    }

    private String _parseGradleScript(String script, String section, boolean contentsOnly) {
        int begin;
        int end = begin = script.indexOf(section + " {");
        int count = 0;
        if (contentsOnly) {
            begin += section.length() + 2;
        }
        while (true) {
            char c = script.charAt(end);
            if (count != 0 && c == '}') {
                --count;
            } else if (c == '{') {
                ++count;
            }
            if (count == 0 && c == '}') {
                if (contentsOnly) break;
                ++end;
                break;
            }
            ++end;
        }
        String newScript = script.substring(begin, end);
        if (contentsOnly) {
            return this._deindent(newScript);
        }
        return newScript;
    }

    private String _removeGradleSection(String script, String section) {
        char c;
        int begin = script.indexOf(section + " {");
        if (begin == -1) {
            return script;
        }
        int end = begin;
        int count = 0;
        do {
            c = script.charAt(end);
            if (count != 0 && c == '}') {
                --count;
            } else if (c == '{') {
                ++count;
            }
            ++end;
        } while (count != 0 || c != '}');
        return this._removeGradleSection(script.substring(0, begin) + script.substring(end, script.length()), section);
    }

    private void _updateBuildGradle(File dir, String bladeRepoName) throws Exception {
        Path cachePath = this._getSamplesCachePath();
        File bladeRepo = new File(cachePath.toFile(), bladeRepoName);
        File sampleGradleFile = new File(dir, "build.gradle");
        String script = BladeUtil.read(sampleGradleFile);
        BladeCLI bladeCLI = this.getBladeCLI();
        WorkspaceProvider workspaceProvider = bladeCLI.getWorkspaceProvider(dir);
        if (workspaceProvider == null) {
            File parentBuildGradleFile = new File(bladeRepo, "gradle/build.gradle");
            String parentBuildScript = this._parseGradleScript(BladeUtil.read(parentBuildGradleFile), "buildscript", false);
            String parentSubprojectsScript = this._parseGradleScript(BladeUtil.read(parentBuildGradleFile), "subprojects", true);
            parentSubprojectsScript = this._removeGradleSection(parentSubprojectsScript, "buildscript");
            System.out.println(parentSubprojectsScript);
            script = parentBuildScript + parentSubprojectsScript + script;
        }
        Files.write(sampleGradleFile.toPath(), script.getBytes(), new OpenOption[0]);
    }
}

