/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import javax.annotation.Nullable;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.internal.Describables;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;

public class VintageBuildModelController
implements BuildModelController {
    private final ProjectsPreparer projectsPreparer;
    private final GradleInternal gradle;
    private final SettingsPreparer settingsPreparer;
    private final TaskExecutionPreparer taskExecutionPreparer;
    private final StateTransitionController<Stage> state;

    public VintageBuildModelController(GradleInternal gradle, ProjectsPreparer projectsPreparer, SettingsPreparer settingsPreparer, TaskExecutionPreparer taskExecutionPreparer, StateTransitionControllerFactory controllerFactory) {
        this.gradle = gradle;
        this.projectsPreparer = projectsPreparer;
        this.settingsPreparer = settingsPreparer;
        this.taskExecutionPreparer = taskExecutionPreparer;
        this.state = controllerFactory.newController(Describables.of("vintage state of", gradle.getOwner().getDisplayName()), (StateTransitionController.State)Stage.Created);
    }

    public SettingsInternal getLoadedSettings() {
        this.prepareSettings();
        return this.gradle.getSettings();
    }

    public GradleInternal getConfiguredModel() {
        this.prepareSettings();
        this.prepareProjects();
        return this.gradle;
    }

    public void prepareToScheduleTasks() {
        this.prepareSettings();
        this.prepareProjects();
    }

    public void scheduleRequestedTasks(@Nullable EntryTaskSelector selector, ExecutionPlan plan) {
        this.state.inState((StateTransitionController.State)Stage.Configured, () -> this.taskExecutionPreparer.scheduleRequestedTasks(this.gradle, selector, plan));
    }

    private void prepareSettings() {
        this.state.transitionIfNotPreviously((StateTransitionController.State)Stage.Created, (StateTransitionController.State)Stage.SettingsLoaded, () -> this.settingsPreparer.prepareSettings(this.gradle));
    }

    private void prepareProjects() {
        this.state.transitionIfNotPreviously((StateTransitionController.State)Stage.SettingsLoaded, (StateTransitionController.State)Stage.Configured, () -> this.projectsPreparer.prepareProjects(this.gradle));
    }

    private static enum Stage implements StateTransitionController.State
    {
        Created,
        SettingsLoaded,
        Configured;

    }
}

