/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.InternalAction;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.MutationGuards;
import org.gradle.api.internal.WithEstimatedSize;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Actions;

public class CompositeDomainObjectSet<T>
extends DelegatingDomainObjectSet<T>
implements WithEstimatedSize {
    private final Spec<T> uniqueSpec = new ItemIsUniqueInCompositeSpec();
    private final Spec<T> notInSpec = new ItemNotInCompositeSpec();
    private final DefaultDomainObjectSet<T> backingSet;
    private final CollectionCallbackActionDecorator callbackActionDecorator;

    public static <T> CompositeDomainObjectSet<T> create(Class<T> type, DomainObjectCollection<? extends T> ... collections) {
        return CompositeDomainObjectSet.create(type, CollectionCallbackActionDecorator.NOOP, collections);
    }

    @SafeVarargs
    public static <T> CompositeDomainObjectSet<T> create(Class<T> type, CollectionCallbackActionDecorator callbackActionDecorator, DomainObjectCollection<? extends T> ... collections) {
        DefaultDomainObjectSet<T> backingSet = new DefaultDomainObjectSet<T>(type, new DomainObjectCompositeCollection(), callbackActionDecorator);
        CompositeDomainObjectSet<? extends T> out = new CompositeDomainObjectSet<T>(backingSet, callbackActionDecorator);
        for (DomainObjectCollection<? extends T> c : collections) {
            out.addCollection(c);
        }
        return out;
    }

    private CompositeDomainObjectSet(DefaultDomainObjectSet<T> backingSet, CollectionCallbackActionDecorator callbackActionDecorator) {
        super(backingSet);
        this.backingSet = backingSet;
        this.callbackActionDecorator = callbackActionDecorator;
    }

    protected DomainObjectCompositeCollection<T> getStore() {
        return (DomainObjectCompositeCollection)this.backingSet.getStore();
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return super.whenObjectAdded(Actions.filter(action, this.uniqueSpec));
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return super.whenObjectRemoved(Actions.filter(action, this.notInSpec));
    }

    public void addCollection(DomainObjectCollection<? extends T> collection) {
        if (!this.getStore().containsCollection(collection)) {
            this.getStore().addComposited(collection);
            collection.all(new InternalAction<T>(){

                @Override
                public void execute(T t) {
                    CompositeDomainObjectSet.this.backingSet.getEventRegister().fireObjectAdded(t);
                }
            });
            collection.whenObjectRemoved(new Action<T>(){

                @Override
                public void execute(T t) {
                    CompositeDomainObjectSet.this.backingSet.getEventRegister().fireObjectRemoved(t);
                }
            });
        }
    }

    public void removeCollection(DomainObjectCollection<? extends T> collection) {
        this.getStore().removeComposited(collection);
        for (Object item : collection) {
            this.backingSet.getEventRegister().fireObjectRemoved(item);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.getStore().iterator();
    }

    @Override
    public int size() {
        return this.getStore().size();
    }

    @Override
    public int estimatedSize() {
        return this.getStore().estimatedSize();
    }

    @Override
    public void all(Action<? super T> action) {
        this.whenObjectAdded(action);
        for (T t : this) {
            this.callbackActionDecorator.decorate(action).execute(t);
        }
    }

    private static final class DomainObjectCompositeCollection<T>
    implements ElementSource<T> {
        private final List<DomainObjectCollection<? extends T>> store = Lists.newLinkedList();

        private DomainObjectCompositeCollection() {
        }

        public boolean containsCollection(DomainObjectCollection<? extends T> collection) {
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                if (domainObjectCollection != collection) continue;
                return true;
            }
            return false;
        }

        Set<T> collect() {
            if (this.store.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet tmp = Sets.newLinkedHashSetWithExpectedSize((int)this.estimatedSize());
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                tmp.addAll(domainObjectCollection);
            }
            return tmp;
        }

        public int size() {
            return this.collect().size();
        }

        public boolean isEmpty() {
            for (DomainObjectCollection<T> ts : this.store) {
                if (ts.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean contains(Object o) {
            for (DomainObjectCollection<T> ts : this.store) {
                if (!ts.contains(o)) continue;
                return true;
            }
            return false;
        }

        public Iterator<T> iterator() {
            if (this.store.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (this.store.size() == 1) {
                return this.store.get(0).iterator();
            }
            return this.collect().iterator();
        }

        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        public boolean addRealized(T element) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void addComposited(DomainObjectCollection<? extends T> collection) {
            this.store.add(collection);
        }

        public void removeComposited(DomainObjectCollection<? extends T> collection) {
            Iterator<DomainObjectCollection<T>> iterator = this.store.iterator();
            while (iterator.hasNext()) {
                DomainObjectCollection<? extends T> next = iterator.next();
                if (next != collection) continue;
                iterator.remove();
                break;
            }
        }

        public boolean constantTimeIsEmpty() {
            return this.store.isEmpty();
        }

        public int estimatedSize() {
            int size = 0;
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                size += WithEstimatedSize.Estimates.estimateSizeOf(domainObjectCollection);
            }
            return size;
        }

        public Iterator<T> iteratorNoFlush() {
            return this.iterator();
        }

        public void realizePending() {
        }

        public void realizePending(Class<?> type) {
        }

        public boolean addPending(ProviderInternal<? extends T> provider) {
            throw new UnsupportedOperationException();
        }

        public boolean removePending(ProviderInternal<? extends T> provider) {
            throw new UnsupportedOperationException();
        }

        public boolean addPendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
            throw new UnsupportedOperationException();
        }

        public boolean removePendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
            throw new UnsupportedOperationException();
        }

        public void onRealize(Action<T> action) {
        }

        public void realizeExternal(ProviderInternal<? extends T> provider) {
        }

        public MutationGuard getMutationGuard() {
            return MutationGuards.identity();
        }
    }

    public class ItemNotInCompositeSpec
    implements Spec<T> {
        @Override
        public boolean isSatisfiedBy(T element) {
            return !CompositeDomainObjectSet.this.getStore().contains(element);
        }
    }

    public class ItemIsUniqueInCompositeSpec
    implements Spec<T> {
        @Override
        public boolean isSatisfiedBy(T element) {
            int matches = 0;
            for (DomainObjectCollection collection : CompositeDomainObjectSet.this.getStore().store) {
                if (!collection.contains(element) || ++matches <= 1) continue;
                return false;
            }
            return true;
        }
    }
}

