/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ProcessesUtil {
    public static List<Long> getAllProcessIds() {
        ArrayList<Long> processIds;
        block31: {
            processIds = new ArrayList<Long>();
            try {
                String os = System.getProperty("os.name");
                if (os.startsWith("Win")) {
                    ProcessBuilder processBuilder = new ProcessBuilder("tasklist.exe", "/fo", "csv", "/nh");
                    Process process = processBuilder.start();
                    try (Scanner scanner = new Scanner(process.getInputStream());){
                        if (scanner.hasNextLine()) {
                            scanner.nextLine();
                        }
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            String[] parts = line.split(",");
                            String pid = parts[1].substring(1);
                            processIds.add(Long.parseLong(pid.replaceFirst(".$", "")));
                        }
                        break block31;
                    }
                }
                ProcessBuilder processBuilder = new ProcessBuilder("ps", "-e");
                Process process = processBuilder.start();
                try (Scanner scanner = new Scanner(process.getInputStream());){
                    if (scanner.hasNextLine()) {
                        scanner.nextLine();
                    }
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        line = line.trim();
                        processIds.add(Long.parseLong(line.substring(0, line.indexOf(" "))));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return processIds;
    }

    public static long getCurrentProcessId() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String vmName = runtimeMXBean.getName();
        return Long.parseLong(vmName.substring(0, vmName.indexOf("@")));
    }
}

