/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.CommandType;
import com.liferay.blade.cli.command.validator.JsProjectTargetValidator;
import com.liferay.blade.cli.command.validator.JsProjectTypeValidator;
import com.liferay.blade.cli.command.validator.ParameterDepdendencyValidator;
import com.liferay.blade.cli.command.validator.ParameterPossibleValues;
import com.liferay.blade.cli.command.validator.TemplateNameValidator;
import java.io.File;

@Parameters(commandDescription="Creates a new Liferay module project from several available templates.", commandNames={"create"})
public class CreateArgs
extends BaseArgs {
    @Parameter(description="Set to true for add on options.", names={"--add-ons"})
    private String _addOns = "false";
    @Parameter(description="If a class is generated in the project, provide the name of the class to be generated. If not provided defaults to project name.", names={"-c", "--classname"})
    private String _className;
    @Parameter(description="Used to identify your module as a Theme Contributor. Also, used to add the Liferay-Theme-Contributor-Type and Web-ContextPath bundle headers.", hidden=true, names={"-C", "--contributor-type"})
    private String _contributorType;
    @Parameter(description="For Service Builder projects, specify the preferred dependency injection method (ds|spring). Default is DS", hidden=true, names={"--dependency-injector"})
    private String _dependencyInjector = "ds";
    @Parameter(description="The directory where to create the new project.", names={"-d", "--dir"})
    private File _dir;
    @Parameter(description="The name of the framework to use in the generated project.", hidden=true, names={"--framework"})
    private String _framework;
    @Parameter(description="The way that the framework dependencies will be configured.", hidden=true, names={"--framework-dependencies"})
    private String _frameworkDependencies = "embedded";
    @Parameter(description="If a new jsp hook fragment needs to be created, provide the name of the host bundle symbolic name. Required for \"-t fragment\".", hidden=true, names={"-h", "--host-bundle-bsn", "--host-bundle-symbolic-name"})
    private String _hostBundleBSN;
    @Parameter(description="If a new jsp hook fragment needs to be created, provide the host bundle version. Required for \"-t fragment\".", hidden=true, names={"-H", "--host-bundle-version"})
    private String _hostBundleVersion;
    @Parameter(description="Specify the javascript framework which will be used in the generated project. (metaljs)|(react)", names={"--js-framework"})
    private String _jsFramework;
    @Parameter(description="use interactive mode to create js project", hidden=true, names={"--jsInteractive"})
    private boolean _jsInteractiveModel;
    @Parameter(description="The js project target to use when creating js project.", names={"--jsTarget"})
    @ParameterDepdendencyValidator(order=1, value=JsProjectTargetValidator.class)
    private String _jsProjectTarget;
    @Parameter(description="The js project type to use when creating js project.", names={"--jsType"})
    @ParameterDepdendencyValidator(order=2, value=JsProjectTypeValidator.class)
    private String _jsProjectType;
    @Parameter(description="The option for Liferay Platform product. (portal)|(dxp)", names={"--liferay-product"})
    private String _liferayProduct = "portal";
    @Parameter(description="The version of Liferay to target when creating the project. Available options are 7.0, 7.1, 7.2, 7.3, 7.4.", names={"-v", "--liferay-version"})
    private String _liferayVersion;
    @Parameter(description="Prints a list of available project templates", hidden=true, names={"-l", "--list-templates"})
    private boolean _listTemplates;
    @Parameter(description="[name]", required=true)
    private String _name;
    @Parameter(description="Sets the name of the original module when creating a project with modules-ext template.", hidden=true, names={"-m", "--original-module-name"})
    private String _originalModuleName;
    @Parameter(description="The Java package to use when generating Java source.", names={"-p", "--package-name"})
    private String _packageName;
    @Parameter(description="If a new DS component needs to be created, provides the name of the service to be implemented.", hidden=true, names={"-s", "--service"})
    private String _service;
    @Parameter(description="The project template to use when creating the project. To see the list of templates available use blade create <-l|--list-templates>", names={"-t", "--template"}, required=true, validateValueWith={TemplateNameValidator.class})
    @ParameterPossibleValues(more=TemplateNameValidator.class, value=TemplateNameValidator.class)
    private String _template;
    @Parameter(description="Choose the view technology that will be used in the generated project.", hidden=true, names={"--view-type"})
    private String _viewType;

    public String getAddOns() {
        return this._addOns;
    }

    public String getClassName() {
        return this._className;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.WORKSPACE_ONLY;
    }

    public String getContributorType() {
        return this._contributorType;
    }

    public String getDependencyInjector() {
        return this._dependencyInjector;
    }

    public File getDir() {
        return this._dir;
    }

    public String getFramework() {
        return this._framework;
    }

    public String getFrameworkDependencies() {
        return this._frameworkDependencies;
    }

    public String getHostBundleBSN() {
        return this._hostBundleBSN;
    }

    public String getHostBundleVersion() {
        return this._hostBundleVersion;
    }

    public String getJSFramework() {
        return this._jsFramework;
    }

    public String getJsProjectTarget() {
        return this._jsProjectTarget;
    }

    public String getJsProjectType() {
        return this._jsProjectType;
    }

    public String getLiferayProduct() {
        return this._liferayProduct;
    }

    public String getLiferayVersion() {
        return this._liferayVersion;
    }

    public String getName() {
        return this._name;
    }

    public String getOriginalModuleName() {
        return this._originalModuleName;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public String getService() {
        return this._service;
    }

    public String getTemplate() {
        return this._template;
    }

    public String getViewType() {
        return this._viewType;
    }

    public boolean isJsInteractiveModel() {
        return this._jsInteractiveModel;
    }

    public boolean isListTemplates() {
        return this._listTemplates;
    }

    public void setAddOns(String addOns) {
        this._addOns = addOns;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setDependencyInjector(String dependencyInjector) {
        this._dependencyInjector = dependencyInjector;
    }

    public void setDir(File dir) {
        this._dir = dir;
    }

    public void setFramework(String framework) {
        this._framework = framework;
    }

    public void setFrameworkDependencies(String frameworkDependencies) {
        this._frameworkDependencies = frameworkDependencies;
    }

    public void setHostBundleBSN(String hostBundleBSN) {
        this._hostBundleBSN = hostBundleBSN;
    }

    public void setHostBundleVersion(String hostBundleVersion) {
        this._hostBundleVersion = hostBundleVersion;
    }

    public void setJSFramework(String jsFramework) {
        this._jsFramework = jsFramework;
    }

    public void setJsInteractiveModel(boolean jsInteractiveModel) {
        this._jsInteractiveModel = jsInteractiveModel;
    }

    public void setJSProjectTarget(String jsProjectTarget) {
        this._jsProjectTarget = jsProjectTarget;
    }

    public void setJSProjectType(String jsProjectType) {
        this._jsProjectType = jsProjectType;
    }

    public void setLiferayProduct(String liferayProduct) {
        this._liferayProduct = liferayProduct;
    }

    public void setLiferayVersion(String liferayVersion) {
        this._liferayVersion = liferayVersion;
    }

    public void setListTemplates(boolean listTemplates) {
        this._listTemplates = listTemplates;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPackageName(String packageName) {
        this._packageName = packageName;
    }

    public void setService(String service) {
        this._service = service;
    }

    public void setTemplate(String template) {
        this._template = template;
    }

    public void setViewType(String viewType) {
        this._viewType = viewType;
    }
}

