/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.GradleRunnerUtil;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.gradle.testkit.runner.BuildTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SamplesCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final File _USER_HOME_DIR = new File(System.getProperty("user.home"));
    private File _extensionsDir = null;
    private File _rootDir = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
        File wrapperZipFile = new File("build/wrapper.zip");
        Files.copy(wrapperZipFile.toPath(), new FileOutputStream(new File("build/classes/java/test/wrapper.zip")));
        SamplesCommandTest._deleteSamplesCache();
    }

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Ignore
    @Test
    public void testGetSample() throws Exception {
        File root = this.temporaryFolder.newFolder("samplesroot");
        String[] args = new String[]{"samples", "-d", root.getPath() + "/test", "friendly-url"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "test/friendly-url");
        Assert.assertTrue((boolean)projectDir.exists());
        File buildFile = new File(projectDir, "build.gradle");
        Assert.assertTrue((boolean)buildFile.exists());
        String projectPath = projectDir.getPath();
        TestUtil.verifyBuild(projectPath, "com.liferay.blade.friendly.url-1.0.0.jar");
    }

    @Test
    public void testGetSampleClientExtension() throws Exception {
        File root = this.temporaryFolder.getRoot();
        String[] args = new String[]{"samples client-extensions", "-d", root.getPath() + "/client-extensions", "liferay-sample-global-css"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "client-extensions/liferay-sample-global-css");
        Assert.assertTrue((boolean)projectDir.exists());
    }

    @Test
    public void testGetSampleMaven70() throws Exception {
        File root = this.temporaryFolder.getRoot();
        String[] args = new String[]{"samples", "-d", root.getPath() + "/test", "-b", "maven", "-v", "7.0", "friendly-url"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "test/friendly-url");
        Assert.assertTrue((boolean)projectDir.exists());
        File gradleBuildFile = new File(projectDir, "build.gradle");
        File mavenBuildFile = new File(projectDir, "pom.xml");
        Assert.assertFalse((boolean)gradleBuildFile.exists());
        Assert.assertTrue((boolean)mavenBuildFile.exists());
        String content = FileUtil.read((File)mavenBuildFile);
        Assert.assertTrue((String)content, (boolean)content.contains("<artifactId>com.liferay.portal.kernel</artifactId>\n\t\t\t<version>2.0.0</version>"));
    }

    @Test
    public void testGetSampleMaven71() throws Exception {
        File root = this.temporaryFolder.getRoot();
        String[] args = new String[]{"samples", "-d", root.getPath() + "/test", "-b", "maven", "-v", "7.1", "friendly-url"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "test/friendly-url");
        Assert.assertTrue((boolean)projectDir.exists());
        File gradleBuildFile = new File(projectDir, "build.gradle");
        File mavenBuildFile = new File(projectDir, "pom.xml");
        Assert.assertFalse((boolean)gradleBuildFile.exists());
        Assert.assertTrue((boolean)mavenBuildFile.exists());
        String content = FileUtil.read((File)mavenBuildFile);
        Assert.assertTrue((String)content, (boolean)content.contains("<artifactId>com.liferay.portal.kernel</artifactId>\n\t\t\t<version>3.0.0</version>"));
    }

    @Test
    public void testGetSampleMaven72() throws Exception {
        File root = this.temporaryFolder.getRoot();
        String[] args = new String[]{"samples", "-d", root.getPath() + "/test", "-b", "maven", "-v", "7.2", "friendly-url"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "test/friendly-url");
        Assert.assertTrue((boolean)projectDir.exists());
        File gradleBuildFile = new File(projectDir, "build.gradle");
        File mavenBuildFile = new File(projectDir, "pom.xml");
        Assert.assertFalse((boolean)gradleBuildFile.exists());
        Assert.assertTrue((boolean)mavenBuildFile.exists());
        String content = FileUtil.read((File)mavenBuildFile);
        Assert.assertTrue((String)content, (boolean)content.contains("<artifactId>com.liferay.portal.kernel</artifactId>"));
    }

    @Ignore
    @Test
    public void testGetSampleWithDependencies() throws Exception {
        File root = this.temporaryFolder.getRoot();
        String[] args = new String[]{"samples", "-d", root.getPath() + "/test", "rest"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "test/rest");
        Assert.assertTrue((boolean)projectDir.exists());
        File buildFile = new File(projectDir, "build.gradle");
        Assert.assertTrue((boolean)buildFile.exists());
        String projectPath = projectDir.getPath();
        TestUtil.verifyBuild(projectPath, "com.liferay.blade.rest-1.0.0.jar");
    }

    @Ignore
    @Test
    public void testGetSampleWithGradleWrapper() throws Exception {
        File root = this.temporaryFolder.getRoot();
        String[] args = new String[]{"samples", "-d", root.getPath() + "/test", "authenticator-shiro"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "test/authenticator-shiro");
        Assert.assertTrue((boolean)projectDir.exists());
        File buildFile = new File(projectDir, "build.gradle");
        File gradleWrapperJar = new File(projectDir, "gradle/wrapper/gradle-wrapper.jar");
        File gradleWrapperProperties = new File(projectDir, "gradle/wrapper/gradle-wrapper.properties");
        File gradleWrapperShell = new File(projectDir, "gradlew");
        Assert.assertTrue((boolean)buildFile.exists());
        Assert.assertTrue((boolean)gradleWrapperJar.exists());
        Assert.assertTrue((boolean)gradleWrapperProperties.exists());
        Assert.assertTrue((boolean)gradleWrapperShell.exists());
        String projectPath = projectDir.getPath();
        TestUtil.verifyBuild(projectPath, "com.liferay.blade.authenticator.shiro-1.0.0.jar");
    }

    @Test
    public void testGetSampleWithGradleWrapperExisting() throws Exception {
        String[] initArgs = new String[]{"--base", this._rootDir.getPath() + "/test/workspace", "init", "-v", BladeTest.PRODUCT_VERSION_DXP_72};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, initArgs);
        String output = bladeTestResults.getOutput();
        output = output.trim();
        Assert.assertEquals((Object)"Checking for new releases...", (Object)output);
        String[] samplesArgs = new String[]{"samples", "-d", this._rootDir.getPath() + "/test/workspace/modules", "auth-failure"};
        bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, samplesArgs);
        output = bladeTestResults.getOutput();
        Assert.assertTrue((String)output, (output == null || output.isEmpty() ? 1 : 0) != 0);
        File projectDir = new File(this.temporaryFolder.getRoot(), "test/workspace/modules/auth-failure");
        Assert.assertTrue((boolean)projectDir.exists());
        File buildFile = new File(projectDir, "build.gradle");
        File gradleWrapperJar = new File(projectDir, "gradle/wrapper/gradle-wrapper.jar");
        File gradleWrapperProperties = new File(projectDir, "gradle/wrapper/gradle-wrapper.properties");
        File gradleWrapperShell = new File(projectDir, "gradlew");
        Assert.assertTrue((boolean)buildFile.exists());
        Assert.assertFalse((boolean)gradleWrapperJar.exists());
        Assert.assertFalse((boolean)gradleWrapperProperties.exists());
        Assert.assertFalse((boolean)gradleWrapperShell.exists());
        File workspaceDir = new File(this.temporaryFolder.getRoot(), "test/workspace");
        BuildTask buildTask = GradleRunnerUtil.executeGradleRunner(workspaceDir.getPath(), "jar");
        GradleRunnerUtil.verifyGradleRunnerOutput(buildTask);
        GradleRunnerUtil.verifyBuildOutput(projectDir.toString(), "com.liferay.blade.auth.failure-1.0.0.jar");
    }

    @Ignore
    @Test
    public void testGetSampleWithVersion70() throws Exception {
        File root = this.temporaryFolder.getRoot();
        String[] args = new String[]{"samples", "-d", root.getPath() + "/test", "-v", "7.0", "jsp-portlet"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "test/jsp-portlet");
        Assert.assertTrue((boolean)projectDir.exists());
        File buildFile = new File(projectDir, "build.gradle");
        String content = FileUtil.read((File)buildFile);
        Assert.assertTrue((boolean)buildFile.exists());
        Assert.assertTrue((String)content, (boolean)content.contains("\"com.liferay.portal.kernel\", version: \"2.0.0\""));
        String projectPath = projectDir.getPath();
        TestUtil.verifyBuild(projectPath, "com.liferay.blade.jsp.portlet-1.0.0.jar");
    }

    @Ignore
    @Test
    public void testGetSampleWithVersion71() throws Exception {
        File root = this.temporaryFolder.getRoot();
        String[] args = new String[]{"samples", "-d", root.getPath() + "/test71", "-v", "7.1", "jsp-portlet"};
        BladeTest bladeTest = this._getBladeTest();
        bladeTest.run(args);
        File projectDir = new File(root, "test71/jsp-portlet");
        Assert.assertTrue((boolean)projectDir.exists());
        File buildFile = new File(projectDir, "build.gradle");
        String content = FileUtil.read((File)buildFile);
        Assert.assertTrue((boolean)buildFile.exists());
        Assert.assertTrue((String)content, (boolean)content.contains("\"com.liferay.portal.kernel\", version: \"3.0.0\""));
        String projectPath = projectDir.getPath();
        TestUtil.verifyBuild(projectPath, "com.liferay.blade.jsp.portlet-1.0.0.jar");
    }

    @Test
    public void testListSamples() throws Exception {
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, "samples");
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((boolean)output.contains("ds-portlet"));
    }

    private static void _deleteSamplesCache() throws Exception {
        Path userHomePath = _USER_HOME_DIR.toPath();
        Path samplesCachePath = userHomePath.resolve(".blade/cache/samples");
        FileUtil.deleteDirIfExists((Path)samplesCachePath);
    }

    private BladeTest _getBladeTest() {
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        bladeTestBuilder.setExtensionsDir(this._extensionsDir.toPath());
        bladeTestBuilder.setSettingsDir(this._rootDir.toPath());
        return bladeTestBuilder.build();
    }
}

