/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.base.Throwables;

public class TransformErrorHandler {
    private final ThreadLocal<ClassNotFoundException> lastError = new ThreadLocal();
    private final String classLoaderName;

    public TransformErrorHandler(String classLoaderName) {
        this.classLoaderName = classLoaderName;
    }

    public void enterClassLoadingScope(String className) throws ClassNotFoundException {
        ClassNotFoundException lastError = this.getLastErrorAndClear();
        if (lastError != null) {
            throw new ClassNotFoundException("A pending instrumentation exception prevented loading a class " + className + " in " + this.classLoaderName, lastError);
        }
    }

    public void classLoadingError(@Nullable String className, Throwable cause) {
        ClassNotFoundException newError = new ClassNotFoundException("Failed to instrument class " + className + " in " + this.classLoaderName, cause);
        Throwable prevError = this.lastError.get();
        if (prevError == null) {
            this.lastError.set(newError);
        } else {
            TransformErrorHandler.addSuppressedIfAvailable(prevError, newError);
        }
    }

    public void exitClassLoadingScope() throws ClassNotFoundException {
        ClassNotFoundException lastError = this.getLastErrorAndClear();
        if (lastError != null) {
            throw lastError;
        }
    }

    public ClassNotFoundException exitClassLoadingScopeWithException(Throwable th) throws ClassNotFoundException {
        ClassNotFoundException pendingException = this.getLastErrorAndClear();
        if (pendingException != null) {
            TransformErrorHandler.addSuppressedIfAvailable(th, pendingException);
        }
        Throwables.propagateIfPossible(th, ClassNotFoundException.class);
        throw new RuntimeException("Unexpected exception type", th);
    }

    @Nullable
    private ClassNotFoundException getLastErrorAndClear() {
        ClassNotFoundException th = this.lastError.get();
        this.lastError.remove();
        return th;
    }

    private static void addSuppressedIfAvailable(Throwable th, Throwable suppressed) {
        try {
            th.addSuppressed(suppressed);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }
}

