/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.StringConverter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Scanner;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class StringPrintStream
extends PrintStream
implements Supplier<String> {
    private Charset _charset;
    private ByteArrayOutputStream _outputStream;

    public static StringPrintStream fromInputStream(InputStream inputStream) {
        StringPrintStream stringPrintStream = new StringPrintStream(new ByteArrayOutputStream(), Charset.defaultCharset());
        StringConverter.readInputStreamToPrintStream(inputStream, stringPrintStream);
        return stringPrintStream;
    }

    public static StringPrintStream newFilteredInstance(Collection<Predicate<String>> filters) {
        return new FilteringPrintStream(new ByteArrayOutputStream(), Charset.defaultCharset(), filters);
    }

    @SafeVarargs
    public static StringPrintStream newFilteredInstance(Predicate<String> ... filters) {
        return new FilteringPrintStream(new ByteArrayOutputStream(), Charset.defaultCharset(), Arrays.asList(filters));
    }

    public static StringPrintStream newInstance() {
        return StringPrintStream.newInstance(Charset.defaultCharset());
    }

    public static StringPrintStream newInstance(Charset charset) {
        return new StringPrintStream(new ByteArrayOutputStream(), charset);
    }

    public static String toString(InputStream inputStream) {
        StringPrintStream stringPrintStream = StringPrintStream.fromInputStream(inputStream);
        return stringPrintStream.toString();
    }

    @Override
    public String get() {
        return new String(this._outputStream.toByteArray(), this._charset);
    }

    public String toString() {
        return this.get();
    }

    private StringPrintStream(ByteArrayOutputStream outputStream, Charset charset) {
        super(outputStream);
        this._outputStream = outputStream;
        this._charset = charset;
    }

    private static class FilteringPrintStream
    extends StringPrintStream {
        private Collection<Predicate<String>> _filters;

        public FilteringPrintStream(ByteArrayOutputStream outputStream, Charset charset, Collection<Predicate<String>> filters) {
            super(outputStream, charset);
            this._filters = filters;
        }

        @Override
        public String get() {
            StringBuilder stringBuilder = new StringBuilder();
            String results = super.get();
            try (Scanner scanner = new Scanner(results);){
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    Stream<Predicate<String>> filtersStream = this._filters.stream();
                    if (filtersStream.anyMatch(predicate -> predicate.test(line))) continue;
                    stringBuilder.append(line + System.lineSeparator());
                }
            }
            return stringBuilder.toString();
        }
    }
}

