/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import com.liferay.blade.cli.util.BladeUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public class ServerUtil {
    public static Optional<Path> findAppServerPath(Path dir, String serverType) throws IOException {
        BiPredicate<Path, BasicFileAttributes> binFolderMatcher = (path, attrs) -> {
            String fileNameString = String.valueOf(path.getFileName());
            boolean match = false;
            if (fileNameString.startsWith(serverType) && Files.isDirectory(path, new LinkOption[0])) {
                match = true;
            }
            if (match) {
                if (Objects.equals(serverType, "tomcat")) {
                    Path executable = path.resolve(Paths.get("bin", ServerUtil.getTomcatExecutable()));
                    match = Files.exists(executable, new LinkOption[0]);
                } else if (Objects.equals(serverType, "jboss") || Objects.equals(serverType, "wildfly")) {
                    Path executable = path.resolve(Paths.get("bin", ServerUtil.getJBossWildflyExecutable()));
                    match = Files.exists(executable, new LinkOption[0]);
                }
            }
            return match;
        };
        try (Stream<Path> stream = Files.find(dir, Integer.MAX_VALUE, binFolderMatcher, new FileVisitOption[0]);){
            Optional<Path> optional = stream.findFirst();
            return optional;
        }
    }

    public static String getJBossWildflyExecutable() {
        String executable = "./standalone.sh";
        if (BladeUtil.isWindows()) {
            executable = "standalone.bat";
        }
        return executable;
    }

    public static String getTomcatExecutable() {
        String executable = "./catalina.sh";
        if (BladeUtil.isWindows()) {
            executable = "catalina.bat";
        }
        return executable;
    }
}

