/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.blade.cli.util.ResourceUtil;
import java.io.File;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class ReleaseUtil {
    private static final int _DEFAULT_MAX_AGE = 7;
    private static final ReleaseEntry _EMPTY_RELEASE_ENTRY = new ReleaseEntry();
    private static ReleaseUtil _releaseUtil;
    private final ReleaseEntries _releaseEntries;
    private final Map<String, ReleaseEntry> _releaseEntryMap = new HashMap<String, ReleaseEntry>();
    private final File _workspaceCacheDir = new File(System.getProperty("user.home"), ".liferay/workspace");

    public static ReleaseEntry getReleaseEntry(String releaseKey) {
        if (_releaseUtil == null) {
            ReleaseUtil.populateReleases(7);
        }
        return ReleaseUtil._releaseUtil._releaseEntryMap.getOrDefault(releaseKey, _EMPTY_RELEASE_ENTRY);
    }

    public static void populateReleases(int maxAge) {
        _releaseUtil = new ReleaseUtil(maxAge);
    }

    public static Stream<ReleaseEntry> releaseEntriesStream() {
        if (_releaseUtil == null) {
            ReleaseUtil.populateReleases(7);
        }
        return ReleaseUtil._releaseUtil._releaseEntries.stream();
    }

    public static <T> T withReleaseEntriesStream(Function<Stream<ReleaseEntry>, T> function) {
        return function.apply(ReleaseUtil.releaseEntriesStream());
    }

    public static <T> T withReleaseEntry(String releaseKey, Function<ReleaseEntry, T> function) {
        return function.apply(ReleaseUtil.getReleaseEntry(releaseKey));
    }

    private ReleaseUtil(int maxAge) {
        File releasesJsonFile = new File(this._workspaceCacheDir, "releases.json");
        this._releaseEntries = ResourceUtil.readJson(ReleaseEntries.class, ResourceUtil.getLocalFileResolver(System.getenv("BLADE_LOCAL_RELEASES_JSON_FILE")), ResourceUtil.getLocalFileResolver(releasesJsonFile, maxAge, ChronoUnit.DAYS), ResourceUtil.getURLResolver(this._workspaceCacheDir, "https://releases-cdn.liferay.com/releases.json", "releases.json"), ResourceUtil.getURLResolver(this._workspaceCacheDir, "https://releases.liferay.com/releases.json", "releases.json"), ResourceUtil.getClassLoaderResolver("/releases.json"));
        if (this._releaseEntries == null) {
            throw new RuntimeException("Could not find releases.json");
        }
        this._releaseEntryMap.clear();
        for (ReleaseEntry releaseEntry : this._releaseEntries) {
            this._releaseEntryMap.put(releaseEntry.getReleaseKey(), releaseEntry);
        }
    }

    private static class ReleaseEntries
    extends ArrayList<ReleaseEntry> {
        private ReleaseEntries() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReleaseEntry {
        @JsonProperty(value="product")
        private String _product;
        @JsonProperty(value="productGroupVersion")
        private String _productGroupVersion;
        @JsonProperty(value="productVersion")
        private String _productVersion;
        @JsonProperty(value="promoted")
        private boolean _promoted;
        @JsonProperty(value="releaseKey")
        private String _releaseKey;
        @JsonProperty(value="targetPlatformVersion")
        private String _targetPlatformVersion;
        @JsonProperty(value="url")
        private String _url;

        public String getProduct() {
            return this._product;
        }

        public String getProductGroupVersion() {
            return this._productGroupVersion;
        }

        public String getProductVersion() {
            return this._productVersion;
        }

        public String getReleaseKey() {
            return this._releaseKey;
        }

        public String getTargetPlatformVersion() {
            return this._targetPlatformVersion;
        }

        public String getUrl() {
            return this._url;
        }

        public boolean isPromoted() {
            return this._promoted;
        }
    }
}

