/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.Set;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Namer;
import org.gradle.api.internal.AbstractPolymorphicDomainObjectContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultPolymorphicNamedEntityInstantiator;
import org.gradle.api.internal.NoFactoryRegisteredForTypeException;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.util.DeprecationLogger;

public class DefaultPolymorphicDomainObjectContainer<T>
extends AbstractPolymorphicDomainObjectContainer<T>
implements ExtensiblePolymorphicDomainObjectContainer<T> {
    protected final DefaultPolymorphicNamedEntityInstantiator<T> namedEntityInstantiator;

    public DefaultPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator, Namer<? super T> namer, CollectionCallbackActionDecorator callbackDecorator) {
        super(type, instantiator, namer, callbackDecorator);
        this.namedEntityInstantiator = new DefaultPolymorphicNamedEntityInstantiator<T>(type, "this container");
    }

    @Deprecated
    public DefaultPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator) {
        this(type, instantiator, Named.Namer.forType(type), CollectionCallbackActionDecorator.NOOP);
        DeprecationLogger.nagUserOfDeprecated("Internal API constructor DefaultPolymorphicDomainObjectContainer(Class<T>, Instantiator)");
    }

    public DefaultPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator, CollectionCallbackActionDecorator callbackDecorator) {
        this(type, instantiator, Named.Namer.forType(type), callbackDecorator);
    }

    @Override
    public NamedEntityInstantiator<T> getEntityInstantiator() {
        return this.namedEntityInstantiator;
    }

    @Override
    protected T doCreate(String name) {
        try {
            return this.namedEntityInstantiator.create(name, this.getType());
        }
        catch (InvalidUserDataException e) {
            if (e.getCause() instanceof NoFactoryRegisteredForTypeException) {
                throw new InvalidUserDataException(String.format("Cannot create a %s named '%s' because this container does not support creating elements by name alone. Please specify which subtype of %s to create. Known subtypes are: %s", this.getTypeDisplayName(), name, this.getTypeDisplayName(), this.namedEntityInstantiator.getSupportedTypeNames()));
            }
            throw e;
        }
    }

    @Override
    protected <U extends T> U doCreate(String name, Class<U> type) {
        return this.namedEntityInstantiator.create(name, type);
    }

    public <U extends T> void registerDefaultFactory(NamedDomainObjectFactory<U> factory) {
        Class castType = (Class)Cast.uncheckedCast(this.getType());
        this.registerFactory(castType, factory);
    }

    @Override
    public <U extends T> void registerFactory(Class<U> type, NamedDomainObjectFactory<? extends U> factory) {
        this.namedEntityInstantiator.registerFactory(type, factory);
    }

    @Override
    public <U extends T> void registerFactory(Class<U> type, final Closure<? extends U> factory) {
        this.registerFactory(type, new NamedDomainObjectFactory<U>(){

            @Override
            public U create(String name) {
                return factory.call((Object)name);
            }
        });
    }

    @Override
    public <U extends T> void registerBinding(Class<U> type, final Class<? extends U> implementationType) {
        this.registerFactory(type, new NamedDomainObjectFactory<U>(){
            boolean named;
            {
                this.named = Named.class.isAssignableFrom(implementationType);
            }

            @Override
            public U create(String name) {
                return this.named ? DefaultPolymorphicDomainObjectContainer.this.getInstantiator().newInstance(implementationType, name) : DefaultPolymorphicDomainObjectContainer.this.getInstantiator().newInstance(implementationType, new Object[0]);
            }
        });
    }

    @Override
    public Set<? extends Class<? extends T>> getCreateableTypes() {
        return this.namedEntityInstantiator.getCreatableTypes();
    }
}

