/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import com.liferay.project.templates.extensions.ProjectTemplatesArgsExt;
import com.liferay.project.templates.extensions.util.FileUtil;
import com.liferay.project.templates.extensions.util.ProjectTemplatesUtil;
import com.liferay.project.templates.extensions.util.StringUtil;
import com.liferay.project.templates.extensions.util.Validator;
import com.liferay.project.templates.extensions.util.WorkspaceUtil;
import com.liferay.project.templates.internal.ProjectGenerator;
import java.beans.Statement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.archetype.ArchetypeGenerationResult;

public class ProjectTemplates {
    private static final String _ARCHETYPE_METADATA_XML = "META-INF/maven/archetype-metadata.xml";
    private static final Set<PosixFilePermission> _wrapperPosixFilePermissions = PosixFilePermissions.fromString("rwxrwxr--");

    public static Map<String, String> getTemplates() throws Exception {
        return ProjectTemplates.getTemplates(Collections.emptySet());
    }

    public static Map<String, String> getTemplates(Collection<File> templatesFiles) throws Exception {
        TreeMap<String, String> templates = new TreeMap<String, String>();
        for (File templatesFile : templatesFiles) {
            Throwable throwable;
            Object bundleDescription;
            Throwable throwable2;
            if (templatesFile.isDirectory()) {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(templatesFile.toPath(), "*.jar");
                throwable2 = null;
                try {
                    for (Path path : directoryStream) {
                        try {
                            String bundleSymbolicName = FileUtil.getManifestProperty(path.toFile(), "Bundle-SymbolicName");
                            String templateName = ProjectTemplatesUtil.getTemplateName(bundleSymbolicName);
                            if (templateName.startsWith("workspace") || (bundleDescription = FileUtil.getManifestProperty(path.toFile(), "Bundle-Description")) == null) continue;
                            ZipFile zipFile = new ZipFile(path.toFile());
                            throwable = null;
                            try {
                                ZipEntry zipEntry = zipFile.getEntry(_ARCHETYPE_METADATA_XML);
                                if (!Objects.nonNull(zipEntry)) continue;
                                templates.put(templateName, (String)bundleDescription);
                            }
                            catch (Throwable zipEntry) {
                                throwable = zipEntry;
                                throw zipEntry;
                            }
                            finally {
                                if (zipFile == null) continue;
                                if (throwable != null) {
                                    try {
                                        zipFile.close();
                                    }
                                    catch (Throwable zipEntry) {
                                        throwable.addSuppressed(zipEntry);
                                    }
                                    continue;
                                }
                                zipFile.close();
                            }
                        }
                        catch (IOException bundleSymbolicName) {}
                    }
                    continue;
                }
                catch (Throwable iterator) {
                    throwable2 = iterator;
                    throw iterator;
                }
                finally {
                    if (directoryStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable iterator) {
                            throwable2.addSuppressed(iterator);
                        }
                        continue;
                    }
                    directoryStream.close();
                    continue;
                }
            }
            JarFile jarFile = new JarFile(templatesFile);
            throwable2 = null;
            try {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String template;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory() || !(template = jarEntry.getName()).startsWith("com.liferay.project.templates.") || !(template = ProjectTemplatesUtil.getTemplateName(template)).startsWith("workspace")) continue;
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    bundleDescription = null;
                    try {
                        JarInputStream jarInputStream = new JarInputStream(inputStream);
                        throwable = null;
                        try {
                            Manifest manifest = jarInputStream.getManifest();
                            Attributes attributes = manifest.getMainAttributes();
                            String bundleDescription2 = attributes.getValue("Bundle-Description");
                            templates.put(template, bundleDescription2);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (jarInputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    jarInputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            jarInputStream.close();
                        }
                    }
                    catch (Throwable jarInputStream) {
                        bundleDescription = jarInputStream;
                        throw jarInputStream;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (bundleDescription != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable jarInputStream) {
                                ((Throwable)bundleDescription).addSuppressed(jarInputStream);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
            catch (Throwable enumeration) {
                throwable2 = enumeration;
                throw enumeration;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable2 != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable enumeration) {
                        throwable2.addSuppressed(enumeration);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
        List<String> archetypeJarNames = ProjectTemplatesUtil.getArchetypeJarNames();
        for (String projectTemplateJarName : archetypeJarNames) {
            String templateName = ProjectTemplatesUtil.getTemplateName(projectTemplateJarName);
            if (templateName.startsWith("workspace")) continue;
            InputStream inputStream = ProjectTemplates.class.getResourceAsStream(projectTemplateJarName);
            Throwable throwable = null;
            try {
                JarInputStream jarInputStream = new JarInputStream(inputStream);
                Throwable throwable5 = null;
                try {
                    Manifest manifest = jarInputStream.getManifest();
                    Attributes attributes = manifest.getMainAttributes();
                    String bundleDescription = attributes.getValue("Bundle-Description");
                    templates.put(templateName, bundleDescription);
                }
                catch (Throwable throwable6) {
                    throwable5 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (jarInputStream == null) continue;
                    if (throwable5 != null) {
                        try {
                            jarInputStream.close();
                        }
                        catch (Throwable throwable7) {
                            throwable5.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    jarInputStream.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return templates;
    }

    public static Map<String, String> getTemplates(File templateDirectory) throws Exception {
        return ProjectTemplates.getTemplates(Arrays.asList(templateDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ProjectTemplatesArgs projectTemplatesArgs = new ProjectTemplatesArgs();
        JCommander.Builder builder = JCommander.newBuilder();
        builder.addObject(projectTemplatesArgs);
        JCommander jCommander = builder.build();
        jCommander.setAcceptUnknownOptions(true);
        jCommander.parseWithoutValidation(args);
        String template = projectTemplatesArgs.getTemplate();
        if (template.equals("portlet")) {
            template = "mvc-portlet";
            projectTemplatesArgs.setTemplate(template);
        }
        File templateFile = ProjectTemplatesUtil.getTemplateFile(projectTemplatesArgs);
        Thread thread = Thread.currentThread();
        ClassLoader oldContextClassLoader = thread.getContextClassLoader();
        URI uri = templateFile.toURI();
        thread.setContextClassLoader(new URLClassLoader(new URL[]{uri.toURL()}));
        ProjectTemplatesArgsExt projectTemplatesArgsExt = ProjectTemplates._getProjectTemplateArgsExt(projectTemplatesArgs.getTemplate(), templateFile);
        builder = JCommander.newBuilder();
        projectTemplatesArgs = new ProjectTemplatesArgs();
        builder = builder.addObject(projectTemplatesArgs);
        if (projectTemplatesArgsExt != null) {
            builder = builder.addObject(projectTemplatesArgsExt);
        }
        jCommander = builder.build();
        if (projectTemplatesArgsExt != null) {
            projectTemplatesArgs.setProjectTemplatesArgsExt(projectTemplatesArgsExt);
        }
        try {
            Path jarPath = FileUtil.getJarPath();
            if (Files.isDirectory(jarPath, new LinkOption[0])) {
                jCommander.setProgramName(ProjectTemplates.class.getName());
            } else {
                jCommander.setProgramName("java -jar " + jarPath.getFileName());
            }
            jCommander.parse(args);
            template = projectTemplatesArgs.getTemplate();
            if (template.equals("portlet")) {
                template = "mvc-portlet";
                projectTemplatesArgs.setTemplate(template);
            }
            if (projectTemplatesArgs.isHelp()) {
                ProjectTemplates._printHelp(jCommander, projectTemplatesArgs);
            } else if (projectTemplatesArgs.isList()) {
                ProjectTemplates._printList(projectTemplatesArgs);
            } else {
                new ProjectTemplates(projectTemplatesArgs);
            }
        }
        catch (ParameterException parameterException) {
            System.err.println(parameterException.getMessage());
            ProjectTemplates._printHelp(jCommander, projectTemplatesArgs);
        }
        finally {
            thread.setContextClassLoader(oldContextClassLoader);
        }
    }

    public ProjectTemplates(ProjectTemplatesArgs projectTemplatesArgs) throws Exception {
        this(projectTemplatesArgs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectTemplates(ProjectTemplatesArgs projectTemplatesArgs, Map<String, String> propertiesMap) throws Exception {
        ProjectTemplatesArgsExt projectTemplatesArgsExt = projectTemplatesArgs.getProjectTemplatesArgsExt();
        Thread thread = Thread.currentThread();
        ClassLoader oldContextClassLoader = thread.getContextClassLoader();
        boolean changedClassLoader = false;
        try {
            Exception exception;
            if (projectTemplatesArgsExt == null) {
                File templateFile = ProjectTemplatesUtil.getTemplateFile(projectTemplatesArgs);
                URI uRI = templateFile.toURI();
                changedClassLoader = true;
                thread.setContextClassLoader(new URLClassLoader(new URL[]{uRI.toURL()}));
                projectTemplatesArgsExt = ProjectTemplates._getProjectTemplateArgsExt(projectTemplatesArgs.getTemplate(), templateFile);
                projectTemplatesArgs.setProjectTemplatesArgsExt(projectTemplatesArgsExt);
            }
            if (propertiesMap != null) {
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    this._setIfPresent(projectTemplatesArgsExt, (String)entry.getKey(), (String)entry.getValue());
                }
            }
            this._checkArgs(projectTemplatesArgs);
            File destinationDir = projectTemplatesArgs.getDestinationDir();
            ProjectGenerator projectGenerator = new ProjectGenerator();
            ArchetypeGenerationResult archetypeGenerationResult = projectGenerator.generateProject(projectTemplatesArgs, destinationDir);
            if (archetypeGenerationResult != null && (exception = archetypeGenerationResult.getCause()) != null) {
                throw exception;
            }
            Path templateDirPath = destinationDir.toPath();
            templateDirPath = templateDirPath.resolve(projectTemplatesArgs.getName());
            if (WorkspaceUtil.isWorkspace(destinationDir)) {
                Files.deleteIfExists(templateDirPath.resolve("settings.gradle"));
            } else {
                if (projectTemplatesArgs.isGradle()) {
                    FileUtil.extractDirectory("gradle-wrapper", templateDirPath);
                    FileUtil.setPosixFilePermissions(templateDirPath.resolve("gradlew"), _wrapperPosixFilePermissions);
                }
                if (projectTemplatesArgs.isMaven()) {
                    FileUtil.extractDirectory("maven-wrapper", templateDirPath);
                    FileUtil.setPosixFilePermissions(templateDirPath.resolve("mvnw"), _wrapperPosixFilePermissions);
                }
            }
            if (!projectTemplatesArgs.isGradle()) {
                FileUtil.deleteFiles(templateDirPath, "build.gradle", "settings.gradle");
            }
            if (!projectTemplatesArgs.isMaven()) {
                FileUtil.deleteFiles(templateDirPath, "pom.xml");
            }
        }
        finally {
            if (changedClassLoader) {
                thread.setContextClassLoader(oldContextClassLoader);
            }
        }
    }

    private static ProjectTemplatesArgsExt _getProjectTemplateArgsExt(String templateName, File archetypeFile) throws MalformedURLException {
        if (archetypeFile == null) {
            return null;
        }
        ServiceLoader<ProjectTemplatesArgsExt> serviceLoader = ServiceLoader.load(ProjectTemplatesArgsExt.class);
        for (ProjectTemplatesArgsExt projectTemplatesArgsExt : serviceLoader) {
            if (!templateName.equals(projectTemplatesArgsExt.getTemplateName())) continue;
            return projectTemplatesArgsExt;
        }
        return null;
    }

    private static void _printHelp(JCommander jCommander, ProjectTemplatesArgs projectTemplatesArgs) throws Exception {
        System.out.println();
        System.out.println("Create a new Liferay module project from several available templates:");
        Map<String, String> templates = ProjectTemplates.getTemplates(projectTemplatesArgs.getArchetypesDirs());
        int lineLength = 0;
        Set<String> templateNames = templates.keySet();
        Iterator<String> iterator = templateNames.iterator();
        while (iterator.hasNext()) {
            String template = iterator.next();
            if (lineLength + template.length() + 1 > jCommander.getColumnSize()) {
                System.out.println();
                lineLength = 0;
            }
            System.out.print(template);
            lineLength += template.length();
            if (!iterator.hasNext()) continue;
            System.out.print(", ");
            lineLength += 2;
        }
        System.out.println();
        System.out.println();
        jCommander.usage();
    }

    private static void _printList(ProjectTemplatesArgs projectTemplatesArgs) throws Exception {
        Map<String, String> templates = ProjectTemplates.getTemplates(projectTemplatesArgs.getArchetypesDirs());
        for (Map.Entry<String, String> entry : templates.entrySet()) {
            System.out.println(entry.getKey() + " - " + entry.getValue());
        }
    }

    private void _checkArgs(ProjectTemplatesArgs projectTemplatesArgs) {
        String[] fileNames;
        if (Validator.isNull(projectTemplatesArgs.getAuthor())) {
            throw new IllegalArgumentException("Author is required");
        }
        if (Validator.isNull(projectTemplatesArgs.getTemplate())) {
            throw new IllegalArgumentException("Template is required");
        }
        String template = projectTemplatesArgs.getTemplate();
        String name = projectTemplatesArgs.getName();
        if (Validator.isNull(name) && !template.equals("workspace")) {
            throw new IllegalArgumentException("Name is required");
        }
        File destinationDir = projectTemplatesArgs.getDestinationDir();
        if (destinationDir == null) {
            throw new IllegalArgumentException("Destination dir is required");
        }
        File dir = destinationDir;
        if (Validator.isNotNull(name)) {
            dir = new File(dir, name);
        }
        if (!projectTemplatesArgs.isForce() && dir.exists() && ((fileNames = dir.list()) == null || fileNames.length > 0)) {
            throw new IllegalArgumentException(dir + " is not empty or it is a file");
        }
        String className = projectTemplatesArgs.getClassName();
        if (Validator.isNull(className) && Validator.isNotNull(name)) {
            className = this._getClassName(name);
        }
        if (template.equals("activator") && !className.endsWith("Activator")) {
            className = className + "Activator";
        } else if ((template.equals("freemarker-portlet") || template.equals("mvc-portlet") || template.equals("npm-angular-portlet") || template.equals("npm-react-portlet") || template.equals("npm-vuejs-portlet") || template.equals("spring-mvc-portlet") || template.equals("portlet")) && className.length() > 7 && className.endsWith("Portlet")) {
            className = className.substring(0, className.length() - 7);
        }
        projectTemplatesArgs.setClassName(className);
        if (Validator.isNull(projectTemplatesArgs.getPackageName()) && Validator.isNotNull(name)) {
            projectTemplatesArgs.setPackageName(this._getPackageName(name));
        }
    }

    private String _getCapitalizedName(String name) {
        name = name.replace('-', ' ');
        name = name.replace('.', ' ');
        return StringUtil.capitalize(name, ' ');
    }

    private String _getClassName(String name) {
        name = this._getCapitalizedName(name);
        return StringUtil.removeChar(name, ' ');
    }

    private String _getPackageName(String name) {
        name = name.replace('-', '.');
        name = name.replace(' ', '.');
        return name.toLowerCase();
    }

    private boolean _hasMethod(Object object, String methodName) {
        if (object != null) {
            Class<?> clazz = object.getClass();
            Method method = null;
            try {
                method = clazz.getMethod(methodName, String.class);
            }
            catch (Exception exception) {
                return false;
            }
            return method != null;
        }
        return false;
    }

    private void _setIfPresent(Object object, String methodName, String value) {
        if (this._hasMethod(object, methodName)) {
            Statement statement = new Statement(object, methodName, new Object[]{value});
            try {
                statement.execute();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

