/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gogo.shell.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class GogoShellClient
implements AutoCloseable {
    private final DataInputStream _inputStream;
    private final DataOutputStream _outputStream;
    private final Socket _socket;

    public GogoShellClient() throws IOException {
        this("localhost", 11311);
    }

    public GogoShellClient(String host, int port) throws IOException {
        this._socket = new Socket(host, port);
        this._inputStream = new DataInputStream(this._socket.getInputStream());
        this._outputStream = new DataOutputStream(this._socket.getOutputStream());
        this._handshake();
    }

    @Override
    public void close() {
        try {
            this._socket.close();
            this._inputStream.close();
            this._outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String send(String command) throws IOException {
        byte[] bytes = command.getBytes();
        int[] codes = new int[bytes.length + 2];
        for (int i = 0; i < bytes.length; ++i) {
            codes[i] = bytes[i];
        }
        codes[bytes.length] = 13;
        codes[bytes.length + 1] = 10;
        this._sendCommand(codes);
        return this._readUntilNextGogoPrompt();
    }

    private static void _assertCondition(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    private static int[] _toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        for (Integer integer : list) {
            array[i++] = integer;
        }
        return array;
    }

    private void _handshake() throws IOException {
        this._readOneCommand();
        this._readOneCommand();
        this._readOneCommand();
        this._readOneCommand();
        this._sendCommand(255, 251, 24);
        this._readOneCommand();
        this._sendCommand(255, 250, 24, 0, 86, 84, 50, 50, 48, 255, 240);
        this._readUntilNextGogoPrompt();
    }

    private int[] _readOneCommand() throws IOException {
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        int iac = this._inputStream.read();
        GogoShellClient._assertCondition(iac == 255);
        bytes.add(iac);
        int second = this._inputStream.read();
        bytes.add(second);
        if (second == 250) {
            int option = this._inputStream.read();
            bytes.add(option);
            int code = this._inputStream.read();
            GogoShellClient._assertCondition(code == 0 || code == 1);
            bytes.add(code);
            if (code == 0) {
                throw new IllegalStateException();
            }
            if (code == 1) {
                iac = this._inputStream.read();
                GogoShellClient._assertCondition(iac == 255);
                bytes.add(iac);
                int se = this._inputStream.read();
                GogoShellClient._assertCondition(se == 240);
                bytes.add(se);
            }
        } else {
            bytes.add(this._inputStream.read());
        }
        return GogoShellClient._toIntArray(bytes);
    }

    private String _readUntilNextGogoPrompt() throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = this._inputStream.read();
        while (c != -1) {
            String string;
            sb.append((char)c);
            int length = sb.length();
            if (length > 2 && (string = sb.substring(length - 3, length)).equals("g! ")) break;
            c = this._inputStream.read();
        }
        String output = sb.substring(0, sb.length() - 3);
        return output.trim();
    }

    private void _sendCommand(int ... codes) throws IOException {
        for (int code : codes) {
            this._outputStream.write(code);
        }
    }
}

