/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;

public class LinkDownloader
implements Runnable {
    private String _link;
    private Path _target;

    public LinkDownloader(String link, Path target) {
        this._link = link;
        this._target = target;
    }

    @Override
    public void run() {
        Redirecter redirecter = new Redirecter(this._link);
        redirecter.run();
        this._save(redirecter._httpURLConnection);
    }

    private String _getFileName(URL url) {
        Path path = Paths.get(url.getFile(), new String[0]);
        return String.valueOf(path.getFileName());
    }

    private void _save(HttpURLConnection httpURLConnection) {
        Path savePath = this._target;
        try {
            if (Files.isDirectory(this._target, new LinkOption[0])) {
                savePath = this._target.resolve(this._getFileName(httpURLConnection.getURL()));
            }
            Files.copy(httpURLConnection.getInputStream(), savePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class Redirecter {
        private static final String _HTTP_FOUND = "302";
        private static final String _HTTP_MOVED = "301";
        private Map<String, List<String>> _headers;
        private HttpURLConnection _httpURLConnection;
        private String _link;
        private URL _url;

        public Redirecter(String link) {
            try {
                this._link = link;
                this._url = new URL(link);
                this._httpURLConnection = (HttpURLConnection)this._url.openConnection();
                this._headers = this._httpURLConnection.getHeaderFields();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public Boolean get() {
            for (String headerEntry : this._headers.get(null)) {
                if (!headerEntry.contains(" 302 ") && !headerEntry.contains(" 301 ")) continue;
                return true;
            }
            return false;
        }

        public void run() {
            try {
                while (this.get().booleanValue()) {
                    List<String> headers = this._headers.get("location");
                    if (headers == null) {
                        headers = this._headers.get("Location");
                    }
                    this._link = headers.get(0);
                    this._url = new URL(this._link);
                    this._httpURLConnection = (HttpURLConnection)this._url.openConnection();
                    this._headers = this._httpURLConnection.getHeaderFields();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

