/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.CopyDirVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class FileUtil {
    private static final Charset _UTF_8 = Charset.forName("UTF-8");
    private static final EnumSet<StandardOpenOption> _readOptions = EnumSet.of(StandardOpenOption.READ);
    private static final EnumSet<StandardOpenOption> _writeOptions = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);

    public static String collect(InputStream inputStream) throws IOException {
        return FileUtil._collect(new BufferedReader(new InputStreamReader(inputStream, _UTF_8)));
    }

    public static File copy(InputStream in, File file) throws IOException {
        FileUtil._copy(in, file.toPath());
        return file;
    }

    public static void copyDir(Path source, Path target) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        Files.walkFileTree(source, new CopyDirVisitor(source, target, StandardCopyOption.REPLACE_EXISTING));
    }

    public static void copyFile(Path sourcePath, Path destinationPath) throws IOException {
        FileUtil.moveFile(sourcePath, destinationPath, false);
    }

    public static void deleteDir(Path dirPath) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioException) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteDirIfExists(Path dirPath) throws IOException {
        if (Files.exists(dirPath, new LinkOption[0])) {
            FileUtil.deleteDir(dirPath);
        }
    }

    public static boolean exists(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static String getManifestProperty(File file, String name) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(name);
            return string;
        }
    }

    public static void moveFile(Path sourcePath, Path destinationPath) throws IOException {
        Files.walkFileTree(sourcePath, new CopyDirVisitor(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING, false));
    }

    public static void moveFile(Path sourcePath, Path destinationPath, boolean removeSourceFile) throws IOException {
        Files.walkFileTree(sourcePath, new CopyDirVisitor(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING, removeSourceFile));
    }

    public static String read(File file) throws IOException {
        return FileUtil._collect(file.toPath(), _UTF_8);
    }

    public static String readStreamToString(InputStream contents) throws IOException {
        return FileUtil.readStreamToString(contents, true);
    }

    public static String readStreamToString(InputStream contents, boolean closeStream) throws IOException {
        if (contents == null) {
            return null;
        }
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(contents, "UTF-8");){
            int read;
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        if (closeStream) {
            contents.close();
        }
        return out.toString();
    }

    public static void unpack(Path path, Path destinationDirPath, int stripComponents) throws IOException {
        String fileName = String.valueOf(path.getFileName());
        if (fileName.endsWith(".gz") || fileName.endsWith(".tar") || fileName.endsWith(".tgz")) {
            FileUtil._untar(path, destinationDirPath, stripComponents);
        } else if (fileName.endsWith(".zip")) {
            FileUtil.unzip(path.toFile(), destinationDirPath.toFile());
        } else {
            throw new UnsupportedOperationException("Unsupported format for " + fileName);
        }
    }

    public static void unzip(File srcFile, File destDir) throws IOException {
        FileUtil.unzip(srcFile, destDir, null);
    }

    public static void unzip(File srcFile, File destDir, String entryToStart) throws IOException {
        try (ZipFile zip = new ZipFile(srcFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            boolean foundStartEntry = false;
            if (entryToStart == null) {
                foundStartEntry = true;
            }
            while (entries.hasMoreElements()) {
                File dir;
                File f;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!foundStartEntry) {
                    foundStartEntry = entryToStart.equals(entryName);
                    continue;
                }
                if (entry.isDirectory() || entryToStart != null && !entryName.startsWith(entryToStart)) continue;
                if (entryToStart != null) {
                    entryName = entryName.replaceFirst(entryToStart, "");
                }
                if (!BladeUtil.isSafelyRelative(f = new File(destDir, entryName), destDir)) {
                    throw new ZipException("Entry " + f.getName() + " is outside of the target destination: " + destDir);
                }
                if (f.exists()) {
                    Files.delete(f.toPath());
                    if (f.exists()) {
                        throw new IOException("Could not delete " + f.getAbsolutePath());
                    }
                }
                if (!(dir = f.getParentFile()).exists() && !dir.mkdirs()) {
                    String msg = "Could not create dir: " + dir.getPath();
                    throw new IOException(msg);
                }
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(f);
                    Throwable throwable2 = null;
                    try {
                        byte[] bytes = new byte[1024];
                        int count = in.read(bytes);
                        while (count != -1) {
                            out.write(bytes, 0, count);
                            count = in.read(bytes);
                        }
                        out.flush();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    public static void unzip(InputStream inputStream, File destinationDir) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File dir;
                if (zipEntry.isDirectory()) continue;
                String entryName = zipEntry.getName();
                File f = new File(destinationDir, entryName);
                if (!BladeUtil.isSafelyRelative(f, destinationDir)) {
                    throw new ZipException("Entry " + f.getName() + " is outside of the target destination: " + destinationDir);
                }
                if (f.exists()) {
                    Files.delete(f.toPath());
                    if (f.exists()) {
                        throw new IOException("Could not delete " + f.getAbsolutePath());
                    }
                }
                if (!(dir = f.getParentFile()).exists() && !dir.mkdirs()) {
                    String msg = "Could not create dir: " + dir.getPath();
                    throw new IOException(msg);
                }
                try (FileOutputStream out = new FileOutputStream(f);){
                    byte[] bytes = new byte[1024];
                    int count = zipInputStream.read(bytes);
                    while (count != -1) {
                        out.write(bytes, 0, count);
                        count = zipInputStream.read(bytes);
                    }
                    out.flush();
                }
                zipInputStream.closeEntry();
            }
        }
    }

    private static String _collect(Path path, Charset encoding) throws IOException {
        return FileUtil._collect(FileUtil._reader(path, encoding));
    }

    private static String _collect(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        FileUtil._copy(reader, stringWriter);
        return stringWriter.toString();
    }

    private static Path _copy(InputStream in, Path path) throws IOException {
        try (FileChannel out = FileUtil._writeChannel(path);){
            FileUtil._copy(in, out);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WritableByteChannel _copy(InputStream inputStream, WritableByteChannel writableByteChannel) throws IOException {
        try {
            int size;
            ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
            byte[] buffer = byteBuffer.array();
            while ((size = inputStream.read(buffer, byteBuffer.position(), byteBuffer.remaining())) > 0) {
                byteBuffer.position(byteBuffer.position() + size);
                byteBuffer.flip();
                writableByteChannel.write(byteBuffer);
                byteBuffer.compact();
            }
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                writableByteChannel.write(byteBuffer);
            }
            WritableByteChannel writableByteChannel2 = writableByteChannel;
            return writableByteChannel2;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Writer _copy(Reader reader, Writer writer) throws IOException {
        try {
            int size;
            char[] buffer = new char[65536];
            while ((size = reader.read(buffer, 0, buffer.length)) > 0) {
                writer.write(buffer, 0, size);
            }
            Writer writer2 = writer;
            return writer2;
        }
        finally {
            reader.close();
        }
    }

    private static FileChannel _readChannel(Path path) throws IOException {
        return FileChannel.open(path, _readOptions, new FileAttribute[0]);
    }

    private static BufferedReader _reader(Path path, Charset encoding) throws IOException {
        return FileUtil._reader(FileUtil._readChannel(path), encoding);
    }

    private static BufferedReader _reader(ReadableByteChannel in, Charset encoding) throws IOException {
        return new BufferedReader(Channels.newReader(in, encoding.newDecoder(), -1));
    }

    private static Path _stripComponents(Path path, int stripComponents, boolean directory) {
        if (stripComponents > 0) {
            int nameCount = path.getNameCount();
            if (stripComponents < nameCount) {
                return path.subpath(stripComponents, nameCount);
            }
            if (directory && stripComponents == nameCount) {
                return path.relativize(path);
            }
        }
        return path;
    }

    private static void _untar(Path tarPath, Path destinationDirPath, int stripComponents) throws IOException {
        try (InputStream inputStream = Files.newInputStream(tarPath, new OpenOption[0]);
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(new GzipCompressorInputStream(inputStream));){
            TarArchiveEntry tarArchiveEntry = null;
            while ((tarArchiveEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
                Path destinationPath = destinationDirPath.resolve(FileUtil._stripComponents(Paths.get(tarArchiveEntry.getName(), new String[0]), stripComponents, tarArchiveEntry.isDirectory()));
                if (tarArchiveEntry.isDirectory()) {
                    Files.createDirectories(destinationPath, new FileAttribute[0]);
                    continue;
                }
                Files.copy(tarArchiveInputStream, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                Date lastModifiedDate = tarArchiveEntry.getLastModifiedDate();
                Files.setLastModifiedTime(destinationPath, FileTime.fromMillis(lastModifiedDate.getTime()));
            }
        }
    }

    private static FileChannel _writeChannel(Path path) throws IOException {
        return FileChannel.open(path, _writeOptions, new FileAttribute[0]);
    }
}

