/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.classfile.AnnotationDefaultAttribute;
import aQute.bnd.classfile.AnnotationInfo;
import aQute.bnd.classfile.AnnotationsAttribute;
import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.BootstrapMethodsAttribute;
import aQute.bnd.classfile.ClassFile;
import aQute.bnd.classfile.CodeAttribute;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.ConstantValueAttribute;
import aQute.bnd.classfile.DeprecatedAttribute;
import aQute.bnd.classfile.ElementValueInfo;
import aQute.bnd.classfile.EnclosingMethodAttribute;
import aQute.bnd.classfile.ExceptionsAttribute;
import aQute.bnd.classfile.FieldInfo;
import aQute.bnd.classfile.InnerClassesAttribute;
import aQute.bnd.classfile.MemberInfo;
import aQute.bnd.classfile.MethodInfo;
import aQute.bnd.classfile.MethodParametersAttribute;
import aQute.bnd.classfile.ParameterAnnotationInfo;
import aQute.bnd.classfile.ParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.SignatureAttribute;
import aQute.bnd.classfile.SourceFileAttribute;
import aQute.bnd.classfile.StackMapTableAttribute;
import aQute.bnd.classfile.TypeAnnotationInfo;
import aQute.bnd.classfile.TypeAnnotationsAttribute;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.OpCodes;
import aQute.bnd.osgi.ParameterAnnotation;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.TypeAnnotation;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.FieldSignature;
import aQute.bnd.signatures.MethodSignature;
import aQute.bnd.stream.MapStream;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.ByteBufferDataInput;
import aQute.lib.strings.Strings;
import aQute.lib.unmodifiable.Lists;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.generics.Create;
import aQute.libg.glob.Glob;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clazz {
    private static final Logger logger = LoggerFactory.getLogger(Clazz.class);
    public static final EnumSet<QUERY> HAS_ARGUMENT = EnumSet.of(QUERY.IMPLEMENTS, new QUERY[]{QUERY.EXTENDS, QUERY.IMPORTS, QUERY.NAMED, QUERY.VERSION, QUERY.ANNOTATED, QUERY.INDIRECTLY_ANNOTATED, QUERY.HIERARCHY_ANNOTATED, QUERY.HIERARCHY_INDIRECTLY_ANNOTATED});
    static final int ACC_SYNTHETIC = 4096;
    static final int ACC_BRIDGE = 64;
    public static final Comparator<Clazz> NAME_COMPARATOR = (a, b) -> a.classFile.this_class.compareTo(b.classFile.this_class);
    private boolean hasRuntimeAnnotations;
    private boolean hasClassAnnotations;
    private boolean hasDefaultConstructor;
    private Set<Descriptors.PackageRef> imports = Create.set();
    private Set<Descriptors.TypeRef> xref = new HashSet<Descriptors.TypeRef>();
    private Set<Descriptors.TypeRef> annotations;
    private int forName = 0;
    private int class$ = 0;
    private Set<Descriptors.PackageRef> api;
    private ClassFile classFile = null;
    private ConstantPool constantPool = null;
    Descriptors.TypeRef superClass;
    private Descriptors.TypeRef[] interfaces;
    ClassDef classDef;
    private Map<Descriptors.TypeRef, Integer> referred = null;
    final Analyzer analyzer;
    final String path;
    final Resource resource;
    public static final int TYPEUSE_INDEX_NONE = -1;
    public static final int TYPEUSE_TARGET_INDEX_EXTENDS = 65535;

    public Clazz(Analyzer analyzer, String path, Resource resource) {
        this.path = path;
        this.resource = resource;
        this.analyzer = analyzer;
    }

    public Set<Descriptors.TypeRef> parseClassFile() throws Exception {
        return this.parseClassFileWithCollector(null);
    }

    public Set<Descriptors.TypeRef> parseClassFile(InputStream in) throws Exception {
        return this.parseClassFile(in, null);
    }

    public Set<Descriptors.TypeRef> parseClassFileWithCollector(ClassDataCollector cd) throws Exception {
        ByteBuffer bb = this.resource.buffer();
        if (bb != null) {
            return this.parseClassFileData(ByteBufferDataInput.wrap(bb), cd);
        }
        return this.parseClassFile(this.resource.openInputStream(), cd);
    }

    public Set<Descriptors.TypeRef> parseClassFile(InputStream in, ClassDataCollector cd) throws Exception {
        try (DataInputStream din = new DataInputStream(in);){
            Set<Descriptors.TypeRef> set = this.parseClassFileData(din, cd);
            return set;
        }
    }

    private Set<Descriptors.TypeRef> parseClassFileData(DataInput in, ClassDataCollector cd) throws Exception {
        Set<Descriptors.TypeRef> xref = this.parseClassFileData(in);
        this.visitClassFile(cd);
        return xref;
    }

    private synchronized Set<Descriptors.TypeRef> parseClassFileData(DataInput in) throws Exception {
        int interfaces_count;
        String superName;
        if (this.classFile != null) {
            return this.xref;
        }
        logger.debug("parseClassFile(): path={} resource={}", (Object)this.path, (Object)this.resource);
        this.classFile = ClassFile.parseClassFile((DataInput)in);
        this.classDef = new ClassDef(this.classFile);
        this.constantPool = this.classFile.constant_pool;
        this.referred = new HashMap<Descriptors.TypeRef, Integer>(this.constantPool.size());
        if (this.classDef.isPublic()) {
            this.api = new HashSet<Descriptors.PackageRef>();
        }
        if (!this.classDef.isModule()) {
            this.referTo(this.classDef.getType(), 1);
        }
        if ((superName = this.classFile.super_class) == null) {
            if (!this.classDef.getType().isObject() && !this.classDef.isModule()) {
                throw new IOException("Class does not have a super class and is not java.lang.Object or module-info");
            }
        } else {
            this.superClass = this.analyzer.getTypeRef(superName);
            this.referTo(this.superClass, this.classFile.access);
        }
        if ((interfaces_count = this.classFile.interfaces.length) > 0) {
            this.interfaces = new Descriptors.TypeRef[interfaces_count];
            for (int i = 0; i < interfaces_count; ++i) {
                this.interfaces[i] = this.analyzer.getTypeRef(this.classFile.interfaces[i]);
                this.referTo(this.interfaces[i], this.classFile.access);
            }
        }
        int constant_pool_count = this.constantPool.size();
        block6: for (int i = 1; i < constant_pool_count; ++i) {
            switch (this.constantPool.tag(i)) {
                case 9: 
                case 10: 
                case 11: {
                    ConstantPool.AbstractRefInfo info = (ConstantPool.AbstractRefInfo)this.constantPool.entry(i);
                    this.classConstRef(this.constantPool.className(info.class_index));
                    continue block6;
                }
                case 12: {
                    ConstantPool.AbstractRefInfo info = (ConstantPool.NameAndTypeInfo)this.constantPool.entry(i);
                    this.referTo(this.constantPool.utf8(info.descriptor_index), 0);
                    continue block6;
                }
                case 16: {
                    ConstantPool.AbstractRefInfo info = (ConstantPool.MethodTypeInfo)this.constantPool.entry(i);
                    this.referTo(this.constantPool.utf8(info.descriptor_index), 0);
                    continue block6;
                }
            }
        }
        for (FieldInfo fieldInfo : this.classFile.fields) {
            this.referTo(fieldInfo.descriptor, fieldInfo.access);
            this.processAttributes(fieldInfo.attributes, Clazz.elementType(fieldInfo), fieldInfo.access);
        }
        this.forName = this.analyzer.is("-noclassforname") ? -1 : this.findMethodReference("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        this.class$ = this.findMethodReference(this.classFile.this_class, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
        for (FieldInfo fieldInfo : this.classFile.methods) {
            this.referTo(fieldInfo.descriptor, fieldInfo.access);
            Annotation.ElementType elementType = Clazz.elementType((MethodInfo)fieldInfo);
            if (elementType == Annotation.ElementType.CONSTRUCTOR && Modifier.isPublic(fieldInfo.access) && fieldInfo.descriptor.equals("()V")) {
                this.hasDefaultConstructor = true;
            }
            this.processAttributes(fieldInfo.attributes, elementType, fieldInfo.access);
        }
        this.processAttributes(this.classFile.attributes, Clazz.elementType(this.classFile), this.classFile.access);
        return this.xref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitClassFile(ClassDataCollector cd) throws Exception {
        if (cd == null) {
            return;
        }
        logger.debug("visitClassFile(): path={} resource={}", (Object)this.path, (Object)this.resource);
        if (!cd.classStart(this)) {
            return;
        }
        try {
            cd.version(this.classFile.minor_version, this.classFile.major_version);
            if (this.superClass != null) {
                cd.extendsClass(this.superClass);
            }
            if (this.interfaces != null) {
                cd.implementsInterfaces(this.interfaces);
            }
            this.referred.forEach((typeRef, access) -> {
                cd.addReference((Descriptors.TypeRef)typeRef);
                cd.referTo((Descriptors.TypeRef)typeRef, (int)access);
            });
            for (FieldInfo fieldInfo : this.classFile.fields) {
                FieldDef fieldDef = new FieldDef((MemberInfo)fieldInfo);
                cd.field(fieldDef);
                this.visitAttributes(cd, fieldDef);
            }
            for (FieldInfo fieldInfo : this.classFile.methods) {
                MethodDef methodDef = new MethodDef((MethodInfo)fieldInfo);
                cd.method(methodDef);
                this.visitAttributes(cd, methodDef);
            }
            cd.memberEnd();
            this.visitAttributes(cd, this.classDef);
        }
        finally {
            cd.classEnd();
        }
    }

    public Stream<FieldDef> fields() {
        return Arrays.stream(this.classFile.fields).map(x$0 -> new FieldDef((MemberInfo)x$0));
    }

    public Stream<MethodDef> methods() {
        return Arrays.stream(this.classFile.methods).map(x$0 -> new MethodDef((MethodInfo)x$0));
    }

    private int findMethodReference(String clazz, String methodname, String descriptor) {
        int constant_pool_count = this.constantPool.size();
        block3: for (int i = 1; i < constant_pool_count; ++i) {
            switch (this.constantPool.tag(i)) {
                case 10: 
                case 11: {
                    ConstantPool.AbstractRefInfo refInfo = (ConstantPool.AbstractRefInfo)this.constantPool.entry(i);
                    if (!clazz.equals(this.constantPool.className(refInfo.class_index))) continue block3;
                    ConstantPool.NameAndTypeInfo nameAndTypeInfo = (ConstantPool.NameAndTypeInfo)this.constantPool.entry(refInfo.name_and_type_index);
                    if (!methodname.equals(this.constantPool.utf8(nameAndTypeInfo.name_index)) || !descriptor.equals(this.constantPool.utf8(nameAndTypeInfo.descriptor_index))) continue block3;
                    return i;
                }
            }
        }
        return -1;
    }

    private void processAttributes(Attribute[] attributes, Annotation.ElementType elementType, int access_flags) {
        block30: for (Attribute attribute : attributes) {
            switch (attribute.name()) {
                case "RuntimeVisibleAnnotations": {
                    this.processAnnotations((AnnotationsAttribute)attribute, elementType, RetentionPolicy.RUNTIME, access_flags);
                    continue block30;
                }
                case "RuntimeInvisibleAnnotations": {
                    this.processAnnotations((AnnotationsAttribute)attribute, elementType, RetentionPolicy.CLASS, access_flags);
                    continue block30;
                }
                case "RuntimeVisibleParameterAnnotations": {
                    this.processParameterAnnotations((ParameterAnnotationsAttribute)attribute, Annotation.ElementType.PARAMETER, RetentionPolicy.RUNTIME, access_flags);
                    continue block30;
                }
                case "RuntimeInvisibleParameterAnnotations": {
                    this.processParameterAnnotations((ParameterAnnotationsAttribute)attribute, Annotation.ElementType.PARAMETER, RetentionPolicy.CLASS, access_flags);
                    continue block30;
                }
                case "RuntimeVisibleTypeAnnotations": {
                    this.processTypeAnnotations((TypeAnnotationsAttribute)attribute, Annotation.ElementType.TYPE_USE, RetentionPolicy.RUNTIME, access_flags);
                    continue block30;
                }
                case "RuntimeInvisibleTypeAnnotations": {
                    this.processTypeAnnotations((TypeAnnotationsAttribute)attribute, Annotation.ElementType.TYPE_USE, RetentionPolicy.CLASS, access_flags);
                    continue block30;
                }
                case "EnclosingMethod": {
                    this.processEnclosingMethod((EnclosingMethodAttribute)attribute);
                    continue block30;
                }
                case "Code": {
                    this.processCode((CodeAttribute)attribute, elementType);
                    continue block30;
                }
                case "Signature": {
                    this.processSignature((SignatureAttribute)attribute, elementType, access_flags);
                    continue block30;
                }
                case "AnnotationDefault": {
                    this.processAnnotationDefault((AnnotationDefaultAttribute)attribute, elementType, access_flags);
                    continue block30;
                }
                case "Exceptions": {
                    this.processExceptions((ExceptionsAttribute)attribute, access_flags);
                    continue block30;
                }
                case "BootstrapMethods": {
                    this.processBootstrapMethods((BootstrapMethodsAttribute)attribute);
                    continue block30;
                }
                case "StackMapTable": {
                    this.processStackMapTable((StackMapTableAttribute)attribute);
                    continue block30;
                }
            }
        }
    }

    private void visitAttributes(ClassDataCollector cd, ElementDef elementDef) throws Exception {
        int access_flags = elementDef.getAccess();
        Annotation.ElementType elementType = elementDef.elementType();
        if (elementDef.isDeprecated()) {
            cd.deprecated();
        }
        block30: for (Attribute attribute : elementDef.attributes()) {
            switch (attribute.name()) {
                case "RuntimeVisibleAnnotations": {
                    this.visitAnnotations(cd, (AnnotationsAttribute)attribute, elementType, RetentionPolicy.RUNTIME, access_flags);
                    continue block30;
                }
                case "RuntimeInvisibleAnnotations": {
                    this.visitAnnotations(cd, (AnnotationsAttribute)attribute, elementType, RetentionPolicy.CLASS, access_flags);
                    continue block30;
                }
                case "RuntimeVisibleParameterAnnotations": {
                    this.visitParameterAnnotations(cd, (ParameterAnnotationsAttribute)attribute, Annotation.ElementType.PARAMETER, RetentionPolicy.RUNTIME, access_flags);
                    continue block30;
                }
                case "RuntimeInvisibleParameterAnnotations": {
                    this.visitParameterAnnotations(cd, (ParameterAnnotationsAttribute)attribute, Annotation.ElementType.PARAMETER, RetentionPolicy.CLASS, access_flags);
                    continue block30;
                }
                case "RuntimeVisibleTypeAnnotations": {
                    this.visitTypeAnnotations(cd, (TypeAnnotationsAttribute)attribute, Annotation.ElementType.TYPE_USE, RetentionPolicy.RUNTIME, access_flags);
                    continue block30;
                }
                case "RuntimeInvisibleTypeAnnotations": {
                    this.visitTypeAnnotations(cd, (TypeAnnotationsAttribute)attribute, Annotation.ElementType.TYPE_USE, RetentionPolicy.CLASS, access_flags);
                    continue block30;
                }
                case "InnerClasses": {
                    this.visitInnerClasses(cd, (InnerClassesAttribute)attribute);
                    continue block30;
                }
                case "EnclosingMethod": {
                    this.visitEnclosingMethod(cd, (EnclosingMethodAttribute)attribute);
                    continue block30;
                }
                case "Code": {
                    this.visitCode(cd, (CodeAttribute)attribute, elementType);
                    continue block30;
                }
                case "Signature": {
                    this.visitSignature(cd, (SignatureAttribute)attribute);
                    continue block30;
                }
                case "ConstantValue": {
                    this.visitConstantValue(cd, (ConstantValueAttribute)attribute);
                    continue block30;
                }
                case "AnnotationDefault": {
                    this.visitAnnotationDefault(cd, (AnnotationDefaultAttribute)attribute, elementDef);
                    continue block30;
                }
                case "MethodParameters": {
                    this.visitMethodParameters(cd, (MethodParametersAttribute)attribute, elementDef);
                    continue block30;
                }
            }
        }
    }

    private void processEnclosingMethod(EnclosingMethodAttribute attribute) {
        this.classConstRef(attribute.class_name);
    }

    private void visitEnclosingMethod(ClassDataCollector cd, EnclosingMethodAttribute attribute) {
        Descriptors.TypeRef cName = this.analyzer.getTypeRef(attribute.class_name);
        cd.enclosingMethod(cName, attribute.method_name, attribute.method_descriptor);
    }

    private void visitInnerClasses(ClassDataCollector cd, InnerClassesAttribute attribute) throws Exception {
        for (InnerClassesAttribute.InnerClass innerClassInfo : attribute.classes) {
            Descriptors.TypeRef innerClass = this.analyzer.getTypeRef(innerClassInfo.inner_class);
            String outerClassName = innerClassInfo.outer_class;
            Descriptors.TypeRef outerClass = outerClassName != null ? this.analyzer.getTypeRef(outerClassName) : null;
            cd.innerClass(innerClass, outerClass, innerClassInfo.inner_name, innerClassInfo.inner_access);
        }
    }

    private void processSignature(SignatureAttribute attribute, Annotation.ElementType elementType, int access_flags) {
        ClassSignature sig;
        if (Clazz.isSynthetic(access_flags)) {
            return;
        }
        String signature = attribute.signature;
        switch (elementType) {
            case ANNOTATION_TYPE: 
            case TYPE: 
            case PACKAGE: {
                sig = this.analyzer.getClassSignature(signature);
                break;
            }
            case FIELD: {
                sig = this.analyzer.getFieldSignature(signature);
                break;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                sig = this.analyzer.getMethodSignature(signature);
                break;
            }
            default: {
                throw new IllegalArgumentException("Signature \"" + signature + "\" found for unknown element type: " + (Object)((Object)elementType));
            }
        }
        Set binaryRefs = sig.erasedBinaryReferences();
        for (String binary : binaryRefs) {
            Descriptors.TypeRef ref = this.analyzer.getTypeRef(binary);
            this.referTo(ref, access_flags);
        }
    }

    private void visitSignature(ClassDataCollector cd, SignatureAttribute attribute) {
        String signature = attribute.signature;
        cd.signature(signature);
    }

    private void processAnnotationDefault(AnnotationDefaultAttribute attribute, Annotation.ElementType elementType, int access_flags) {
        Object value = attribute.value;
        this.processElementValue(value, elementType, RetentionPolicy.RUNTIME, access_flags);
    }

    private void visitAnnotationDefault(ClassDataCollector cd, AnnotationDefaultAttribute attribute, ElementDef elementDef) {
        MethodDef methodDef = (MethodDef)elementDef;
        Object value = this.annotationDefault(attribute, methodDef.getAccess());
        cd.annotationDefault(methodDef, value);
    }

    static Annotation.ElementType elementType(FieldInfo fieldInfo) {
        return Annotation.ElementType.FIELD;
    }

    static Annotation.ElementType elementType(MethodInfo methodInfo) {
        return methodInfo.name.equals("<init>") ? Annotation.ElementType.CONSTRUCTOR : Annotation.ElementType.METHOD;
    }

    static Annotation.ElementType elementType(ClassFile classFile) {
        if (Clazz.isAnnotation(classFile.access)) {
            return Annotation.ElementType.ANNOTATION_TYPE;
        }
        if (Clazz.isModule(classFile.access)) {
            return Annotation.ElementType.MODULE;
        }
        return classFile.this_class.endsWith("/package-info") ? Annotation.ElementType.PACKAGE : Annotation.ElementType.TYPE;
    }

    Object annotationDefault(AnnotationDefaultAttribute attribute, int access_flags) {
        try {
            return this.newElementValue(attribute.value, Annotation.ElementType.METHOD, RetentionPolicy.RUNTIME, access_flags);
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
    }

    private void visitConstantValue(ClassDataCollector cd, ConstantValueAttribute attribute) {
        Object value = attribute.value;
        cd.constant(value);
    }

    private void processExceptions(ExceptionsAttribute attribute, int access_flags) {
        for (String exception : attribute.exceptions) {
            Descriptors.TypeRef clazz = this.analyzer.getTypeRef(exception);
            this.referTo(clazz, access_flags);
        }
    }

    private void visitMethodParameters(ClassDataCollector cd, MethodParametersAttribute attribute, ElementDef elementDef) {
        MethodDef method = (MethodDef)elementDef;
        cd.methodParameters(method, MethodParameter.parameters(attribute));
    }

    private void processCode(CodeAttribute attribute, Annotation.ElementType elementType) {
        ByteBuffer code = attribute.code.duplicate();
        code.rewind();
        int lastReference = -1;
        block10: while (code.hasRemaining()) {
            int instruction = Byte.toUnsignedInt(code.get());
            switch (instruction) {
                case 18: {
                    lastReference = Byte.toUnsignedInt(code.get());
                    this.classConstRef(lastReference);
                    continue block10;
                }
                case 19: {
                    lastReference = Short.toUnsignedInt(code.getShort());
                    this.classConstRef(lastReference);
                    continue block10;
                }
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    int class_index = Short.toUnsignedInt(code.getShort());
                    this.classConstRef(class_index);
                    lastReference = -1;
                    continue block10;
                }
                case 197: {
                    int class_index = Short.toUnsignedInt(code.getShort());
                    this.classConstRef(class_index);
                    code.get();
                    lastReference = -1;
                    continue block10;
                }
                case 184: {
                    String fqn;
                    int method_ref_index = Short.toUnsignedInt(code.getShort());
                    if (!(method_ref_index != this.forName && method_ref_index != this.class$ || lastReference == -1 || this.constantPool.tag(lastReference) != 8 || (fqn = this.constantPool.string(lastReference)).equals("class") || fqn.indexOf(46) <= 0)) {
                        Descriptors.TypeRef typeRef = this.analyzer.getTypeRefFromFQN(fqn);
                        this.referTo(typeRef, 0);
                    }
                    lastReference = -1;
                    continue block10;
                }
                case 196: {
                    int opcode = Byte.toUnsignedInt(code.get());
                    code.position(code.position() + (opcode == 132 ? 4 : 2));
                    lastReference = -1;
                    continue block10;
                }
                case 170: {
                    int rem = code.position() % 4;
                    if (rem != 0) {
                        code.position(code.position() + 4 - rem);
                    }
                    int deflt = code.getInt();
                    int low = code.getInt();
                    int high = code.getInt();
                    code.position(code.position() + (high - low + 1) * 4);
                    lastReference = -1;
                    continue block10;
                }
                case 171: {
                    int rem = code.position() % 4;
                    if (rem != 0) {
                        code.position(code.position() + 4 - rem);
                    }
                    int deflt = code.getInt();
                    int npairs = code.getInt();
                    code.position(code.position() + npairs * 8);
                    lastReference = -1;
                    continue block10;
                }
            }
            code.position(code.position() + OpCodes.OFFSETS[instruction]);
            lastReference = -1;
        }
        for (CodeAttribute.ExceptionHandler exceptionHandler : attribute.exception_table) {
            this.classConstRef(exceptionHandler.catch_type);
        }
        this.processAttributes(attribute.attributes, elementType, 0);
    }

    private void visitCode(ClassDataCollector cd, CodeAttribute attribute, Annotation.ElementType elementType) throws Exception {
        ByteBuffer code = attribute.code.duplicate();
        code.rewind();
        block9: while (code.hasRemaining()) {
            int instruction = Byte.toUnsignedInt(code.get());
            switch (instruction) {
                case 183: {
                    int method_ref_index = Short.toUnsignedInt(code.getShort());
                    this.visitReferenceMethod(cd, method_ref_index);
                    continue block9;
                }
                case 182: {
                    int method_ref_index = Short.toUnsignedInt(code.getShort());
                    this.visitReferenceMethod(cd, method_ref_index);
                    continue block9;
                }
                case 185: {
                    int method_ref_index = Short.toUnsignedInt(code.getShort());
                    this.visitReferenceMethod(cd, method_ref_index);
                    code.position(code.position() + 2);
                    continue block9;
                }
                case 184: {
                    int method_ref_index = Short.toUnsignedInt(code.getShort());
                    this.visitReferenceMethod(cd, method_ref_index);
                    continue block9;
                }
                case 196: {
                    int opcode = Byte.toUnsignedInt(code.get());
                    code.position(code.position() + (opcode == 132 ? 4 : 2));
                    continue block9;
                }
                case 170: {
                    int rem = code.position() % 4;
                    if (rem != 0) {
                        code.position(code.position() + 4 - rem);
                    }
                    int deflt = code.getInt();
                    int low = code.getInt();
                    int high = code.getInt();
                    code.position(code.position() + (high - low + 1) * 4);
                    continue block9;
                }
                case 171: {
                    int rem = code.position() % 4;
                    if (rem != 0) {
                        code.position(code.position() + 4 - rem);
                    }
                    int deflt = code.getInt();
                    int npairs = code.getInt();
                    code.position(code.position() + npairs * 8);
                    continue block9;
                }
            }
            code.position(code.position() + OpCodes.OFFSETS[instruction]);
        }
        CodeDef codeDef = new CodeDef(attribute, elementType);
        this.visitAttributes(cd, codeDef);
    }

    private void visitReferenceMethod(ClassDataCollector cd, int method_ref_index) {
        ConstantPool.AbstractRefInfo refInfo = (ConstantPool.AbstractRefInfo)this.constantPool.entry(method_ref_index);
        String className = this.constantPool.className(refInfo.class_index);
        ConstantPool.NameAndTypeInfo nameAndTypeInfo = (ConstantPool.NameAndTypeInfo)this.constantPool.entry(refInfo.name_and_type_index);
        String method = this.constantPool.utf8(nameAndTypeInfo.name_index);
        String descriptor = this.constantPool.utf8(nameAndTypeInfo.descriptor_index);
        Descriptors.TypeRef type = this.analyzer.getTypeRef(className);
        cd.referenceMethod(0, type, method, descriptor);
    }

    private void processParameterAnnotations(ParameterAnnotationsAttribute attribute, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        for (ParameterAnnotationInfo parameterAnnotationInfo : attribute.parameter_annotations) {
            for (AnnotationInfo annotationInfo : parameterAnnotationInfo.annotations) {
                this.processAnnotation(annotationInfo, elementType, policy, access_flags);
            }
        }
    }

    private void visitParameterAnnotations(ClassDataCollector cd, ParameterAnnotationsAttribute attribute, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) throws Exception {
        for (ParameterAnnotationInfo parameterAnnotationInfo : attribute.parameter_annotations) {
            if (parameterAnnotationInfo.annotations.length <= 0) continue;
            cd.parameter(parameterAnnotationInfo.parameter);
            for (AnnotationInfo annotationInfo : parameterAnnotationInfo.annotations) {
                Annotation annotation = this.newAnnotation(annotationInfo, elementType, policy, access_flags);
                cd.annotation(annotation);
            }
        }
    }

    private void processTypeAnnotations(TypeAnnotationsAttribute attribute, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        for (TypeAnnotationInfo typeAnnotationInfo : attribute.type_annotations) {
            this.processAnnotation((AnnotationInfo)typeAnnotationInfo, elementType, policy, access_flags);
        }
    }

    private void visitTypeAnnotations(ClassDataCollector cd, TypeAnnotationsAttribute attribute, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) throws Exception {
        for (TypeAnnotationInfo typeAnnotationInfo : attribute.type_annotations) {
            cd.typeuse(typeAnnotationInfo.target_type, typeAnnotationInfo.target_index, typeAnnotationInfo.target_info, typeAnnotationInfo.type_path);
            Annotation annotation = this.newAnnotation((AnnotationInfo)typeAnnotationInfo, elementType, policy, access_flags);
            cd.annotation(annotation);
        }
    }

    private void processAnnotations(AnnotationsAttribute attribute, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        for (AnnotationInfo annotationInfo : attribute.annotations) {
            this.processAnnotation(annotationInfo, elementType, policy, access_flags);
        }
    }

    private void visitAnnotations(ClassDataCollector cd, AnnotationsAttribute attribute, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) throws Exception {
        for (AnnotationInfo annotationInfo : attribute.annotations) {
            Annotation annotation = this.newAnnotation(annotationInfo, elementType, policy, access_flags);
            cd.annotation(annotation);
        }
    }

    private void processAnnotation(AnnotationInfo annotationInfo, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        if (this.annotations == null) {
            this.annotations = new HashSet<Descriptors.TypeRef>();
        }
        String typeName = annotationInfo.type;
        Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(typeName);
        this.annotations.add(typeRef);
        if (policy == RetentionPolicy.RUNTIME) {
            this.referTo(typeRef, 0);
            this.hasRuntimeAnnotations = true;
            if (this.api != null && (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags))) {
                this.api.add(typeRef.getPackageRef());
            }
        } else {
            this.hasClassAnnotations = true;
        }
        for (ElementValueInfo elementValueInfo : annotationInfo.values) {
            this.processElementValue(elementValueInfo.value, elementType, policy, access_flags);
        }
    }

    Annotation newAnnotation(AnnotationInfo annotationInfo, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        String typeName = annotationInfo.type;
        Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(typeName);
        Map<String, Object> elements = this.annotationValues(annotationInfo.values, elementType, policy, access_flags);
        return new Annotation(typeRef, elements, elementType, policy);
    }

    ParameterAnnotation newParameterAnnotation(int parameter, AnnotationInfo annotationInfo, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        String typeName = annotationInfo.type;
        Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(typeName);
        Map<String, Object> elements = this.annotationValues(annotationInfo.values, elementType, policy, access_flags);
        return new ParameterAnnotation(parameter, typeRef, elements, elementType, policy);
    }

    TypeAnnotation newTypeAnnotation(TypeAnnotationInfo annotationInfo, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        String typeName = annotationInfo.type;
        Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(typeName);
        Map<String, Object> elements = this.annotationValues(annotationInfo.values, elementType, policy, access_flags);
        return new TypeAnnotation(annotationInfo.target_type, annotationInfo.target_info, annotationInfo.target_index, annotationInfo.type_path, typeRef, elements, elementType, policy);
    }

    private Map<String, Object> annotationValues(ElementValueInfo[] values, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        LinkedHashMap<String, Object> elements = new LinkedHashMap<String, Object>();
        for (ElementValueInfo elementValueInfo : values) {
            String element = elementValueInfo.name;
            Object value = this.newElementValue(elementValueInfo.value, elementType, policy, access_flags);
            elements.put(element, value);
        }
        return elements;
    }

    private void processElementValue(Object value, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        block5: {
            block6: {
                Descriptors.PackageRef packageRef;
                block4: {
                    if (!(value instanceof ElementValueInfo.EnumConst)) break block4;
                    if (policy != RetentionPolicy.RUNTIME) break block5;
                    ElementValueInfo.EnumConst enumConst = (ElementValueInfo.EnumConst)value;
                    Descriptors.TypeRef name = this.analyzer.getTypeRef(enumConst.type);
                    this.referTo(name, 0);
                    if (this.api == null || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags)) break block5;
                    this.api.add(name.getPackageRef());
                    break block5;
                }
                if (!(value instanceof ElementValueInfo.ResultConst)) break block6;
                if (policy != RetentionPolicy.RUNTIME) break block5;
                ElementValueInfo.ResultConst resultConst = (ElementValueInfo.ResultConst)value;
                Descriptors.TypeRef name = this.analyzer.getTypeRef(resultConst.descriptor);
                if (name.isPrimitive() || (packageRef = name.getPackageRef()).isPrimitivePackage()) break block5;
                this.referTo(name, 0);
                if (this.api == null || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags)) break block5;
                this.api.add(packageRef);
                break block5;
            }
            if (value instanceof AnnotationInfo) {
                this.processAnnotation((AnnotationInfo)value, elementType, policy, access_flags);
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                int num_values = array.length;
                for (int i = 0; i < num_values; ++i) {
                    this.processElementValue(array[i], elementType, policy, access_flags);
                }
            }
        }
    }

    private Object newElementValue(Object value, Annotation.ElementType elementType, RetentionPolicy policy, int access_flags) {
        if (value instanceof ElementValueInfo.EnumConst) {
            ElementValueInfo.EnumConst enumConst = (ElementValueInfo.EnumConst)value;
            return enumConst.name;
        }
        if (value instanceof ElementValueInfo.ResultConst) {
            ElementValueInfo.ResultConst resultConst = (ElementValueInfo.ResultConst)value;
            Descriptors.TypeRef name = this.analyzer.getTypeRef(resultConst.descriptor);
            return name;
        }
        if (value instanceof AnnotationInfo) {
            return this.newAnnotation((AnnotationInfo)value, elementType, policy, access_flags);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int num_values = array.length;
            Object[] result = new Object[num_values];
            for (int i = 0; i < num_values; ++i) {
                result[i] = this.newElementValue(array[i], elementType, policy, access_flags);
            }
            return result;
        }
        return value;
    }

    private void processBootstrapMethods(BootstrapMethodsAttribute attribute) {
        for (BootstrapMethodsAttribute.BootstrapMethod bootstrapMethod : attribute.bootstrap_methods) {
            for (int bootstrap_argument : bootstrapMethod.bootstrap_arguments) {
                this.classConstRef(bootstrap_argument);
            }
        }
    }

    private void processStackMapTable(StackMapTableAttribute attribute) {
        block6: for (StackMapTableAttribute.StackMapFrame stackMapFrame : attribute.entries) {
            switch (stackMapFrame.type()) {
                case 127: {
                    StackMapTableAttribute.SameLocals1StackItemFrame sameLocals1StackItemFrame = (StackMapTableAttribute.SameLocals1StackItemFrame)stackMapFrame;
                    this.verification_type_info(sameLocals1StackItemFrame.stack);
                    continue block6;
                }
                case 247: {
                    StackMapTableAttribute.SameLocals1StackItemFrameExtended sameLocals1StackItemFrameExtended = (StackMapTableAttribute.SameLocals1StackItemFrameExtended)stackMapFrame;
                    this.verification_type_info(sameLocals1StackItemFrameExtended.stack);
                    continue block6;
                }
                case 254: {
                    StackMapTableAttribute.AppendFrame appendFrame = (StackMapTableAttribute.AppendFrame)stackMapFrame;
                    for (StackMapTableAttribute.VerificationTypeInfo verificationTypeInfo : appendFrame.locals) {
                        this.verification_type_info(verificationTypeInfo);
                    }
                    continue block6;
                }
                case 255: {
                    StackMapTableAttribute.FullFrame fullFrame = (StackMapTableAttribute.FullFrame)stackMapFrame;
                    for (StackMapTableAttribute.VerificationTypeInfo verificationTypeInfo : fullFrame.locals) {
                        this.verification_type_info(verificationTypeInfo);
                    }
                    for (StackMapTableAttribute.VerificationTypeInfo verificationTypeInfo : fullFrame.stack) {
                        this.verification_type_info(verificationTypeInfo);
                    }
                    continue block6;
                }
            }
        }
    }

    private void verification_type_info(StackMapTableAttribute.VerificationTypeInfo verificationTypeInfo) {
        switch (verificationTypeInfo.tag) {
            case 7: {
                StackMapTableAttribute.ObjectVariableInfo objectVariableInfo = (StackMapTableAttribute.ObjectVariableInfo)verificationTypeInfo;
                this.classConstRef(objectVariableInfo.type);
            }
        }
    }

    private void referTo(Descriptors.TypeRef typeRef, int modifiers) {
        this.xref.add(typeRef);
        if (typeRef.isPrimitive()) {
            return;
        }
        Descriptors.PackageRef packageRef = typeRef.getPackageRef();
        if (packageRef.isPrimitivePackage()) {
            return;
        }
        this.imports.add(packageRef);
        if (this.api != null && (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers))) {
            this.api.add(packageRef);
        }
        this.referred.merge(typeRef, modifiers, (o, n) -> {
            int new_modifiers;
            int old_modifiers = o;
            if (old_modifiers == (new_modifiers = n.intValue()) || new_modifiers == 0) {
                return o;
            }
            if (old_modifiers == 0) {
                return n;
            }
            return old_modifiers | new_modifiers;
        });
    }

    private void referTo(String descriptor, int modifiers) {
        char c = descriptor.charAt(0);
        if (c != '(' && c != 'L' && c != '[' && c != '<' && c != 'T') {
            return;
        }
        MethodSignature sig = c == '(' || c == '<' ? this.analyzer.getMethodSignature(descriptor) : this.analyzer.getFieldSignature(descriptor);
        Set binaryRefs = sig.erasedBinaryReferences();
        for (String binary : binaryRefs) {
            Descriptors.TypeRef ref = this.analyzer.getTypeRef(binary);
            this.referTo(ref, modifiers);
        }
    }

    @Deprecated
    public void parseDescriptor(String descriptor, int modifiers) {
        if (this.referred == null) {
            this.referred = new HashMap<Descriptors.TypeRef, Integer>();
        }
        this.referTo(descriptor, modifiers);
    }

    public Set<Descriptors.PackageRef> getReferred() {
        return this.imports;
    }

    public String getAbsolutePath() {
        return this.path;
    }

    @Deprecated
    public void reset() {
    }

    private Stream<Clazz> hierarchyStream(final Analyzer analyzer) {
        Objects.requireNonNull(analyzer);
        Spliterators.AbstractSpliterator<Clazz> spliterator = new Spliterators.AbstractSpliterator<Clazz>(Long.MAX_VALUE, 273){
            private Clazz clazz;
            {
                super(x0, x1);
                this.clazz = Clazz.this;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Clazz> action) {
                Objects.requireNonNull(action);
                if (this.clazz == null) {
                    return false;
                }
                action.accept(this.clazz);
                Descriptors.TypeRef type = this.clazz.superClass;
                if (type == null) {
                    this.clazz = null;
                } else {
                    try {
                        this.clazz = analyzer.findClass(type);
                    }
                    catch (Exception e) {
                        throw Exceptions.duck((Throwable)e);
                    }
                    if (this.clazz == null) {
                        analyzer.warning("While traversing the type tree for %s cannot find class %s", Clazz.this, type);
                    }
                }
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    private Stream<Descriptors.TypeRef> typeStream(final Analyzer analyzer, final Function<? super Clazz, Collection<? extends Descriptors.TypeRef>> func, final Set<Descriptors.TypeRef> visited) {
        Objects.requireNonNull(analyzer);
        Objects.requireNonNull(func);
        Spliterators.AbstractSpliterator<Descriptors.TypeRef> spliterator = new Spliterators.AbstractSpliterator<Descriptors.TypeRef>(Long.MAX_VALUE, 273){
            private final Deque<Descriptors.TypeRef> queue;
            private final Set<Descriptors.TypeRef> seen;
            {
                super(x0, x1);
                this.queue = new ArrayDeque<Descriptors.TypeRef>((Collection)func.apply(Clazz.this));
                this.seen = visited != null ? visited : new HashSet();
            }

            @Override
            public boolean tryAdvance(Consumer<? super Descriptors.TypeRef> action) {
                Descriptors.TypeRef type;
                Objects.requireNonNull(action);
                do {
                    if ((type = this.queue.poll()) != null) continue;
                    return false;
                } while (this.seen.contains(type));
                this.seen.add(type);
                action.accept(type);
                if (visited != null) {
                    Clazz clazz;
                    try {
                        clazz = analyzer.findClass(type);
                    }
                    catch (Exception e) {
                        throw Exceptions.duck((Throwable)e);
                    }
                    if (clazz == null) {
                        analyzer.warning("While traversing the type tree for %s cannot find class %s", Clazz.this, type);
                    } else {
                        this.queue.addAll((Collection)func.apply(clazz));
                    }
                }
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public boolean is(QUERY query, Instruction instr, Analyzer analyzer) throws Exception {
        switch (query) {
            case ANY: {
                return true;
            }
            case NAMED: {
                Objects.requireNonNull(instr);
                return instr.matches(this.getClassName().getDottedOnly()) ^ instr.isNegated();
            }
            case VERSION: {
                Objects.requireNonNull(instr);
                String v = this.classFile.major_version + "." + this.classFile.minor_version;
                return instr.matches(v) ^ instr.isNegated();
            }
            case IMPLEMENTS: {
                Objects.requireNonNull(instr);
                HashSet visited = new HashSet();
                return this.hierarchyStream(analyzer).flatMap(c -> c.typeStream(analyzer, Clazz::interfaces, visited)).map(Descriptors.TypeRef::getDottedOnly).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case EXTENDS: {
                Objects.requireNonNull(instr);
                return this.hierarchyStream(analyzer).skip(1L).map(Clazz::getClassName).map(Descriptors.TypeRef::getDottedOnly).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case PUBLIC: {
                return this.isPublic();
            }
            case CONCRETE: {
                return !this.isAbstract();
            }
            case ANNOTATED: {
                Objects.requireNonNull(instr);
                return this.typeStream(analyzer, Clazz::annotations, null).map(Descriptors.TypeRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case INDIRECTLY_ANNOTATED: {
                Objects.requireNonNull(instr);
                return this.typeStream(analyzer, Clazz::annotations, new HashSet<Descriptors.TypeRef>()).map(Descriptors.TypeRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case HIERARCHY_ANNOTATED: {
                Objects.requireNonNull(instr);
                return this.hierarchyStream(analyzer).flatMap(c -> c.typeStream(analyzer, Clazz::annotations, null)).map(Descriptors.TypeRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case HIERARCHY_INDIRECTLY_ANNOTATED: {
                Objects.requireNonNull(instr);
                HashSet visited = new HashSet();
                return this.hierarchyStream(analyzer).flatMap(c -> c.typeStream(analyzer, Clazz::annotations, visited)).map(Descriptors.TypeRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case RUNTIMEANNOTATIONS: {
                return this.hasRuntimeAnnotations;
            }
            case CLASSANNOTATIONS: {
                return this.hasClassAnnotations;
            }
            case ABSTRACT: {
                return this.isAbstract();
            }
            case IMPORTS: {
                Objects.requireNonNull(instr);
                return this.hierarchyStream(analyzer).map(Clazz::getReferred).flatMap(Collection::stream).distinct().map(Descriptors.PackageRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case DEFAULT_CONSTRUCTOR: {
                return this.hasPublicNoArgsConstructor();
            }
            case STATIC: {
                return !this.isInnerClass();
            }
            case INNER: {
                return this.isInnerClass();
            }
        }
        return instr == null ? false : instr.isNegated();
    }

    public String toString() {
        return this.classDef != null ? this.classDef.getName() : this.resource.toString();
    }

    public boolean isPublic() {
        return this.classDef.isPublic();
    }

    public boolean isProtected() {
        return this.classDef.isProtected();
    }

    public boolean isEnum() {
        return this.classDef.isEnum() && this.superClass.getBinary().equals("java/lang/Enum");
    }

    public boolean isSynthetic() {
        return this.classDef.isSynthetic();
    }

    static boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    public boolean isModule() {
        return this.classDef.isModule();
    }

    public boolean isPackageInfo() {
        return this.classDef.isPackageInfo();
    }

    static boolean isModule(int access) {
        return (access & 0x8000) != 0;
    }

    static boolean isEnum(int access) {
        return (access & 0x4000) != 0;
    }

    public JAVA getFormat() {
        return JAVA.format(this.classFile.major_version);
    }

    public static String objectDescriptorToFQN(String string) {
        if ((string.startsWith("L") || string.startsWith("T")) && string.endsWith(";")) {
            return string.substring(1, string.length() - 1).replace('/', '.');
        }
        switch (string.charAt(0)) {
            case 'V': {
                return "void";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'S': {
                return "short";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case 'Z': {
                return "boolean";
            }
            case '[': {
                return Clazz.objectDescriptorToFQN(string.substring(1)) + "[]";
            }
        }
        throw new IllegalArgumentException("Invalid type character in descriptor " + string);
    }

    public static String unCamel(String id) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            boolean tolower;
            int n;
            char c = id.charAt(i);
            if (c == '_' || c == '$' || c == '-' || c == '.') {
                if (out.length() <= 0 || Character.isWhitespace(out.charAt(out.length() - 1))) continue;
                out.append(' ');
                continue;
            }
            for (n = i; n < id.length() && Character.isUpperCase(id.charAt(n)); ++n) {
            }
            if (n == i) {
                out.append(id.charAt(i));
                continue;
            }
            boolean bl = tolower = n - i == 1;
            if (i > 0 && !Character.isWhitespace(out.charAt(out.length() - 1))) {
                out.append(' ');
            }
            while (i < n) {
                if (tolower) {
                    out.append(Character.toLowerCase(id.charAt(i)));
                } else {
                    out.append(id.charAt(i));
                }
                ++i;
            }
            --i;
        }
        if (id.startsWith(".")) {
            out.append(" *");
        }
        out.replace(0, 1, Character.toUpperCase(out.charAt(0)) + "");
        return out.toString();
    }

    public boolean isInterface() {
        return this.classDef.isInterface();
    }

    public boolean isAbstract() {
        return this.classDef.isAbstract();
    }

    public boolean hasPublicNoArgsConstructor() {
        return this.hasDefaultConstructor;
    }

    public int getAccess() {
        return this.classDef.getAccess();
    }

    @Deprecated
    public void setInnerAccess(int access) {
    }

    public Stream<Annotation> annotations(String binaryNameFilter) {
        return this.classDef.annotations(binaryNameFilter);
    }

    public Stream<TypeAnnotation> typeAnnotations(String binaryNameFilter) {
        return this.classDef.typeAnnotations(binaryNameFilter);
    }

    public Descriptors.TypeRef getClassName() {
        return this.classDef.getType();
    }

    public boolean isInnerClass() {
        return this.classDef.isInnerClass();
    }

    @Deprecated
    public MethodDef getMethodDef(int access, String name, String descriptor) {
        return new MethodDef(access, name, descriptor);
    }

    public Descriptors.TypeRef getSuper() {
        return this.superClass;
    }

    public String getFQN() {
        return this.classDef.getName();
    }

    public Descriptors.TypeRef[] getInterfaces() {
        return this.interfaces;
    }

    public List<Descriptors.TypeRef> interfaces() {
        return this.interfaces != null ? Lists.of((Object[])this.interfaces) : Collections.emptyList();
    }

    public Set<Descriptors.TypeRef> annotations() {
        return this.annotations != null ? this.annotations : Collections.emptySet();
    }

    public boolean isFinal() {
        return this.classDef.isFinal();
    }

    @Deprecated
    public void setDeprecated(boolean b) {
    }

    public boolean isDeprecated() {
        return this.classDef.isDeprecated();
    }

    public boolean isAnnotation() {
        return this.classDef.isAnnotation();
    }

    static boolean isAnnotation(int access) {
        return (access & 0x2000) != 0;
    }

    public Set<Descriptors.PackageRef> getAPIUses() {
        return this.api != null ? this.api : Collections.emptySet();
    }

    public TypeDef getExtends(Descriptors.TypeRef type) {
        return new TypeDef(type, false);
    }

    public TypeDef getImplements(Descriptors.TypeRef type) {
        return new TypeDef(type, true);
    }

    private void classConstRef(int index) {
        if (this.constantPool.tag(index) == 7) {
            String name = this.constantPool.className(index);
            this.classConstRef(name);
        }
    }

    private void classConstRef(String name) {
        if (name != null) {
            Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(name);
            this.referTo(typeRef, 0);
        }
    }

    public String getClassSignature() {
        return this.classDef.getSignature();
    }

    public String getSourceFile() {
        return this.classDef.getSourceFile();
    }

    public Map<String, Object> getDefaults() throws Exception {
        this.parseClassFile();
        if (!this.classDef.isAnnotation()) {
            return Collections.emptyMap();
        }
        Map<String, Object> map = this.methods().filter(m -> m.attribute(AnnotationDefaultAttribute.class).isPresent()).collect(Collectors.toMap(FieldDef::getName, MethodDef::getConstant));
        return map;
    }

    public Resource getResource() {
        return this.resource;
    }

    public class TypeDef
    extends Def {
        final Descriptors.TypeRef type;
        final boolean interf;

        public TypeDef(Descriptors.TypeRef type, boolean interf) {
            super(1);
            this.type = type;
            this.interf = interf;
        }

        public Descriptors.TypeRef getReference() {
            return this.type;
        }

        public boolean getImplements() {
            return this.interf;
        }

        @Override
        public String getName() {
            if (this.interf) {
                return "<implements>";
            }
            return "<extends>";
        }

        @Override
        public Descriptors.TypeRef getType() {
            return this.type;
        }

        @Override
        public Descriptors.TypeRef[] getPrototype() {
            return null;
        }
    }

    public class MethodDef
    extends FieldDef {
        @Deprecated
        public MethodDef(int access, String method, String descriptor) {
            super(access, method, descriptor);
        }

        public MethodDef(MethodInfo methodInfo) {
            super((MemberInfo)methodInfo);
        }

        public boolean isConstructor() {
            String name = this.getName();
            return name.equals("<init>") || name.equals("<clinit>");
        }

        @Override
        public boolean isFinal() {
            return super.isFinal() || Clazz.this.isFinal();
        }

        @Override
        public Descriptors.TypeRef[] getPrototype() {
            return this.getDescriptor().getPrototype();
        }

        public boolean isBridge() {
            return (super.getAccess() & 0x40) != 0;
        }

        @Override
        public String getGenericReturnType() {
            String signature = this.getSignature();
            MethodSignature sig = Clazz.this.analyzer.getMethodSignature(signature != null ? signature : this.descriptor());
            return sig.resultType.toString();
        }

        public MethodParameter[] getParameters() {
            return this.attribute(MethodParametersAttribute.class).map(MethodParameter::parameters).orElseGet(() -> new MethodParameter[0]);
        }

        @Override
        public Object getConstant() {
            return this.attribute(AnnotationDefaultAttribute.class).map(a -> Clazz.this.annotationDefault((AnnotationDefaultAttribute)a, this.getAccess())).orElse(null);
        }

        <A extends ParameterAnnotationsAttribute> Stream<ParameterAnnotationInfo> parameterAnnotationInfos(Class<A> attributeType) {
            return this.attributes(attributeType).flatMap(a -> Arrays.stream(a.parameter_annotations));
        }

        public Stream<ParameterAnnotation> parameterAnnotations(String binaryNameFilter) {
            Predicate<AnnotationInfo> matches = this.matches(binaryNameFilter);
            Annotation.ElementType elementType = this.elementType();
            Stream runtimeParameterAnnotations = this.parameterAnnotationInfos(RuntimeVisibleParameterAnnotationsAttribute.class).flatMap(a -> this.parameterAnnotations((ParameterAnnotationInfo)a, matches, elementType, RetentionPolicy.RUNTIME));
            Stream classParameterAnnotations = this.parameterAnnotationInfos(RuntimeInvisibleParameterAnnotationsAttribute.class).flatMap(a -> this.parameterAnnotations((ParameterAnnotationInfo)a, matches, elementType, RetentionPolicy.CLASS));
            return Stream.concat(runtimeParameterAnnotations, classParameterAnnotations);
        }

        private Stream<ParameterAnnotation> parameterAnnotations(ParameterAnnotationInfo parameterAnnotationInfo, Predicate<AnnotationInfo> matches, Annotation.ElementType elementType, RetentionPolicy policy) {
            int parameter = parameterAnnotationInfo.parameter;
            return Arrays.stream(parameterAnnotationInfo.annotations).filter(matches).map(a -> Clazz.this.newParameterAnnotation(parameter, (AnnotationInfo)a, elementType, policy, this.getAccess()));
        }

        @Override
        <A extends TypeAnnotationsAttribute> Stream<TypeAnnotationInfo> typeAnnotationInfos(Class<A> attributeType) {
            Annotation.ElementType elementType = this.elementType();
            Stream<A> methodAttributes = this.attributes(attributeType);
            Stream codeAttributes = this.attribute(CodeAttribute.class).map(code -> new CodeDef((CodeAttribute)code, elementType).attributes(attributeType)).orElseGet(Stream::empty);
            return Stream.concat(methodAttributes, codeAttributes).flatMap(a -> Arrays.stream(a.type_annotations));
        }

        @Override
        Annotation.ElementType elementType() {
            return this.getName().equals("<init>") ? Annotation.ElementType.CONSTRUCTOR : Annotation.ElementType.METHOD;
        }
    }

    public static class MethodParameter {
        private final MethodParametersAttribute.MethodParameter methodParameter;

        MethodParameter(MethodParametersAttribute.MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        public String getName() {
            return this.methodParameter.name;
        }

        public int getAccess() {
            return this.methodParameter.access_flags;
        }

        public String toString() {
            return this.getName();
        }

        static MethodParameter[] parameters(MethodParametersAttribute attribute) {
            int parameters_count = attribute.parameters.length;
            MethodParameter[] parameters = new MethodParameter[parameters_count];
            for (int i = 0; i < parameters_count; ++i) {
                parameters[i] = new MethodParameter(attribute.parameters[i]);
            }
            return parameters;
        }
    }

    public class FieldDef
    extends ElementDef {
        private final String name;
        private final String descriptor;

        @Deprecated
        public FieldDef(int access, String name, String descriptor) {
            super(access, new Attribute[0]);
            this.name = name;
            this.descriptor = descriptor;
        }

        FieldDef(MemberInfo memberInfo) {
            super(memberInfo.access, memberInfo.attributes);
            this.name = memberInfo.name;
            this.descriptor = memberInfo.descriptor;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Descriptors.TypeRef getType() {
            return this.getDescriptor().getType();
        }

        @Deprecated
        public void setDeprecated(boolean deprecated) {
        }

        public Descriptors.TypeRef getContainingClass() {
            return Clazz.this.getClassName();
        }

        public String descriptor() {
            return this.descriptor;
        }

        public Descriptors.Descriptor getDescriptor() {
            return Clazz.this.analyzer.getDescriptor(this.descriptor());
        }

        @Deprecated
        public void setConstant(Object o) {
        }

        public Object getConstant() {
            return this.attribute(ConstantValueAttribute.class).map(a -> a.value).orElse(null);
        }

        public String getGenericReturnType() {
            String signature = this.getSignature();
            FieldSignature sig = Clazz.this.analyzer.getFieldSignature(signature != null ? signature : this.descriptor());
            return sig.type.toString();
        }

        @Override
        public Descriptors.TypeRef[] getPrototype() {
            return null;
        }

        @Override
        Annotation.ElementType elementType() {
            return Annotation.ElementType.FIELD;
        }
    }

    class ClassDef
    extends ElementDef {
        private final Descriptors.TypeRef type;

        ClassDef(ClassFile classFile) {
            super(classFile.access, classFile.attributes);
            this.type = Clazz.this.analyzer.getTypeRef(classFile.this_class);
        }

        String getSourceFile() {
            return this.attribute(SourceFileAttribute.class).map(a -> a.sourcefile).orElse(null);
        }

        boolean isInnerClass() {
            String binary = this.type.getBinary();
            return this.attributes(InnerClassesAttribute.class).flatMap(a -> Arrays.stream(a.classes)).anyMatch(inner -> inner.inner_class.equals(binary) && !Modifier.isStatic(inner.inner_access));
        }

        boolean isPackageInfo() {
            return this.type.getBinary().endsWith("/package-info");
        }

        @Override
        public String getName() {
            return this.type.getFQN();
        }

        @Override
        public Descriptors.TypeRef getType() {
            return this.type;
        }

        @Override
        Annotation.ElementType elementType() {
            if (super.isAnnotation()) {
                return Annotation.ElementType.ANNOTATION_TYPE;
            }
            if (super.isModule()) {
                return Annotation.ElementType.MODULE;
            }
            return this.isPackageInfo() ? Annotation.ElementType.PACKAGE : Annotation.ElementType.TYPE;
        }
    }

    class CodeDef
    extends ElementDef {
        private final Annotation.ElementType elementType;

        CodeDef(CodeAttribute code, Annotation.ElementType elementType) {
            super(0, code.attributes);
            this.elementType = elementType;
        }

        @Override
        Annotation.ElementType elementType() {
            return this.elementType;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }
    }

    abstract class ElementDef
    extends Def {
        private final Attribute[] attributes;

        ElementDef(int access, Attribute[] attributes) {
            super(access);
            this.attributes = attributes;
        }

        Attribute[] attributes() {
            return this.attributes;
        }

        public boolean isDeprecated() {
            return this.attribute(DeprecatedAttribute.class).isPresent() || this.annotationInfos(RuntimeVisibleAnnotationsAttribute.class).anyMatch(a -> a.type.equals("Ljava/lang/Deprecated;"));
        }

        public String getSignature() {
            return this.attribute(SignatureAttribute.class).map(a -> a.signature).orElse(null);
        }

        <A extends Attribute> Stream<A> attributes(Class<A> attributeType) {
            Stream<Attribute> stream = Arrays.stream(this.attributes()).filter(attributeType::isInstance);
            return stream;
        }

        <A extends Attribute> Optional<A> attribute(Class<A> attributeType) {
            return this.attributes(attributeType).findFirst();
        }

        <A extends AnnotationsAttribute> Stream<AnnotationInfo> annotationInfos(Class<A> attributeType) {
            return this.attributes(attributeType).flatMap(a -> Arrays.stream(a.annotations));
        }

        public Stream<Annotation> annotations(String binaryNameFilter) {
            Predicate<AnnotationInfo> matches = this.matches(binaryNameFilter);
            Annotation.ElementType elementType = this.elementType();
            Stream<Annotation> runtimeAnnotations = this.annotationInfos(RuntimeVisibleAnnotationsAttribute.class).filter(matches).map(a -> Clazz.this.newAnnotation((AnnotationInfo)a, elementType, RetentionPolicy.RUNTIME, this.getAccess()));
            Stream<Annotation> classAnnotations = this.annotationInfos(RuntimeInvisibleAnnotationsAttribute.class).filter(matches).map(a -> Clazz.this.newAnnotation((AnnotationInfo)a, elementType, RetentionPolicy.CLASS, this.getAccess()));
            return Stream.concat(runtimeAnnotations, classAnnotations);
        }

        Predicate<AnnotationInfo> matches(String binaryNameFilter) {
            if (binaryNameFilter == null || binaryNameFilter.equals("*")) {
                return annotationInfo -> true;
            }
            Glob glob = new Glob("L{" + binaryNameFilter + "};");
            return annotationInfo -> glob.matches(annotationInfo.type);
        }

        <A extends TypeAnnotationsAttribute> Stream<TypeAnnotationInfo> typeAnnotationInfos(Class<A> attributeType) {
            return this.attributes(attributeType).flatMap(a -> Arrays.stream(a.type_annotations));
        }

        public Stream<TypeAnnotation> typeAnnotations(String binaryNameFilter) {
            Predicate<AnnotationInfo> matches = this.matches(binaryNameFilter);
            Annotation.ElementType elementType = this.elementType();
            Stream<TypeAnnotation> runtimeTypeAnnotations = this.typeAnnotationInfos(RuntimeVisibleTypeAnnotationsAttribute.class).filter(matches).map(a -> Clazz.this.newTypeAnnotation((TypeAnnotationInfo)a, elementType, RetentionPolicy.RUNTIME, this.getAccess()));
            Stream<TypeAnnotation> classTypeAnnotations = this.typeAnnotationInfos(RuntimeInvisibleTypeAnnotationsAttribute.class).filter(matches).map(a -> Clazz.this.newTypeAnnotation((TypeAnnotationInfo)a, elementType, RetentionPolicy.CLASS, this.getAccess()));
            return Stream.concat(runtimeTypeAnnotations, classTypeAnnotations);
        }

        @Override
        public String getName() {
            return super.toString();
        }

        @Override
        public Descriptors.TypeRef getType() {
            return null;
        }

        @Override
        public Descriptors.TypeRef[] getPrototype() {
            return null;
        }

        public String toString() {
            return this.getName();
        }

        abstract Annotation.ElementType elementType();
    }

    public abstract class Def {
        private final int access;

        public Def(int access) {
            this.access = access;
        }

        public int getAccess() {
            return this.access;
        }

        public boolean isEnum() {
            return Clazz.isEnum(this.getAccess());
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.getAccess());
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.getAccess());
        }

        public boolean isProtected() {
            return Modifier.isProtected(this.getAccess());
        }

        public boolean isFinal() {
            return Modifier.isFinal(this.getAccess());
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.getAccess());
        }

        public boolean isPrivate() {
            return Modifier.isPrivate(this.getAccess());
        }

        public boolean isNative() {
            return Modifier.isNative(this.getAccess());
        }

        public boolean isTransient() {
            return Modifier.isTransient(this.getAccess());
        }

        public boolean isVolatile() {
            return Modifier.isVolatile(this.getAccess());
        }

        public boolean isInterface() {
            return Modifier.isInterface(this.getAccess());
        }

        public boolean isSynthetic() {
            return Clazz.isSynthetic(this.getAccess());
        }

        public boolean isModule() {
            return Clazz.isModule(this.getAccess());
        }

        public boolean isAnnotation() {
            return Clazz.isAnnotation(this.getAccess());
        }

        @Deprecated
        public Collection<Descriptors.TypeRef> getAnnotations() {
            return null;
        }

        public Descriptors.TypeRef getOwnerType() {
            return Clazz.this.classDef.getType();
        }

        public abstract String getName();

        public abstract Descriptors.TypeRef getType();

        public abstract Descriptors.TypeRef[] getPrototype();

        public Object getClazz() {
            return Clazz.this;
        }
    }

    @Deprecated
    protected static class Assoc {
        private Assoc() {
        }
    }

    public static enum QUERY {
        IMPLEMENTS,
        EXTENDS,
        IMPORTS,
        NAMED,
        ANY,
        VERSION,
        CONCRETE,
        ABSTRACT,
        PUBLIC,
        ANNOTATED,
        INDIRECTLY_ANNOTATED,
        HIERARCHY_ANNOTATED,
        HIERARCHY_INDIRECTLY_ANNOTATED,
        RUNTIMEANNOTATIONS,
        CLASSANNOTATIONS,
        DEFAULT_CONSTRUCTOR,
        STATIC,
        INNER;

    }

    public static enum JAVA {
        JDK1_1(45, "JRE-1.1", "(&(osgi.ee=JavaSE)(version=1.1))"),
        JDK1_2(46, "J2SE-1.2", "(&(osgi.ee=JavaSE)(version=1.2))"),
        JDK1_3(47, "J2SE-1.3", "(&(osgi.ee=JavaSE)(version=1.3))"),
        JDK1_4(48, "J2SE-1.4", "(&(osgi.ee=JavaSE)(version=1.4))"),
        J2SE5(49, "J2SE-1.5", "(&(osgi.ee=JavaSE)(version=1.5))"),
        J2SE6(50, "JavaSE-1.6", "(&(osgi.ee=JavaSE)(version=1.6))"),
        OpenJDK7(51, "JavaSE-1.7", "(&(osgi.ee=JavaSE)(version=1.7))"),
        OpenJDK8(52, "JavaSE-1.8", "(&(osgi.ee=JavaSE)(version=1.8))"){
            Map<String, Set<String>> profiles;

            @Override
            public Map<String, Set<String>> getProfiles() throws IOException {
                if (this.profiles == null) {
                    UTF8Properties p = new UTF8Properties();
                    try (InputStream in = Clazz.class.getResourceAsStream("profiles-" + (Object)((Object)this) + ".properties");){
                        ((Properties)p).load(in);
                    }
                    this.profiles = (Map)MapStream.of((Map)p).map((k, v) -> MapStream.entry((Object)((String)k), Strings.splitAsStream((String)((String)v)).collect(Collectors.toSet()))).collect(MapStream.toMap());
                }
                return this.profiles;
            }
        }
        ,
        OpenJDK9(53, "JavaSE-9", "(&(osgi.ee=JavaSE)(version=9))"),
        OpenJDK10(54, "JavaSE-10", "(&(osgi.ee=JavaSE)(version=10))"),
        OpenJDK11(55, "JavaSE-11", "(&(osgi.ee=JavaSE)(version=11))"),
        OpenJDK12(56, "JavaSE-12", "(&(osgi.ee=JavaSE)(version=12))"),
        OpenJDK13(57, "JavaSE-13", "(&(osgi.ee=JavaSE)(version=13))"),
        OpenJDK14(58, "JavaSE-14", "(&(osgi.ee=JavaSE)(version=14))"),
        OpenJDK15(59, "JavaSE-15", "(&(osgi.ee=JavaSE)(version=15))"),
        OpenJDK16(60, "JavaSE-16", "(&(osgi.ee=JavaSE)(version=16))"),
        OpenJDK17(61, "JavaSE-17", "(&(osgi.ee=JavaSE)(version=17))"),
        OpenJDK18(62, "JavaSE-18", "(&(osgi.ee=JavaSE)(version=18))"),
        OpenJDK19(63, "JavaSE-19", "(&(osgi.ee=JavaSE)(version=19))"),
        OpenJDK20(64, "JavaSE-20", "(&(osgi.ee=JavaSE)(version=20))"),
        UNKNOWN(Integer.MAX_VALUE, "<UNKNOWN>", "(osgi.ee=UNKNOWN)");

        final int major;
        final String ee;
        final String filter;

        private JAVA(int major, String ee, String filter) {
            this.major = major;
            this.ee = ee;
            this.filter = filter;
        }

        static JAVA format(int n) {
            for (JAVA e : JAVA.values()) {
                if (e.major != n) continue;
                return e;
            }
            return UNKNOWN;
        }

        public int getMajor() {
            return this.major;
        }

        public boolean hasAnnotations() {
            return this.major >= JAVA.J2SE5.major;
        }

        public boolean hasGenerics() {
            return this.major >= JAVA.J2SE5.major;
        }

        public boolean hasEnums() {
            return this.major >= JAVA.J2SE5.major;
        }

        public static JAVA getJava(int major, int minor) {
            return JAVA.format(major);
        }

        public String getEE() {
            return this.ee;
        }

        public String getFilter() {
            return this.filter;
        }

        public Map<String, Set<String>> getProfiles() throws IOException {
            return null;
        }
    }

    @Deprecated
    public class ClassConstant {
        final int cname;
        public boolean referred;

        public ClassConstant(int class_index) {
            this.cname = class_index;
        }

        public String getName() {
            return Clazz.this.constantPool.utf8(this.cname);
        }

        public String toString() {
            return "ClassConstant[" + this.getName() + "]";
        }
    }
}

