/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.extensions.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    public static void deleteDir(Path dirPath) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioException) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteFileInPath(final String fileName, Path rootDirPath) throws IOException {
        Files.walkFileTree(rootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path path = dirPath.resolve(fileName);
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteFiles(Path dirPath, final String ... fileNames) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                for (String fileName : fileNames) {
                    Files.deleteIfExists(dirPath.resolve(fileName));
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteFilesByPattern(Path dirPath, final Pattern pattern) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String fileName = String.valueOf(path.getFileName());
                Matcher matcher = pattern.matcher(fileName);
                if (matcher.matches()) {
                    Files.deleteIfExists(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void extractDirectory(String dirName, Path destinationDirPath) throws Exception {
        Map<String, InputStream> filesAndDirectories = FileUtil._getFilesFromClasspath("/" + dirName);
        for (Map.Entry<String, InputStream> entry : filesAndDirectories.entrySet()) {
            Path pathKeyPath = Paths.get(entry.getKey(), new String[0]);
            pathKeyPath = pathKeyPath.subpath(1, pathKeyPath.getNameCount());
            InputStream inputStream = entry.getValue();
            Throwable throwable = null;
            try {
                Path destinationPath = Paths.get(destinationDirPath.toString(), pathKeyPath.toString());
                if (inputStream != null) {
                    Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
                    try {
                        Files.copy(inputStream, destinationPath, new CopyOption[0]);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throw new RuntimeException(throwable2);
                    }
                }
                Files.createDirectories(destinationPath, new FileAttribute[0]);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
    }

    public static Path getFile(Path dirPath, String glob) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath, glob);){
            Iterator<Path> iterator = directoryStream.iterator();
            if (iterator.hasNext()) {
                Path path = iterator.next();
                return path;
            }
        }
        return null;
    }

    public static Path getFile(Path dirPath, String glob, String regex) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath, glob);){
            for (Path path : directoryStream) {
                String fileName = String.valueOf(path.getFileName());
                if (!fileName.matches(regex)) continue;
                Path path2 = path;
                return path2;
            }
        }
        return null;
    }

    public static Path getJarPath() throws URISyntaxException {
        return Paths.get(FileUtil._getJarURI());
    }

    public static String getManifestProperty(File file, String name) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(name);
            return string;
        }
    }

    public static Path getRootDir(Path dirPath, String markerFileName) {
        do {
            if (!Files.exists(dirPath.resolve(markerFileName), new LinkOption[0])) continue;
            return dirPath;
        } while ((dirPath = dirPath.getParent()) != null);
        return null;
    }

    public static String read(Path path) throws IOException {
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        return content.replace("\r\n", "\n");
    }

    public static Properties readProperties(Path path) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            properties.load(inputStream);
        }
        return properties;
    }

    public static void replaceString(File file, String search, String replace) throws IOException {
        Path path = file.toPath();
        String content = FileUtil.read(path);
        String newContent = content.replace(search, replace);
        Files.write(path, newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static void setPosixFilePermissions(Path path, Set<PosixFilePermission> posixFilePermissions) throws IOException {
        try {
            Files.setPosixFilePermissions(path, posixFilePermissions);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static Map<String, InputStream> _getFilesFromClasspath(String dirPathString) throws Exception {
        URL url;
        if (dirPathString != null && File.separatorChar == '\\') {
            dirPathString = dirPathString.replace('\\', '/');
        }
        if ((url = FileUtil.class.getResource(dirPathString)) == null) {
            String errorMessage = String.format("%s not found", dirPathString);
            throw new NoSuchElementException(errorMessage);
        }
        HashMap<String, InputStream> pathMap = new HashMap<String, InputStream>();
        URI uri = url.toURI();
        String scheme = uri.getScheme();
        if (scheme.contains("jar")) {
            FileSystem jarFileSystem = FileUtil._getJarFileSystem();
            Path fileSystemPath = jarFileSystem.getPath(dirPathString, new String[0]);
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(fileSystemPath);){
                for (Path dirPath : directoryStream) {
                    String pathString = dirPath.toString();
                    if (Files.isDirectory(dirPath, new LinkOption[0])) {
                        pathMap.put(pathString, null);
                        pathMap.putAll(FileUtil._getFilesFromClasspath(pathString));
                        continue;
                    }
                    InputStream inputStream = FileUtil.class.getResourceAsStream(pathString);
                    pathMap.put(pathString, inputStream);
                }
            }
        }
        Path path = Paths.get(uri);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path dirPath : directoryStream) {
                Path folderNamePath = Paths.get(dirPathString, new String[0]);
                Path relativeDirPath = path.relativize(dirPath);
                String pathToResolveString = String.valueOf(folderNamePath.resolve(relativeDirPath));
                if (Files.isDirectory(dirPath, new LinkOption[0])) {
                    pathMap.put(pathToResolveString + File.separator, null);
                    pathMap.putAll(FileUtil._getFilesFromClasspath(pathToResolveString));
                    continue;
                }
                FileInputStream inputStream = new FileInputStream(dirPath.toFile());
                pathMap.put(pathToResolveString, inputStream);
            }
        }
        return pathMap;
    }

    private static FileSystem _getJarFileSystem() throws Exception {
        Path jarPath = Paths.get(FileUtil._getJarURI());
        return FileSystems.newFileSystem(jarPath, null);
    }

    private static URI _getJarURI() throws URISyntaxException {
        ProtectionDomain protectionDomain = FileUtil.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL jarURL = codeSource.getLocation();
        return jarURL.toURI();
    }
}

