/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.format.TersePrettyDurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;

public class ProgressBar {
    private final TersePrettyDurationFormatter elapsedTimeFormatter = new TersePrettyDurationFormatter();
    private final ConsoleMetaData consoleMetaData;
    private final String progressBarPrefix;
    private final int progressBarWidth;
    private final String progressBarSuffix;
    private final char fillerChar;
    private final char incompleteChar;
    private final String suffix;
    private int current;
    private int total;
    private boolean failing;
    private String lastElapsedTimeStr;
    private List<StyledTextOutputEvent.Span> formatted;

    public ProgressBar(ConsoleMetaData consoleMetaData, String progressBarPrefix, int progressBarWidth, String progressBarSuffix, char completeChar, char incompleteChar, String suffix, int initialProgress, int totalProgress) {
        this.consoleMetaData = consoleMetaData;
        this.progressBarPrefix = progressBarPrefix;
        this.progressBarWidth = progressBarWidth;
        this.progressBarSuffix = progressBarSuffix;
        this.fillerChar = completeChar;
        this.incompleteChar = incompleteChar;
        this.suffix = suffix;
        this.current = initialProgress;
        this.total = totalProgress;
    }

    public void moreProgress(int totalProgress) {
        this.total += totalProgress;
        this.formatted = null;
    }

    public void update(boolean failing) {
        ++this.current;
        this.failing = this.failing || failing;
        this.formatted = null;
    }

    public List<StyledTextOutputEvent.Span> formatProgress(boolean timerEnabled, long elapsedTime) {
        String elapsedTimeStr = this.elapsedTimeFormatter.format(elapsedTime);
        if (this.formatted == null || !elapsedTimeStr.equals(this.lastElapsedTimeStr)) {
            int consoleCols = this.consoleMetaData.getCols();
            int completedWidth = (int)((double)this.current * 1.0 / (double)this.total * (double)this.progressBarWidth);
            int remainingWidth = this.progressBarWidth - completedWidth;
            String statusPrefix = this.trimToConsole(consoleCols, 0, this.progressBarPrefix);
            String coloredProgress = this.trimToConsole(consoleCols, statusPrefix.length(), this.fill(this.fillerChar, completedWidth));
            String statusSuffix = this.trimToConsole(consoleCols, coloredProgress.length(), this.fill(this.incompleteChar, remainingWidth) + this.progressBarSuffix + " " + (int)((double)this.current * 100.0 / (double)this.total) + '%' + ' ' + this.suffix + (timerEnabled ? " [" + elapsedTimeStr + "]" : ""));
            this.lastElapsedTimeStr = elapsedTimeStr;
            this.formatted = Lists.newArrayList(new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, statusPrefix), new StyledTextOutputEvent.Span(this.failing ? StyledTextOutput.Style.FailureHeader : StyledTextOutput.Style.SuccessHeader, coloredProgress), new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, statusSuffix));
        }
        return this.formatted;
    }

    private String fill(char ch, int count) {
        char[] chars = new char[count];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = ch;
        }
        return new String(chars);
    }

    private String trimToConsole(int cols, int prefixLength, String str) {
        int consoleWidth = cols - 1;
        int remainingWidth = consoleWidth - prefixLength;
        if (consoleWidth < 0) {
            return str;
        }
        if (remainingWidth <= 0) {
            return "";
        }
        if (consoleWidth < str.length()) {
            return str.substring(0, consoleWidth);
        }
        return str;
    }
}

