/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.gradle.tooling.ProjectInfo;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;

public class GradleTooling {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectInfo loadProjectInfo(Path projectPath) throws Exception {
        ProjectInfo projectInfo = null;
        GradleConnector connector = GradleConnector.newConnector();
        connector.forProjectDirectory(projectPath.toFile());
        try (ProjectConnection connection = null;){
            connection = connector.connect();
            ModelBuilder<ProjectInfo> modelBuilder = connection.model(ProjectInfo.class);
            Path tempPath = Files.createTempDirectory("tooling", new FileAttribute[0]);
            InputStream in = GradleTooling.class.getResourceAsStream("/tooling.zip");
            FileUtil.unzip(in, tempPath.toFile());
            try (Stream<Path> toolingFiles = Files.list(tempPath);){
                String files = toolingFiles.map(Path::toAbsolutePath).map(Path::toString).map(path -> "\"" + path.replaceAll("\\\\", "/") + "\"").collect(Collectors.joining(", "));
                String initScriptTemplate = FileUtil.collect(GradleTooling.class.getResourceAsStream("init.gradle"));
                String initScriptContents = initScriptTemplate.replaceAll("%files%", files);
                Path initPath = tempPath.resolve("init.gradle");
                Files.write(initPath, initScriptContents.getBytes(), new OpenOption[0]);
                modelBuilder.withArguments(new String[]{"--init-script", initPath.toString(), "--stacktrace"});
                projectInfo = modelBuilder.get();
            }
        }
        return projectInfo;
    }
}

