/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.ProcessResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GradleExecTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Path _extensionsPath = null;
    private Path _rootPath = null;

    @Before
    public void setUp() throws Exception {
        File rootDir = this.temporaryFolder.getRoot();
        this._rootPath = rootDir.toPath();
        File extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
        this._extensionsPath = extensionsDir.toPath();
    }

    @Test
    public void testGradleWrapper() throws Exception {
        File workspace70 = new File(this._rootPath.toFile(), "workspace70");
        this._makeWorkspaceVersion(workspace70, "dxp-7.0-sp17");
        String[] args = new String[]{"--base", workspace70.toString(), "create", "-t", "api", "foo"};
        this._getBladeTest().run(args);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        bladeTestBuilder.setExtensionsDir(this._extensionsPath);
        bladeTestBuilder.setSettingsDir(this._rootPath);
        bladeTestBuilder.setStdOut(ps);
        BladeTest bladeCLI = bladeTestBuilder.build();
        GradleExec gradleExec = new GradleExec((BladeCLI)bladeCLI);
        ProcessResult result = gradleExec.executeTask("tasks");
        int resultCode = result.getResultCode();
        String output = result.get();
        if (resultCode > 0) {
            Assert.assertEquals((String)("Gradle command returned error code " + resultCode + System.lineSeparator() + output), (long)0L, (long)resultCode);
        } else {
            Assert.assertFalse((String)("Gradle build failed " + System.lineSeparator() + output), (boolean)output.contains("BUILD FAILED"));
        }
    }

    private BladeTest _getBladeTest() {
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        bladeTestBuilder.setExtensionsDir(this._extensionsPath);
        bladeTestBuilder.setSettingsDir(this._rootPath);
        return bladeTestBuilder.build();
    }

    private void _makeWorkspaceVersion(File workspace, String version) throws Exception {
        File parentFile = workspace.getParentFile();
        String[] args = new String[]{"--base", parentFile.getPath(), "init", workspace.getName(), "-v", version};
        TestUtil.runBlade(workspace, this._extensionsPath.toFile(), args);
    }
}

