/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.junit.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLTestUtil {
    private static final Transformer _transformer;

    public static Element getChildElement(Element parentElement, String name) {
        Node node = parentElement.getFirstChild();
        do {
            Element element;
            if (node.getNodeType() != 1 || !name.equals((element = (Element)node).getTagName())) continue;
            return element;
        } while ((node = node.getNextSibling()) != null);
        return null;
    }

    public static List<Element> getChildElements(Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            boolean ignoreNode = false;
            NodeList childNodeList = childElement.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Text text;
                String textContent;
                Node childNode = childNodeList.item(j);
                if (childNode.getNodeType() != 3 || !(textContent = (text = (Text)childNode).getTextContent()).contains("Ignore Dependency Comparison")) continue;
                ignoreNode = true;
                break;
            }
            if (ignoreNode) continue;
            elements.add(childElement);
        }
        return elements;
    }

    public static void testXmlElement(Path path, String parentElementString, List<Element> elements, int index, String expectedTagName, String expectedTextContent) throws TransformerException {
        if (elements.size() <= index) {
            StringBuilder sb = new StringBuilder();
            sb.append("Missing child element <");
            sb.append(expectedTagName);
            sb.append('>');
            sb.append(expectedTextContent);
            sb.append("</");
            sb.append(expectedTagName);
            sb.append("> of ");
            sb.append(parentElementString);
            sb.append(" in ");
            sb.append(path);
            Assert.fail((String)sb.toString());
        }
        Element element = elements.get(index);
        String elementString = XMLTestUtil.toString(element);
        Assert.assertEquals((String)("Incorrect tag name of " + elementString + " in " + path), (Object)expectedTagName, (Object)element.getTagName());
        Assert.assertEquals((String)("Incorrect text content of " + elementString + " in " + path), (Object)expectedTextContent, (Object)element.getTextContent());
    }

    public static String toString(Element element) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        _transformer.transform(new DOMSource(element), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    static {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            _transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new ExceptionInInitializerError(transformerConfigurationException);
        }
        _transformer.setOutputProperty("omit-xml-declaration", "yes");
    }
}

