/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.BladeSettings;
import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.Extensions;
import com.liferay.blade.cli.ExtensionsClassLoaderSupplier;
import com.liferay.blade.cli.TestUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ExtensionsTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final int _BUILT_IN_COMMANDS_COUNT = ExtensionsTest._getBuiltInCommandsCount();
    private BladeTest _bladeTest;
    private ExtensionsClassLoaderSupplier _extensionsClassLoaderSupplier = null;
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
        this._extensionsClassLoaderSupplier = new ExtensionsClassLoaderSupplier(this._extensionsDir.toPath());
        bladeTestBuilder.setExtensionsDir(this._extensionsDir.toPath());
        bladeTestBuilder.setSettingsDir(this._rootDir.toPath());
        this._bladeTest = bladeTestBuilder.build();
    }

    @After
    public void tearDown() throws Exception {
        this._extensionsClassLoaderSupplier.close();
    }

    @Test
    public void testArgsSort() throws Exception {
        String[] args = new String[]{"--base", "/foo/bar/dir/", "--flag1", "extension", "install", "/path/to/jar.jar", "--flag2"};
        ClassLoader classLoader = this._extensionsClassLoaderSupplier.get();
        try (Extensions extensions = new Extensions(classLoader);){
            String[] sortedArgs = Extensions.sortArgs((Map)extensions.getCommands(), (String[])args);
            boolean correctSort = false;
            for (String arg : sortedArgs) {
                if (!Objects.equals(arg, "extension install")) continue;
                correctSort = true;
            }
            Assert.assertTrue((boolean)correctSort);
        }
    }

    @Test
    public void testBadJar() throws Exception {
        this._setupBadExtension();
        String[] args = new String[]{"create", "-l"};
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, args);
        String output = results.getOutput();
        String errors = results.getErrors();
        boolean commandSuccess = output.contains("Creates a Liferay");
        Assert.assertTrue((boolean)commandSuccess);
        boolean errorOccurred = errors.contains("java.lang.NoClassDefFoundError");
        Assert.assertTrue((boolean)errorOccurred);
    }

    @Test
    public void testLoadCommandsBuiltIn() throws Exception {
        ClassLoader classLoader = this._extensionsClassLoaderSupplier.get();
        try (Extensions extensions = new Extensions(classLoader);){
            Map commands = extensions.getCommands();
            List values = commands.values().stream().distinct().collect(Collectors.toList());
            Assert.assertNotNull(values);
            Assert.assertEquals((String)values.toString(), (long)_BUILT_IN_COMMANDS_COUNT, (long)values.size());
        }
    }

    @Test
    public void testLoadCommandsWithCustomExtension() throws Exception {
        this._setupTestExtensions();
        ClassLoader classLoader = this._extensionsClassLoaderSupplier.get();
        try (Extensions extensions = new Extensions(classLoader);){
            Map commands = extensions.getCommands();
            List values = commands.values().stream().distinct().collect(Collectors.toList());
            Assert.assertNotNull(values);
            Assert.assertEquals((String)values.toString(), (long)(_BUILT_IN_COMMANDS_COUNT + 1), (long)values.size());
        }
    }

    @Test
    public void testLoadCommandsWithCustomExtensionInWorkspace() throws Exception {
        this._setupTestExtensions();
        File workspaceDir = this.temporaryFolder.newFolder(new String[]{"build", "test", "workspace"});
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-P", "foo", "-v", "portal-7.3-ga6"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        BladeSettings settings = this._bladeTest.getBladeSettings();
        settings.setProfileName("foo");
        ClassLoader classLoader = this._extensionsClassLoaderSupplier.get();
        try (Extensions extensions = new Extensions(classLoader);){
            Map commands = extensions.getCommands("foo");
            List values = commands.values().stream().distinct().collect(Collectors.toList());
            Assert.assertNotNull(values);
            Assert.assertEquals((String)values.toString(), (long)(_BUILT_IN_COMMANDS_COUNT + 2), (long)values.size());
        }
    }

    private static int _getBuiltInCommandsCount() {
        ClassLoader classLoader = ExtensionsTest.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/services/com.liferay.blade.cli.command.BaseCommand");
        try (Scanner scanner = new Scanner(inputStream);){
            int numLines = 0;
            while (scanner.hasNextLine()) {
                scanner.nextLine();
                ++numLines;
            }
            int n = numLines;
            return n;
        }
    }

    private static void _setupTestExtension(Path extensionsPath, String jarPath) throws IOException {
        File sampleJarFile = new File(jarPath);
        Assert.assertTrue((String)(sampleJarFile.getAbsolutePath() + " does not exist."), (boolean)sampleJarFile.exists());
        Path sampleJarPath = extensionsPath.resolve(sampleJarFile.getName());
        Files.copy(sampleJarFile.toPath(), sampleJarPath, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertTrue((boolean)Files.exists(sampleJarPath, new LinkOption[0]));
    }

    private void _setupBadExtension() throws Exception {
        Path extensionsPath = this._extensionsDir.toPath();
        ExtensionsTest._setupTestExtension(extensionsPath, System.getProperty("badCommandJarFile"));
    }

    private void _setupTestExtensions() throws Exception {
        Path extensionsPath = this._extensionsDir.toPath();
        ExtensionsTest._setupTestExtension(extensionsPath, System.getProperty("sampleCommandJarFile"));
        ExtensionsTest._setupTestExtension(extensionsPath, System.getProperty("sampleProfileJarFile"));
        ExtensionsTest._setupTestExtension(extensionsPath, System.getProperty("sampleTemplateJarFile"));
    }
}

