/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.TestUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ConvertThemeCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUpTestExtensions() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testListThemes() throws Exception {
        File workspace = this._createWorkspace();
        String[] args = new String[]{"convert", "-l", "--base", workspace.getAbsolutePath()};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)output, (boolean)output.contains("compass-theme"));
    }

    @Ignore
    @Test
    public void testMigrateCompassTheme() throws Exception {
        File workspace = this._createWorkspace();
        String[] args = new String[]{"--base", workspace.getAbsolutePath(), "convert", "-a"};
        BladeTestResults bladeTestResults = TestUtil.runBlade(workspace, this._extensionsDir, System.out, null, System.in, false, args);
        File oldCompassTheme = new File(workspace, "plugins-sdk/themes/compass-theme");
        Assert.assertTrue((!oldCompassTheme.exists() ? 1 : 0) != 0);
        File compassTheme = new File(workspace, "themes/compass-theme");
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)output, (boolean)output.contains(compassTheme.getAbsolutePath()));
        Assert.assertTrue((boolean)compassTheme.exists());
        File packageJsonFile = new File(compassTheme, "package.json");
        String json = new String(Files.readAllBytes(packageJsonFile.toPath()));
        Assert.assertTrue((boolean)json.contains("\"supportCompass\": true"));
        File nonCompassTheme = new File(workspace, "themes/non-compass-theme");
        Assert.assertTrue((boolean)compassTheme.exists());
        packageJsonFile = new File(nonCompassTheme, "package.json");
        json = new String(Files.readAllBytes(packageJsonFile.toPath()));
        Assert.assertTrue((boolean)json.contains("\"supportCompass\": false"));
    }

    private void _createTheme(File workspace, String themeName, boolean compass) throws Exception {
        File theme = new File(workspace, "plugins-sdk/themes/" + themeName);
        File diffs = new File(theme, "/docroot/_diffs/css");
        diffs.mkdirs();
        String css = "";
        if (compass) {
            css = "@import \"compass\";";
        }
        File customCss = new File(diffs, "custom.css");
        Files.write(customCss.toPath(), css.getBytes(), new OpenOption[0]);
        File webInf = new File(theme, "/docroot/WEB-INF/");
        webInf.mkdirs();
        String xml = "";
        File lookAndFeelXml = new File(webInf, "liferay-look-and-feel.xml");
        Files.write(lookAndFeelXml.toPath(), xml.getBytes(), new OpenOption[0]);
        String properties = "liferay-versions=7.0.0+";
        File liferayPluginPackage = new File(webInf, "liferay-plugin-package.properties");
        Files.write(liferayPluginPackage.toPath(), properties.getBytes(), new OpenOption[0]);
    }

    private File _createWorkspace() throws Exception {
        File workspace = new File(this._rootDir, "build/test/workspace");
        File themesDir = new File(workspace, "themes");
        themesDir.mkdirs();
        String settings = "apply plugin: \"com.liferay.workspace\"";
        File settingsFile = new File(workspace, "settings.gradle");
        Files.write(settingsFile.toPath(), settings.getBytes(), new OpenOption[0]);
        String gradleProperties = "liferay.workspace.wars.dir=wars";
        File gradlePropertiesFile = new File(workspace, "gradle.properties");
        Files.write(gradlePropertiesFile.toPath(), gradleProperties.getBytes(), new OpenOption[0]);
        this._createTheme(workspace, "compass-theme", true);
        this._createTheme(workspace, "non-compass-theme", false);
        File pluginsSdk = new File(workspace, "plugins-sdk");
        File buildProperties = new File(pluginsSdk, "build.properties");
        buildProperties.createNewFile();
        File portletsDir = new File(workspace, "plugins-sdk/portlets");
        portletsDir.mkdirs();
        File buildXml = new File(portletsDir, "build.xml");
        buildXml.createNewFile();
        File hooksDir = new File(workspace, "plugins-sdk/hooks");
        hooksDir.mkdirs();
        buildXml = new File(hooksDir, "build.xml");
        buildXml.createNewFile();
        return workspace;
    }
}

