/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.StringTestUtil;
import com.liferay.blade.cli.TestUtil;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.diibadaaba.zipdiff.DifferenceCalculator;
import net.diibadaaba.zipdiff.Differences;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class InstallExtensionCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String _LINK_TO_DEPLOY_COMMAND = "https://github.com/liferay/liferay-blade-cli/tree/master/extensions/maven-profile";
    private static final File _sampleCommandJarFile = new File(System.getProperty("sampleCommandJarFile"));
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testInstallCustomExtension() throws Exception {
        String[] args = new String[]{"extension install", _sampleCommandJarFile.getAbsolutePath()};
        File root = this.temporaryFolder.getRoot();
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)("Expected output to contain \"successful\"\n" + output), (boolean)output.contains(" successful"));
        Assert.assertTrue((boolean)output.contains(_sampleCommandJarFile.getName()));
        File extensionJar = new File(root, ".blade/extensions/" + _sampleCommandJarFile.getName());
        Assert.assertTrue((String)(extensionJar.getAbsolutePath() + " does not exist"), (boolean)extensionJar.exists());
    }

    @Ignore
    @Test
    public void testInstallCustomExtensionSubdirectory() throws Exception {
        Assume.assumeFalse((boolean)this._isWindows());
        String[] args = new String[]{"extension", "install", _LINK_TO_DEPLOY_COMMAND};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, args);
        String output = bladeTestResults.getOutput();
        String errors = bladeTestResults.getErrors();
        Assert.assertTrue((String)("Expected output to contain \"successful\"\n" + output + System.lineSeparator() + errors), (boolean)output.contains(" successful"));
        Path rootPath = this._rootDir.toPath();
        Path extensionDirPath = rootPath.resolve(Paths.get(".blade", "extensions"));
        try (Stream<Path> extensionStream = Files.list(extensionDirPath);){
            boolean pathExists = extensionStream.map(Path::getFileName).map(Object::toString).anyMatch(fileNameString -> fileNameString.startsWith("maven-profile"));
            Assert.assertTrue((String)"maven-profile extension jar does not exist", (boolean)pathExists);
        }
    }

    @Test
    public void testInstallCustomExtensionTwiceDontOverwrite() throws Exception {
        String jarName = _sampleCommandJarFile.getName();
        File extensionJar = new File(this._extensionsDir, jarName);
        String[] args = new String[]{"extension", "install", _sampleCommandJarFile.getAbsolutePath()};
        Path extensionPath = extensionJar.toPath();
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        InstallExtensionCommandTest._testJarsDiff(_sampleCommandJarFile, extensionJar);
        Assert.assertTrue((String)("Expected output to contain \"successful\"\n" + output), (boolean)output.contains(" successful"));
        Assert.assertTrue((boolean)output.contains(jarName));
        File tempDir = this.temporaryFolder.newFolder("overwrite");
        Path tempPath = tempDir.toPath();
        Path sampleCommandPath = tempPath.resolve(_sampleCommandJarFile.getName());
        Files.copy(_sampleCommandJarFile.toPath(), sampleCommandPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        File sampleCommandFile = sampleCommandPath.toFile();
        sampleCommandFile.setLastModified(0L);
        args = new String[]{"extension", "install", sampleCommandFile.getAbsolutePath()};
        output = this._testBladeWithInteractive(this._rootDir, this._extensionsDir, args, "n");
        Assert.assertTrue((String)("Expected output to contain \"already exists\"\n" + output), (boolean)output.contains(" already exists"));
        Assert.assertFalse((String)("Expected output to not contain \"installed successfully\"\n" + output), (boolean)output.contains(" installed successfully"));
        Assert.assertTrue((sampleCommandFile.lastModified() == 0L ? 1 : 0) != 0);
        File extensionFile = extensionPath.toFile();
        Assert.assertFalse((extensionFile.lastModified() == 0L ? 1 : 0) != 0);
        output = this._testBladeWithInteractive(this._rootDir, this._extensionsDir, args, "defaultShouldBeNo");
        Assert.assertFalse((extensionFile.lastModified() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected output to contain \"already exists\"\n" + output), (boolean)output.contains(" already exists"));
        Assert.assertFalse((String)("Expected output to not contain \"Overwriting\"\n" + output), (boolean)output.contains("Overwriting"));
        Assert.assertFalse((String)("Expected output to not contain \"installed successfully\"\n" + output), (boolean)output.contains(" installed successfully"));
    }

    @Test
    public void testInstallCustomExtensionTwiceOverwrite() throws Exception {
        String jarName = _sampleCommandJarFile.getName();
        File extensionJar = new File(this._extensionsDir, jarName);
        String[] args = new String[]{"extension", "install", _sampleCommandJarFile.getAbsolutePath()};
        Path extensionPath = extensionJar.toPath();
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        InstallExtensionCommandTest._testJarsDiff(_sampleCommandJarFile, extensionJar);
        Assert.assertTrue((String)("Expected output to contain \"successful\"\n" + output), (boolean)output.contains(" successful"));
        Assert.assertTrue((boolean)output.contains(jarName));
        File tempDir = this.temporaryFolder.newFolder("overwrite");
        Path tempPath = tempDir.toPath();
        Path sampleCommandPath = tempPath.resolve(_sampleCommandJarFile.getName());
        Files.copy(_sampleCommandJarFile.toPath(), sampleCommandPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        File sampleCommandFile = sampleCommandPath.toFile();
        sampleCommandFile.setLastModified(0L);
        args = new String[]{"extension", "install", sampleCommandFile.getAbsolutePath()};
        output = this._testBladeWithInteractive(this._rootDir, this._extensionsDir, args, "y");
        InstallExtensionCommandTest._testJarsDiff(sampleCommandFile, extensionJar);
        Assert.assertTrue((String)("Expected output to contain \"Overwrite\"\n" + output), (boolean)output.contains("Overwrite"));
        boolean assertCorrect = output.contains(" installed successfully");
        if (!assertCorrect) {
            Assert.assertTrue((String)("Expected output to contain \"installed successfully\"\n" + output), (boolean)assertCorrect);
        }
        File extensionFile = extensionPath.toFile();
        Assert.assertEquals((long)sampleCommandFile.lastModified(), (long)extensionFile.lastModified());
    }

    @Test
    public void testInstallCustomGithubExtension() throws Exception {
        Assume.assumeFalse((boolean)this._isWindows());
        String[] args = new String[]{"extension", "install", "https://github.com/gamerson/blade-sample-command"};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)("Expected output to contain \"successful\"\n" + output), (boolean)output.contains(" successful"));
        Path rootPath = this._rootDir.toPath();
        Path extensionJarPath = rootPath.resolve(Paths.get(".blade", "extensions", "blade-sample-command-master-1.0.0.jar"));
        boolean pathExists = Files.exists(extensionJarPath, new LinkOption[0]);
        Assert.assertTrue((String)(extensionJarPath.toAbsolutePath() + " does not exist"), (boolean)pathExists);
    }

    @Test
    public void testInstallExtensionPathRequired() throws Exception {
        String[] args = new String[]{"extension install"};
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        BladeTest bladeTest = bladeTestBuilder.build();
        String error = null;
        try {
            bladeTest.run(args);
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        Assert.assertTrue((String)error, (boolean)error.contains("Unable to acquire an answer"));
    }

    @Test
    public void testInstallUninstallCustomExtension() throws Exception {
        String[] args = new String[]{"extension install", _sampleCommandJarFile.getAbsolutePath()};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)("Expected output to contain \"successful\"\n" + output), (boolean)output.contains(" successful"));
        Assert.assertTrue((boolean)output.contains(_sampleCommandJarFile.getName()));
        args = new String[]{"extension uninstall", _sampleCommandJarFile.getName()};
        bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        output = bladeTestResults.getOutput();
        Assert.assertTrue((String)("Expected output to contain \"successful\"\n" + output), (boolean)output.contains(" successful"));
        Assert.assertTrue((boolean)output.contains(_sampleCommandJarFile.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _testJarsDiff(File warFile1, File warFile2) throws IOException {
        boolean realChange;
        DifferenceCalculator differenceCalculator = new DifferenceCalculator(warFile1, warFile2);
        differenceCalculator.setFilenameRegexToIgnore(Collections.singleton(".*META-INF.*"));
        differenceCalculator.setIgnoreTimestamps(true);
        Differences differences = differenceCalculator.getDifferences();
        if (!differences.hasDifferences()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("WAR ");
        message.append(warFile1);
        message.append(" and ");
        message.append(warFile2);
        message.append(" do not match:");
        message.append(System.lineSeparator());
        Map added = differences.getAdded();
        Map changed = differences.getChanged();
        Map removed = differences.getRemoved();
        if (added.isEmpty() && !changed.isEmpty() && removed.isEmpty()) {
            realChange = false;
            ZipFile zipFile1 = null;
            ZipFile zipFile2 = null;
            try {
                zipFile1 = new ZipFile(warFile1);
                zipFile2 = new ZipFile(warFile2);
                for (Map.Entry entry : changed.entrySet()) {
                    ZipArchiveEntry[] zipArchiveEntries = (ZipArchiveEntry[])entry.getValue();
                    ZipArchiveEntry zipArchiveEntry1 = zipArchiveEntries[0];
                    ZipArchiveEntry zipArchiveEntry2 = zipArchiveEntries[0];
                    if (zipArchiveEntry1.isDirectory() && zipArchiveEntry2.isDirectory() && zipArchiveEntry1.getSize() == zipArchiveEntry2.getSize() && zipArchiveEntry1.getCompressedSize() <= 2L && zipArchiveEntry2.getCompressedSize() <= 2L) continue;
                    try (InputStream inputStream1 = zipFile1.getInputStream(zipFile1.getEntry(zipArchiveEntry1.getName()));
                         InputStream inputStream2 = zipFile2.getInputStream(zipFile2.getEntry(zipArchiveEntry2.getName()));){
                        List<String> lines1 = StringTestUtil.readLines(inputStream1);
                        List<String> lines2 = StringTestUtil.readLines(inputStream2);
                        message.append(System.lineSeparator());
                        message.append("--- ");
                        message.append(zipArchiveEntry1.getName());
                        message.append(System.lineSeparator());
                        message.append("+++ ");
                        message.append(zipArchiveEntry2.getName());
                        message.append(System.lineSeparator());
                        Patch diff = DiffUtils.diff(lines1, lines2);
                        for (Delta delta : diff.getDeltas()) {
                            message.append('\t');
                            message.append(delta.getOriginal());
                            message.append(System.lineSeparator());
                            message.append('\t');
                            message.append(delta.getRevised());
                            message.append(System.lineSeparator());
                        }
                    }
                    realChange = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                ZipFile.closeQuietly(zipFile1);
                ZipFile.closeQuietly(zipFile2);
                throw throwable;
            }
            ZipFile.closeQuietly((ZipFile)zipFile1);
            ZipFile.closeQuietly((ZipFile)zipFile2);
        } else {
            realChange = true;
        }
        Assert.assertFalse((String)message.toString(), (boolean)realChange);
    }

    private boolean _isWindows() {
        String osName = System.getProperty("os.name");
        osName = osName.toLowerCase();
        return osName.contains("win");
    }

    private String _testBladeWithInteractive(File userHomeDir, File extensionsDir, String[] args, String data) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes("UTF-8"));
        try {
            BladeTestResults bladeTestResults = TestUtil.runBlade(userHomeDir, extensionsDir, (InputStream)in, args);
            return bladeTestResults.getOutput();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

