/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ConvertCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testAll() throws Exception {
        Path rootPath = this._rootDir.toPath();
        Path testPath = rootPath.resolve("build/testUpgradePluginsSDKTo70");
        Files.createDirectories(testPath, new FileAttribute[0]);
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testPath.toFile());
        Assert.assertTrue((boolean)Files.exists(testPath, new LinkOption[0]));
        Path projectPath = testPath.resolve("plugins-sdk-with-git");
        Path pluginsSdkPath = projectPath.resolve("plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkPath);
        String[] args = new String[]{"--base", projectPath.toString(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectPath.toString(), "convert", "-a", "-r"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, false, args);
        Path apiPath = testPath.resolve("plugins-sdk-with-git/modules/sample-service-builder/sample-service-builder-api");
        Assert.assertTrue((boolean)Files.exists(apiPath, new LinkOption[0]));
        Path servicePath = projectPath.resolve("modules/sample-service-builder/sample-service-builder-service");
        Assert.assertTrue((boolean)Files.exists(servicePath, new LinkOption[0]));
        Path portletPath = projectPath.resolve("modules/sample-service-builder/sample-service-builder-portlet");
        Assert.assertTrue((boolean)Files.exists(portletPath, new LinkOption[0]));
    }

    @Test
    public void testAllNotRemoveSource() throws Exception {
        Path rootPath = this._rootDir.toPath();
        Path testPath = rootPath.resolve("build/testUpgradePluginsSDKTo70");
        Files.createDirectories(testPath, new FileAttribute[0]);
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testPath.toFile());
        Assert.assertTrue((boolean)Files.exists(testPath, new LinkOption[0]));
        Path projectPath = testPath.resolve("plugins-sdk-with-git");
        Path pluginsSdkPath = projectPath.resolve("plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkPath);
        String[] args = new String[]{"--base", projectPath.toString(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectPath.toString(), "convert", "-a"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, false, args);
        Path apiPath = testPath.resolve("plugins-sdk-with-git/modules/sample-service-builder/sample-service-builder-api");
        Assert.assertTrue((boolean)Files.exists(apiPath, new LinkOption[0]));
        Path servicePath = projectPath.resolve("modules/sample-service-builder/sample-service-builder-service");
        Assert.assertTrue((boolean)Files.exists(servicePath, new LinkOption[0]));
        Path portletPath = projectPath.resolve("modules/sample-service-builder/sample-service-builder-portlet");
        Assert.assertTrue((boolean)Files.exists(portletPath, new LinkOption[0]));
        Path pluginServiceBuilderPath = pluginsSdkPath.resolve("portlets/sample-service-builder-portlet");
        Assert.assertTrue((boolean)Files.exists(pluginServiceBuilderPath, new LinkOption[0]));
    }

    @Test
    public void testConvertSpringPortlet() throws Exception {
        File testdir = new File(this._rootDir, "plugins-sdk-spring");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        File workspaceParent = new File(this._rootDir, "workspace-parent");
        String[] args = new String[]{"--base", workspaceParent.getPath(), "init", "ws", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File workspaceDir = new File(workspaceParent, "ws");
        Assert.assertTrue((boolean)workspaceDir.exists());
        args = new String[]{"--base", workspaceDir.getPath(), "convert", "--source", projectDir.getPath(), "-v", "7.1", "my-springportletmvc-portlet"};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String errors = bladeTestResults.getErrors();
        Assert.assertTrue((String)errors, (boolean)errors.isEmpty());
        File portletDir = new File(workspaceDir, "modules/my-springportletmvc/my-springportletmvc-portlet");
        Assert.assertTrue((boolean)portletDir.exists());
        File buildGradle = new File(portletDir, "build.gradle");
        this._contains(buildGradle, ".*compile group: \"org.hibernate\", name: \"hibernate-validator\", version: \"5.2.5.Final\".*", ".*compile group: \"javax.validation\", name: \"validation-api\", version: \"1.1.0.Final\".*", ".*compile group: \"org.springframework\", name: \"spring-core\", version: \"4.3.22.RELEASE\".*", ".*compile group: \"org.springframework\", name: \"spring-webmvc\", version: \"4.3.22.RELEASE\".*", ".*compile group: \"org.springframework\", name: \"spring-webmvc-portlet\", version: \"4.3.22.RELEASE\".*", ".*compile rootProject.files\\(\"libs/org.objectweb.asm-6.0.0.jar\"\\).*");
        this._notContains(buildGradle, ".*spring-asm\".*");
    }

    @Test
    public void testFindPluginsSdkPlugin() throws Exception {
        Path rootPath = this._rootDir.toPath();
        Path testPath = rootPath.resolve("build/testPluginsSdkWithMetadata");
        Files.createDirectories(testPath, new FileAttribute[0]);
        FileUtil.unzip((File)new File("test-resources/projects/invalid-plugins-sdk-path.zip"), (File)testPath.toFile());
        Assert.assertTrue((boolean)Files.exists(testPath, new LinkOption[0]));
        Path pluginsSdkPath = testPath.resolve("invalid-plugins-sdk-path");
        Assert.assertTrue((boolean)Files.exists(pluginsSdkPath, new LinkOption[0]));
        Path workspacePath = testPath.resolve("workspace");
        Files.createDirectories(workspacePath, new FileAttribute[0]);
        String[] args = new String[]{"--base", workspacePath.toString(), "init", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", workspacePath.toString(), "convert", "-s", pluginsSdkPath.toString(), "tasks-portlet"};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, args);
        String errors = bladeTestResults.getErrors();
        Assert.assertTrue((String)errors, (boolean)errors.contains("pluginsSdkDir is not a valid Plugins SDK"));
    }

    @Test
    public void testMoveLayouttplToWars() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMoveLayouttplToWars1");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.getPath(), "convert", "-q", "1-2-1-columns-layouttpl"};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File layoutWar = new File(projectDir, "modules/1-2-1-columns-layouttpl");
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)output, (boolean)output.contains(layoutWar.getAbsolutePath()));
        Assert.assertTrue((boolean)layoutWar.exists());
        File buildXmlFile = new File(layoutWar, "build.xml");
        Assert.assertFalse((boolean)buildXmlFile.exists());
        File buildGradleFile = new File(layoutWar, "build.gradle");
        Assert.assertFalse((boolean)buildGradleFile.exists());
        File docrootDir = new File(layoutWar, "docroot");
        Assert.assertFalse((boolean)docrootDir.exists());
    }

    @Test
    public void testMoveLayouttplToWarsNotRemoveSource() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMoveLayouttplToWars2");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.getPath(), "convert", "1-2-1-columns-layouttpl"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File layoutWar = new File(projectDir, "modules/1-2-1-columns-layouttpl");
        Assert.assertTrue((boolean)layoutWar.exists());
        File buildXmlFile = new File(layoutWar, "build.xml");
        Assert.assertFalse((boolean)buildXmlFile.exists());
        File buildGradleFile = new File(layoutWar, "build.gradle");
        Assert.assertFalse((boolean)buildGradleFile.exists());
        File docrootDir = new File(layoutWar, "docroot");
        Assert.assertFalse((boolean)docrootDir.exists());
        File srclayoutDir = new File(pluginsSdkDir, "layouttpl/1-2-1-columns-layouttpl");
        Assert.assertTrue((boolean)srclayoutDir.exists());
        File srclayoutBuildXml = new File(srclayoutDir, "build.xml");
        Assert.assertTrue((boolean)srclayoutBuildXml.exists());
    }

    @Test
    public void testMovePluginsToWars() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMovePluginsToWars");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Path testPath = testdir.toPath();
        Assert.assertTrue((boolean)Files.exists(testPath, new LinkOption[0]));
        Path projectDir = testPath.resolve("plugins-sdk-with-git");
        Path pluginsSdkDir = projectDir.resolve("plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir);
        String[] args = new String[]{"--base", projectDir.toString(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.toString(), "convert", "-r", "sample-application-adapter-hook"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Path sampleExpandoHook = projectDir.resolve("modules/sample-application-adapter-hook");
        Assert.assertTrue((boolean)Files.exists(sampleExpandoHook, new LinkOption[0]));
        Path sampleHookWrongPath = projectDir.resolve("plugins-sdk/hooks/sample-application-adapter-hook");
        Assert.assertFalse((boolean)Files.exists(sampleHookWrongPath, new LinkOption[0]));
        args = new String[]{"--base", projectDir.toString(), "convert", "-r", "sample-servlet-filter-hook"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Path sampleServletFilterHook = projectDir.resolve("modules/sample-servlet-filter-hook");
        Assert.assertTrue((boolean)Files.exists(sampleServletFilterHook, new LinkOption[0]));
        Path buildGradle = sampleServletFilterHook.resolve("build.gradle");
        this._contains(buildGradle.toFile(), ".*war \\{.*");
        Path hookDir = projectDir.resolve("plugins-sdk/hooks/sample-servlet-filter-hook");
        Assert.assertFalse((boolean)Files.exists(hookDir, new LinkOption[0]));
    }

    @Test
    public void testMovePluginsToWarsNotRemoveSource() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMovePluginsToWars");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Path testPath = testdir.toPath();
        Assert.assertTrue((boolean)Files.exists(testPath, new LinkOption[0]));
        Path projectDir = testPath.resolve("plugins-sdk-with-git");
        Path pluginsSdkDir = projectDir.resolve("plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir);
        String[] args = new String[]{"--base", projectDir.toString(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.toString(), "convert", "sample-application-adapter-hook"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Path sampleExpandoHook = projectDir.resolve("modules/sample-application-adapter-hook");
        Assert.assertTrue((boolean)Files.exists(sampleExpandoHook, new LinkOption[0]));
        Path sampleHookWrongPath = projectDir.resolve("plugins-sdk/hooks/sample-application-adapter-hook");
        Assert.assertTrue((boolean)Files.exists(sampleHookWrongPath, new LinkOption[0]));
        args = new String[]{"--base", projectDir.toString(), "convert", "sample-servlet-filter-hook"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Path sampleServletFilterHook = projectDir.resolve("modules/sample-servlet-filter-hook");
        Assert.assertTrue((boolean)Files.exists(sampleServletFilterHook, new LinkOption[0]));
        Path hookDir = projectDir.resolve("plugins-sdk/hooks/sample-servlet-filter-hook");
        Assert.assertTrue((boolean)Files.exists(hookDir, new LinkOption[0]));
    }

    @Test
    public void testMoveThemesToWars() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMoveThemesToWar");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File theme = new File(projectDir, "modules/sample-styled-minimal-theme");
        args = new String[]{"--base", projectDir.getPath(), "convert", "-t", "-r", "sample-styled-minimal-theme"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Assert.assertTrue((boolean)theme.exists());
        File buildXmlFile = new File(theme, "build.xml");
        Assert.assertFalse((boolean)buildXmlFile.exists());
        File buildGradleFile = new File(theme, "build.gradle");
        Assert.assertTrue((boolean)buildGradleFile.exists());
        File docrootDir = new File(theme, "docroot");
        Assert.assertFalse((boolean)docrootDir.exists());
        File webappDir = new File(theme, "src/main/webapp");
        Assert.assertTrue((boolean)webappDir.exists());
        File diffsDir = new File(theme, "src/main/webapp/_diffs");
        Assert.assertFalse((boolean)diffsDir.exists());
        File themeDir = new File(projectDir, "plugins-sdk/themes/sample-styled-minimal-theme");
        Assert.assertFalse((boolean)themeDir.exists());
        args = new String[]{"--base", projectDir.getPath(), "convert", "-t", "-r", "sample-styled-advanced-theme"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File advancedTheme = new File(projectDir, "modules/sample-styled-advanced-theme");
        Assert.assertTrue((boolean)advancedTheme.exists());
        buildXmlFile = new File(advancedTheme, "build.xml");
        Assert.assertFalse((boolean)buildXmlFile.exists());
        buildGradleFile = new File(advancedTheme, "build.gradle");
        Assert.assertTrue((boolean)buildGradleFile.exists());
        docrootDir = new File(advancedTheme, "docroot");
        Assert.assertFalse((boolean)docrootDir.exists());
        webappDir = new File(advancedTheme, "src/main/webapp");
        Assert.assertTrue((boolean)webappDir.exists());
        diffsDir = new File(advancedTheme, "src/main/webapp/_diffs");
        Assert.assertFalse((boolean)diffsDir.exists());
        themeDir = new File(projectDir, "plugins-sdk/themes/sample-styled-advanced-theme");
        Assert.assertFalse((boolean)themeDir.exists());
    }

    @Test
    public void testMoveThemesToWarsNotRemoveSource() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMoveThemesToWarNotRemoveSource");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File theme = new File(projectDir, "modules/sample-styled-minimal-theme");
        args = new String[]{"--base", projectDir.getPath(), "convert", "-t", "sample-styled-minimal-theme"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Assert.assertTrue((boolean)theme.exists());
        File buildXmlFile = new File(theme, "build.xml");
        Assert.assertFalse((boolean)buildXmlFile.exists());
        File buildGradleFile = new File(theme, "build.gradle");
        Assert.assertTrue((boolean)buildGradleFile.exists());
        File docrootDir = new File(theme, "docroot");
        Assert.assertFalse((boolean)docrootDir.exists());
        File webappDir = new File(theme, "src/main/webapp");
        Assert.assertTrue((boolean)webappDir.exists());
        File diffsDir = new File(theme, "src/main/webapp/_diffs");
        Assert.assertFalse((boolean)diffsDir.exists());
        File themeDir = new File(projectDir, "plugins-sdk/themes/sample-styled-minimal-theme");
        Assert.assertTrue((boolean)themeDir.exists());
        args = new String[]{"--base", projectDir.getPath(), "convert", "-t", "sample-styled-advanced-theme"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File advancedTheme = new File(projectDir, "modules/sample-styled-advanced-theme");
        Assert.assertTrue((boolean)advancedTheme.exists());
        buildXmlFile = new File(advancedTheme, "build.xml");
        Assert.assertFalse((boolean)buildXmlFile.exists());
        buildGradleFile = new File(advancedTheme, "build.gradle");
        Assert.assertTrue((boolean)buildGradleFile.exists());
        docrootDir = new File(advancedTheme, "docroot");
        Assert.assertFalse((boolean)docrootDir.exists());
        webappDir = new File(advancedTheme, "src/main/webapp");
        Assert.assertTrue((boolean)webappDir.exists());
        diffsDir = new File(advancedTheme, "src/main/webapp/_diffs");
        Assert.assertFalse((boolean)diffsDir.exists());
        themeDir = new File(projectDir, "plugins-sdk/themes/sample-styled-advanced-theme");
        Assert.assertTrue((boolean)themeDir.exists());
    }

    @Test
    public void testReadIvyXml() throws Exception {
        File projectDir = this._setupWorkspace("readIvyXml");
        String[] args = new String[]{"--base", projectDir.getPath(), "convert", "sample-dao-portlet"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        this._contains(new File(projectDir, "modules/sample-dao/sample-dao-portlet/build.gradle"), ".*compile group: \"c3p0\", name: \"c3p0\", version: \"0.9.0.4\".*", ".*compile group: \"mysql\", name: \"mysql-connector-java\", version: \"5.0.7\".*");
        args = new String[]{"--base", projectDir.getPath(), "convert", "sample-tapestry-portlet"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        this._contains(new File(projectDir, "modules/sample-tapestry/sample-tapestry-portlet/build.gradle"), ".*compile group: \"hivemind\", name: \"hivemind\", version: \"1.1\".*", ".*compile group: \"hivemind\", name: \"hivemind-lib\", version: \"1.1\".*", ".*compile group: \"org.apache.tapestry\", name: \"tapestry-annotations\", version: \"4.1\".*", ".*compile group: \"org.apache.tapestry\", name: \"tapestry-framework\", version: \"4.1\".*", ".*compile group: \"org.apache.tapestry\", name: \"tapestry-portlet\", version: \"4.1\".*");
        File ivmXmlFile = new File(projectDir, "modules/sample-tapestry/sample-tapestry-portlet/ivy.xml");
        Assert.assertFalse((boolean)ivmXmlFile.exists());
    }

    @Test
    public void testReadLiferayPlguinPackageProperties() throws Exception {
        File projectDir = this._setupWorkspace("readLiferayPlguinPackageProperties");
        String[] args = new String[]{"--base", projectDir.getPath(), "convert", "sample-hibernate-portlet"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File warDir = new File(projectDir, "modules/sample-hibernate/sample-hibernate-portlet");
        Assert.assertTrue((String)warDir.getAbsolutePath(), (boolean)warDir.exists());
        File buildGradle = new File(warDir, "build.gradle");
        this._contains(buildGradle, ".*compile group: \"commons-collections\", name: \"commons-collections\", version: \"3.2.2\".*", ".*compile group: \"commons-httpclient\", name: \"commons-httpclient\", version: \"3.1\".*", ".*compile group: \"dom4j\", name: \"dom4j\", version: \"1.6.1\".*", ".*compile group: \"antlr\", name: \"antlr\", version: \"2.7.7\".*", ".*compile group: \"javax.xml.soap\", name: \"saaj-api\", version: \"1.3\".*", ".*compile group: \"org.slf4j\", name: \"slf4j-api\", version: \"1.7.2\".*", ".*compileOnly group: \"com.liferay.portal\", name: \"com.liferay.util.bridges\".*", ".*compileOnly group: \"com.liferay.portal\", name: \"com.liferay.util.java\".*", ".*compileOnly group: \"com.liferay.portal\", name: \"com.liferay.util.taglib\".*");
        this._contains(buildGradle, ".*Unknown dependency.*hibernate3.*", ".*Unknown dependency.*util-slf4j.*");
    }

    @Test
    public void testSourceParameter() throws Exception {
        File testdir = new File(this._rootDir, "plugins-sdk-alternative-location");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        File workspaceParent = new File(this._rootDir, "workspace-parent");
        String[] args = new String[]{"--base", workspaceParent.getPath(), "init", "ws", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File workspaceDir = new File(workspaceParent, "ws");
        Assert.assertTrue((boolean)workspaceDir.exists());
        args = new String[]{"--base", workspaceDir.getPath(), "convert", "--source", projectDir.getPath(), "sample-application-adapter-hook"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File warDir = new File(workspaceDir, "modules/sample-application-adapter-hook");
        Assert.assertTrue((boolean)warDir.exists());
    }

    @Test
    public void testThemeDocrootBackup() throws Exception {
        File projectDir = this._setupWorkspace("testThemeDocrootBackup");
        String[] args = new String[]{"--base", projectDir.getPath(), "convert", "-t", "sample-html4-theme"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File afile = new File(projectDir, "modules/sample-html4-theme/docroot_backup/other/afile");
        Assert.assertTrue((boolean)afile.exists());
    }

    private void _contains(File file, String ... patterns) throws Exception {
        String content = FileUtil.read((File)file);
        for (String pattern : patterns) {
            this._contains(content, pattern);
        }
    }

    private void _contains(String content, String regex) throws Exception {
        Pattern pattern = Pattern.compile(regex, 40);
        Matcher matcher = pattern.matcher(content);
        Assert.assertTrue((boolean)matcher.matches());
    }

    private void _notContains(File file, String ... patterns) throws Exception {
        String content = FileUtil.read((File)file);
        for (String pattern : patterns) {
            this._notContains(content, pattern);
        }
    }

    private void _notContains(String content, String regex) throws Exception {
        Pattern pattern = Pattern.compile(regex, 40);
        Matcher matcher = pattern.matcher(content);
        Assert.assertFalse((boolean)matcher.matches());
    }

    private File _setupWorkspace(String name) throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/" + name);
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.3-ga4"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Assert.assertTrue((boolean)pluginsSdkDir.exists());
        return projectDir;
    }
}

