/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ConvertServiceBuilderCommandTest {
    public static final String SB_PROJECT_NAME = "sample-service-builder-portlet";
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testConvertServiceBuilder() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMigrateServiceBuilder");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.3-ga2"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.getPath(), "convert", "-q", SB_PROJECT_NAME};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File oldSbProject = new File(pluginsSdkDir, "portlet/sample-service-builder-portlet");
        Assert.assertFalse((boolean)oldSbProject.exists());
        File sbWar = new File(projectDir, "modules/sample-service-builder/sample-service-builder-portlet");
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)output, (boolean)output.contains(sbWar.getAbsolutePath()));
        Assert.assertTrue((boolean)sbWar.exists());
        File buildXmlFile = new File(sbWar, "build.xml");
        Assert.assertFalse((boolean)buildXmlFile.exists());
        File buildGradleFile = new File(sbWar, "build.gradle");
        Assert.assertTrue((boolean)buildGradleFile.exists());
        File docrootDir = new File(sbWar, "docroot");
        Assert.assertFalse((boolean)docrootDir.exists());
        File moduleDir = new File(projectDir, "modules");
        File newSbDir = new File(moduleDir, "sample-service-builder");
        File sbServiceDir = new File(newSbDir, "sample-service-builder-service");
        File sbApiDir = new File(newSbDir, "sample-service-builder-api");
        Assert.assertTrue((boolean)sbServiceDir.exists());
        Assert.assertTrue((boolean)sbApiDir.exists());
        Assert.assertTrue((String)output, (boolean)output.contains(sbServiceDir.getAbsolutePath()));
        Assert.assertTrue((String)output, (boolean)output.contains(sbApiDir.getAbsolutePath()));
        File serviceXmlFile = new File(sbServiceDir, "service.xml");
        Assert.assertTrue((boolean)serviceXmlFile.exists());
        File servicePropertiesFile = new File(sbServiceDir, "src/main/resources/service.properties");
        Assert.assertTrue((boolean)servicePropertiesFile.exists());
        File baseSpringXmlFile = new File(sbServiceDir, "src/main/resources/META-INF/base-spring.xml");
        Assert.assertFalse((String)baseSpringXmlFile.getAbsolutePath(), (boolean)baseSpringXmlFile.exists());
        File hintsXmlFile = new File(sbServiceDir, "src/main/resources/META-INF/portlet-model-hints.xml");
        Assert.assertTrue((boolean)hintsXmlFile.exists());
        File localImplFile = new File(sbServiceDir, "src/main/java/com/liferay/sampleservicebuilder/service/impl/FooLocalServiceImpl.java");
        Assert.assertTrue((boolean)localImplFile.exists());
        File serviceImplFile = new File(sbServiceDir, "src/main/java/com/liferay/sampleservicebuilder/service/impl/FooServiceImpl.java");
        Assert.assertTrue((boolean)serviceImplFile.exists());
        File implFile = new File(sbServiceDir, "src/main/java/com/liferay/sampleservicebuilder/model/impl/FooImpl.java");
        Assert.assertTrue((boolean)implFile.exists());
        File bndBnd = new File(sbApiDir, "bnd.bnd");
        Assert.assertTrue((boolean)bndBnd.exists());
        String bndContent = FileUtil.read((File)bndBnd);
        Assert.assertTrue((String)bndContent, (boolean)bndContent.contains("com.liferay.sampleservicebuilder.exception"));
    }

    @Test
    public void testConvertServiceBuilderTasksPortletCustomName() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/test-tasks-portlet-conversion");
        String[] args = new String[]{"--base", testdir.getPath(), "init", "-u", "-v", "portal-7.3-ga2"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Path testPath = testdir.toPath();
        Path pluginsSdkPath = testPath.resolve("plugins-sdk");
        File tasksPluginsSdk = new File("test-resources/projects/tasks-plugins-sdk");
        FileUtil.copyDir((Path)tasksPluginsSdk.toPath(), (Path)pluginsSdkPath);
        Assert.assertTrue((boolean)Files.exists(testPath.resolve("plugins-sdk/portlets/tasks-portlet"), new LinkOption[0]));
        String[] convertArgs = new String[]{"--base", testdir.getPath(), "convert", "tasks-portlet", "foo"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, convertArgs);
        Assert.assertTrue((boolean)Files.exists(testPath.resolve("modules/foo/foo-api/build.gradle"), new LinkOption[0]));
    }

    @Test
    public void testConvertServiceBuilderTasksPortletDefaultName() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/test-tasks-portlet-conversion");
        String[] args = new String[]{"--base", testdir.getPath(), "init", "-u", "-v", "portal-7.3-ga2"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Path testPath = testdir.toPath();
        Path pluginsSdkPath = testPath.resolve("plugins-sdk");
        File taskPluginsSdk = new File("test-resources/projects/tasks-plugins-sdk");
        FileUtil.copyDir((Path)taskPluginsSdk.toPath(), (Path)pluginsSdkPath);
        Assert.assertTrue((boolean)Files.exists(testPath.resolve("plugins-sdk/portlets/tasks-portlet"), new LinkOption[0]));
        String[] convertArgs = new String[]{"--base", testdir.getPath(), "convert", "tasks-portlet"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, convertArgs);
        File buildGradleFile = new File(testdir, "modules/tasks/tasks-api/build.gradle");
        Assert.assertTrue((boolean)buildGradleFile.exists());
        File exceptionDir = new File(testdir, "modules/tasks/tasks-api/src/main/java/com/liferay/tasks/exception");
        Assert.assertTrue((boolean)exceptionDir.exists());
        File file = new File(testdir, "modules/tasks/tasks-service/src/main/java/com/liferay/tasks/model/impl/TasksEntryModelImpl.java");
        Assert.assertTrue((boolean)file.exists());
        file = new File(testdir, "modules/tasks/tasks-service/src/main/java/com/liferay/tasks/service/impl/TasksEntryServiceImpl.java");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)Files.exists(testPath.resolve("modules/tasks/tasks-service/service.xml"), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(testPath.resolve("modules/tasks/tasks-portlet/src/main/webapp/WEB-INF/service.xml"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(testPath.resolve("modules/tasks/tasks-portlet/src/main/webapp/WEB-INF/portlet.xml"), new LinkOption[0]));
        File portletGradleFile = new File(testdir, "modules/tasks/tasks-portlet/build.gradle");
        Assert.assertTrue((boolean)portletGradleFile.exists());
        String content = new String(Files.readAllBytes(portletGradleFile.toPath()));
        Assert.assertTrue((String)content, (boolean)content.contains("compileOnly project(\":modules:tasks:tasks-api\")"));
    }

    @Test
    public void testConvertServiceBuilderWithoutRemove() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMigrateServiceBuilder");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.3-ga2"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.getPath(), "convert", SB_PROJECT_NAME};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File oldSbProject = new File(pluginsSdkDir, "portlets/sample-service-builder-portlet");
        Assert.assertTrue((boolean)oldSbProject.exists());
        File moduleDir = new File(projectDir, "modules");
        File newSbDir = new File(moduleDir, "sample-service-builder");
        File sbServiceDir = new File(newSbDir, "sample-service-builder-service");
        File sbApiDir = new File(newSbDir, "sample-service-builder-api");
        File sbWar = new File(newSbDir, SB_PROJECT_NAME);
        Assert.assertTrue((String)sbServiceDir.getAbsolutePath(), (boolean)sbServiceDir.exists());
        Assert.assertTrue((String)sbApiDir.getAbsolutePath(), (boolean)sbApiDir.exists());
        Assert.assertTrue((String)sbWar.getAbsolutePath(), (boolean)sbWar.exists());
    }

    @Test
    public void testConvertServiceBuilderWithRemove() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMigrateServiceBuilder");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.3-ga2"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.getPath(), "convert", "-r", SB_PROJECT_NAME};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File oldSbProject = new File(pluginsSdkDir, "portlets/sample-service-builder-portlet");
        Assert.assertFalse((boolean)oldSbProject.exists());
        File moduleDir = new File(projectDir, "modules");
        File newSbDir = new File(moduleDir, "sample-service-builder");
        File sbServiceDir = new File(newSbDir, "sample-service-builder-service");
        File sbApiDir = new File(newSbDir, "sample-service-builder-api");
        File sbWar = new File(newSbDir, SB_PROJECT_NAME);
        Assert.assertTrue((String)sbServiceDir.getAbsolutePath(), (boolean)sbServiceDir.exists());
        Assert.assertTrue((String)sbApiDir.getAbsolutePath(), (boolean)sbApiDir.exists());
        Assert.assertTrue((String)sbWar.getAbsolutePath(), (boolean)sbWar.exists());
    }
}

