/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.StringPrintStream;
import java.io.PrintStream;
import java.util.Optional;
import java.util.Scanner;

public class BladeIOTest
extends BladeTest {
    private Optional<String> _error = null;
    private StringPrintStream _errorStream;
    private Optional<String> _output = null;
    private StringPrintStream _outputStream;

    public static BladeIOTest getBlade() {
        try {
            StringPrintStream outputStream = StringPrintStream.newInstance();
            StringPrintStream errorStream = StringPrintStream.newInstance();
            return new BladeIOTest(outputStream, errorStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getError() {
        if (this._error == null) {
            this._error = Optional.ofNullable(BladeIOTest._getErrorString(this._errorStream.toString()));
        }
        return this._error.orElse(null);
    }

    public String getOutput() {
        if (this._output == null) {
            this._output = Optional.ofNullable(this._outputStream.toString());
        }
        return this._output.orElse(null);
    }

    public boolean runBlade(String ... args) {
        try {
            super.run(args);
            return this.getError() != null;
        }
        catch (Exception e) {
            boolean errorMissing = false;
            if (this._error == null) {
                errorMissing = true;
            }
            if (!errorMissing) {
                boolean bl = errorMissing = !this._error.isPresent();
            }
            if (!errorMissing) {
                String errorMessage = this._error.get();
                boolean bl = errorMissing = (errorMessage = errorMessage.trim()).length() == 0;
            }
            if (errorMissing) {
                this._error = Optional.ofNullable(e.toString());
            }
            return true;
        }
    }

    private static String _getErrorString(String error) {
        StringBuilder sb = null;
        try (Scanner scanner = new Scanner(error);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("SLF4J:")) continue;
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append("Encountered error at line: " + line + System.lineSeparator());
                    continue;
                }
                sb.append(line + System.lineSeparator());
            }
        }
        if (sb == null) {
            return null;
        }
        return sb.toString();
    }

    private BladeIOTest(StringPrintStream out, StringPrintStream err) throws Exception {
        super((PrintStream)out, (PrintStream)err, System.in);
        this._outputStream = out;
        this._errorStream = err;
    }
}

