/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.command.UpdateCommand;
import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import com.liferay.blade.cli.util.BladeVersions;
import java.io.File;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PrepareForTest(value={ServiceLoader.class, UpdateCommand.class, BladeVersions.class, BladeCLI.class})
@RunWith(value=PowerMockRunner.class)
public class UpdateCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
        PowerMock.mockStatic(ServiceLoader.class);
        UpdateCommandTest._setupWorkspaceProviderServiceLoader();
        UpdateCommandTest._setupCommandServiceLoader();
        PowerMock.replayAll((Object[])new Object[0]);
    }

    @Test
    public void testCurrentMajorLessThanUpdatedMajorDefault() {
        String currentVersion = "1.5.9.1.2.3.4.5.6.7.8.9";
        String releaseUpdateVersion = "2.1.1.4.5.6";
        String snapshotUpdateVersion = "2.1.1.5.6.7-snapshot";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMajorLessThanUpdatedMajorReleaseToRelease() {
        String currentVersion = "1.5.9.1.2.3.4.5.6.7.8.9";
        String releaseUpdateVersion = "2.1.1.4.5.6";
        String snapshotUpdateVersion = "2.1.1.5.6.7-snapshot";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-r", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMajorLessThanUpdatedMajorReleaseToSnapshot() {
        String currentVersion = "1.5.9.1.2.3.4.5.6.7.8.9";
        String releaseUpdateVersion = "2.1.1.4.5.6";
        String snapshotUpdateVersion = "2.1.1.5.6.7-snapshot";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-s", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMajorLessThanUpdatedMajorSnapshotToRelease() {
        String currentVersion = "1.5.9.1.2.3.4.5.6.7.8.9-snapshot";
        String releaseUpdateVersion = "2.1.1.4.5.6";
        String snapshotUpdateVersion = "2.1.1.5.6.7-snapshot";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-r", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMajorLessThanUpdatedMajorSnapshotToSnapshot() {
        String currentVersion = "1.5.9.1.2.3.4.5.6.7.8.9-snapshot";
        String releaseUpdateVersion = "2.1.1.4.5.6";
        String snapshotUpdateVersion = "2.1.1.5.6.7-snapshot";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-s", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMajorMoreThanUpdatedMajorDefault() {
        String currentVersion = "3.0.0.2018.10.23.1234";
        String releaseUpdateVersion = "2.1.1.4.5.6";
        String snapshotUpdateVersion = "2.5.9-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMajorMoreThanUpdatedMajorRelease() {
        String currentVersion = "3.0.0.2018.10.23.1234";
        String releaseUpdateVersion = "2.1.1.4.5.6";
        String snapshotUpdateVersion = "2.5.9-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-r", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMajorMoreThanUpdatedMajorSnapshot() {
        String currentVersion = "3.0.0.2018.10.23.1234";
        String releaseUpdateVersion = "2.1.1.4.5.6";
        String snapshotUpdateVersion = "2.5.9-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-s", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMinorLessThanUpdatedMinorDefault() {
        String currentVersion = "12.1.9.SCHWIBBY";
        String releaseUpdateVersion = "12.2.0";
        String snapshotUpdateVersion = "12.2.1-snapshot";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMinorLessThanUpdatedMinorRelease() {
        String currentVersion = "12.1.9.SCHWIBBY";
        String releaseUpdateVersion = "12.2.0";
        String snapshotUpdateVersion = "12.2.1-snapshot";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-r", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMinorLessThanUpdatedMinorSnapshot() {
        String currentVersion = "12.1.9.SCHWIBBY";
        String releaseUpdateVersion = "12.2.0";
        String snapshotUpdateVersion = "12.2.1-snapshot";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-s", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMinorMoreThanUpdatedMinorDefault() {
        String currentVersion = "3.6.0.001810231234";
        String releaseUpdateVersion = "3.5.9-SCHNAPS";
        String snapshotUpdateVersion = "3.5.9-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMinorMoreThanUpdatedMinorRelease() {
        String currentVersion = "3.6.0.001810231234";
        String releaseUpdateVersion = "3.5.9-SCHNAPS";
        String snapshotUpdateVersion = "3.5.9-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-r", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentMinorMoreThanUpdatedMinorSnapshot() {
        String currentVersion = "3.6.0.001810231234";
        String releaseUpdateVersion = "3.5.9-SCHNAPS";
        String snapshotUpdateVersion = "3.5.9-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-s", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentPatchLessThanUpdatedPatchDefault() {
        String currentVersion = "123.10.10.SCHOOBY";
        String releaseUpdateVersion = "123.10.20-whiff";
        String snapshotUpdateVersion = "123.10.20-whiff-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentPatchLessThanUpdatedPatchRelease() {
        String currentVersion = "123.10.10.SCHOOBY";
        String releaseUpdateVersion = "123.10.20-whiff";
        String snapshotUpdateVersion = "123.10.20-whiff-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-r", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentPatchLessThanUpdatedPatchSnapshot() {
        String currentVersion = "123.10.10.SCHOOBY";
        String releaseUpdateVersion = "123.10.20-whiff";
        String snapshotUpdateVersion = "123.10.20-whiff-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-s", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentPatchMoreThanUpdatedPatchDefault() {
        String currentVersion = "3.5.9.001810231234";
        String releaseUpdateVersion = "3.5.8.999999";
        String snapshotUpdateVersion = "3.5.8.999999-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testCurrentSnapshot() {
        String currentVersion = "3.4.0.SNAPSHOT201812060746";
        String releaseUpdateVersion = "3.4.0-20181206.074623-13";
        String snapshotUpdateVersion = "3.4.0-20181206.074623-13";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testTwoSnapshotVersions() {
        String currentVersion = "3.3.1.SNAPSHOT201811211846";
        String releaseUpdateVersion = "3.3.1-20181128.214621-308";
        String snapshotUpdateVersion = "3.3.1-20181128.214621-308-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + releaseUpdateVersion), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    @Test
    public void testUpdateSnapshotButNotRelease() {
        String currentVersion = "3.8.0-SNAPSHOT";
        String releaseUpdateVersion = "3.7.9";
        String snapshotUpdateVersion = "3.8.1-SNAPSHOT";
        UpdateCommandTest._setupStaticVersionsMock(currentVersion, releaseUpdateVersion, snapshotUpdateVersion);
        BladeTestResults results = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "update", "-r", "--check");
        String resultsOutput = results.getOutput();
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated."), (boolean)resultsOutput.contains("A new release update is available for blade: " + releaseUpdateVersion));
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + snapshotUpdateVersion), (boolean)resultsOutput.contains("A new snapshot update is available for blade: " + snapshotUpdateVersion));
    }

    private static void _setupCommandServiceLoader() {
        ServiceLoader commandServiceLoader = (ServiceLoader)PowerMock.createNiceMock(ServiceLoader.class);
        ArrayList<UpdateCommand> commands = new ArrayList<UpdateCommand>();
        commands.add(new UpdateCommand());
        EasyMock.expect(commandServiceLoader.iterator()).andReturn(commands.iterator()).once();
        Capture classCapture = EasyMock.newCapture();
        EasyMock.expect(ServiceLoader.load((Class)EasyMock.capture((Capture)classCapture), (ClassLoader)EasyMock.anyObject())).andReturn((Object)commandServiceLoader).once();
    }

    private static void _setupStaticVersionsMock(String currentVersion, String releaseUpdateVersion, String snapshotUpdateVersion) {
        try {
            PowerMock.mockStaticPartialNice(UpdateCommand.class, (String[])new String[]{"_getVersions"});
            IExpectationSetters andReturn = PowerMock.expectPrivate(UpdateCommand.class, (String)"_getVersions", (Object[])new Object[0]);
            andReturn.andReturn((Object)new BladeVersions(currentVersion, releaseUpdateVersion, snapshotUpdateVersion));
            PowerMock.replayAll((Object[])new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void _setupWorkspaceProviderServiceLoader() {
        ServiceLoader workspaceServiceLoader = (ServiceLoader)PowerMock.createNiceMock(ServiceLoader.class);
        ArrayList<GradleWorkspaceProvider> workspaceProviders = new ArrayList<GradleWorkspaceProvider>();
        workspaceProviders.add(new GradleWorkspaceProvider());
        EasyMock.expect(workspaceServiceLoader.iterator()).andReturn(workspaceProviders.iterator()).once();
        Capture workspaceClassCapture = EasyMock.newCapture();
        EasyMock.expect(ServiceLoader.load((Class)EasyMock.capture((Capture)workspaceClassCapture), (ClassLoader)EasyMock.anyObject())).andReturn((Object)workspaceServiceLoader).once();
    }
}

