/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.GradleRunner;
import org.gradle.testkit.runner.TaskOutcome;
import org.junit.Assert;

public class GradleRunnerUtil {
    public static BuildTask executeGradleRunner(String projectPath, String ... taskPath) {
        Path projectDir = Paths.get(projectPath, new String[0]);
        GradleRunner gradleRunner = GradleRunner.create();
        gradleRunner.withProjectDir(projectDir.toFile());
        gradleRunner.withArguments(taskPath);
        BuildResult buildResult = gradleRunner.build();
        BuildTask buildTask = null;
        for (BuildTask task : buildResult.getTasks()) {
            String taskPathString = task.getPath();
            if (!taskPathString.endsWith(taskPath[taskPath.length - 1])) continue;
            buildTask = task;
            break;
        }
        return buildTask;
    }

    public static Path verifyBuildOutput(String projectPath, String fileName) throws IOException {
        return GradleRunnerUtil.verifyBuildOutput(projectPath, fileName, false);
    }

    public static Path verifyBuildOutput(String projectPath, final String fileName, final boolean regex) throws IOException {
        final Path[] projectFilePath = new Path[1];
        Files.walkFileTree(Paths.get(projectPath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Pattern fileNamePattern;
                Matcher matcher;
                Path pathFileName = file.getFileName();
                String pathFileNameString = pathFileName.toString();
                if (Objects.equal((Object)pathFileNameString, (Object)fileName)) {
                    projectFilePath[0] = file;
                    return FileVisitResult.TERMINATE;
                }
                if (regex && (matcher = (fileNamePattern = Pattern.compile(fileName, 32)).matcher(pathFileNameString)).find()) {
                    projectFilePath[0] = file;
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Assert.assertNotNull((String)("Unable to find project file " + fileName + " in " + projectPath), (Object)projectFilePath[0]);
        return projectFilePath[0];
    }

    public static void verifyGradleRunnerOutput(BuildTask buildTask) {
        Assert.assertNotNull((Object)buildTask);
        Assert.assertEquals((Object)TaskOutcome.SUCCESS, (Object)buildTask.getOutcome());
    }
}

